/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget.field;

import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.config.Notification;
import dev.terminalmc.chatnotify.config.Trigger;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.text.ColorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextField
extends class_342 {
    public static final long CLICK_CHAIN_TIME = 250L;
    public static final int TEXT_COLOR_DEFAULT = -2039584;
    public static final int TEXT_COLOR_ERROR = -43691;
    public static final int TEXT_COLOR_HINT = -11184811;
    public static final int TEXT_COLOR_PREVIEW = -5592406;
    private final class_327 font;
    public final List<@NotNull Validator> validators = new ArrayList<Validator>();
    public boolean lenient = true;
    private int normalTextColor = -2039584;
    @Nullable
    private class_7919 normalTooltip;
    @Nullable
    private class_7919 errorTooltip;
    private final List<String> history = new ArrayList<String>();
    private int historyIndex = -1;
    private double dragOriginX;
    private int dragOriginPos;
    private long lastClickTime;
    private int chainedClicks;

    public TextField(int x, int y, int width, int height) {
        this(class_310.method_1551().field_1772, x, y, width, height, (class_2561)class_2561.method_43473(), null);
    }

    public TextField(int x, int y, int width, int height, @Nullable Validator validator) {
        this(class_310.method_1551().field_1772, x, y, width, height, (class_2561)class_2561.method_43473(), validator);
    }

    public TextField(class_327 font, int x, int y, int width, int height, class_2561 msg, @Nullable Validator validator) {
        super(font, x, y, width, height, msg);
        this.font = font;
        if (validator != null) {
            this.validators.add(validator);
        }
    }

    public TextField withValidator(@NotNull Validator validator) {
        this.validators.add(validator);
        return this;
    }

    public TextField regexValidator() {
        this.validators.add(new Validator.Regex());
        return this;
    }

    public TextField hexColorValidator() {
        this.validators.add(new Validator.HexColor());
        return this;
    }

    public TextField soundValidator() {
        this.validators.add(new Validator.Sound());
        return this;
    }

    public TextField posIntValidator() {
        this.validators.add(new Validator.PosInt());
        return this;
    }

    public TextField strict() {
        this.lenient = false;
        return this;
    }

    public TextField lenient() {
        this.lenient = true;
        return this;
    }

    public void method_1863(@NotNull Consumer<String> responder) {
        super.method_1863(str -> {
            this.updateHistory((String)str);
            if (this.validate((String)str) || this.lenient) {
                responder.accept((String)str);
            }
        });
    }

    private boolean validate(String str) {
        for (Validator v : this.validators) {
            Optional<class_2561> error = v.validate(str);
            if (!error.isPresent()) continue;
            this.errorTooltip = class_7919.method_47407((class_2561)error.get());
            super.method_47400(this.errorTooltip);
            super.method_1868(-43691);
            return false;
        }
        this.errorTooltip = null;
        super.method_1868(this.normalTextColor);
        super.method_47400(this.normalTooltip);
        return true;
    }

    public void method_47404(@NotNull class_2561 hint) {
        super.method_47404((class_2561)hint.method_27661().method_54663(-11184811));
    }

    public void method_47400(@Nullable class_7919 tooltip) {
        this.normalTooltip = tooltip;
        if (this.errorTooltip == null) {
            super.method_47400(tooltip);
        }
    }

    public void method_1868(int color) {
        this.normalTextColor = color;
        if (this.errorTooltip == null) {
            super.method_1868(color);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            long time = class_156.method_658();
            if (this.lastClickTime + 250L > time) {
                switch (++this.chainedClicks) {
                    case 1: {
                        int pos;
                        int start = pos = this.method_1881();
                        if (pos < 0) {
                            start = 0;
                        } else if (pos >= this.method_1882().length() || this.method_1882().charAt(pos) == ' ' || pos > 0 && this.method_1882().charAt(pos - 1) != ' ') {
                            start = this.method_1853(-1);
                        }
                        int end = this.method_1853(1);
                        this.method_1883(start, false);
                        this.method_1883(end, true);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.method_1872(false);
                        this.method_1884(0);
                        break;
                    }
                    case 4: {
                        this.chainedClicks = 0;
                        this.method_1884(this.method_1881());
                    }
                }
            } else {
                this.chainedClicks = 0;
            }
            this.lastClickTime = time;
            this.dragOriginX = mouseX;
            this.dragOriginPos = this.method_1881();
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button != 0) {
            return false;
        }
        String str = this.method_1882();
        if (mouseX < this.dragOriginX) {
            String subLeft = str.substring(0, this.dragOriginPos);
            int offsetChars = this.font.method_27524(subLeft, class_3532.method_15357((double)(this.dragOriginX - mouseX)), true).length();
            this.method_1883(this.dragOriginPos - offsetChars, true);
        } else {
            String subRight = str.substring(this.dragOriginPos);
            int offsetChars = this.font.method_27524(subRight, class_3532.method_15357((double)(mouseX - this.dragOriginX)), false).length();
            this.method_1883(this.dragOriginPos + offsetChars, true);
        }
        return true;
    }

    private void updateHistory(String str) {
        if (this.historyIndex == -1 || !this.history.get(this.historyIndex).equals(str)) {
            if (this.historyIndex < this.history.size() - 1) {
                for (int i = this.history.size() - 1; i > this.historyIndex; --i) {
                    this.history.removeLast();
                }
            }
            this.history.add(str);
            ++this.historyIndex;
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!super.method_25404(keyCode, scanCode, modifiers)) {
            if (TextField.isUndo(keyCode)) {
                this.undo();
                return true;
            }
            if (TextField.isRedo(keyCode)) {
                this.redo();
                return true;
            }
            return false;
        }
        return true;
    }

    private void undo() {
        if (this.historyIndex > 0) {
            this.method_1852(this.history.get(--this.historyIndex));
        }
    }

    private void redo() {
        if (this.historyIndex < this.history.size() - 1) {
            this.method_1852(this.history.get(++this.historyIndex));
        }
    }

    public static boolean isUndo(int keyCode) {
        return keyCode == 90 && class_437.method_25441() && !class_437.method_25442() && !class_437.method_25443();
    }

    public static boolean isRedo(int keyCode) {
        return keyCode == 89 && class_437.method_25441() && !class_437.method_25442() && !class_437.method_25443();
    }

    public static String fixRegexMessage(String str) {
        Matcher indexMatcher;
        if ((str = str.replaceAll("\\n", "")).endsWith("^") && (indexMatcher = Pattern.compile("near index (\\d+)\n").matcher(str)).find()) {
            class_327 font = class_310.method_1551().field_1772;
            int index = Integer.parseInt(indexMatcher.group(1));
            int startPos = indexMatcher.end();
            int cursorPos = startPos + index;
            int cursorOffset = font.method_1727(str.substring(startPos, cursorPos));
            char[] charArray = new char[cursorOffset / font.method_1727(" ")];
            Arrays.fill(charArray, ' ');
            String newSpace = new String(charArray);
            Matcher cursorMatcher = Pattern.compile("\n( *\\^)$").matcher(str);
            if (cursorMatcher.find(cursorPos)) {
                String cursorLine = cursorMatcher.group(1);
                str = str.replaceAll(Pattern.quote(cursorLine) + "$", newSpace + "^");
            }
        }
        return str;
    }

    @FunctionalInterface
    public static interface Validator {
        public Optional<class_2561> validate(String var1);

        public static class UniqueTrigger
        implements Validator {
            final Notification notif;
            final Trigger trigger;
            final Type type;

            public UniqueTrigger(Notification notif, Trigger trigger) {
                this(notif, trigger, Type.MAIN);
            }

            private UniqueTrigger(Notification notif, Trigger trigger, Type type) {
                this.notif = notif;
                this.trigger = trigger;
                this.type = type;
            }

            public static UniqueTrigger inclusion(Notification notif, Trigger trigger) {
                return new UniqueTrigger(notif, trigger, Type.INCLUSION);
            }

            public static UniqueTrigger exclusion(Notification notif, Trigger trigger) {
                return new UniqueTrigger(notif, trigger, Type.EXCLUSION);
            }

            @Override
            public Optional<class_2561> validate(String str) {
                if (str.isBlank()) {
                    return Optional.empty();
                }
                class_5250 err = class_2561.method_43473().method_27692(class_124.field_1061);
                boolean hasErr = this.checkTriggers(err, false, this.notif.triggers, str, "");
                if (this.notif.inclusionEnabled) {
                    boolean bl = hasErr = this.checkTriggers(err, hasErr, this.notif.inclusionTriggers, str, ".inclusion") || hasErr;
                }
                if (this.notif.exclusionEnabled) {
                    boolean bl = hasErr = this.checkTriggers(err, hasErr, this.notif.exclusionTriggers, str, ".exclusion") || hasErr;
                }
                if (!(this.type != Type.MAIN || this.notif.inclusionEnabled && !this.notif.inclusionTriggers.isEmpty() || this.notif.exclusionEnabled && !this.notif.exclusionTriggers.isEmpty())) {
                    hasErr = this.checkOtherNotifs(err, hasErr, str);
                }
                return hasErr ? Optional.of(err) : Optional.empty();
            }

            private boolean checkOtherNotifs(class_5250 err, boolean hasErr, String str) {
                int i = 0;
                for (Notification n : Config.get().getNotifs()) {
                    ++i;
                    if (n == this.notif || !n.enabled || n.inclusionEnabled && !n.inclusionTriggers.isEmpty() || n.exclusionEnabled && !n.exclusionTriggers.isEmpty()) continue;
                    int j = 0;
                    for (Trigger t : n.triggers) {
                        ++j;
                        if (t.type != this.trigger.type || !t.string.equals(str)) continue;
                        if (hasErr) {
                            err.method_27693("\n");
                        }
                        err.method_10852((class_2561)Localization.localized("ui", "field.error.trigger.duplicate", class_2561.method_43470((String)String.valueOf(j)).method_27692(class_124.field_1065), class_2561.method_43470((String)String.valueOf(i)).method_27692(class_124.field_1065)));
                        return true;
                    }
                }
                return hasErr;
            }

            private boolean checkTriggers(class_5250 err, boolean hasErr, List<Trigger> triggers, String str, String errKey) {
                int i = 0;
                for (Trigger t : triggers) {
                    ++i;
                    if (t.equals(this.trigger) || t.type != this.trigger.type || !t.string.equals(str)) continue;
                    if (hasErr) {
                        err.method_27693("\n");
                    }
                    err.method_10852((class_2561)Localization.localized("ui", "field.error.trigger.duplicate.here" + errKey, class_2561.method_43470((String)String.valueOf(i)).method_27692(class_124.field_1065)));
                    return true;
                }
                return hasErr;
            }

            private static enum Type {
                MAIN,
                INCLUSION,
                EXCLUSION;

            }
        }

        public static class InputKey
        implements Validator {
            List<String> keys;

            public InputKey(List<String> keys) {
                this.keys = keys;
            }

            @Override
            public Optional<class_2561> validate(String str) {
                if (this.keys.contains(str)) {
                    return Optional.empty();
                }
                return Optional.of(Localization.localized("ui", "field.error.input_key", new Object[0]).method_27692(class_124.field_1061));
            }
        }

        public static class PosInt
        implements Validator {
            @Override
            public Optional<class_2561> validate(String str) {
                try {
                    if (Integer.parseInt(str) < 0) {
                        throw new NumberFormatException();
                    }
                    return Optional.empty();
                }
                catch (NumberFormatException ignored) {
                    return Optional.of(Localization.localized("ui", "field.error.pos_int", new Object[0]).method_27692(class_124.field_1061));
                }
            }
        }

        public static class Sound
        implements Validator {
            private final Set<String> sounds = new HashSet<String>(class_310.method_1551().method_1483().method_4864().stream().map(class_2960::toString).toList());

            @Override
            public Optional<class_2561> validate(String str) {
                if (this.sounds.contains(str) || !str.contains(":") && this.sounds.contains("minecraft:" + str)) {
                    return Optional.empty();
                }
                return Optional.of(Localization.localized("ui", "field.error.sound", new Object[0]).method_27692(class_124.field_1061));
            }
        }

        public static class HexColor
        implements Validator {
            @Override
            public Optional<class_2561> validate(String str) {
                if (ColorUtil.parseColor(str) != null) {
                    return Optional.empty();
                }
                return Optional.of(Localization.localized("ui", "field.error.color", new Object[0]).method_27692(class_124.field_1061));
            }
        }

        public static class Regex
        implements Validator {
            @Override
            public Optional<class_2561> validate(String str) {
                try {
                    Pattern.compile(str);
                    return Optional.empty();
                }
                catch (PatternSyntaxException e) {
                    return Optional.of(class_2561.method_43470((String)TextField.fixRegexMessage(e.getMessage())).method_27692(class_124.field_1061));
                }
            }
        }
    }
}

