/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.util;

import java.util.ArrayList;
import java.util.List;

public class TimingUtil {
    private static final List<ScheduledActions> ACTIONS = new ArrayList<ScheduledActions>();

    private TimingUtil() {
        throw new UnsupportedOperationException("This class cannot be instantiated.");
    }

    public static void send(Runnable action, int totalDelay) {
        ACTIONS.add(new ScheduledActions(action, totalDelay));
    }

    public static void clear() {
        ACTIONS.clear();
    }

    public static void tickActions() {
        ACTIONS.removeIf(sa -> {
            if (sa.tick()) {
                sa.exec();
                return false;
            }
            return sa.canRemove();
        });
    }

    private static class ScheduledActions {
        Runnable action;
        int ticks;
        boolean completed;

        ScheduledActions(Runnable action, int delay) {
            this.action = action;
            this.ticks = delay;
            this.completed = false;
        }

        void exec() {
            this.action.run();
        }

        boolean tick() {
            if (--this.ticks <= 0 && !this.completed) {
                this.completed = true;
                return true;
            }
            return false;
        }

        boolean canRemove() {
            return this.completed;
        }
    }
}

