/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.toast;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class NotificationToast
implements Toast {
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"toast/advancement");
    private static final int WIDTH = 160;
    private static final int HEIGHT = 32;
    private static final int X_MARGIN = 10;
    private static final int Y_MARGIN = 6;
    private static final int LINE_SPACE = 3;
    private final int lineHeight;
    private final List<FormattedCharSequence> messageLines;
    private final int displayTime;

    public NotificationToast(Component message, int displayTime) {
        this.messageLines = Minecraft.getInstance().font.split((FormattedText)message, 140);
        Objects.requireNonNull(Minecraft.getInstance().font);
        this.lineHeight = 9 + 3;
        this.displayTime = displayTime;
    }

    @NotNull
    public Toast.Visibility render(@NotNull GuiGraphics graphics, @NotNull ToastComponent component, long elapsedTime) {
        Font font = component.getMinecraft().font;
        if (this.messageLines.size() <= 1) {
            graphics.blitSprite(BACKGROUND_SPRITE, 0, 0, 160, this.height());
        } else {
            int width = 160;
            int height = 32 + this.lineHeight * Math.max(0, this.messageLines.size() - 2);
            int partialSpriteHeight = 28;
            int bottomSpriteHeight = Math.min(4, height - partialSpriteHeight);
            this.renderBackgroundRow(graphics, width, 0, 0, partialSpriteHeight);
            int offset = 10;
            for (int y = partialSpriteHeight; y < height - bottomSpriteHeight; y += offset) {
                int vOffset = 16;
                int vHeight = Math.min(16, height - y - bottomSpriteHeight);
                this.renderBackgroundRow(graphics, width, vOffset, y, vHeight);
            }
            this.renderBackgroundRow(graphics, width, 32 - bottomSpriteHeight, height - bottomSpriteHeight, bottomSpriteHeight);
        }
        if (this.messageLines.size() == 1) {
            graphics.drawString(font, this.messageLines.getFirst(), 10, 6 + this.lineHeight / 2, -1, false);
        } else {
            for (int j = 0; j < this.messageLines.size(); ++j) {
                graphics.drawString(font, this.messageLines.get(j), 10, 6 + this.lineHeight * j, -1, false);
            }
        }
        return (double)elapsedTime < (double)this.displayTime * component.getNotificationDisplayTimeMultiplier() ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
    }

    private void renderBackgroundRow(GuiGraphics graphics, int width, int vOffset, int y, int vHeight) {
        int uWidth = vOffset == 0 ? 20 : 5;
        int uRemainder = Math.min(60, width - uWidth);
        graphics.blitSprite(BACKGROUND_SPRITE, 160, 32, 0, vOffset, 0, y, uWidth, vHeight);
        int offset = 64;
        for (int x = uWidth; x < width - uRemainder; x += offset) {
            graphics.blitSprite(BACKGROUND_SPRITE, 160, 32, 32, vOffset, x, y, Math.min(offset, width - x - uRemainder), vHeight);
        }
        graphics.blitSprite(BACKGROUND_SPRITE, 160, 32, 160 - uRemainder, vOffset, width - uRemainder, y, uRemainder, vHeight);
    }
}

