/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget.list;

import dev.terminalmc.chatnotify.gui.screen.OptionScreen;
import dev.terminalmc.chatnotify.gui.widget.SilentButton;
import dev.terminalmc.chatnotify.gui.widget.slider.DoubleSlider;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OptionList
extends ContainerObjectSelectionList<Entry> {
    protected final Minecraft mc;
    protected final OptionScreen screen;
    protected final int entryWidth;
    protected final int entryHeight;
    protected final int entrySpacing;
    protected int rowWidth;
    protected int dynWideEntryWidth;
    protected int dynEntryWidth;
    protected int entryX;
    protected int dynWideEntryX;
    protected int dynEntryX;
    protected int smallWidgetWidth;
    protected int tinyWidgetWidth;

    public OptionList(Minecraft mc, OptionScreen screen, int width, int height, int y, int entryWidth, int entryHeight, int entrySpacing) {
        super(mc, width, height, y, entryHeight + entrySpacing);
        this.mc = mc;
        this.screen = screen;
        this.entryWidth = entryWidth;
        this.entryHeight = entryHeight;
        this.entrySpacing = entrySpacing;
        this.updateElementBounds();
    }

    protected void updateElementBounds() {
        this.dynWideEntryWidth = Math.max(this.entryWidth, (int)((float)this.width / 100.0f * Math.max(50.0f, 70.0f - (float)Math.max(0, this.width - 600) * 0.05f)));
        this.dynEntryWidth = Math.max(this.entryWidth, (int)((float)this.width / 100.0f * Math.max(30.0f, 50.0f - (float)Math.max(0, this.width - 600) * 0.05f)));
        this.entryX = this.width / 2 - this.entryWidth / 2;
        this.dynWideEntryX = this.width / 2 - this.dynWideEntryWidth / 2;
        this.dynEntryX = this.width / 2 - this.dynEntryWidth / 2;
        this.rowWidth = Math.max(this.entryWidth, this.dynWideEntryWidth) + 40 + 48;
        this.smallWidgetWidth = Math.max(16, this.entryHeight);
        this.tinyWidgetWidth = 16;
    }

    protected void init() {
        double scrollAmount = this.getScrollAmount();
        this.clearEntries();
        this.setFocused(null);
        this.addEntries();
        this.setScrollAmount(scrollAmount);
    }

    public OptionScreen getScreen() {
        return this.screen;
    }

    public void addEntry(int index, Entry entry) {
        this.children().add(index, entry);
    }

    public void addSpacedEntry(Entry entry) {
        super.addEntry((AbstractSelectionList.Entry)entry);
        super.addEntry((AbstractSelectionList.Entry)new Entry.Space(entry));
    }

    public void addSpacedEntry(int index, Entry entry) {
        this.addEntry(index, entry);
        this.addEntry(index + 1, new Entry.Space(entry));
    }

    protected abstract void addEntries();

    public void updateSizeAndPosition(int width, int height, int y) {
        super.updateSizeAndPosition(width, height, y);
        this.updateElementBounds();
        this.init();
    }

    public int getRowWidth() {
        return this.rowWidth;
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + this.rowWidth / 2;
    }

    protected boolean isValidMouseClick(int button) {
        return button == 0 || button == 1;
    }

    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        public static final int SPACE = 4;
        public static final int SPACE_SMALL = 2;
        public static final int SPACE_TINY = 1;
        public static final WidgetSprites OPTION_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"chatnotify", (String)"widget/options_button"), ResourceLocation.fromNamespaceAndPath((String)"chatnotify", (String)"widget/options_button_disabled"), ResourceLocation.fromNamespaceAndPath((String)"chatnotify", (String)"widget/options_button_highlighted"));
        public final List<AbstractWidget> elements = new ArrayList<AbstractWidget>();

        @NotNull
        public List<? extends GuiEventListener> children() {
            return this.elements;
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return this.elements;
        }

        public void render(@NotNull GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            this.elements.forEach(widget -> {
                widget.setY(y);
                widget.render(graphics, mouseX, mouseY, delta);
            });
        }

        public static class Space
        extends Entry {
            private final Entry entry;

            public Space(Entry entry) {
                this.entry = entry;
            }

            public boolean isDragging() {
                return this.entry.isDragging();
            }

            public void setDragging(boolean dragging) {
                this.entry.setDragging(dragging);
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                return this.entry.mouseClicked(mouseX, mouseY, button);
            }

            public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
                return this.entry.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
            }

            public void setFocused(GuiEventListener listener) {
                this.entry.setFocused(listener);
            }

            public GuiEventListener getFocused() {
                return this.entry.getFocused();
            }

            public ComponentPath focusPathAtIndex(@NotNull FocusNavigationEvent event, int i) {
                if (this.entry.children().isEmpty()) {
                    return null;
                }
                ComponentPath $$2 = this.entry.children().get(Math.min(i, this.entry.children().size() - 1)).nextFocusPath(event);
                return ComponentPath.path((ContainerEventHandler)this.entry, (ComponentPath)$$2);
            }
        }

        public static class DoubleSlider
        extends Entry {
            public DoubleSlider(int x, int width, int height, double min, double max, int precision, @Nullable String messagePrefix, @Nullable String messageSuffix, @Nullable String valueNameMin, @Nullable String valueNameMax, Supplier<Double> source, Consumer<Double> dest) {
                this.elements.add(new dev.terminalmc.chatnotify.gui.widget.slider.DoubleSlider(x, 0, width, height, min, max, precision, messagePrefix, messageSuffix, valueNameMin, valueNameMax, source, dest));
            }
        }

        public static class SilentActionButton
        extends Entry {
            public SilentActionButton(int x, int width, int height, Component message, @Nullable Tooltip tooltip, int tooltipDelay, Button.OnPress onPress) {
                SilentButton silentButton = new SilentButton(x, 0, width, height, message, onPress);
                if (tooltip != null) {
                    silentButton.setTooltip(tooltip);
                }
                if (tooltipDelay >= 0) {
                    silentButton.setTooltipDelay(Duration.ofMillis(tooltipDelay));
                }
                this.elements.add(silentButton);
            }
        }

        public static class ActionButton
        extends Entry {
            private final Button button;

            public ActionButton(int x, int width, int height, Component message, @Nullable Tooltip tooltip, int tooltipDelay, Button.OnPress onPress) {
                this.button = Button.builder((Component)message, (Button.OnPress)onPress).pos(x, 0).size(width, height).build();
                if (tooltip != null) {
                    this.button.setTooltip(tooltip);
                }
                if (tooltipDelay >= 0) {
                    this.button.setTooltipDelay(Duration.ofMillis(tooltipDelay));
                }
                this.elements.add(this.button);
            }

            public void setBounds(int x, int width, int height) {
                this.button.setPosition(x, 0);
                this.button.setSize(width, height);
            }
        }

        public static class Text
        extends Entry {
            public Text(int x, int width, int height, Component message, @Nullable Tooltip tooltip, int tooltipDelay) {
                Object widget = Minecraft.getInstance().font.width(message.getString()) <= width ? new StringWidget(x, 0, width, height, message, Minecraft.getInstance().font) : new MultiLineTextWidget(x, 0, message, Minecraft.getInstance().font).setMaxWidth(width).setCentered(true);
                if (tooltip != null) {
                    widget.setTooltip(tooltip);
                }
                if (tooltipDelay >= 0) {
                    widget.setTooltipDelay(Duration.ofMillis(tooltipDelay));
                }
                this.elements.add(widget);
            }
        }
    }
}

