/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget.list.root.notif;

import dev.terminalmc.chatnotify.config.Notification;
import dev.terminalmc.chatnotify.config.TextStyle;
import dev.terminalmc.chatnotify.gui.screen.OptionScreen;
import dev.terminalmc.chatnotify.gui.widget.HsvColorPicker;
import dev.terminalmc.chatnotify.gui.widget.field.TextField;
import dev.terminalmc.chatnotify.gui.widget.list.OptionList;
import dev.terminalmc.chatnotify.mixin.accessor.TextColorAccessor;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.Unicode;
import dev.terminalmc.chatnotify.util.text.ColorUtil;
import java.awt.Color;
import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FastColor;

public class FormatList
extends OptionList {
    private final Notification notif;

    public FormatList(Minecraft mc, OptionScreen screen, int width, int height, int y, int entryWidth, int entryHeight, int entrySpacing, Notification notif) {
        super(mc, screen, width, height, y, entryWidth, entryHeight, entrySpacing);
        this.notif = notif;
    }

    @Override
    protected void addEntries() {
        this.addEntry((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (Component)Localization.localized("option", "notif.format.list", Unicode.INFO.str), Tooltip.create((Component)Localization.localized("option", "notif.format.list.tooltip", new Object[0])), -1));
        this.addEntry((AbstractSelectionList.Entry)new Entry.ColorOptions(this.entryX, this.entryWidth, this.entryHeight, this, () -> this.notif.textStyle.color, val -> {
            this.notif.textStyle.color = val;
        }, () -> this.notif.textStyle.doColor, val -> {
            this.notif.textStyle.doColor = val;
        }, Localization.localized("option", "notif.format.color", new Object[0])));
        this.addEntry((AbstractSelectionList.Entry)new Entry.FormatOptions(this.entryX, this.entryWidth, this.entryHeight, this.notif, true));
        this.addEntry((AbstractSelectionList.Entry)new Entry.FormatOptions(this.entryX, this.entryWidth, this.entryHeight, this.notif, false));
    }

    private void initList() {
        this.init();
    }

    static abstract class Entry
    extends OptionList.Entry {
        Entry() {
        }

        private static class FormatOptions
        extends Entry {
            private FormatOptions(int x, int width, int height, Notification notif, boolean first) {
                if (first) {
                    this.createFirst(x, width, height, notif);
                } else {
                    this.createSecond(x, width, height, notif);
                }
            }

            private void createFirst(int x, int width, int height, Notification notif) {
                int buttonWidth = (width - 8) / 3;
                CycleButton boldButton = CycleButton.builder(state -> this.getMessage((TextStyle.FormatMode)((Object)state), ChatFormatting.BOLD)).withValues((Object[])TextStyle.FormatMode.values()).withInitialValue((Object)notif.textStyle.bold).withTooltip(this::getTooltip).create(x, 0, buttonWidth, height, (Component)Localization.localized("option", "notif.format.bold", new Object[0]), (button, state) -> {
                    notif.textStyle.bold = state;
                });
                boldButton.setTooltipDelay(Duration.ofMillis(500L));
                this.elements.add(boldButton);
                CycleButton italicButton = CycleButton.builder(state -> this.getMessage((TextStyle.FormatMode)((Object)state), ChatFormatting.ITALIC)).withValues((Object[])TextStyle.FormatMode.values()).withInitialValue((Object)notif.textStyle.italic).withTooltip(this::getTooltip).create(x + width / 2 - buttonWidth / 2, 0, buttonWidth, height, (Component)Localization.localized("option", "notif.format.italic", new Object[0]), (button, state) -> {
                    notif.textStyle.italic = state;
                });
                italicButton.setTooltipDelay(Duration.ofMillis(500L));
                this.elements.add(italicButton);
                CycleButton underlineButton = CycleButton.builder(state -> this.getMessage((TextStyle.FormatMode)((Object)state), ChatFormatting.UNDERLINE)).withValues((Object[])TextStyle.FormatMode.values()).withInitialValue((Object)notif.textStyle.underlined).withTooltip(this::getTooltip).create(x + width - buttonWidth, 0, buttonWidth, height, (Component)Localization.localized("option", "notif.format.underline", new Object[0]), (button, state) -> {
                    notif.textStyle.underlined = state;
                });
                underlineButton.setTooltipDelay(Duration.ofMillis(500L));
                this.elements.add(underlineButton);
            }

            private void createSecond(int x, int width, int height, Notification notif) {
                int buttonWidth = (width - 4) / 2;
                CycleButton strikethroughButton = CycleButton.builder(state -> this.getMessage((TextStyle.FormatMode)((Object)state), ChatFormatting.STRIKETHROUGH)).withValues((Object[])TextStyle.FormatMode.values()).withInitialValue((Object)notif.textStyle.strikethrough).withTooltip(this::getTooltip).create(x, 0, buttonWidth, height, (Component)Localization.localized("option", "notif.format.strikethrough", new Object[0]), (button, state) -> {
                    notif.textStyle.strikethrough = state;
                });
                strikethroughButton.setTooltipDelay(Duration.ofMillis(500L));
                this.elements.add(strikethroughButton);
                CycleButton obfuscateButton = CycleButton.builder(state -> this.getMessage((TextStyle.FormatMode)((Object)state), ChatFormatting.OBFUSCATED)).withValues((Object[])TextStyle.FormatMode.values()).withInitialValue((Object)notif.textStyle.obfuscated).withTooltip(this::getTooltip).create(x + width - buttonWidth, 0, buttonWidth, height, (Component)Localization.localized("option", "notif.format.obfuscate", new Object[0]), (button, state) -> {
                    notif.textStyle.obfuscated = state;
                });
                obfuscateButton.setTooltipDelay(Duration.ofMillis(500L));
                this.elements.add(obfuscateButton);
            }

            private Component getMessage(TextStyle.FormatMode mode, ChatFormatting format) {
                return switch (mode) {
                    case TextStyle.FormatMode.ON -> CommonComponents.OPTION_ON.copy().withStyle(format).withStyle(ChatFormatting.GREEN);
                    case TextStyle.FormatMode.OFF -> CommonComponents.OPTION_OFF.copy().withStyle(ChatFormatting.RED);
                    default -> Component.literal((String)"/").withStyle(ChatFormatting.GRAY);
                };
            }

            private Tooltip getTooltip(TextStyle.FormatMode mode) {
                return mode.equals((Object)TextStyle.FormatMode.DISABLED) ? Tooltip.create((Component)Localization.localized("option", "notif.format.disabled.tooltip", new Object[0])) : null;
            }
        }

        private static class ColorOptions
        extends Entry {
            ColorOptions(int x, int width, int height, FormatList list, Supplier<Integer> supplier, Consumer<Integer> consumer, Supplier<Boolean> statusSupplier, Consumer<Boolean> statusConsumer, MutableComponent text) {
                int statusButtonWidth = Math.max(24, height);
                int colorFieldWidth = Minecraft.getInstance().font.width("#FFAAFF+++");
                int mainButtonWidth = width - colorFieldWidth - statusButtonWidth - 8;
                Button mainButton = Button.builder((Component)text.withColor(supplier.get().intValue()), button -> {
                    int cpHeight = 80;
                    int cpWidth = 200;
                    list.getScreen().setOverlayWidget(new HsvColorPicker(x + width / 2 - cpWidth / 2, list.getScreen().height / 2 - cpHeight / 2, cpWidth, cpHeight, supplier, consumer, widget -> list.initList()));
                }).pos(x, 0).size(mainButtonWidth, height).build();
                this.elements.add(mainButton);
                TextField colorField = new TextField(x + mainButtonWidth + 4, 0, colorFieldWidth, height);
                colorField.hexColorValidator().strict();
                colorField.setMaxLength(7);
                colorField.setResponder(val -> {
                    TextColor textColor = ColorUtil.parseColor(val);
                    if (textColor != null) {
                        int color = textColor.getValue();
                        consumer.accept(color);
                        mainButton.setMessage((Component)mainButton.getMessage().copy().withColor(color));
                        float[] hsv = new float[3];
                        Color.RGBtoHSB(FastColor.ARGB32.red((int)color), FastColor.ARGB32.green((int)color), FastColor.ARGB32.blue((int)color), hsv);
                        if ((double)hsv[2] < 0.1) {
                            colorField.setTextColor(0xFFFFFF);
                        } else {
                            colorField.setTextColor(color);
                        }
                    }
                });
                colorField.setValue(((TextColorAccessor)TextColor.fromRgb((int)supplier.get())).chatnotify$formatValue());
                this.elements.add(colorField);
                this.elements.add(CycleButton.booleanBuilder((Component)CommonComponents.OPTION_ON.copy().withStyle(ChatFormatting.GREEN), (Component)CommonComponents.OPTION_OFF.copy().withStyle(ChatFormatting.RED)).displayOnlyValue().withInitialValue((Object)statusSupplier.get()).create(x + width - statusButtonWidth, 0, statusButtonWidth, height, (Component)Component.empty(), (button, status) -> statusConsumer.accept((Boolean)status)));
            }
        }
    }
}

