/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify;

import com.mojang.datafixers.util.Pair;
import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.config.Notification;
import dev.terminalmc.chatnotify.config.StyleTarget;
import dev.terminalmc.chatnotify.config.Trigger;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.ModLogger;
import dev.terminalmc.chatnotify.util.ResponseUtil;
import dev.terminalmc.chatnotify.util.TimingUtil;
import dev.terminalmc.chatnotify.util.text.FormatUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_442;

public class ChatNotify {
    public static final String MOD_ID = "chatnotify";
    public static final String MOD_NAME = "ChatNotify";
    public static final ModLogger LOG = new ModLogger("ChatNotify");
    public static boolean hasResetConfig = false;
    public static final List<Pair<Long, String>> recentMessages = new ArrayList<Pair<Long, String>>();
    public static final Queue<class_2561> unmodifiedChat = new LinkedList<class_2561>();

    public static void init() {
        Config.getAndSave();
    }

    public static void onConfigSaved(Config config) {
        for (Notification notif : config.getNotifs()) {
            for (Trigger trig : notif.triggers) {
                if (trig.type == Trigger.Type.REGEX) {
                    trig.tryCompilePattern();
                }
                if (trig.styleTarget.type == StyleTarget.Type.REGEX) {
                    trig.styleTarget.tryCompilePattern();
                    continue;
                }
                if (trig.styleTarget.type != StyleTarget.Type.CAPTURING) continue;
                trig.styleTarget.tryParseIndexes();
            }
            for (Trigger trig : notif.exclusionTriggers) {
                if (trig.type != Trigger.Type.REGEX) continue;
                trig.tryCompilePattern();
            }
        }
    }

    public static void afterClientTick(class_310 mc) {
        ResponseUtil.tickResponses(mc);
        TimingUtil.tickActions();
        if (hasResetConfig && mc.field_1755 instanceof class_442) {
            hasResetConfig = false;
            mc.method_1566().method_1999((class_368)new class_370(new class_370.class_9037(15000L), (class_2561)Localization.localized("toast", "reset.title", new Object[0]), (class_2561)Localization.localized("toast", "reset.message", class_2561.method_43470((String)"chatnotify.unreadable.json").method_27692(class_124.field_1065))));
        }
    }

    public static void updateUsernameNotif(Config config) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null) {
            config.setProfileName(FormatUtil.stripCodes(mc.field_1724.method_5477().getString()));
            config.setDisplayName(FormatUtil.stripCodes(mc.field_1724.method_5476().getString()));
        }
    }
}

