/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget;

import dev.terminalmc.chatnotify.gui.widget.OverlayWidget;
import dev.terminalmc.chatnotify.gui.widget.field.TextField;
import dev.terminalmc.chatnotify.mixin.accessor.TextColorAccessor;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.inject.IGuiGraphics;
import dev.terminalmc.chatnotify.util.text.ColorUtil;
import java.awt.Color;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_5251;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;

public class HsvColorPicker
extends OverlayWidget {
    public static final int GUI_SHADOW = -1610612736;
    public static final int GUI_LIGHT = -6250336;
    public static final int GUI_DARK = -13882324;
    public static final int ARGB_WHITE = -1;
    public static final int ARGB_RED = -65536;
    public static final int ARGB_YELLOW = -256;
    public static final int ARGB_GREEN = -16711936;
    public static final int ARGB_CYAN = -16711681;
    public static final int ARGB_BLUE = -16776961;
    public static final int ARGB_MAGENTA = -65281;
    public static final int[] ARGB_GRADIENT = new int[]{-65536, -256, -16711936, -16711681, -16776961, -65281, -65536};
    public static final int MIN_WIDTH = 200;
    public static final int MIN_HEIGHT = 80;
    public static final int MAX_WIDTH = 400;
    public static final int MAX_HEIGHT = 300;
    public static final int BORDER = 2;
    public static final int OUTLINE = 1;
    public static final int CURSOR = 1;
    private final String newColorLabel = " " + Localization.localized("common", "new", new Object[0]).getString() + " ";
    private final String oldColorLabel = " " + Localization.localized("common", "old", new Object[0]).getString() + " ";
    private final Supplier<Integer> source;
    private final Consumer<Integer> dest;
    private boolean hasClickedOnH = false;
    private boolean hasClickedOnSv = false;
    private int hsvPickerBoxWidth;
    private int svFieldX;
    private int svFieldY;
    private int svFieldWidth;
    private int svFieldHeight;
    private int svCursorX;
    private int svCursorY;
    private int hFieldX;
    private int hFieldY;
    private int hFieldWidth;
    private int hFieldHeight;
    private int hSecSize;
    private int hCursorY;
    private int newCFieldX;
    private int newCFieldY;
    private int newCFieldWidth;
    private int newCFieldHeight;
    private int newCFieldTextX;
    private int newCFieldTextY;
    private int oldCFieldX;
    private int oldCFieldY;
    private int oldCFieldWidth;
    private int oldCFieldHeight;
    private int oldCFieldTextX;
    private int oldCFieldTextY;
    private TextField hexField;
    private class_4185 cancelButton;
    private class_4185 confirmButton;
    private final float[] hsv = new float[3];
    private int oldColor;
    private boolean updateFromCursor;

    public HsvColorPicker(int x, int y, int width, int height, Supplier<Integer> source, Consumer<Integer> dest, Consumer<OverlayWidget> close) {
        super(x, y, width, height, true, (class_2561)class_2561.method_43473(), close);
        this.source = source;
        this.dest = dest;
        this.updateColorFromSource();
        this.init();
    }

    @Override
    protected void init() {
        class_310 mc = class_310.method_1551();
        int hexFieldHeight = 20;
        int minColorBoxWidth = 12;
        int interiorWidth = this.field_22758 - 4;
        int interiorHeight = this.field_22759 - 4;
        this.hsvPickerBoxWidth = interiorWidth / 2;
        this.hFieldWidth = minColorBoxWidth;
        this.hSecSize = (interiorHeight - 2) / 6;
        this.hFieldHeight = this.hSecSize * 6;
        this.svFieldWidth = this.hsvPickerBoxWidth - this.hFieldWidth - 4 - 4;
        this.svFieldHeight = this.hFieldHeight;
        this.svFieldX = 3;
        this.hFieldX = this.svFieldX + this.svFieldWidth + 2 + 2;
        this.svFieldY = this.hFieldY = 3 + (interiorHeight - (this.hFieldHeight + 2)) / 2;
        class_327 font = mc.field_1772;
        int hexFieldX = 2 + this.hsvPickerBoxWidth;
        int hexFieldY = 2;
        int hexFieldWidth = interiorWidth - this.hsvPickerBoxWidth;
        this.hexField = new TextField(this.method_46426() + hexFieldX, this.method_46427() + hexFieldY, hexFieldWidth, hexFieldHeight);
        this.hexField.strict().hexColorValidator();
        this.hexField.method_1880(7);
        this.hexField.method_1863(this::updateColorFromHexField);
        this.hexField.method_1852(((TextColorAccessor)class_5251.method_27717((int)Color.HSBtoRGB(this.hsv[0], this.hsv[1], this.hsv[2]))).chatnotify$formatValue());
        int cancelButtonWidth = interiorWidth - this.hsvPickerBoxWidth - this.hsvPickerBoxWidth / 2;
        int buttonHeight = 20;
        int cancelButtonX = 2 + this.hsvPickerBoxWidth;
        int buttonY = 2 + interiorHeight - buttonHeight;
        this.cancelButton = class_4185.method_46430((class_2561)class_5244.field_24335, button -> this.onClose()).method_46433(this.method_46426() + cancelButtonX, this.method_46427() + buttonY).method_46437(cancelButtonWidth, buttonHeight).method_46431();
        int confirmButtonWidth = interiorWidth - this.hsvPickerBoxWidth - cancelButtonWidth;
        int confirmButtonX = 2 + this.hsvPickerBoxWidth + cancelButtonWidth;
        this.confirmButton = class_4185.method_46430((class_2561)class_5244.field_24334, button -> {
            this.dest.accept(class_3532.method_15369((float)this.hsv[0], (float)this.hsv[1], (float)this.hsv[2]));
            this.onClose();
        }).method_46433(this.method_46426() + confirmButtonX, this.method_46427() + buttonY).method_46437(confirmButtonWidth, buttonHeight).method_46431();
        int cFieldTextWidth = Math.min(Math.max(font.method_1727(this.newColorLabel), font.method_1727(this.oldColorLabel)), interiorWidth - this.hsvPickerBoxWidth - minColorBoxWidth);
        int combinedCFieldHeight = interiorHeight - hexFieldHeight - buttonHeight - 4;
        this.newCFieldWidth = hexFieldWidth - cFieldTextWidth - 2;
        this.newCFieldHeight = combinedCFieldHeight / 2;
        this.newCFieldX = hexFieldX + cFieldTextWidth + 1;
        this.newCFieldY = hexFieldY + hexFieldHeight + 1;
        this.newCFieldTextX = this.method_46426() + this.newCFieldX - cFieldTextWidth - 1;
        int n = this.method_46427() + this.newCFieldY;
        Objects.requireNonNull(font);
        this.newCFieldTextY = n + (this.newCFieldHeight - 9) / 2;
        this.oldCFieldWidth = this.newCFieldWidth;
        this.oldCFieldHeight = combinedCFieldHeight - this.newCFieldHeight;
        this.oldCFieldX = this.newCFieldX;
        this.oldCFieldY = this.newCFieldY + this.newCFieldHeight + 2;
        this.oldCFieldTextX = this.newCFieldTextX;
        int n2 = this.method_46427() + this.oldCFieldY;
        Objects.requireNonNull(font);
        this.oldCFieldTextY = n2 + (this.oldCFieldHeight - 9) / 2;
    }

    @Override
    public int getMinWidth() {
        return 200;
    }

    @Override
    public int getMaxWidth() {
        return 400;
    }

    @Override
    public int getMinHeight() {
        return 80;
    }

    @Override
    public int getMaxHeight() {
        return 300;
    }

    public void updateColorFromSource() {
        int color = this.source.get();
        Color.RGBtoHSB(class_9848.method_61327((int)color), class_9848.method_61329((int)color), class_9848.method_61331((int)color), this.hsv);
        this.oldColor = color;
        if (this.hexField != null) {
            this.hexField.method_1852(((TextColorAccessor)class_5251.method_27717((int)color)).chatnotify$formatValue());
        }
    }

    private void updateHexField() {
        this.updateFromCursor = true;
        int color = Color.HSBtoRGB(this.hsv[0], this.hsv[1], this.hsv[2]);
        this.hexField.method_1852(((TextColorAccessor)class_5251.method_27717((int)color)).chatnotify$formatValue());
        this.updateFromCursor = false;
    }

    private void updateColorFromHexField(String s) {
        class_5251 textColor = ColorUtil.parseColor(s);
        if (textColor != null) {
            int color = textColor.method_27716();
            if (!this.updateFromCursor) {
                Color.RGBtoHSB(class_9848.method_61327((int)color), class_9848.method_61329((int)color), class_9848.method_61331((int)color), this.hsv);
                this.updateHCursor();
                this.updateSvCursor();
            }
            if ((double)this.hsv[2] < 0.1) {
                this.hexField.method_1868(-1);
            } else {
                this.hexField.method_1868(0xFF000000 | color);
            }
        }
    }

    private void updateHCursor() {
        this.hCursorY = this.hFieldY + (int)(this.hsv[0] * (float)this.hFieldHeight);
    }

    private void updateSvCursor() {
        this.svCursorX = this.svFieldX + (int)(this.hsv[1] * (float)this.svFieldWidth);
        this.svCursorY = this.svFieldY + (int)((1.0f - this.hsv[2]) * (float)this.svFieldHeight);
    }

    private void updateHFromCursor(double cursorY) {
        this.hsv[0] = (float)cursorY / (float)this.hFieldHeight;
        this.updateHexField();
    }

    private void updateSvFromCursor(double cursorX, double cursorY) {
        this.hsv[1] = (float)cursorX / (float)this.svFieldWidth;
        this.hsv[2] = 1.0f - (float)cursorY / (float)this.svFieldHeight;
        this.updateHexField();
    }

    private float getHFromCursor() {
        return ((float)this.hCursorY - (float)this.hFieldY) / (float)this.hFieldHeight;
    }

    public boolean method_25404(class_11908 event) {
        if (this.hexField.method_25370()) {
            return this.hexField.method_25404(event);
        }
        return false;
    }

    public boolean method_25400(class_11905 event) {
        if (this.hexField.method_25370()) {
            return this.hexField.method_25400(event);
        }
        return false;
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        this.hasClickedOnH = false;
        this.hasClickedOnSv = false;
        if (this.mouseOnElement(event.comp_4798(), event.comp_4799(), this.method_46426(), this.method_46427(), this.field_22758, this.field_22759).isPresent()) {
            if (this.mouseOnWidget((class_339)this.hexField, event.comp_4798(), event.comp_4799())) {
                if (!this.hexField.method_25370()) {
                    this.hexField.method_25365(true);
                } else {
                    this.hexField.method_25402(event, doubleClick);
                }
                return true;
            }
            this.hexField.method_25365(false);
            if (event.method_74245() == 0) {
                Optional<double[]> hFieldCursor = this.mouseOnElement(event.comp_4798(), event.comp_4799(), this.method_46426() + this.hFieldX, this.method_46427() + this.hFieldY, this.hFieldWidth, this.hFieldHeight);
                if (hFieldCursor.isPresent()) {
                    this.hasClickedOnH = true;
                    this.hCursorY = (int)hFieldCursor.get()[1] + this.hFieldY;
                    this.updateHFromCursor(hFieldCursor.get()[1]);
                    return true;
                }
                Optional<double[]> svFieldCursor = this.mouseOnElement(event.comp_4798(), event.comp_4799(), this.method_46426() + this.svFieldX, this.method_46427() + this.svFieldY, this.svFieldWidth, this.svFieldHeight);
                if (svFieldCursor.isPresent()) {
                    this.hasClickedOnSv = true;
                    this.svCursorX = (int)svFieldCursor.get()[0] + this.svFieldX;
                    this.svCursorY = (int)svFieldCursor.get()[1] + this.svFieldY;
                    this.updateSvFromCursor(svFieldCursor.get()[0], svFieldCursor.get()[1]);
                    return true;
                }
                if (this.mouseOnWidget((class_339)this.cancelButton, event.comp_4798(), event.comp_4799())) {
                    this.cancelButton.method_25402(event, doubleClick);
                    return true;
                }
                if (this.mouseOnWidget((class_339)this.confirmButton, event.comp_4798(), event.comp_4799())) {
                    this.confirmButton.method_25402(event, doubleClick);
                    return true;
                }
            }
        } else {
            this.onClose();
        }
        return true;
    }

    public boolean method_25403(class_11909 event, double deltaX, double deltaY) {
        if (this.hasClickedOnH) {
            double cursorY = event.comp_4799() - (double)this.method_46427();
            if (cursorY < (double)this.hFieldY) {
                cursorY = this.hFieldY;
            } else if (cursorY > (double)(this.hFieldY + this.hFieldHeight)) {
                cursorY = this.hFieldY + this.hFieldHeight;
            }
            this.updateHFromCursor(cursorY - (double)this.hFieldY);
            this.hCursorY = (int)cursorY;
            return true;
        }
        if (this.hasClickedOnSv) {
            double cursorX = event.comp_4798() - (double)this.method_46426();
            double cursorY = event.comp_4799() - (double)this.method_46427();
            if (cursorX < (double)this.svFieldX) {
                cursorX = this.svFieldX;
            } else if (cursorX > (double)(this.svFieldX + this.svFieldWidth)) {
                cursorX = this.svFieldX + this.svFieldWidth;
            }
            if (cursorY < (double)this.svFieldY) {
                cursorY = this.svFieldY;
            } else if (cursorY > (double)(this.svFieldY + this.svFieldHeight)) {
                cursorY = this.svFieldY + this.svFieldHeight;
            }
            this.updateSvFromCursor(cursorX - (double)this.svFieldX, cursorY - (double)this.svFieldY);
            this.svCursorX = (int)cursorX;
            this.svCursorY = (int)cursorY;
            return true;
        }
        return super.method_25403(event, deltaX, deltaY);
    }

    private boolean mouseOnWidget(class_339 widget, double mouseX, double mouseY) {
        Optional<double[]> mouseOnWidget = this.mouseOnElement(mouseX, mouseY, widget.method_46426(), widget.method_46427(), widget.method_25368(), widget.method_25364());
        return mouseOnWidget.isPresent();
    }

    private Optional<double[]> mouseOnElement(double mouseX, double mouseY, int elementX, int elementY, int elementWidth, int elementHeight) {
        if ((double)elementX <= mouseX && mouseX < (double)(elementX + elementWidth) && (double)elementY <= mouseY && mouseY < (double)(elementY + elementHeight)) {
            return Optional.of(new double[]{mouseX - (double)elementX, mouseY - (double)elementY});
        }
        return Optional.empty();
    }

    protected void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float delta) {
        this.drawColorPicker(graphics);
        graphics.method_25303(class_310.method_1551().field_1772, this.newColorLabel, this.newCFieldTextX, this.newCFieldTextY, -1);
        graphics.method_25303(class_310.method_1551().field_1772, this.oldColorLabel, this.oldCFieldTextX, this.oldCFieldTextY, -1);
        this.hexField.method_48579(graphics, mouseX, mouseY, delta);
        this.cancelButton.method_25394(graphics, mouseX, mouseY, delta);
        this.confirmButton.method_25394(graphics, mouseX, mouseY, delta);
    }

    private void drawColorPicker(@NotNull class_332 graphics) {
        int left = this.method_46426();
        int top = this.method_46427();
        int right = left + this.field_22758;
        int bottom = top + this.field_22759;
        int insideL = left + 2;
        int insideT = top + 2;
        int insideR = right - 2;
        int insideB = bottom - 2;
        int svL = left + this.svFieldX;
        int svT = top + this.svFieldY;
        int svR = svL + this.svFieldWidth;
        int svB = svT + this.svFieldHeight;
        int hL = left + this.hFieldX;
        int hT = top + this.hFieldY;
        int hR = hL + this.hFieldWidth;
        int hB = hT + this.hFieldHeight;
        int ncL = left + this.newCFieldX;
        int ncT = top + this.newCFieldY;
        int ncR = ncL + this.newCFieldWidth;
        int ncB = ncT + this.newCFieldHeight;
        int ocL = left + this.oldCFieldX;
        int ocT = top + this.oldCFieldY;
        int ocR = ocL + this.oldCFieldWidth;
        int ocB = ocT + this.oldCFieldHeight;
        graphics.method_25294(0, 0, graphics.method_51421(), graphics.method_51443(), -1610612736);
        graphics.method_25294(left, top, right, bottom, -6250336);
        graphics.method_25294(insideL, insideT, insideR, insideB, -13882324);
        graphics.method_25294(insideL, insideT, insideL + this.hsvPickerBoxWidth, insideB, -6250336);
        graphics.method_25294(svL - 1, svT - 1, svR + 1, svB + 1, -13882324);
        graphics.method_25294(svL, svT, svR, svB, -1);
        int rgb = Color.HSBtoRGB(this.getHFromCursor(), 1.0f, 1.0f);
        ((IGuiGraphics)graphics).chatnotify$fillGradientHorizontal(svL, svT, svR, svB, rgb & 0xFFFFFF, 0xFF000000 | rgb);
        graphics.method_25296(svL, svT, svR, svB, 0, -16777216);
        int limitSvCursorY = top + Math.min(this.svCursorY, this.svFieldY + this.svFieldHeight - 1);
        graphics.method_25294(svL, limitSvCursorY, svR, limitSvCursorY + 1, -6250336);
        int limitSvCursorX = left + Math.min(this.svCursorX, this.svFieldX + this.svFieldWidth - 1);
        graphics.method_25294(limitSvCursorX, svT, limitSvCursorX + 1, svB, -6250336);
        graphics.method_25294(hL - 1, hT - 1, hR + 1, hB + 1, -13882324);
        int start = hT;
        int end = start + this.hSecSize;
        for (int i = 0; i < ARGB_GRADIENT.length - 1; ++i) {
            graphics.method_25296(hL, start, hR, end, ARGB_GRADIENT[i], ARGB_GRADIENT[i + 1]);
            start = end;
            end += this.hSecSize;
        }
        int limitHCursorY = Math.min(this.hCursorY, this.hFieldY + this.hFieldHeight - 1);
        graphics.method_25294(hL, top + limitHCursorY, hR, top + limitHCursorY + 1, -6250336);
        graphics.method_25294(ncL - 1, ncT - 1, ncR + 1, ncB + 1, -6250336);
        rgb = class_3532.method_15369((float)this.hsv[0], (float)this.hsv[1], (float)this.hsv[2]);
        graphics.method_25294(ncL, ncT, ncR, ncB, 0xFF000000 | rgb);
        graphics.method_25294(ocL - 1, ocT - 1, ocR + 1, ocB + 1, -6250336);
        graphics.method_25294(ocL, ocT, ocR, ocB, 0xFF000000 | this.oldColor);
    }
}

