/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.datafixers.util.Pair;
import dev.terminalmc.chatnotify.ChatNotify;
import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.util.text.FormatUtil;
import dev.terminalmc.chatnotify.util.text.MessageUtil;
import net.minecraft.class_2561;
import net.minecraft.class_2678;
import net.minecraft.class_2703;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_640;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_634.class}, priority=792)
public class ClientPacketListenerMixin {
    @WrapOperation(method={"method_34076(Lnet/minecraft/class_5894;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_329;method_1758(Lnet/minecraft/class_2561;Z)V")})
    private void wrapSetOverlayMessage(class_329 instance, class_2561 message, boolean animateColor, Operation<Void> original) {
        if (Config.get().actionBarDetectionMode.equals((Object)Config.CommonDetectionMode.PACKET)) {
            if ((message = MessageUtil.processMessage(message)) != null) {
                original.call(new Object[]{instance, message, animateColor});
            }
        } else {
            original.call(new Object[]{instance, message, animateColor});
        }
    }

    @WrapOperation(method={"method_34083(Lnet/minecraft/class_5904;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_329;method_34004(Lnet/minecraft/class_2561;)V")})
    private void wrapSetTitle(class_329 instance, class_2561 message, Operation<Void> original) {
        if (Config.get().titleDetectionMode.equals((Object)Config.CommonDetectionMode.PACKET)) {
            if ((message = MessageUtil.processMessage(message)) != null) {
                original.call(new Object[]{instance, message});
            }
        } else {
            original.call(new Object[]{instance, message});
        }
    }

    @WrapOperation(method={"method_34082(Lnet/minecraft/class_5903;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_329;method_34002(Lnet/minecraft/class_2561;)V")})
    private void wrapSetSubtitle(class_329 instance, class_2561 message, Operation<Void> original) {
        if (Config.get().subtitleDetectionMode.equals((Object)Config.CommonDetectionMode.PACKET)) {
            if ((message = MessageUtil.processMessage(message)) != null) {
                original.call(new Object[]{instance, message});
            }
        } else {
            original.call(new Object[]{instance, message});
        }
    }

    @Inject(method={"method_11120(Lnet/minecraft/class_2678;)V"}, at={@At(value="TAIL")})
    private void getProfileName(class_2678 packet, CallbackInfo ci) {
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        String name = FormatUtil.stripCodes(class_310.method_1551().field_1724.method_5477().getString());
        Config.get().setProfileName(name);
        Config.get().setDisplayName(name);
    }

    @Inject(method={"method_45726(Lnet/minecraft/class_2703$class_5893;Lnet/minecraft/class_2703$class_2705;Lnet/minecraft/class_640;)V"}, at={@At(value="TAIL")})
    private void getDisplayName(class_2703.class_5893 action, class_2703.class_2705 entry, class_640 playerInfo, CallbackInfo ci) {
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        if (action.equals((Object)class_2703.class_5893.field_29139) && playerInfo.method_2966().id().equals(class_310.method_1551().field_1724.method_5667()) && entry.comp_1111() != null) {
            Config.get().setDisplayName(FormatUtil.stripCodes(entry.comp_1111().getString()));
        }
    }

    @Inject(method={"method_45729(Ljava/lang/String;)V"}, at={@At(value="HEAD")})
    private void getMessage(String message, CallbackInfo ci) {
        this.chatnotify$storeMessage(message);
    }

    @Inject(method={"method_45730(Ljava/lang/String;)V"}, at={@At(value="HEAD")})
    private void getCommand(String command, CallbackInfo ci) {
        this.chatnotify$storeCommand(command);
    }

    @Inject(method={"method_71927(Ljava/lang/String;Lnet/minecraft/class_437;)V"}, at={@At(value="HEAD")})
    private void getUnsignedCommand(String command, class_437 screen, CallbackInfo ci) {
        this.chatnotify$storeCommand(command);
    }

    @Unique
    private void chatnotify$storeMessage(String message) {
        long time = System.nanoTime();
        this.chatnotify$removeOldMessages(time);
        String plainMsg = "";
        for (String prefix : Config.get().prefixes) {
            if (!message.startsWith(prefix)) continue;
            plainMsg = message.replaceFirst(prefix, "").strip();
            break;
        }
        ChatNotify.recentMessages.add((Pair<Long, String>)Pair.of((Object)(time + 5000000000L), (Object)(plainMsg.isEmpty() ? message : plainMsg)));
    }

    @Unique
    private void chatnotify$storeCommand(String command) {
        long time = System.currentTimeMillis();
        this.chatnotify$removeOldMessages(time);
        command = "/" + (String)command;
        for (String prefix : Config.get().prefixes) {
            if (!((String)command).startsWith(prefix)) continue;
            if (((String)(command = ((String)command).replaceFirst(prefix, "").strip())).isEmpty()) break;
            ChatNotify.recentMessages.add((Pair<Long, String>)Pair.of((Object)(time + 5000000000L), (Object)command));
            break;
        }
    }

    @Unique
    private void chatnotify$removeOldMessages(long time) {
        ChatNotify.recentMessages.removeIf(pair -> (Long)pair.getFirst() < time);
    }
}

