/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.screen;

import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.config.Notification;
import dev.terminalmc.chatnotify.gui.screen.OptionScreen;
import dev.terminalmc.chatnotify.gui.widget.list.FilterList;
import dev.terminalmc.chatnotify.gui.widget.list.OptionList;
import dev.terminalmc.chatnotify.gui.widget.list.root.ControlList;
import dev.terminalmc.chatnotify.gui.widget.list.root.DefaultList;
import dev.terminalmc.chatnotify.gui.widget.list.root.DetectionList;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.Unicode;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class RootScreen
extends OptionScreen {
    public RootScreen(Screen lastScreen) {
        this(lastScreen, TabKey.NOTIFICATION.key);
    }

    public RootScreen(Screen lastScreen, String defaultKey) {
        super(lastScreen);
        this.addTabs(defaultKey);
        this.updateTabTitles();
    }

    private void addTabs(String defaultKey) {
        List<OptionScreen.Tab> tabs = List.of(new OptionScreen.Tab(TabKey.NOTIFICATION.key, this::getNotificationList), new OptionScreen.Tab(TabKey.CONTROL.key, RootScreen::getControlList), new OptionScreen.Tab(TabKey.DEFAULT.key, RootScreen::getDefaultList), new OptionScreen.Tab(TabKey.DETECTION.key, RootScreen::getDetectionList));
        super.setTabs(tabs, defaultKey);
    }

    public void updateTabTitles() {
        for (TabKey tabKey : TabKey.values()) {
            this.updateTabTitle(tabKey);
        }
    }

    private void updateTabTitle(TabKey tabKey) {
        MutableComponent title = Component.m_237115_((String)tabKey.key);
        switch (tabKey) {
            case NOTIFICATION: {
                if (Config.get().getNotifs().isEmpty()) break;
                title.m_130946_(" ");
                title.m_7220_((Component)Localization.localized("common", "count", Config.get().getNotifs().size()));
            }
        }
        super.updateTabTitle(tabKey.key, (Component)title);
    }

    @Override
    protected void addFooter() {
        int spacing = 4;
        int buttonWidth = 116 - spacing;
        int buttonHeight = 20;
        int x1 = this.f_96543_ / 2 - buttonWidth - spacing / 2;
        int x2 = this.f_96543_ / 2 + spacing / 2;
        int y = Math.min(this.f_96544_ - buttonHeight, this.f_96544_ - 16 - buttonHeight / 2);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, button -> this.onCancel()).m_252794_(x1, y).m_253046_(buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.m_7379_()).m_252794_(x2, y).m_253046_(buttonWidth, buttonHeight).m_253136_());
    }

    private void onCancel() {
        Minecraft.m_91087_().m_91152_((Screen)new ConfirmScreen(confirm -> {
            if (confirm) {
                Config.reload();
                Minecraft.m_91087_().m_91152_((Screen)this);
                this.m_7379_();
            } else {
                Minecraft.m_91087_().m_91152_((Screen)this);
            }
        }, (Component)Localization.localized("option", "root.exit_without_saving", new Object[0]), (Component)Localization.localized("option", "root.exit_without_saving.confirm", new Object[0])));
    }

    @Override
    public void m_7379_() {
        super.m_7379_();
        Config.save();
    }

    private OptionList getNotificationList(OptionScreen screen) {
        return new FilterList<Notification>(Minecraft.m_91087_(), screen, 0, 0, 0, 0, 232, 20, 5, FilterList.Entry.NotifOptions.class, (srcIdx, dstIdx) -> {
            srcIdx = srcIdx + 1;
            dstIdx = dstIdx + 1;
            return Config.get().moveNotif((int)srcIdx, (int)dstIdx);
        }, () -> this.updateTabTitle(TabKey.NOTIFICATION), (Component)Localization.localized("option", "notif.list", Unicode.INFO.str), (Component)Localization.localized("option", "notif.list.tooltip", new Object[0]), null, null, () -> Config.get().getNotifs(), (x, width, height, list, notif, index) -> index == 0 ? new FilterList.Entry.NotifOptions.Locked(x, width, height, list, (Notification)notif) : new FilterList.Entry.NotifOptions(x, width, height, list, (Notification)notif, index), null, () -> Config.get().addNotif());
    }

    private static OptionList getControlList(OptionScreen screen) {
        return new ControlList(Minecraft.m_91087_(), screen, 0, 0, 0, 0, 232, 20, 5);
    }

    private static OptionList getDetectionList(OptionScreen screen) {
        return new DetectionList(Minecraft.m_91087_(), screen, 0, 0, 0, 0, 232, 20, 5);
    }

    private static OptionList getDefaultList(OptionScreen screen) {
        return new DefaultList(Minecraft.m_91087_(), screen, 0, 0, 0, 0, 232, 20, 5);
    }

    public static enum TabKey {
        NOTIFICATION(Localization.translationKey("option", "notif")),
        CONTROL(Localization.translationKey("option", "control")),
        DEFAULT(Localization.translationKey("option", "default")),
        DETECTION(Localization.translationKey("option", "detection"));

        public final String key;

        private TabKey(String key) {
            this.key = key;
        }
    }
}

