/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HorizontalList<E extends AbstractWidget>
extends AbstractContainerEventHandler
implements Renderable,
NarratableEntry {
    private static final int SCROLLBAR_WIDTH = 32;
    private static final int SCROLLBAR_HEIGHT = 6;
    private static final int MIN_WIDTH = 64;
    private static final int MIN_HEIGHT = 26;
    private final List<E> entries = new ArrayList();
    private final Minecraft mc;
    private final int space;
    public Snap snap = Snap.BOTTOM;
    public boolean topScrollbar;
    private boolean scrolling;
    private double scrollAmount;
    @Nullable
    private E hovered;
    @Nullable
    private E selected;
    protected int x0;
    protected int x1;
    protected int y0;
    protected int y1;
    protected int width;
    protected int height;

    public HorizontalList(int x, int y, int width, int height, int spacing, boolean topScrollbar) {
        this.space = spacing;
        this.mc = Minecraft.m_91087_();
        this.topScrollbar = topScrollbar;
        this.x0 = x;
        this.x1 = x + width;
        this.y0 = y;
        this.y1 = y + height;
        this.width = width;
        this.height = height;
    }

    @Nullable
    public E getHovered() {
        return this.hovered;
    }

    private void updateHovered(double mouseX, double mouseY) {
        if (this.m_5953_(mouseX, mouseY)) {
            for (AbstractWidget e : this.entries) {
                if (!e.m_5953_(mouseX, mouseY)) continue;
                this.hovered = e;
                return;
            }
        }
    }

    @Nullable
    public E getSelected() {
        return this.selected;
    }

    public void setSelected(@Nullable E selected) {
        if (!this.entries.contains(selected)) {
            throw new IllegalArgumentException("Specified entry is not present in the list.");
        }
        this.selected = selected;
    }

    public int numEntries() {
        return this.entries.size();
    }

    @NotNull
    public List<E> entries() {
        return Collections.unmodifiableList(this.entries);
    }

    public E getEntry(int index) {
        return (E)((AbstractWidget)this.entries.get(index));
    }

    public int addEntry(E entry) {
        this.entries.add(entry);
        return this.entries.size() - 1;
    }

    public boolean removeEntry(E entry) {
        boolean removed = this.entries.remove(entry);
        if (removed && entry == this.getSelected()) {
            this.setSelected(null);
        }
        return removed;
    }

    public void clearEntries() {
        this.entries.clear();
        this.setSelected(null);
    }

    public int getX() {
        return this.x0;
    }

    public int getY() {
        return this.y0;
    }

    public int getRight() {
        return this.x1;
    }

    public int getBottom() {
        return this.y1;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    public void setHeight(int height) {
        this.setSize(this.getWidth(), height);
    }

    public void setSize(int width, int height) {
        this.width = Math.max(width, 64);
        this.height = Math.max(height, 26);
        this.x1 = this.x0 + width;
        this.y1 = this.y0 + height;
        this.clampScrollAmount();
    }

    public void setBounds(int width, int height, int x, int y) {
        this.setSize(width, height);
        this.setPosition(x, y);
    }

    public void setPosition(int x, int y) {
        this.x0 = x;
        this.x1 = x + this.width;
        this.y0 = y;
        this.y1 = y + this.height;
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderListBackground(graphics);
        this.renderChildren(graphics, mouseX, mouseY, partialTick);
        this.renderScrollbar(graphics);
        this.renderSeparators(graphics);
        this.updateHovered(mouseX, mouseY);
    }

    protected void renderListBackground(GuiGraphics graphics) {
        graphics.m_280246_(0.125f, 0.125f, 0.125f, 1.0f);
        graphics.m_280163_(Screen.f_279548_, this.x0, this.y0, (float)this.x1, (float)(this.y1 + (int)this.scrollAmount), this.x1 - this.x0, this.y1 - this.y0, 32, 32);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void renderChildren(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.m_280588_(this.getX(), this.getY(), this.getRight(), this.getBottom());
        int x = this.getX() - (int)this.scrollAmount;
        int topOffset = this.topScrollbar ? 6 : 0;
        int bottomOffset = this.topScrollbar ? 0 : 6;
        for (AbstractWidget child : this.entries) {
            int y = switch (this.snap) {
                default -> throw new IncompatibleClassChangeError();
                case Snap.TOP -> this.getY() + topOffset;
                case Snap.MIDDLE -> this.getY() + (this.getHeight() - child.m_93694_()) / 2;
                case Snap.BOTTOM -> this.getY() + this.getHeight() - child.m_93694_() - bottomOffset;
            };
            child.m_264152_(x, y);
            if (child.m_252754_() + child.m_5711_() > this.getX() && child.m_252754_() < this.getRight()) {
                child.m_88315_(graphics, mouseX, mouseY, partialTick);
            }
            x += child.m_5711_() + this.space;
        }
        graphics.m_280618_();
    }

    protected void renderScrollbar(GuiGraphics graphics) {
        if (this.scrollbarVisible()) {
            int y = this.getScrollbarPosition();
            int scrollerWidth = (int)((float)(this.getWidth() * this.getWidth()) / (float)this.getMaxPosition());
            scrollerWidth = Mth.m_14045_((int)scrollerWidth, (int)32, (int)this.getWidth());
            int scrollerPos = Math.max(this.getX(), (int)this.scrollAmount * (this.getWidth() - scrollerWidth) / this.getMaxScroll() + this.getX());
            graphics.m_280509_(this.getX(), y, this.getRight(), y + 6, -16777216);
            graphics.m_280509_(scrollerPos, y, scrollerPos + scrollerWidth, y + 6, -8355712);
            graphics.m_280509_(scrollerPos, y, scrollerPos + scrollerWidth - 1, y + 6 - 1, -4144960);
        }
    }

    protected boolean scrollbarVisible() {
        return this.getMaxScroll() > 0;
    }

    protected void renderSeparators(GuiGraphics guiGraphics) {
        guiGraphics.m_280246_(0.25f, 0.25f, 0.25f, 1.0f);
        guiGraphics.m_280163_(Screen.f_279548_, this.x0 - 2, 0, 0.0f, 0.0f, this.width, this.y0 - 2, 32, 32);
        guiGraphics.m_280163_(Screen.f_279548_, this.x0 - 2, this.y1 + 2, 0.0f, (float)this.y1, this.width, this.height - this.y1, 32, 32);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.m_285978_(RenderType.m_286086_(), this.x0 - 2, this.y0 - 2, this.x1 + 2, this.y0 + 2, -16777216, 0, 0);
        guiGraphics.m_285978_(RenderType.m_286086_(), this.x0 - 2, this.y1 - 2, this.x1 + 2, this.y1 + 2, 0, -16777216, 0);
    }

    public void m_7522_(@Nullable GuiEventListener focused) {
        super.m_7522_(focused);
        int i = this.entries.indexOf((AbstractWidget)focused);
        if (i >= 0) {
            AbstractWidget entry = (AbstractWidget)this.entries.get(i);
            this.setSelected(entry);
            if (this.mc.m_264529_().m_264505_()) {
                this.ensureVisible(entry);
            }
        }
    }

    protected void ensureVisible(E entry) {
        int leftHang = entry.m_252754_() - this.getX();
        int rightHang = entry.m_252754_() + entry.m_5711_() - this.getRight();
        if (leftHang < 0) {
            this.scroll(leftHang);
        } else if (rightHang > 0) {
            this.scroll(rightHang);
        }
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return mouseX >= (double)this.getX() && mouseY >= (double)this.getY() && mouseX < (double)this.getRight() && mouseY < (double)this.getBottom();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.updateScrollingState(mouseX, mouseY, button);
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        return this.scrolling || super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0 && this.scrolling) {
            if (mouseX < (double)this.getX()) {
                this.setScrollAmount(0.0);
            } else if (mouseX > (double)this.getRight()) {
                this.setScrollAmount(this.getMaxScroll());
            } else {
                double maxScroll = Math.max(1, this.getMaxScroll());
                int innerWidth = this.getWidth();
                int scrollerWidth = Mth.m_14045_((int)((int)((float)(innerWidth * innerWidth) / (float)this.getMaxPosition())), (int)32, (int)innerWidth);
                double multiplier = Math.max(1.0, maxScroll / (double)(innerWidth - scrollerWidth));
                this.setScrollAmount(this.scrollAmount + dragX * multiplier);
            }
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int scrollMultiplier = 10;
        this.setScrollAmount(this.scrollAmount - delta * (double)scrollMultiplier);
        return true;
    }

    protected void updateScrollingState(double mouseX, double mouseY, int button) {
        this.scrolling = button == 0 && mouseY >= (double)this.getScrollbarPosition() && mouseY < (double)(this.getScrollbarPosition() + 6) && mouseX >= (double)this.getX() && mouseX < (double)this.getRight();
    }

    protected int getScrollbarPosition() {
        return this.topScrollbar ? this.getY() : this.getY() + this.getHeight() - 6;
    }

    protected int getMaxPosition() {
        int pos = 0;
        for (AbstractWidget e : this.entries) {
            pos += e.m_5711_();
            pos += this.space;
        }
        return pos - this.space;
    }

    private void scroll(int scroll) {
        this.setScrollAmount(this.scrollAmount + (double)scroll);
    }

    public void setScrollAmount(double scroll) {
        this.setClampedScrollAmount(scroll);
    }

    public void clampScrollAmount() {
        this.setClampedScrollAmount(this.scrollAmount);
    }

    public void setClampedScrollAmount(double scroll) {
        this.scrollAmount = Mth.m_14008_((double)scroll, (double)0.0, (double)this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - this.getWidth());
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull NarratableEntry.NarrationPriority m_142684_() {
        if (this.m_93696_()) {
            return NarratableEntry.NarrationPriority.FOCUSED;
        }
        return this.hovered != null ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(@NotNull NarrationElementOutput output) {
        E hovered = this.getHovered();
        if (hovered != null) {
            hovered.m_142291_(output.m_142047_());
            this.narrateListElementPosition(output, hovered);
        } else {
            AbstractWidget focused = (AbstractWidget)this.m_7222_();
            if (focused != null) {
                focused.m_142291_(output.m_142047_());
                this.narrateListElementPosition(output, focused);
            }
        }
        output.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.component_list.usage"));
    }

    protected void narrateListElementPosition(NarrationElementOutput output, E entry) {
        int index;
        if (this.entries.size() > 1 && (index = this.entries.indexOf(entry)) != -1) {
            output.m_169146_(NarratedElementType.POSITION, (Component)Component.m_237110_((String)"narrator.position.list", (Object[])new Object[]{index + 1, this.entries.size()}));
        }
    }

    @NotNull
    public final List<E> m_6702_() {
        return Collections.unmodifiableList(this.entries);
    }

    public static enum Snap {
        TOP,
        MIDDLE,
        BOTTOM;

    }
}

