/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget;

import com.mojang.blaze3d.platform.Window;
import dev.terminalmc.chatnotify.mixin.accessor.AbstractWidgetAccessor;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public abstract class OverlayWidget
extends AbstractWidget {
    private Consumer<OverlayWidget> close;
    public final boolean fixedSize;
    public final double nominalWidthRatio;
    public final double nominalHeightRatio;

    public OverlayWidget(int x, int y, int width, int height, boolean fixedSize, Component msg, Consumer<OverlayWidget> close) {
        super(x, y, width, height, msg);
        this.checkWidth(width);
        this.checkHeight(height);
        this.close = close;
        Window window = Minecraft.m_91087_().m_91268_();
        this.fixedSize = fixedSize;
        this.nominalWidthRatio = (double)width / (double)window.m_85445_();
        this.nominalHeightRatio = (double)height / (double)window.m_85446_();
    }

    public void addOnClose(Consumer<OverlayWidget> close) {
        Consumer<OverlayWidget> close2 = this.close;
        this.close = widget -> {
            close.accept((OverlayWidget)((Object)widget));
            close2.accept((OverlayWidget)((Object)widget));
        };
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return true;
    }

    protected abstract void init();

    public void onClose() {
        this.close.accept(this);
    }

    public abstract int getMinWidth();

    public abstract int getMaxWidth();

    public abstract int getMinHeight();

    public abstract int getMaxHeight();

    public int getNominalWidth(int screenWidth) {
        if (this.fixedSize) {
            return this.f_93618_;
        }
        return Math.min(Math.max(this.getMinWidth(), (int)((double)screenWidth * this.nominalWidthRatio)), this.getMaxWidth());
    }

    public int getNominalHeight(int screenHeight) {
        if (this.fixedSize) {
            return this.f_93619_;
        }
        return Math.min(Math.max(this.getMinHeight(), (int)((double)screenHeight * this.nominalHeightRatio)), this.getMaxHeight());
    }

    public void updateBounds(int screenWidth, int screenHeight) {
        super.m_93674_(this.getNominalWidth(screenWidth));
        ((AbstractWidgetAccessor)((Object)this)).chatnotify$setHeight(this.getNominalHeight(screenHeight));
        super.m_252865_(screenWidth / 2 - this.m_5711_() / 2);
        super.m_253211_(screenHeight / 2 - this.m_93694_() / 2);
        this.init();
    }

    public void m_264152_(int x, int y) {
        super.m_264152_(x, y);
        this.init();
    }

    public void m_252865_(int x) {
        super.m_252865_(x);
        this.init();
    }

    public void m_253211_(int y) {
        super.m_253211_(y);
        this.init();
    }

    public void setSize(int width, int height) {
        this.m_93674_(width);
        this.setHeight(height);
        this.init();
    }

    public void m_93674_(int width) {
        super.m_93674_(this.checkWidth(width));
        this.init();
    }

    public void setHeight(int height) {
        ((AbstractWidgetAccessor)((Object)this)).chatnotify$setHeight(this.checkHeight(height));
        this.init();
    }

    protected int checkWidth(int width) {
        if (width < this.getMinWidth()) {
            throw new IllegalArgumentException("Width cannot be less than " + this.getMinWidth() + ", got " + width);
        }
        return width;
    }

    protected int checkHeight(int height) {
        if (height < this.getMinHeight()) {
            throw new IllegalArgumentException("Height cannot be less than " + this.getMinHeight() + ", got " + height);
        }
        return height;
    }

    protected void m_168797_(@NotNull NarrationElementOutput narration) {
    }
}

