/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget.field;

import dev.terminalmc.chatnotify.gui.widget.ExpandingList;
import dev.terminalmc.chatnotify.gui.widget.OverlayWidget;
import dev.terminalmc.chatnotify.gui.widget.field.TextField;
import dev.terminalmc.chatnotify.mixin.accessor.AbstractSelectionListAccessor;
import dev.terminalmc.chatnotify.util.Unicode;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DropdownTextField
extends OverlayWidget {
    public static final int MIN_WIDTH = 80;
    public static final int MIN_HEIGHT = 40;
    public static final int MAX_WIDTH = 500;
    public static final int MAX_HEIGHT = 800;
    private final Supplier<String> supplier;
    private final Consumer<String> consumer;
    private final Collection<String> dropdownValues;
    private Function<String, DropdownWidget> dropWidgetProvider;
    private Button cancelButton;
    private Button confirmButton;
    private TextField textField;
    private ExpandingList dropdown;
    private boolean suppressUpdate;
    @Nullable
    private String oldVal = null;

    public DropdownTextField(int x, int y, int width, int height, Component msg, Supplier<String> supplier, Consumer<String> consumer, Consumer<OverlayWidget> close, Collection<String> dropdownValues) {
        super(x, y, width, height, false, msg, close);
        this.supplier = supplier;
        this.consumer = consumer;
        this.dropdownValues = dropdownValues;
        this.dropWidgetProvider = this::createDefaultDropWidget;
        this.init();
    }

    @Override
    protected void init() {
        Minecraft mc = Minecraft.m_91087_();
        int x = this.m_252754_();
        int y = this.m_252907_();
        int widgetHeight = 20;
        int verticalSpace = 1;
        int buttonWidth = 20;
        int textFieldWidth = this.f_93618_ - 2 * widgetHeight;
        this.cancelButton = Button.m_253074_((Component)Component.m_237113_((String)Unicode.CROSS.str).m_130940_(ChatFormatting.RED), button -> this.onClose()).m_252794_(x + this.f_93618_ - buttonWidth * 2, y).m_253046_(buttonWidth, widgetHeight).m_253136_();
        this.confirmButton = Button.m_253074_((Component)Component.m_237113_((String)Unicode.CHECK.str).m_130940_(ChatFormatting.GREEN), button -> {
            this.consumer.accept(this.textField.m_94155_());
            this.onClose();
        }).m_252794_(x + this.f_93618_ - buttonWidth, y).m_253046_(buttonWidth, widgetHeight).m_253136_();
        this.textField = new TextField(x, y, textFieldWidth, widgetHeight);
        Objects.requireNonNull(mc.f_91062_);
        Objects.requireNonNull(mc.f_91062_);
        this.dropdown = new ExpandingList(x, y + widgetHeight + verticalSpace, this.f_93618_, this.f_93619_ - widgetHeight - verticalSpace, 9, 9, 2);
        this.textField.m_94199_(240);
        this.textField.m_94151_(this::valueResponder);
        this.textField.m_94144_(this.oldVal == null ? this.supplier.get() : this.oldVal);
        this.textField.m_93692_(true);
    }

    @Override
    public int getMinWidth() {
        return 80;
    }

    @Override
    public int getMaxWidth() {
        return 500;
    }

    @Override
    public int getMinHeight() {
        return 40;
    }

    @Override
    public int getMaxHeight() {
        return 800;
    }

    private DropdownWidget createDefaultDropWidget(String str) {
        int n = this.textField.m_252754_();
        int n2 = this.textField.m_252907_() + this.textField.m_93694_();
        int n3 = this.textField.m_5711_();
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return new DropdownWidget(n, n2, n3, 9 + 2, (Component)Component.m_237113_((String)str), Minecraft.m_91087_().f_91062_, this::tabComplete);
    }

    public DropdownTextField withSoundDropType() {
        this.dropWidgetProvider = this::createSoundDropWidget;
        this.init();
        return this;
    }

    private SoundDropdownWidget createSoundDropWidget(String str) {
        int n = this.textField.m_252754_();
        int n2 = this.textField.m_252907_() + this.textField.m_93694_();
        int n3 = this.textField.m_5711_();
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return new SoundDropdownWidget(n, n2, n3, 9 + 2, (Component)Component.m_237113_((String)str), Minecraft.m_91087_().f_91062_, this::tabComplete);
    }

    private void tabComplete(String str) {
        this.suppressUpdate = true;
        this.textField.m_94144_(str);
        this.suppressUpdate = false;
    }

    private void valueResponder(String str) {
        this.oldVal = str;
        if (!this.suppressUpdate) {
            this.dropdown.highlightIndex = -1;
            this.dropdown.clearWidgets();
            this.dropdown.m_93410_(0.0);
            for (String suggestion : this.dropdownValues) {
                if (!suggestion.contains(str) || suggestion.equals(str)) continue;
                StringWidget widget = this.dropWidgetProvider.apply(suggestion);
                widget.m_267769_();
                this.dropdown.addWidget((AbstractWidget)widget);
            }
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.textField.m_93696_()) {
            if (!this.dropdown.isEmpty()) {
                if (keyCode == 258) {
                    if (Screen.m_96638_()) {
                        this.tabUp();
                    } else {
                        this.tabDown();
                    }
                    return true;
                }
                if (keyCode == 265) {
                    this.tabUp();
                    return true;
                }
                if (keyCode == 264) {
                    this.tabDown();
                    return true;
                }
            }
            return this.textField.m_7933_(keyCode, scanCode, modifiers);
        }
        return false;
    }

    private void tabUp() {
        if (--this.dropdown.highlightIndex < 0) {
            this.dropdown.highlightIndex = this.dropdown.size() - 1;
        }
        this.dropdown.ensureVisible(this.dropdown.highlightIndex);
        this.tabComplete(this.dropdown.get(this.dropdown.highlightIndex).m_6035_().getString());
    }

    private void tabDown() {
        if (++this.dropdown.highlightIndex >= this.dropdown.size()) {
            this.dropdown.highlightIndex = 0;
        }
        this.dropdown.ensureVisible(this.dropdown.highlightIndex);
        this.tabComplete(this.dropdown.get(this.dropdown.highlightIndex).m_6035_().getString());
    }

    public boolean m_5534_(char chr, int modifiers) {
        if (this.textField.m_93696_()) {
            return this.textField.m_5534_(chr, modifiers);
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.mouseOnWidget(this, mouseX, mouseY)) {
            if (this.mouseOnWidget((AbstractWidget)this.textField, mouseX, mouseY)) {
                if (!this.textField.m_93696_()) {
                    this.textField.m_93692_(true);
                } else {
                    this.textField.m_6375_(mouseX, mouseY, button);
                }
            } else if (this.textField.m_93696_() && this.mouseOnWidget((AbstractSelectionList<?>)this.dropdown, mouseX, mouseY)) {
                this.dropdown.m_6375_(mouseX, mouseY, button);
            } else {
                this.textField.m_93692_(false);
                if (button == 0) {
                    if (this.mouseOnWidget((AbstractWidget)this.cancelButton, mouseX, mouseY)) {
                        this.cancelButton.m_6375_(mouseX, mouseY, button);
                    } else if (this.mouseOnWidget((AbstractWidget)this.confirmButton, mouseX, mouseY)) {
                        this.confirmButton.m_6375_(mouseX, mouseY, button);
                    }
                }
            }
        } else {
            this.cancelButton.m_5691_();
        }
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.textField.m_93696_() && this.mouseOnWidget((AbstractWidget)this.textField, mouseX, mouseY)) {
            return this.textField.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }
        this.dropdown.m_7522_(null);
        return this.dropdown.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.textField.m_93696_() && this.mouseOnWidget((AbstractSelectionList<?>)this.dropdown, mouseX, mouseY)) {
            return this.dropdown.m_6050_(mouseX, mouseY, delta);
        }
        return false;
    }

    private boolean mouseOnWidget(AbstractSelectionList<?> widget, double mouseX, double mouseY) {
        AbstractSelectionListAccessor access = (AbstractSelectionListAccessor)widget;
        return (double)access.chatnotify$getX0() <= mouseX && mouseX < (double)access.chatnotify$getX1() && (double)access.chatnotify$getY0() <= mouseY && mouseY < (double)access.chatnotify$getY1();
    }

    private boolean mouseOnWidget(AbstractWidget widget, double mouseX, double mouseY) {
        return (double)widget.m_252754_() <= mouseX && mouseX < (double)(widget.m_252754_() + widget.m_5711_()) && (double)widget.m_252907_() <= mouseY && mouseY < (double)(widget.m_252907_() + widget.m_93694_());
    }

    protected void m_87963_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.textField.m_93696_() && !this.dropdown.isEmpty()) {
            this.dropdown.m_88315_(graphics, mouseX, mouseY, delta);
        }
        this.textField.m_87963_(graphics, mouseX, mouseY, delta);
        this.cancelButton.m_88315_(graphics, mouseX, mouseY, delta);
        this.confirmButton.m_88315_(graphics, mouseX, mouseY, delta);
    }

    @Override
    public void onClose() {
        super.onClose();
        if (SoundDropdownWidget.lastSound != null) {
            Minecraft.m_91087_().m_91106_().m_120399_(SoundDropdownWidget.lastSound);
        }
    }

    public static class DropdownWidget
    extends StringWidget {
        private final Consumer<String> consumer;

        private DropdownWidget(int x, int y, int width, int height, Component msg, Font font, Consumer<String> consumer) {
            super(x, y, width, height, msg, font);
            this.f_93623_ = true;
            this.consumer = consumer;
        }

        public static DropdownWidget create(int x, int y, int width, int height, Component msg, Font font, Consumer<String> dest) {
            return new DropdownWidget(x, y, width, height, msg, font, dest);
        }

        public void m_5716_(double mouseX, double mouseY) {
            this.consumer.accept(this.m_6035_().getString());
        }
    }

    public static class SoundDropdownWidget
    extends DropdownWidget {
        @Nullable
        private static SoundInstance lastSound;

        private SoundDropdownWidget(int x, int y, int width, int height, Component msg, Font font, Consumer<String> consumer) {
            super(x, y, width, height, msg, font, consumer);
        }

        public static SoundDropdownWidget create(int x, int y, int width, int height, Component msg, Font font, Consumer<String> consumer) {
            return new SoundDropdownWidget(x, y, width, height, msg, font, consumer);
        }

        public void m_7435_(@NotNull SoundManager soundManager) {
            if (lastSound != null) {
                soundManager.m_120399_(lastSound);
            }
            lastSound = new SimpleSoundInstance(new ResourceLocation(this.m_6035_().getString()), SoundSource.MASTER, 1.0f, 1.0f, SoundInstance.m_235150_(), false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true);
            soundManager.m_120367_(lastSound);
        }
    }
}

