/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget.list.root.notif.trigger;

import dev.terminalmc.chatnotify.config.Trigger;
import dev.terminalmc.chatnotify.gui.screen.OptionScreen;
import dev.terminalmc.chatnotify.gui.widget.field.TextField;
import dev.terminalmc.chatnotify.gui.widget.list.OptionList;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.Unicode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeySelectorList
extends OptionList {
    public static final String[] CHAT_KEYS = new String[]{".", "chat.type", "chat.type.text", "chat.type.announcement", "chat.type.admin", "chat.type.emote", "chat.type.team.sent", "chat.type.team.text"};
    public static final String[] PLAYER_KEYS = new String[]{"multiplayer.player.joined", "multiplayer.player.left", "death."};
    public static final String[] ADVANCEMENT_KEYS = new String[]{"chat.type.advancement", "chat.type.advancement.task", "chat.type.advancement.goal", "chat.type.advancement.challenge"};
    public static final String[] COMMAND_KEYS = new String[]{"commands.", "commands.message.display", "commands.message.display.incoming", "commands.message.display.outgoing"};
    private final Trigger trigger;

    public KeySelectorList(Minecraft mc, OptionScreen screen, int width, int height, int top, int bottom, int entryWidth, int entryHeight, Trigger trigger) {
        super(mc, screen, width, height, top, bottom, entryWidth, entryHeight, 1);
        this.trigger = trigger;
    }

    @Override
    protected void addEntries() {
        this.m_7085_((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (Component)Localization.localized("option", "notif.trigger.selector.list", Unicode.INFO.str), Tooltip.m_257550_((Component)Localization.localized("option", "notif.trigger.selector.list.tooltip", new Object[0])), -1));
        this.m_7085_((AbstractSelectionList.Entry)new Entry.TriggerOption(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, this.trigger));
        this.m_7085_((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (Component)Localization.localized("key", "group.chat", new Object[0]), null, -1));
        this.addKeyEntries(CHAT_KEYS);
        this.m_7085_((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (Component)Localization.localized("key", "group.player", new Object[0]), null, -1));
        this.addKeyEntries(PLAYER_KEYS);
        this.m_7085_((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (Component)Localization.localized("key", "group.advancement", new Object[0]), null, -1));
        this.addKeyEntries(ADVANCEMENT_KEYS);
        this.m_7085_((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (Component)Localization.localized("key", "group.command", new Object[0]), null, -1));
        this.addKeyEntries(COMMAND_KEYS);
    }

    private void addKeyEntries(String[] keys) {
        for (int i = 0; i < keys.length; ++i) {
            this.m_7085_((AbstractSelectionList.Entry)new Entry.KeyOption(this.entryX, this.entryWidth, this.entryHeight, this, this.trigger, keys[i], i < keys.length - 1 ? keys[++i] : null));
        }
    }

    private static abstract class Entry
    extends OptionList.Entry {
        private Entry() {
        }

        private static class KeyOption
        extends Entry {
            KeyOption(int x, int width, int height, KeySelectorList list, Trigger trigger, @NotNull String key1, @Nullable String key2) {
                int buttonWidth = (width - 1) / 2;
                this.elements.add(Button.m_253074_((Component)Localization.localized("key", "id." + key1, new Object[0]), button -> {
                    trigger.string = key1;
                    list.m_93410_(0.0);
                    list.init();
                }).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)key1))).m_252794_(x, 0).m_253046_(buttonWidth, height).m_253136_());
                if (key2 != null) {
                    this.elements.add(Button.m_253074_((Component)Localization.localized("key", "id." + key2, new Object[0]), button -> {
                        trigger.string = key2;
                        list.m_93410_(0.0);
                        list.init();
                    }).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)key2))).m_252794_(x + width - buttonWidth, 0).m_253046_(buttonWidth, height).m_253136_());
                }
            }
        }

        private static class TriggerOption
        extends Entry {
            TriggerOption(int x, int width, int height, Trigger trigger) {
                TextField triggerField = new TextField(x, 0, width, height);
                if (trigger.type == Trigger.Type.REGEX) {
                    triggerField.regexValidator();
                }
                triggerField.m_94199_(240);
                triggerField.m_94144_(trigger.string);
                triggerField.m_94151_(str -> {
                    trigger.string = str.strip();
                });
                triggerField.m_257771_((Component)Localization.localized("option", "notif.trigger.field.hint", new Object[0]));
                this.elements.add(triggerField);
            }
        }
    }
}

