/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget.slider;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class DoubleSlider
extends AbstractSliderButton {
    protected final double min;
    protected final double max;
    protected final double range;
    protected final int precision;
    protected final String messagePrefix;
    protected final String messageSuffix;
    protected final String valueNameMin;
    protected final String valueNameMax;
    protected final Supplier<Double> source;
    protected final Consumer<Double> dest;

    public DoubleSlider(int x, int y, int width, int height, double min, double max, int precision, @Nullable String messagePrefix, @Nullable String messageSuffix, @Nullable String valueNameMin, @Nullable String valueNameMax, Supplier<Double> source, Consumer<Double> dest) {
        super(x, y, width, height, (Component)Component.m_237119_(), (source.get() - min) / (max - min));
        this.min = min;
        this.max = max;
        this.range = max - min;
        this.precision = precision;
        this.messagePrefix = messagePrefix;
        this.messageSuffix = messageSuffix;
        this.valueNameMin = valueNameMin;
        this.valueNameMax = valueNameMax;
        this.source = source;
        this.dest = dest;
        this.m_5695_();
    }

    public void refresh() {
        this.f_93577_ = (this.source.get() - this.min) / this.range;
        this.m_5695_();
    }

    protected void m_5695_() {
        double messageValue = this.round(this.f_93577_ * this.range + this.min, this.precision);
        String valueStr = String.valueOf(messageValue);
        if (this.f_93577_ == 0.0 && this.valueNameMin != null) {
            valueStr = this.valueNameMin;
        } else if (this.f_93577_ == 1.0 && this.valueNameMax != null) {
            valueStr = this.valueNameMax;
        }
        StringBuilder messageBuilder = new StringBuilder(valueStr);
        if (this.messagePrefix != null) {
            messageBuilder.insert(0, this.messagePrefix);
        }
        if (this.messageSuffix != null) {
            messageBuilder.append(this.messageSuffix);
        }
        this.m_93666_((Component)Component.m_237113_((String)messageBuilder.toString()));
    }

    protected void m_5697_() {
        this.dest.accept(this.round(this.f_93577_ * this.range + this.min, this.precision));
    }

    protected double round(double value, int precision) {
        int scale = (int)Math.pow(10.0, precision);
        return (double)Math.round(value * (double)scale) / (double)scale;
    }
}

