/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.datafixers.util.Pair;
import dev.terminalmc.chatnotify.ChatNotify;
import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.util.text.FormatUtil;
import dev.terminalmc.chatnotify.util.text.MessageUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientPacketListener.class}, priority=792)
public class ClientPacketListenerMixin {
    @WrapOperation(method={"setActionBarText"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;setOverlayMessage(Lnet/minecraft/network/chat/Component;Z)V")})
    private void wrapSetOverlayMessage(Gui instance, Component message, boolean animateColor, Operation<Void> original) {
        if (Config.get().actionBarDetectionMode.equals((Object)Config.CommonDetectionMode.PACKET)) {
            if ((message = MessageUtil.processMessage(message)) != null) {
                original.call(new Object[]{instance, message, animateColor});
            }
        } else {
            original.call(new Object[]{instance, message, animateColor});
        }
    }

    @WrapOperation(method={"setTitleText"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;setTitle(Lnet/minecraft/network/chat/Component;)V")})
    private void wrapSetTitle(Gui instance, Component message, Operation<Void> original) {
        if (Config.get().titleDetectionMode.equals((Object)Config.CommonDetectionMode.PACKET)) {
            if ((message = MessageUtil.processMessage(message)) != null) {
                original.call(new Object[]{instance, message});
            }
        } else {
            original.call(new Object[]{instance, message});
        }
    }

    @WrapOperation(method={"setSubtitleText"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;setSubtitle(Lnet/minecraft/network/chat/Component;)V")})
    private void wrapSetSubtitle(Gui instance, Component message, Operation<Void> original) {
        if (Config.get().subtitleDetectionMode.equals((Object)Config.CommonDetectionMode.PACKET)) {
            if ((message = MessageUtil.processMessage(message)) != null) {
                original.call(new Object[]{instance, message});
            }
        } else {
            original.call(new Object[]{instance, message});
        }
    }

    @Inject(method={"handleLogin"}, at={@At(value="TAIL")})
    private void getProfileName(ClientboundLoginPacket packet, CallbackInfo ci) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        String name = FormatUtil.stripCodes(Minecraft.m_91087_().f_91074_.m_7755_().getString());
        Config.get().setProfileName(name);
        Config.get().setDisplayName(name);
    }

    @Inject(method={"applyPlayerInfoUpdate"}, at={@At(value="TAIL")})
    private void getDisplayName(ClientboundPlayerInfoUpdatePacket.Action action, ClientboundPlayerInfoUpdatePacket.Entry entry, PlayerInfo playerInfo, CallbackInfo ci) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        if (action.equals((Object)ClientboundPlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME) && playerInfo.m_105312_().getId().equals(Minecraft.m_91087_().f_91074_.m_20148_()) && entry.f_244512_() != null) {
            Config.get().setDisplayName(FormatUtil.stripCodes(entry.f_244512_().getString()));
        }
    }

    @Inject(method={"sendChat"}, at={@At(value="HEAD")})
    private void getMessage(String message, CallbackInfo ci) {
        this.chatnotify$storeMessage(message);
    }

    @Inject(method={"sendCommand"}, at={@At(value="HEAD")})
    private void getCommand(String command, CallbackInfo ci) {
        this.chatnotify$storeCommand(command);
    }

    @Inject(method={"sendUnsignedCommand"}, at={@At(value="HEAD")})
    private void getUnsignedCommand(String command, CallbackInfoReturnable<Boolean> cir) {
        this.chatnotify$storeCommand(command);
    }

    @Unique
    private void chatnotify$storeMessage(String message) {
        long time = System.nanoTime();
        this.chatnotify$removeOldMessages(time);
        String plainMsg = "";
        for (String prefix : Config.get().prefixes) {
            if (!message.startsWith(prefix)) continue;
            plainMsg = message.replaceFirst(prefix, "").strip();
            break;
        }
        ChatNotify.recentMessages.add((Pair<Long, String>)Pair.of((Object)(time + 5000000000L), (Object)(plainMsg.isEmpty() ? message : plainMsg)));
    }

    @Unique
    private void chatnotify$storeCommand(String command) {
        long time = System.currentTimeMillis();
        this.chatnotify$removeOldMessages(time);
        command = "/" + (String)command;
        for (String prefix : Config.get().prefixes) {
            if (!((String)command).startsWith(prefix)) continue;
            if (((String)(command = ((String)command).replaceFirst(prefix, "").strip())).isEmpty()) break;
            ChatNotify.recentMessages.add((Pair<Long, String>)Pair.of((Object)(time + 5000000000L), (Object)command));
            break;
        }
    }

    @Unique
    private void chatnotify$removeOldMessages(long time) {
        ChatNotify.recentMessages.removeIf(pair -> (Long)pair.getFirst() < time);
    }
}

