/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.util.text;

import dev.terminalmc.chatnotify.ChatNotify;
import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.mixin.accessor.StyleAccessor;
import dev.terminalmc.chatnotify.util.Unicode;
import java.util.ArrayList;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.jetbrains.annotations.Nullable;

public class FormatUtil {
    private static final Pattern COLOR_CODE_PATTERN = Pattern.compile(Pattern.quote(Unicode.SECTION.str) + ".?");
    private static final String PLACEHOLDER_PATTERN_STRING = "%(\\d+\\$)?([-#+ 0,(<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])";
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("%(\\d+\\$)?([-#+ 0,(<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");

    private FormatUtil() {
    }

    public static String stripCodes(String str) {
        return COLOR_CODE_PATTERN.matcher(str).replaceAll("");
    }

    public static MutableComponent convertToStyledLiteral(MutableComponent text) throws IllegalArgumentException {
        if (text.m_214077_() instanceof TranslatableContents) {
            text = FormatUtil.convertToLiteral(text);
        }
        text.m_7360_().replaceAll(sibling -> FormatUtil.convertToStyledLiteral(sibling.m_6881_()));
        if (text.m_214077_() instanceof LiteralContents) {
            text = FormatUtil.convertCodesToStyles(text);
        }
        return text;
    }

    private static MutableComponent convertToLiteral(MutableComponent text) throws IllegalArgumentException {
        boolean validFormat;
        String string;
        ArrayList oldSiblings;
        boolean debug;
        TranslatableContents contents;
        block24: {
            ComponentContents componentContents = text.m_214077_();
            if (!(componentContents instanceof TranslatableContents)) {
                return text;
            }
            contents = (TranslatableContents)componentContents;
            debug = Config.get().debugMode.equals((Object)Config.DebugMode.ALL);
            if (debug) {
                ChatNotify.LOG.warn("Converting message to literal", new Object[0]);
                ChatNotify.LOG.warn("Text:", new Object[0]);
                ChatNotify.LOG.warn(text.getString(), new Object[0]);
                ChatNotify.LOG.warn("Tree:", new Object[0]);
                ChatNotify.LOG.warn(text.toString(), new Object[0]);
            }
            oldSiblings = new ArrayList(text.m_7360_());
            Language lang = Language.m_128107_();
            String key = contents.m_237508_();
            @Nullable String fallback = contents.m_264577_();
            string = fallback == null ? lang.m_6834_(key) : lang.m_118919_(key, fallback);
            validFormat = true;
            try {
                String.format(string, contents.m_237523_());
            }
            catch (IllegalFormatException e) {
                validFormat = false;
                text = Component.m_237113_((String)string).m_130948_(text.m_7383_());
                if (!debug) break block24;
                ChatNotify.LOG.warn("Invalid string format:", new Object[0]);
                ChatNotify.LOG.warn(e.getMessage(), new Object[0]);
                ChatNotify.LOG.warn(string, new Object[0]);
            }
        }
        if (validFormat) {
            Object[] unorderedArgs = contents.m_237523_();
            Object[] args = new Object[unorderedArgs.length];
            int argIdx = 0;
            ArrayList<String> split = new ArrayList<String>();
            Matcher m = PLACEHOLDER_PATTERN.matcher(string);
            int previousEnd = 0;
            while (m.find()) {
                split.add(string.substring(previousEnd, m.start()));
                previousEnd = m.end();
                if (m.group(1) == null) {
                    args[argIdx] = unorderedArgs[argIdx];
                } else {
                    int num = Integer.parseInt(m.group(1).substring(0, m.group(1).length() - 1));
                    if (num < 1 || num > unorderedArgs.length) {
                        ChatNotify.LOG.warn("Translation specifies arg number {} out of range for length {}", num, unorderedArgs.length);
                        num = argIdx + 1;
                    }
                    args[argIdx] = unorderedArgs[num - 1];
                }
                ++argIdx;
            }
            if (previousEnd != 0) {
                if (previousEnd < string.length()) {
                    split.add(string.substring(previousEnd));
                } else {
                    split.add("");
                }
            }
            if (debug) {
                ChatNotify.LOG.warn("Format string:", new Object[0]);
                ChatNotify.LOG.warn(string, new Object[0]);
                ChatNotify.LOG.warn("Size of split array: {}", split.size());
                ChatNotify.LOG.warn("Size of args array: {}", contents.m_237523_().length);
                ChatNotify.LOG.warn("Split array:", new Object[0]);
                StringBuilder sb = new StringBuilder("[");
                int i = 0;
                for (String s : split) {
                    if (i++ != 0) {
                        sb.append(",");
                    }
                    sb.append(s);
                }
                sb.append("]");
                ChatNotify.LOG.warn(sb.toString(), new Object[0]);
            }
            if (split.isEmpty()) {
                text = Component.m_237113_((String)string).m_130948_(text.m_7383_());
            } else {
                int numPlaceholders = split.size() - 1;
                text = Component.m_237119_().m_130948_(text.m_7383_());
                List siblings = text.m_7360_();
                for (int i = 0; i < numPlaceholders; ++i) {
                    Object object;
                    if (!((String)split.get(i)).isEmpty()) {
                        if (debug) {
                            ChatNotify.LOG.warn("Adding translated substring:", new Object[0]);
                            ChatNotify.LOG.warn((String)split.get(i), new Object[0]);
                        }
                        siblings.add(Component.m_237113_((String)((String)split.get(i))));
                    }
                    if ((object = args[i]) instanceof Component) {
                        Component argComponent = (Component)object;
                        if (debug) {
                            ChatNotify.LOG.warn("Adding arg component", new Object[0]);
                            ChatNotify.LOG.warn("Text:", new Object[0]);
                            ChatNotify.LOG.warn(argComponent.getString(), new Object[0]);
                            ChatNotify.LOG.warn("Tree:", new Object[0]);
                            ChatNotify.LOG.warn(argComponent.toString(), new Object[0]);
                        }
                        siblings.add(argComponent);
                        continue;
                    }
                    if (debug) {
                        ChatNotify.LOG.warn("Adding arg object", new Object[0]);
                        ChatNotify.LOG.warn("getClass():", new Object[0]);
                        ChatNotify.LOG.warn(args[i].getClass().getName(), new Object[0]);
                        ChatNotify.LOG.warn("toString():", new Object[0]);
                        ChatNotify.LOG.warn(args[i].toString(), new Object[0]);
                    }
                    siblings.add(Component.m_237113_((String)args[i].toString()));
                }
                if (!((String)split.get(split.size() - 1)).isEmpty()) {
                    siblings.add(Component.m_237113_((String)((String)split.get(split.size() - 1))));
                }
            }
        }
        text.m_7360_().addAll(oldSiblings);
        return text;
    }

    private static MutableComponent convertCodesToStyles(MutableComponent text) {
        ComponentContents componentContents = text.m_214077_();
        if (!(componentContents instanceof LiteralContents)) {
            return text;
        }
        LiteralContents contents = (LiteralContents)componentContents;
        String str = contents.f_237368_();
        if (!str.contains(Unicode.SECTION.str)) {
            return text;
        }
        ArrayList oldSiblings = new ArrayList(text.m_7360_());
        text = Component.m_237119_().m_130948_(text.m_7383_());
        StringBuilder sb = new StringBuilder();
        char[] chars = str.toCharArray();
        FormatCodes codes = new FormatCodes();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == Unicode.SECTION.chr.charValue()) {
                if (!sb.isEmpty()) {
                    text.m_7220_((Component)Component.m_237113_((String)sb.toString()).m_130948_(codes.createStyle()));
                    sb.setLength(0);
                }
                if (i >= chars.length - 1) continue;
                char next = chars[++i];
                switch (next) {
                    case 'r': {
                        codes.clear();
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        codes.color = ChatFormatting.m_126645_((char)next);
                        break;
                    }
                    case 'k': {
                        codes.obfuscated = true;
                        break;
                    }
                    case 'l': {
                        codes.bold = true;
                        break;
                    }
                    case 'm': {
                        codes.strikethrough = true;
                        break;
                    }
                    case 'n': {
                        codes.underline = true;
                        break;
                    }
                    case 'o': {
                        codes.italic = true;
                        break;
                    }
                }
                continue;
            }
            sb.append(chars[i]);
        }
        if (!sb.isEmpty()) {
            text.m_7220_((Component)Component.m_237113_((String)sb.toString()).m_130948_(codes.createStyle()));
        }
        text.m_7360_().addAll(oldSiblings);
        return text;
    }

    private static class FormatCodes {
        @Nullable
        ChatFormatting color = null;
        boolean bold = false;
        boolean italic = false;
        boolean underline = false;
        boolean strikethrough = false;
        boolean obfuscated = false;

        private FormatCodes() {
        }

        Style createStyle() {
            return StyleAccessor.chatnotify$new(this.color == null ? null : TextColor.m_131270_((ChatFormatting)this.color), this.bold ? Boolean.valueOf(true) : null, this.italic ? Boolean.valueOf(true) : null, this.underline ? Boolean.valueOf(true) : null, this.strikethrough ? Boolean.valueOf(true) : null, this.obfuscated ? Boolean.valueOf(true) : null, null, null, null, null);
        }

        void clear() {
            this.color = null;
            this.bold = false;
            this.italic = false;
            this.underline = false;
            this.strikethrough = false;
            this.obfuscated = false;
        }
    }
}

