/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget.list.root.notif.trigger;

import com.mojang.datafixers.util.Pair;
import dev.terminalmc.chatnotify.ChatNotify;
import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.config.StyleTarget;
import dev.terminalmc.chatnotify.config.TextStyle;
import dev.terminalmc.chatnotify.config.Trigger;
import dev.terminalmc.chatnotify.gui.screen.OptionScreen;
import dev.terminalmc.chatnotify.gui.widget.HsvColorPicker;
import dev.terminalmc.chatnotify.gui.widget.field.MultiLineTextField;
import dev.terminalmc.chatnotify.gui.widget.field.TextField;
import dev.terminalmc.chatnotify.gui.widget.list.OptionList;
import dev.terminalmc.chatnotify.mixin.accessor.AbstractWidgetAccessor;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.Unicode;
import dev.terminalmc.chatnotify.util.text.FormatUtil;
import dev.terminalmc.chatnotify.util.text.MessageUtil;
import dev.terminalmc.chatnotify.util.text.StyleUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;

public class TriggerEditorList
extends OptionList {
    private final Trigger trigger;
    private final TextStyle textStyle;
    private final List<Component> recentChat;
    private boolean filter;
    private boolean restyle;
    private MultiLineTextField textDisplayField;
    private String displayText = "";
    private TextField keyDisplayField;
    private String displayKey = "";

    public TriggerEditorList(Minecraft mc, OptionScreen screen, int width, int height, int top, int bottom, int entryWidth, int entryHeight, int entrySpacing, Trigger trigger, TextStyle textStyle) {
        super(mc, screen, width, height, top, bottom, entryWidth, entryHeight, entrySpacing);
        this.trigger = trigger;
        this.textStyle = textStyle;
        List recentChatReversed = ChatNotify.unmodifiedChat.stream().toList();
        this.recentChat = new ArrayList<Component>();
        for (int i = recentChatReversed.size() - 1; i >= 0; --i) {
            this.recentChat.add((Component)recentChatReversed.get(i));
        }
    }

    @Override
    protected void addEntries() {
        this.addSpacedEntry(new Entry.TriggerOptions(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight + this.f_93387_, this, this.trigger));
        if (this.trigger.styleTarget.enabled) {
            this.m_7085_((AbstractSelectionList.Entry)new Entry.StyleTargetOptions(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, this, this.trigger.styleTarget));
        }
        this.textDisplayField = new MultiLineTextField(this.dynWideEntryX, 0, this.dynWideEntryWidth, this.entryHeight, (Component)Localization.localized("option", "notif.trigger.editor.display.text.hint", new Object[0]));
        this.textDisplayField.m_240159_(this.displayText);
        this.addSpacedEntry(new Entry.DisplayField(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight + this.f_93387_, (AbstractWidget)this.textDisplayField, (Component)Localization.localized("option", "notif.trigger.editor.display.text", new Object[0])));
        this.keyDisplayField = new TextField(this.dynWideEntryX, 0, this.dynWideEntryWidth, this.entryHeight);
        this.keyDisplayField.m_94199_(256);
        this.keyDisplayField.m_94144_(this.displayKey);
        this.m_7085_((AbstractSelectionList.Entry)new Entry.DisplayField(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, (AbstractWidget)this.keyDisplayField, (Component)Localization.localized("option", "notif.trigger.editor.display.key", new Object[0])));
        this.m_7085_((AbstractSelectionList.Entry)new Entry.Controls(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, this));
        this.addChatMessages(this.recentChat);
    }

    private void setTextDisplayValue(String text) {
        this.displayText = text;
        this.textDisplayField.m_240159_(this.displayText);
    }

    private void setKeyDisplayValue(String key) {
        this.displayKey = key;
        this.keyDisplayField.m_94144_(this.displayKey);
    }

    private void addChatMessages(List<Component> recentChat) {
        boolean restyleAll = Config.get().restyleMode.equals((Object)Config.RestyleMode.ALL_INSTANCES);
        ArrayList<Pair> displayChat = new ArrayList<Pair>();
        for (Component msg : recentChat) {
            boolean hit;
            MutableComponent restyledMsg = msg.m_6881_();
            Matcher matcher = null;
            String msgStr = FormatUtil.stripCodes(msg.getString());
            switch (this.trigger.type) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case NORMAL: {
                    boolean bl;
                    matcher = MessageUtil.normalSearch(msgStr, this.trigger.string);
                    boolean bl2 = bl = matcher.find();
                    break;
                }
                case REGEX: {
                    boolean bl2;
                    boolean bl;
                    try {
                        matcher = Pattern.compile(this.trigger.string).matcher(msgStr);
                        bl2 = bl = matcher.find();
                    }
                    catch (PatternSyntaxException ignored) {
                        bl2 = bl = false;
                    }
                    break;
                }
                case KEY: {
                    boolean bl;
                    boolean bl2 = hit = (bl = MessageUtil.keySearch(msg, this.trigger.string));
                }
            }
            if (this.filter && !hit) continue;
            if (this.restyle && hit) {
                if (this.trigger.styleTarget.enabled) {
                    if (this.trigger.styleTarget.type == StyleTarget.Type.REGEX) {
                        this.trigger.styleTarget.tryCompilePattern();
                    } else if (this.trigger.styleTarget.type == StyleTarget.Type.CAPTURING) {
                        this.trigger.styleTarget.tryParseIndexes();
                    }
                }
                restyledMsg = StyleUtil.restyle(msg, msgStr, this.trigger, matcher, this.textStyle, restyleAll);
            }
            displayChat.add(new Pair((Object)msg, (Object)restyledMsg));
        }
        displayChat.forEach(pair -> {
            Entry.MessageEntry entry = new Entry.MessageEntry(this.dynWideEntryX, this.dynWideEntryWidth, this, (Component)pair.getFirst(), (Component)pair.getSecond());
            this.m_7085_((AbstractSelectionList.Entry)entry);
            for (int requiredHeight = this.mc.f_91062_.m_92920_(((Component)pair.getFirst()).getString(), this.dynWideEntryWidth) - this.f_93387_; requiredHeight > 0; requiredHeight -= this.f_93387_) {
                OptionList.Entry.Space spaceEntry = new OptionList.Entry.Space(entry);
                this.m_7085_((AbstractSelectionList.Entry)spaceEntry);
            }
        });
        if (!(this.m_6702_().get(this.m_6702_().size() - 1) instanceof Entry.MessageEntry)) {
            this.m_7085_((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, (Component)Localization.localized("option", "notif.trigger.editor.recent_messages.none", new Object[0]), null, -1));
        }
    }

    static abstract class Entry
    extends OptionList.Entry {
        Entry() {
        }

        private static class MessageEntry
        extends Entry {
            private final TriggerEditorList list;
            private final Component msg;

            MessageEntry(int x, int width, TriggerEditorList list, Component msg, Component restyledMsg) {
                this.list = list;
                this.msg = msg;
                MultiLineTextWidget widget = new MultiLineTextWidget(x, 0, restyledMsg, Minecraft.m_91087_().f_91062_);
                widget.m_269098_(width);
                this.elements.add(widget);
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                String string;
                this.list.setTextDisplayValue(FormatUtil.stripCodes(this.msg.getString()));
                ComponentContents componentContents = this.msg.m_214077_();
                if (componentContents instanceof TranslatableContents) {
                    TranslatableContents tc = (TranslatableContents)componentContents;
                    string = tc.m_237508_();
                } else {
                    string = Localization.localized("option", "notif.trigger.editor.display.key.none", new Object[0]).getString();
                }
                this.list.setKeyDisplayValue(string);
                this.list.m_93410_(0.0);
                return true;
            }
        }

        private static class DisplayField
        extends Entry {
            DisplayField(int x, int width, int height, AbstractWidget widget, Component label) {
                int labelWidth = 40;
                int fieldWidth = width - labelWidth - 4;
                Button labelButton = Button.m_253074_((Component)label, button -> {}).m_252794_(x, 0).m_253046_(labelWidth, height).m_253136_();
                labelButton.f_93623_ = false;
                this.elements.add(labelButton);
                widget.m_93674_(fieldWidth);
                ((AbstractWidgetAccessor)widget).chatnotify$setHeight(height);
                widget.m_252865_(x + width - fieldWidth);
                this.elements.add(widget);
            }
        }

        private static class Controls
        extends Entry {
            Controls(int x, int width, int height, TriggerEditorList list) {
                int buttonWidth = (width - 8) / 3;
                int movingX = x;
                this.elements.add(CycleButton.m_168896_((Component)CommonComponents.f_130653_.m_6881_().m_130940_(ChatFormatting.GREEN), (Component)CommonComponents.f_130654_.m_6881_().m_130940_(ChatFormatting.RED)).m_168948_((Object)list.filter).m_168936_(movingX, 0, buttonWidth, height, (Component)Localization.localized("option", "notif.trigger.editor.filter", new Object[0]), (button, status) -> {
                    list.filter = status;
                    list.init();
                }));
                this.elements.add(CycleButton.m_168896_((Component)CommonComponents.f_130653_.m_6881_().m_130940_(ChatFormatting.GREEN), (Component)CommonComponents.f_130654_.m_6881_().m_130940_(ChatFormatting.RED)).m_168948_((Object)list.restyle).m_168936_(movingX += buttonWidth + 4, 0, buttonWidth, height, (Component)Localization.localized("option", "notif.trigger.editor.restyle", new Object[0]), (button, status) -> {
                    list.restyle = status;
                    list.init();
                }));
                movingX = x + width - buttonWidth;
                this.elements.add(Button.m_253074_((Component)Localization.localized("option", "notif.format.color", new Object[0]).m_6270_(Style.f_131099_.m_178520_(list.textStyle.color)), button -> {
                    int cpHeight = 80;
                    int cpWidth = 200;
                    list.screen.setOverlayWidget(new HsvColorPicker(x + width / 2 - cpWidth / 2, ((TriggerEditorList)list).screen.f_96544_ / 2 - cpHeight / 2, cpWidth, cpHeight, () -> list.textStyle.color, val -> {
                        list.textStyle.color = val;
                    }, widget -> list.init()));
                }).m_252794_(movingX, 0).m_253046_(buttonWidth, height).m_253136_());
            }
        }

        private static class StyleTargetOptions
        extends Entry {
            StyleTargetOptions(int x, int width, int height, TriggerEditorList list, StyleTarget styleTarget) {
                int stringFieldWidth = width - list.tinyWidgetWidth * 4;
                int movingX = x + list.tinyWidgetWidth;
                StringWidget infoIcon = new StringWidget(movingX, 0, list.tinyWidgetWidth, height, (Component)Component.m_237113_((String)Unicode.INFO.str), Minecraft.m_91087_().f_91062_);
                infoIcon.m_267729_();
                infoIcon.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "notif.trigger.style_target.tooltip", new Object[0])));
                infoIcon.m_257427_(500);
                this.elements.add(infoIcon);
                CycleButton typeButton = CycleButton.m_168894_(type -> Component.m_237113_((String)type.icon)).m_168961_((Object[])StyleTarget.Type.values()).m_168929_().m_168948_((Object)styleTarget.type).m_232498_(type -> Tooltip.m_257550_((Component)Localization.localized("option", "notif.trigger.style_target.type." + String.valueOf(type) + ".tooltip", new Object[0]))).m_168936_(movingX += list.tinyWidgetWidth, 0, list.tinyWidgetWidth, height, (Component)Component.m_237119_(), (button, type) -> {
                    styleTarget.type = type;
                    list.init();
                });
                typeButton.m_257427_(500);
                this.elements.add(typeButton);
                TextField stringField = new TextField(movingX += list.tinyWidgetWidth, 0, stringFieldWidth, height);
                if (styleTarget.type == StyleTarget.Type.REGEX) {
                    stringField.regexValidator();
                }
                stringField.m_94199_(240);
                stringField.m_94144_(styleTarget.string);
                stringField.m_94151_(string -> {
                    styleTarget.string = string.strip();
                    list.m_6702_().removeIf(entry -> entry instanceof MessageEntry || entry instanceof OptionList.Entry.Text || entry instanceof OptionList.Entry.Space && list.m_6702_().indexOf(entry) > 4);
                    list.addChatMessages(list.recentChat);
                });
                stringField.m_257771_((Component)Localization.localized("option", "notif.trigger.style_target.field.hint", new Object[0]));
                this.elements.add(stringField);
                movingX = x + width - list.tinyWidgetWidth;
                this.elements.add(Button.m_253074_((Component)Component.m_237113_((String)Unicode.CROSS.str).m_130940_(ChatFormatting.RED), button -> {
                    styleTarget.enabled = false;
                    list.init();
                }).m_252794_(movingX, 0).m_253046_(list.tinyWidgetWidth, height).m_253136_());
            }
        }

        private static class TriggerOptions
        extends Entry {
            TriggerOptions(int x, int width, int height, TriggerEditorList list, Trigger trigger) {
                int triggerFieldWidth = width - list.tinyWidgetWidth * 2;
                int movingX = x;
                CycleButton typeButton = CycleButton.m_168894_(type -> Component.m_237113_((String)type.icon)).m_168961_((Object[])Trigger.Type.values()).m_168929_().m_168948_((Object)trigger.type).m_232498_(type -> Tooltip.m_257550_((Component)Localization.localized("option", "notif.trigger.type." + String.valueOf(type) + ".tooltip", new Object[0]))).m_168936_(movingX, 0, list.tinyWidgetWidth, height, (Component)Component.m_237119_(), (button, type) -> {
                    trigger.type = type;
                    list.init();
                });
                typeButton.m_257427_(500);
                this.elements.add(typeButton);
                MultiLineTextField triggerField = new MultiLineTextField(movingX += list.tinyWidgetWidth, 0, triggerFieldWidth, height, (Component)Localization.localized("option", "notif.trigger.field.hint", new Object[0]));
                if (trigger.type == Trigger.Type.REGEX) {
                    triggerField.regexValidator();
                }
                triggerField.m_239273_(str -> {
                    trigger.string = str.strip();
                    if (list.m_6702_().size() > 4) {
                        list.m_6702_().removeIf(entry -> entry instanceof MessageEntry || entry instanceof OptionList.Entry.Text || entry instanceof OptionList.Entry.Space && list.m_6702_().indexOf(entry) > 4);
                        list.addChatMessages(list.recentChat);
                    }
                });
                triggerField.m_240159_(trigger.string);
                this.elements.add(triggerField);
                Button styleButton = Button.m_253074_((Component)Component.m_237113_((String)"+"), button -> {
                    trigger.styleTarget.enabled = true;
                    list.init();
                }).m_252794_(movingX += triggerFieldWidth, 0).m_253046_(list.tinyWidgetWidth, height).m_253136_();
                if (!trigger.styleTarget.enabled) {
                    styleButton.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "notif.trigger.style_target.add.tooltip", new Object[0])));
                    styleButton.m_257427_(500);
                } else {
                    styleButton.f_93623_ = false;
                }
                this.elements.add(styleButton);
            }
        }
    }
}

