/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify;

import com.mojang.datafixers.util.Pair;
import dev.terminalmc.chatnotify.compat.commandkeys.CommandKeysWrapper;
import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.config.Notification;
import dev.terminalmc.chatnotify.config.Response;
import dev.terminalmc.chatnotify.config.StyleTarget;
import dev.terminalmc.chatnotify.config.Trigger;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.ModLogger;
import dev.terminalmc.chatnotify.util.text.FormatUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.chat.Component;

public class ChatNotify {
    public static final String MOD_ID = "chatnotify";
    public static final String MOD_NAME = "ChatNotify";
    public static final ModLogger LOG = new ModLogger("ChatNotify");
    public static boolean hasResetConfig = false;
    public static final List<Pair<Long, String>> recentMessages = new ArrayList<Pair<Long, String>>();
    public static final List<Response> RESPONSES = new ArrayList<Response>();
    public static final Queue<Component> unmodifiedChat = new LinkedList<Component>();

    public static void init() {
        Config.getAndSave();
    }

    public static void onConfigSaved(Config config) {
        for (Notification notif : config.getNotifs()) {
            for (Trigger trig : notif.triggers) {
                if (trig.type == Trigger.Type.REGEX) {
                    trig.tryCompilePattern();
                }
                if (trig.styleTarget.type == StyleTarget.Type.REGEX) {
                    trig.styleTarget.tryCompilePattern();
                    continue;
                }
                if (trig.styleTarget.type != StyleTarget.Type.CAPTURING) continue;
                trig.styleTarget.tryParseIndexes();
            }
            for (Trigger trig : notif.exclusionTriggers) {
                if (trig.type != Trigger.Type.REGEX) continue;
                trig.tryCompilePattern();
            }
        }
    }

    public static void afterClientTick(Minecraft mc) {
        ChatNotify.tickResponses(mc);
        if (hasResetConfig && mc.f_91080_ instanceof TitleScreen) {
            hasResetConfig = false;
            mc.m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.UNSECURE_SERVER_WARNING, (Component)Localization.localized("toast", "reset.title", new Object[0]), (Component)Localization.localized("toast", "reset.message", Component.m_237113_((String)"chatnotify.unreadable.json").m_130940_(ChatFormatting.GOLD))));
        }
    }

    private static void tickResponses(Minecraft mc) {
        if (mc.m_91403_() == null || !mc.m_91403_().m_6198_()) {
            RESPONSES.clear();
            return;
        }
        ArrayList<String> sending = new ArrayList<String>();
        RESPONSES.removeIf(resMsg -> {
            if (--resMsg.countdown <= 0) {
                if (resMsg.sendingString != null && !resMsg.sendingString.isBlank()) {
                    if (resMsg.type.equals((Object)Response.Type.COMMANDKEYS)) {
                        CommandKeysWrapper.trySend(resMsg.sendingString);
                    } else {
                        sending.add(resMsg.sendingString);
                    }
                }
                return true;
            }
            return false;
        });
        ChatNotify.sendMessages(sending, mc.m_91403_());
    }

    private static void sendMessages(List<String> messages, ClientPacketListener connection) {
        if (messages.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        switch (Config.get().sendMode) {
            case SCREEN: {
                Object object;
                Screen oldScreen = mc.f_91080_;
                if (!(mc.f_91080_ instanceof ChatScreen)) {
                    mc.m_91152_((Screen)new ChatScreen(""));
                }
                if ((object = mc.f_91080_) instanceof ChatScreen) {
                    ChatScreen cs = (ChatScreen)object;
                    for (String msg : messages) {
                        cs.m_241797_(msg, false);
                    }
                }
                mc.m_91152_(oldScreen);
                break;
            }
            case PACKET: {
                for (String msg : messages) {
                    if (msg.startsWith("/")) {
                        connection.m_246623_(msg.substring(1));
                        continue;
                    }
                    connection.m_246175_(msg);
                }
                break;
            }
        }
    }

    public static void updateUsernameNotif(Config config) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            config.setProfileName(FormatUtil.stripCodes(mc.f_91074_.m_7755_().getString()));
            config.setDisplayName(FormatUtil.stripCodes(mc.f_91074_.m_5446_().getString()));
        }
    }
}

