/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.screen;

import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.config.Notification;
import dev.terminalmc.chatnotify.config.Response;
import dev.terminalmc.chatnotify.config.Trigger;
import dev.terminalmc.chatnotify.gui.screen.OptionScreen;
import dev.terminalmc.chatnotify.gui.widget.field.TextField;
import dev.terminalmc.chatnotify.gui.widget.list.FilterList;
import dev.terminalmc.chatnotify.gui.widget.list.OptionList;
import dev.terminalmc.chatnotify.gui.widget.list.root.notif.FormatList;
import dev.terminalmc.chatnotify.gui.widget.list.root.notif.MiscOptionList;
import dev.terminalmc.chatnotify.gui.widget.list.root.notif.SoundList;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.Unicode;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class NotifScreen
extends OptionScreen {
    private final Notification notif;

    public NotifScreen(Screen lastScreen, Notification notif) {
        this(lastScreen, notif, TabKey.TRIGGERS.key);
    }

    public NotifScreen(Screen lastScreen, Notification notif, String defaultKey) {
        super(lastScreen);
        this.notif = notif;
        notif.editing = true;
        this.addTabs(defaultKey);
        this.updateTabTitles();
    }

    private void addTabs(String defaultKey) {
        List<OptionScreen.Tab> tabs = List.of(new OptionScreen.Tab(TabKey.TRIGGERS.key, NotifScreen::getTriggerList), new OptionScreen.Tab(TabKey.FORMAT.key, NotifScreen::getFormatList), new OptionScreen.Tab(TabKey.SOUND.key, NotifScreen::getSoundList), new OptionScreen.Tab(TabKey.INCLUSION.key, NotifScreen::getInclusionList), new OptionScreen.Tab(TabKey.EXCLUSION.key, NotifScreen::getExclusionList), new OptionScreen.Tab(TabKey.RESPONSES.key, NotifScreen::getResponsesList), new OptionScreen.Tab(TabKey.MISC.key, NotifScreen::getMiscList));
        super.setTabs(tabs, defaultKey);
    }

    public void updateTabTitles() {
        for (TabKey tabKey : TabKey.values()) {
            this.updateTabTitle(tabKey);
        }
    }

    private void updateTabTitle(TabKey tabKey) {
        MutableComponent title = Component.m_237115_((String)tabKey.key);
        switch (tabKey) {
            case TRIGGERS: {
                if (this.notif.triggers.isEmpty()) break;
                title.m_130946_(" ");
                title.m_7220_((Component)Localization.localized("common", "count", this.notif.triggers.size()));
                break;
            }
            case INCLUSION: {
                if (!this.notif.inclusionEnabled || this.notif.inclusionTriggers.isEmpty()) break;
                title.m_130946_(" ");
                title.m_7220_((Component)Localization.localized("common", "count", this.notif.inclusionTriggers.size()));
                break;
            }
            case EXCLUSION: {
                if (!this.notif.exclusionEnabled || this.notif.exclusionTriggers.isEmpty()) break;
                title.m_130946_(" ");
                title.m_7220_((Component)Localization.localized("common", "count", this.notif.exclusionTriggers.size()));
                break;
            }
            case RESPONSES: {
                if (!this.notif.responseEnabled || this.notif.responses.isEmpty()) break;
                title.m_130946_(" ");
                title.m_7220_((Component)Localization.localized("common", "count", this.notif.responses.size()));
            }
        }
        super.updateTabTitle(tabKey.key, (Component)title);
    }

    @Override
    public void m_7379_() {
        this.notif.editing = false;
        super.m_7379_();
    }

    private static OptionList getTriggerList(OptionScreen screen) {
        Notification notif = NotifScreen.cast((OptionScreen)screen).notif;
        return new FilterList<Trigger>(Minecraft.m_91087_(), screen, 0, 0, 0, 0, 232, 20, 5, FilterList.Entry.TriggerOptions.class, (srcIdx, dstIdx) -> notif == Config.get().getUserNotif() ? notif.moveTrigger(srcIdx + 2, dstIdx + 2) : notif.moveTrigger((int)srcIdx, (int)dstIdx), () -> NotifScreen.cast(screen).updateTabTitle(TabKey.TRIGGERS), (Component)Localization.localized("option", "notif.trigger.list", Unicode.INFO.str), (Component)Localization.localized("option", "notif.trigger.list.tooltip", new Object[0]), null, null, () -> notif.triggers, (x, width, height, list, trigger, index) -> {
            if (notif.equals(Config.get().getUserNotif()) && index <= 1) {
                return new FilterList.Entry.LockedTriggerOptions(x, width, height, (Trigger)trigger, (Component)Localization.localized("option", index == 0 ? "notif.trigger.list.special.profile_name" : "notif.trigger.list.special.display_name", new Object[0]));
            }
            return new FilterList.Entry.TriggerOptions(x, width, height, list, (Trigger)trigger, notif.textStyle, index, i -> notif.triggers.remove((int)i), new TextField.Validator.UniqueTrigger(notif, (Trigger)trigger), true);
        }, (x, width, height, list, trigger) -> trigger.styleTarget.enabled ? new FilterList.Entry.StyleTargetOptions(x, width, height, list, trigger.styleTarget) : null, () -> notif.triggers.add(new Trigger()));
    }

    private static OptionList getFormatList(OptionScreen screen) {
        return new FormatList(Minecraft.m_91087_(), screen, 0, 0, 0, 0, 232, 20, 5, NotifScreen.cast((OptionScreen)screen).notif);
    }

    private static OptionList getSoundList(OptionScreen screen) {
        return new SoundList(Minecraft.m_91087_(), screen, 0, 0, 0, 0, 232, 20, NotifScreen.cast((OptionScreen)screen).notif.sound);
    }

    private static OptionList getInclusionList(OptionScreen screen) {
        Notification notif = NotifScreen.cast((OptionScreen)screen).notif;
        return new FilterList<Trigger>(Minecraft.m_91087_(), screen, 0, 0, 0, 0, 232, 20, 5, FilterList.Entry.TriggerOptions.class, notif::moveInclusionTrigger, () -> NotifScreen.cast(screen).updateTabTitle(TabKey.INCLUSION), (Component)Localization.localized("option", "notif.inclusion.list", Unicode.INFO.str), (Component)Localization.localized("option", "notif.inclusion.list.tooltip", new Object[0]), () -> notif.inclusionEnabled, status -> {
            notif.inclusionEnabled = status;
        }, () -> notif.inclusionTriggers, (x, width, height, list, trigger, index) -> new FilterList.Entry.TriggerOptions(x, width, height, list, (Trigger)trigger, notif.textStyle, index, i -> notif.inclusionTriggers.remove((int)i), TextField.Validator.UniqueTrigger.inclusion(notif, trigger), false), null, () -> notif.inclusionTriggers.add(new Trigger()));
    }

    private static OptionList getExclusionList(OptionScreen screen) {
        Notification notif = NotifScreen.cast((OptionScreen)screen).notif;
        return new FilterList<Trigger>(Minecraft.m_91087_(), screen, 0, 0, 0, 0, 232, 20, 5, FilterList.Entry.TriggerOptions.class, notif::moveExclusionTrigger, () -> NotifScreen.cast(screen).updateTabTitle(TabKey.EXCLUSION), (Component)Localization.localized("option", "notif.exclusion.list", Unicode.INFO.str), (Component)Localization.localized("option", "notif.exclusion.list.tooltip", new Object[0]), () -> notif.exclusionEnabled, status -> {
            notif.exclusionEnabled = status;
        }, () -> notif.exclusionTriggers, (x, width, height, list, trigger, index) -> new FilterList.Entry.TriggerOptions(x, width, height, list, (Trigger)trigger, notif.textStyle, index, i -> notif.exclusionTriggers.remove((int)i), TextField.Validator.UniqueTrigger.exclusion(notif, trigger), false), null, () -> notif.exclusionTriggers.add(new Trigger()));
    }

    private static OptionList getResponsesList(OptionScreen screen) {
        Notification notif = NotifScreen.cast((OptionScreen)screen).notif;
        return new FilterList<Response>(Minecraft.m_91087_(), screen, 0, 0, 0, 0, 232, 20, 5, FilterList.Entry.ResponseOptions.class, notif::moveResponseMessage, () -> NotifScreen.cast(screen).updateTabTitle(TabKey.RESPONSES), (Component)Localization.localized("option", "notif.response.list", Unicode.INFO.str), (Component)Localization.localized("option", "notif.response.list.tooltip", new Object[0]), () -> notif.responseEnabled, status -> {
            notif.responseEnabled = status;
        }, () -> notif.responses, (x, width, height, list, trigger, index) -> new FilterList.Entry.ResponseOptions(x, width, height, list, (Response)trigger, index, i -> notif.responses.remove((int)i)), null, () -> notif.responses.add(new Response()));
    }

    private static OptionList getMiscList(OptionScreen screen) {
        return new MiscOptionList(Minecraft.m_91087_(), screen, 0, 0, 0, 0, 232, 20, 5, NotifScreen.cast((OptionScreen)screen).notif);
    }

    private static NotifScreen cast(OptionScreen screen) {
        if (!(screen instanceof NotifScreen)) {
            throw new IllegalArgumentException(String.format("Option list supplier for class %s cannot use screen type %s", NotifScreen.class.getName(), ((Object)((Object)screen)).getClass().getName()));
        }
        NotifScreen s = (NotifScreen)screen;
        return s;
    }

    public static enum TabKey {
        TRIGGERS(Localization.translationKey("option", "notif.trigger")),
        FORMAT(Localization.translationKey("option", "notif.format")),
        SOUND(Localization.translationKey("option", "notif.sound")),
        INCLUSION(Localization.translationKey("option", "notif.inclusion")),
        EXCLUSION(Localization.translationKey("option", "notif.exclusion")),
        RESPONSES(Localization.translationKey("option", "notif.response")),
        MISC(Localization.translationKey("option", "notif.misc"));

        public final String key;

        private TabKey(String key) {
            this.key = key;
        }
    }
}

