/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.screen;

import dev.terminalmc.chatnotify.ChatNotify;
import dev.terminalmc.chatnotify.gui.widget.HorizontalList;
import dev.terminalmc.chatnotify.gui.widget.OverlayWidget;
import dev.terminalmc.chatnotify.gui.widget.list.OptionList;
import dev.terminalmc.chatnotify.mixin.accessor.ScreenAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OptionScreen
extends OptionsSubScreen {
    public static final int HEADER_MARGIN = 32;
    public static final int FOOTER_MARGIN = 32;
    public static final int BASE_ROW_WIDTH = 320;
    public static final int SCROLL_BAR_MARGIN = 20;
    public static final int ELEMENT_SPACING = 4;
    public static final int ELEMENT_SPACING_NARROW = 2;
    public static final int ELEMENT_SPACING_FINE = 1;
    public static final int LIST_ENTRY_HEIGHT = 20;
    public static final int LIST_ENTRY_SPACING = 5;
    public static final int HANGING_WIDGET_MARGIN = 24;
    public static final int BASE_LIST_ENTRY_WIDTH = 232;
    public static final int TAB_LIST_HEIGHT = 28;
    public static final int TAB_LIST_Y = 2;
    public static final int TAB_LIST_MARGIN = 24;
    public static final int MIN_TAB_WIDTH = 40;
    public static final int MAX_TAB_WIDTH = 120;
    public static final int TAB_HEIGHT = 20;
    public static final int TAB_SPACING = 4;
    protected final Map<String, Button> tabLookup = new HashMap<String, Button>();
    protected final HorizontalList<Button> tabs = new HorizontalList(24, 2, this.f_96543_ - 48, 28, 4, true);
    @Nullable
    private OptionList list;
    @Nullable
    private OverlayWidget overlay = null;
    boolean childrenHidden;
    private final List<GuiEventListener> childrenAlt = new ArrayList<GuiEventListener>();
    private final List<Renderable> renderablesAlt = new ArrayList<Renderable>();
    private final List<NarratableEntry> narratablesAlt = new ArrayList<NarratableEntry>();

    public OptionScreen(Screen lastScreen) {
        super(lastScreen, Minecraft.m_91087_().f_91066_, (Component)Component.m_237119_());
    }

    protected void m_7856_() {
        this.m_169413_();
        this.clearWidgetsAlt();
        this.m_264131_();
        this.addContents();
        this.addHeader();
        this.addFooter();
        this.addOverlay();
        this.setInitialFocus();
    }

    public void m_6574_(@NotNull Minecraft mc, int width, int height) {
        this.f_96543_ = width;
        this.f_96544_ = height;
        this.m_7856_();
    }

    protected void addHeader() {
        this.tabs.setWidth(this.f_96543_ - 48);
        this.m_142416_((GuiEventListener)this.tabs);
    }

    protected void addContents() {
        if (this.list != null) {
            this.list.m_93437_(this.f_96543_, this.f_96544_ - 32 - 32, 32, this.f_96544_ - 32);
            this.m_142416_((GuiEventListener)this.list);
        }
    }

    protected void addFooter() {
        int w = 232;
        int h = 20;
        int x = this.f_96543_ / 2 - w / 2;
        int y = Math.min(this.f_96544_ - h, this.f_96544_ - 16 - h / 2);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.m_7379_()).m_252794_(x, y).m_253046_(w, h).m_253136_());
    }

    protected void addOverlay() {
        if (this.overlay != null) {
            this.overlay.updateBounds(this.f_96543_, this.f_96544_);
            this.setOverlay(this.overlay);
        }
    }

    protected void m_264131_() {
        ComponentPath path = this.m_264435_();
        if (path != null) {
            path.m_264432_(false);
        }
    }

    protected void setInitialFocus() {
        FocusNavigationEvent.TabNavigation nav;
        ComponentPath path;
        if (this.f_96541_.m_264529_().m_264505_() && (path = super.m_264064_((FocusNavigationEvent)(nav = new FocusNavigationEvent.TabNavigation(true)))) != null) {
            this.m_264158_(path);
        }
    }

    public void m_7379_() {
        Screen screen = this.f_96281_;
        if (screen instanceof OptionScreen) {
            OptionScreen screen2 = (OptionScreen)screen;
            screen2.m_6574_(Minecraft.m_91087_(), this.f_96543_, this.f_96544_);
        }
        super.m_7379_();
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280039_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
    }

    protected void setTabs(List<Tab> tabList, String defaultKey) {
        if (tabList.isEmpty()) {
            throw new IllegalArgumentException("Tab list cannot be empty!");
        }
        int defaultIndex = -1;
        int i = 0;
        for (Tab tab : tabList) {
            if (this.tabLookup.containsKey(tab.key)) {
                ChatNotify.LOG.error("Duplicate tab found with key '{}'!", tab.key);
                continue;
            }
            MutableComponent title = Component.m_237115_((String)tab.key);
            Button button = Button.m_253074_((Component)title, b -> {
                this.tabs.entries().forEach(b2 -> {
                    b2.f_93623_ = true;
                });
                b.f_93623_ = false;
                this.setList(tab.getList(this));
            }).m_253046_(Mth.m_14045_((int)(Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)title) + 8), (int)40, (int)120), 20).m_253136_();
            this.tabLookup.put(tab.key, button);
            this.tabs.addEntry(button);
            if (defaultIndex == -1 && tab.key.equals(defaultKey)) {
                defaultIndex = i;
                continue;
            }
            ++i;
        }
        if (defaultIndex == -1) {
            defaultIndex = 0;
        }
        this.tabs.getEntry((int)defaultIndex).f_93623_ = false;
        this.list = tabList.get(defaultIndex).getList(this);
    }

    private void setList(@NotNull OptionList list) {
        this.list = list;
        this.m_7856_();
    }

    public void updateTabTitle(String key, Component title) {
        Button button = this.tabLookup.get(key);
        if (button != null) {
            button.m_93666_(title);
            button.m_93674_(Mth.m_14045_((int)(Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)title) + 8), (int)40, (int)120));
        }
    }

    public void setOverlayWidget(OverlayWidget widget) {
        widget.addOnClose(w -> this.removeOverlay());
        this.setOverlay(widget);
    }

    private void setOverlay(@NotNull OverlayWidget widget) {
        this.removeOverlay();
        this.overlay = widget;
        this.setChildrenVisible(false);
        this.m_142416_((GuiEventListener)this.overlay);
    }

    public void removeOverlay() {
        if (this.overlay != null) {
            this.m_169411_((GuiEventListener)this.overlay);
            this.overlay = null;
            this.setChildrenVisible(true);
        }
    }

    private void setChildrenVisible(boolean visible) {
        if (visible && this.childrenHidden) {
            this.childrenHidden = false;
            ((ScreenAccessor)((Object)this)).chatnotify$getChildren().addAll(this.childrenAlt);
            ((ScreenAccessor)((Object)this)).chatnotify$getRenderables().addAll(this.renderablesAlt);
            ((ScreenAccessor)((Object)this)).chatnotify$getNarratables().addAll(this.narratablesAlt);
            this.clearWidgetsAlt();
        } else if (!visible && !this.childrenHidden) {
            this.childrenHidden = true;
            this.childrenAlt.addAll(((ScreenAccessor)((Object)this)).chatnotify$getChildren());
            this.renderablesAlt.addAll(((ScreenAccessor)((Object)this)).chatnotify$getRenderables());
            this.narratablesAlt.addAll(((ScreenAccessor)((Object)this)).chatnotify$getNarratables());
            this.m_169413_();
        }
    }

    private void clearWidgetsAlt() {
        this.childrenAlt.clear();
        this.renderablesAlt.clear();
        this.narratablesAlt.clear();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.overlay != null) {
            if (keyCode == 256) {
                this.overlay.onClose();
                this.removeOverlay();
            } else {
                this.overlay.m_7933_(keyCode, scanCode, modifiers);
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char chr, int modifiers) {
        if (this.overlay != null) {
            this.overlay.m_5534_(chr, modifiers);
            return true;
        }
        return super.m_5534_(chr, modifiers);
    }

    public static class Tab {
        final String key;
        private final Function<OptionScreen, OptionList> supplier;
        @Nullable
        private OptionList list = null;

        public Tab(String key, Function<OptionScreen, OptionList> supplier) {
            this.key = key;
            this.supplier = supplier;
        }

        @NotNull
        public OptionList getList(OptionScreen screen) {
            if (this.list == null) {
                this.list = this.supplier.apply(screen);
            }
            return this.list;
        }
    }
}

