/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget.list;

import dev.terminalmc.chatnotify.ChatNotify;
import dev.terminalmc.chatnotify.gui.screen.OptionScreen;
import dev.terminalmc.chatnotify.gui.widget.list.OptionList;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DragReorderList
extends OptionList {
    private final Map<Class<? extends OptionList.Entry>, BiFunction<Integer, Integer, Boolean>> clsFunMap;
    private int dragSourceSlot = -1;
    private Class<? extends OptionList.Entry> dragClass;
    @Nullable
    private Class<? extends OptionList.Entry> trailerClass;
    boolean hasTrailer;

    public DragReorderList(Minecraft mc, OptionScreen screen, int width, int height, int top, int bottom, int entryWidth, int entryHeight, int entrySpacing, Map<Class<? extends OptionList.Entry>, BiFunction<Integer, Integer, Boolean>> clsFunMap) {
        super(mc, screen, width, height, top, bottom, entryWidth, entryHeight, entrySpacing);
        this.clsFunMap = clsFunMap;
    }

    protected void startDragging(OptionList.Entry entry, @Nullable Class<? extends OptionList.Entry> trailerClass, boolean hasTrailer) {
        if (this.validate(entry, trailerClass, hasTrailer)) {
            this.dragSourceSlot = this.m_6702_().indexOf((Object)entry);
            this.dragClass = ((Object)((Object)entry)).getClass();
            this.trailerClass = trailerClass;
            this.hasTrailer = hasTrailer;
        }
    }

    private boolean validate(OptionList.Entry entry, @Nullable Class<? extends OptionList.Entry> trailerClass, boolean hasTrailer) {
        Class<?> cls = ((Object)((Object)entry)).getClass();
        int index = this.m_6702_().indexOf((Object)entry);
        if (index == -1) {
            ChatNotify.LOG.error("Cannot drag entry of type '{}'. Not present in list.", new Object[0]);
            return false;
        }
        if (cls.equals(trailerClass)) {
            ChatNotify.LOG.error("Cannot drag entry of type '{}' at index {}. Identical trailer class.", cls, index);
            return false;
        }
        if (!this.clsFunMap.containsKey(((Object)((Object)entry)).getClass())) {
            ChatNotify.LOG.error("Cannot drag entry of type '{}' at index {}. Allowed types: {}", cls, index, this.clsFunMap.keySet().stream().map(Class::getName).collect(Collectors.joining(", ")));
            return false;
        }
        if (hasTrailer) {
            if (index < this.m_6702_().size()) {
                Class<?> trailerCls = ((Object)((Object)((OptionList.Entry)((Object)this.m_6702_().get(index + 1))))).getClass();
                if (!trailerCls.equals(OptionList.Entry.Space.class) && !trailerCls.equals(trailerClass)) {
                    ChatNotify.LOG.error("Cannot drag entry of type '{}' at index {}. hasTrailer is true but trailer is class '{}'. Allowed trailer types: '{}', '{}'.", OptionList.Entry.Space.class, trailerClass);
                    return false;
                }
            } else {
                ChatNotify.LOG.error("Cannot drag entry of type '{}' at index {}. hasTrailer is true but entry is the last list element.", new Object[0]);
                return false;
            }
        }
        int start = this.getListStart(cls);
        int end = this.getListEnd(cls);
        for (int i = start; i <= end; ++i) {
            if (((Object)((Object)((OptionList.Entry)((Object)this.m_6702_().get(i))))).getClass().equals(cls)) {
                Class<?> trailerCls = ((Object)((Object)((OptionList.Entry)((Object)this.m_6702_().get(i + 1))))).getClass();
                if (!trailerCls.equals(trailerClass) && !trailerCls.equals(OptionList.Entry.Space.class)) continue;
                ++i;
                continue;
            }
            ChatNotify.LOG.error("Cannot drag entry of type '{}' at index {}. Encountered unexpected type '{}' at index {} breaking contiguous sub-list from {} to {}. Allowed trailer types: '{}', '{}'.", cls, this.m_6702_().indexOf((Object)entry), ((Object)((Object)((OptionList.Entry)((Object)this.m_6702_().get(i))))).getClass(), i, start, end, OptionList.Entry.Space.class, trailerClass);
            return false;
        }
        return true;
    }

    private void cancelDrag() {
        this.dragSourceSlot = -1;
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.m_88315_(graphics, mouseX, mouseY, delta);
        if (this.dragSourceSlot != -1) {
            super.m_238964_(graphics, mouseX, mouseY, delta, this.dragSourceSlot, mouseX, mouseY, this.entryWidth, this.entryHeight);
            if (this.hasTrailer) {
                super.m_238964_(graphics, mouseX, mouseY, delta, this.dragSourceSlot + 1, mouseX, mouseY + this.f_93387_, this.entryWidth, this.entryHeight);
            }
        }
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        if (this.dragSourceSlot != -1) {
            return true;
        }
        return super.m_5953_(mouseX, mouseY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.dragSourceSlot != -1 && button == 0) {
            this.dropDragged(mouseY);
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    private int getListStart(Class<? extends OptionList.Entry> cls) {
        for (int i = 0; i < this.m_6702_().size(); ++i) {
            if (!((Object)((Object)((OptionList.Entry)((Object)this.m_6702_().get(i))))).getClass().equals(cls)) continue;
            return i;
        }
        throw new IllegalArgumentException("getListStart could not find any element of type " + cls.getName());
    }

    private int getListEnd(Class<? extends OptionList.Entry> cls) {
        for (int i = this.m_6702_().size() - 1; i >= 0; --i) {
            if (!((Object)((Object)((OptionList.Entry)((Object)this.m_6702_().get(i))))).getClass().equals(cls)) continue;
            return i;
        }
        throw new IllegalArgumentException("getListEnd could not find any element of type " + cls.getName());
    }

    private int getOffset(int index) {
        int i = 0;
        int offset = 0;
        for (OptionList.Entry entry : this.m_6702_()) {
            if (!((Object)((Object)entry)).getClass().equals(this.dragClass)) {
                ++offset;
            }
            if (i++ != index) continue;
            return offset;
        }
        throw new IllegalArgumentException(String.format("Index out of range for class '%s' and index %s", this.dragClass, index));
    }

    private void dropDragged(double mouseY) {
        int hoveredSlot;
        int end;
        int start = this.getListStart(this.dragClass);
        if (start == (end = this.getListEnd(this.dragClass))) {
            this.cancelDrag();
            return;
        }
        @Nullable OptionList.Entry hoveredEntry = (OptionList.Entry)this.m_93412_((double)this.f_93393_ + (double)this.f_93388_ / 2.0, mouseY);
        if (hoveredEntry == null && (mouseY > (double)this.f_93391_ || mouseY > (double)(this.f_93390_ + this.f_93387_ * this.m_6702_().size()))) {
            hoveredEntry = (OptionList.Entry)((Object)this.m_6702_().get(end));
        }
        if (hoveredEntry == null) {
            hoveredSlot = start - 1;
        } else {
            hoveredSlot = this.m_6702_().indexOf((Object)hoveredEntry);
            if (hoveredSlot <= start - 1) {
                hoveredSlot = start - 1;
            } else if (hoveredSlot > end) {
                hoveredSlot = end;
            } else if (((Object)((Object)hoveredEntry)).getClass().equals(OptionList.Entry.Space.class) || ((Object)((Object)hoveredEntry)).getClass().equals(this.trailerClass)) {
                if (!((Object)((Object)((OptionList.Entry)((Object)this.m_6702_().get(--hoveredSlot))))).getClass().equals(this.dragClass)) {
                    throw new IllegalStateException(String.format("Invalid list structure: trailer parent class '%s', expected '%s'", ((Object)((Object)((OptionList.Entry)((Object)this.m_6702_().get(hoveredSlot))))).getClass(), this.dragClass));
                }
            } else if (!((Object)((Object)hoveredEntry)).getClass().equals(this.dragClass)) {
                throw new IllegalStateException(String.format("Invalid list structure: found class %s, expected %s or %s", ((Object)((Object)hoveredEntry)).getClass(), this.dragClass, this.trailerClass));
            }
        }
        if (hoveredSlot > this.dragSourceSlot || hoveredSlot < this.dragSourceSlot - 1) {
            int dstIdx;
            int srcIdx = this.dragSourceSlot - this.getOffset(this.dragSourceSlot);
            if (srcIdx > (dstIdx = hoveredSlot - this.getOffset(hoveredSlot))) {
                ++dstIdx;
            }
            if (this.clsFunMap.get(this.dragClass).apply(srcIdx, dstIdx).booleanValue()) {
                this.init();
            }
        }
        this.cancelDrag();
    }
}

