/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget.list;

import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.config.Notification;
import dev.terminalmc.chatnotify.config.Response;
import dev.terminalmc.chatnotify.config.StyleTarget;
import dev.terminalmc.chatnotify.config.TextStyle;
import dev.terminalmc.chatnotify.config.Trigger;
import dev.terminalmc.chatnotify.gui.screen.NotifScreen;
import dev.terminalmc.chatnotify.gui.screen.OptionScreen;
import dev.terminalmc.chatnotify.gui.screen.TriggerScreen;
import dev.terminalmc.chatnotify.gui.widget.ConfirmButton;
import dev.terminalmc.chatnotify.gui.widget.HsvColorPicker;
import dev.terminalmc.chatnotify.gui.widget.RightClickableButton;
import dev.terminalmc.chatnotify.gui.widget.field.DropdownTextField;
import dev.terminalmc.chatnotify.gui.widget.field.FakeTextField;
import dev.terminalmc.chatnotify.gui.widget.field.MultiLineTextField;
import dev.terminalmc.chatnotify.gui.widget.field.TextField;
import dev.terminalmc.chatnotify.gui.widget.list.DragReorderList;
import dev.terminalmc.chatnotify.gui.widget.list.OptionList;
import dev.terminalmc.chatnotify.mixin.accessor.KeyAccessor;
import dev.terminalmc.chatnotify.mixin.accessor.TextColorAccessor;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.Unicode;
import dev.terminalmc.chatnotify.util.functional.StringSupplier;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FastColor;
import net.minecraft.util.StringUtil;
import org.jetbrains.annotations.Nullable;

public class FilterList<E extends StringSupplier>
extends DragReorderList {
    private String filterString = "";
    @Nullable
    private Pattern filterPattern = null;
    private OptionList.Entry.ActionButton addButtonEntry;
    private final Runnable tabNameUpdate;
    private final Component title;
    private final Component titleTooltip;
    @Nullable
    private final Supplier<Boolean> statusSupplier;
    @Nullable
    private final Consumer<Boolean> statusConsumer;
    private final Supplier<List<E>> listSupplier;
    private final EntrySupplier<E> entrySupplier;
    @Nullable
    private final TrailerSupplier<E> trailerSupplier;

    public FilterList(Minecraft mc, OptionScreen screen, int width, int height, int top, int bottom, int entryWidth, int entryHeight, int entrySpacing, Class<? extends Entry.ListEntry> entryClass, BiFunction<Integer, Integer, Boolean> moveFunction, Runnable tabNameUpdate, Component title, Component titleTooltip, @Nullable Supplier<Boolean> statusSupplier, @Nullable Consumer<Boolean> statusConsumer, Supplier<List<E>> listSupplier, EntrySupplier<E> entrySupplier, @Nullable TrailerSupplier<E> trailerSupplier, Runnable addRunnable) {
        super(mc, screen, width, height, top, bottom, entryWidth, entryHeight, entrySpacing, new HashMap<Class<? extends OptionList.Entry>, BiFunction<Integer, Integer, Boolean>>(Map.of(entryClass, moveFunction)));
        this.tabNameUpdate = tabNameUpdate;
        this.title = title;
        this.titleTooltip = titleTooltip;
        this.statusSupplier = statusSupplier;
        this.statusConsumer = statusConsumer;
        this.listSupplier = listSupplier;
        this.entrySupplier = entrySupplier;
        this.trailerSupplier = trailerSupplier;
        this.addButtonEntry = new OptionList.Entry.ActionButton(this.entryX, entryWidth, entryHeight, (Component)Component.m_237113_((String)"+"), null, -1, button -> {
            addRunnable.run();
            tabNameUpdate.run();
            this.filterString = "";
            this.filterPattern = null;
            this.init();
            this.m_93498_((AbstractSelectionList.Entry)this.addButtonEntry);
        });
    }

    @Override
    protected void addEntries() {
        this.m_7085_((AbstractSelectionList.Entry)new Entry.ListHeader(this.dynEntryX, this.dynEntryWidth, this.entryHeight, this));
        this.refreshSubList();
        this.addButtonEntry.setBounds(this.entryX, this.entryWidth, this.entryHeight);
        this.m_7085_((AbstractSelectionList.Entry)this.addButtonEntry);
    }

    protected void refreshSubList() {
        Iterator iterator = this.m_6702_().iterator();
        while (iterator.hasNext()) {
            OptionList.Entry entry = (OptionList.Entry)((Object)iterator.next());
            if (entry instanceof Entry.SpacedListEntry) {
                iterator.remove();
                iterator.next();
                iterator.remove();
                continue;
            }
            if (!(entry instanceof Entry.ListEntry) && !(entry instanceof Entry.ListEntryTrailer)) continue;
            iterator.remove();
        }
        int start = this.m_6702_().indexOf((Object)this.addButtonEntry);
        if (start == -1) {
            start = this.m_6702_().size();
        }
        List<E> list = this.listSupplier.get();
        for (int i = list.size() - 1; i >= 0; --i) {
            Entry.ListEntryTrailer trailer;
            StringSupplier e = (StringSupplier)list.get(i);
            if (this.filterPattern != null && !this.filterPattern.matcher(e.getString()).find()) continue;
            Entry.ListEntry entry = this.entrySupplier.get(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, this, e, list.indexOf(e));
            if (entry instanceof Entry.SpacedListEntry) {
                this.addEntry(start, new OptionList.Entry.Space(entry));
            } else if (this.trailerSupplier != null && (trailer = this.trailerSupplier.get(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, this, e)) != null) {
                this.addEntry(start, trailer);
            }
            this.addEntry(start, entry);
        }
        this.tabNameUpdate.run();
        this.m_93410_(this.m_93517_());
    }

    @FunctionalInterface
    public static interface EntrySupplier<E extends StringSupplier> {
        public Entry.ListEntry get(int var1, int var2, int var3, FilterList<?> var4, E var5, int var6);
    }

    @FunctionalInterface
    public static interface TrailerSupplier<E extends StringSupplier> {
        @Nullable
        public Entry.ListEntryTrailer get(int var1, int var2, int var3, FilterList<?> var4, E var5);
    }

    public static abstract class Entry
    extends OptionList.Entry {

        public static class NotifOptions
        extends ListEntry {
            public NotifOptions(int x, int width, int height, FilterList<?> list, Notification notif, int index) {
                TextField triggerField;
                int minFieldWidth;
                Minecraft mc = Minecraft.m_91087_();
                Trigger trigger = notif.triggers.size() == 1 ? notif.triggers.get(0) : null;
                boolean singleTrig = trigger != null;
                int statusButtonWidth = 24;
                int soundFieldWidth = minFieldWidth = mc.f_91062_.m_92895_("#FFAAFF++");
                int soundFieldWidthMax = mc.f_91062_.m_92895_("block.note_block.chime++");
                boolean showColorField = false;
                boolean showColorFieldNominal = notif.textStyle.doColor;
                boolean showSoundField = false;
                boolean showSoundFieldNominal = notif.sound.isEnabled();
                int triggerWidth = width - 2 - list.smallWidgetWidth - 2 - list.tinyWidgetWidth - 2 - list.tinyWidgetWidth - 2 - statusButtonWidth;
                int triggerWidthNominalMin = 220;
                int excess = triggerWidth - triggerWidthNominalMin;
                if (excess > minFieldWidth && showSoundFieldNominal) {
                    showSoundField = true;
                    triggerWidth -= soundFieldWidth;
                }
                if ((excess = triggerWidth - triggerWidthNominalMin) > minFieldWidth && showColorFieldNominal) {
                    showColorField = true;
                    triggerWidth -= minFieldWidth;
                }
                if (showSoundField) {
                    excess = triggerWidth - triggerWidthNominalMin;
                    triggerWidth -= excess;
                    int soundBonus = (int)((double)excess * 0.7);
                    int soundMargin = Math.max(0, soundFieldWidth + soundBonus - 100);
                    soundBonus -= (int)((double)soundMargin * 0.5);
                    soundMargin = Math.max(0, soundFieldWidth + soundBonus - soundFieldWidthMax);
                    soundFieldWidth += (soundBonus -= soundMargin);
                    triggerWidth += excess - soundBonus;
                }
                int triggerFieldWidth = triggerWidth;
                if (singleTrig) {
                    triggerFieldWidth -= list.tinyWidgetWidth * 2;
                }
                int movingX = x;
                if (index != 0) {
                    Button indicatorButton = Button.m_253074_((Component)Component.m_237113_((String)String.valueOf(index + 1)), button -> {}).m_252794_(x - list.smallWidgetWidth - 4 - list.tinyWidgetWidth, 0).m_253046_(list.tinyWidgetWidth, height).m_253136_();
                    indicatorButton.f_93623_ = false;
                    this.elements.add(indicatorButton);
                    Button dragButton = Button.m_253074_((Component)Component.m_237113_((String)Unicode.UP_DOWN.str), button -> {
                        this.m_7897_(true);
                        list.startDragging(this, null, false);
                    }).m_252794_(x - list.smallWidgetWidth - 4, 0).m_253046_(list.smallWidgetWidth, height).m_253136_();
                    dragButton.f_93623_ = list.filterPattern == null;
                    this.elements.add(dragButton);
                }
                if (singleTrig) {
                    CycleButton typeButton = CycleButton.m_168894_(type -> Component.m_237113_((String)type.icon)).m_168961_((Object[])Trigger.Type.values()).m_168929_().m_168948_((Object)trigger.type).m_232498_(type -> Tooltip.m_257550_((Component)Localization.localized("option", "notif.trigger.type." + String.valueOf(type) + ".tooltip", new Object[0]))).m_168936_(movingX, 0, list.tinyWidgetWidth, height, (Component)Component.m_237119_(), (button, type) -> {
                        trigger.type = type;
                        list.init();
                    });
                    typeButton.m_257427_(200);
                    this.elements.add(typeButton);
                    Button editorButton = Button.m_253074_((Component)Component.m_237113_((String)Unicode.EDIT.str), button -> {
                        notif.editing = true;
                        mc.m_91152_((Screen)new TriggerScreen(mc.f_91080_, trigger, notif.textStyle, () -> {
                            notif.editing = false;
                        }, TriggerScreen.TabKey.TRIGGER_EDITOR.key));
                    }).m_252794_(movingX += list.tinyWidgetWidth, 0).m_253046_(list.tinyWidgetWidth, height).m_253136_();
                    editorButton.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "notif.trigger.open.trigger_editor.tooltip", new Object[0])));
                    editorButton.m_257427_(200);
                    this.elements.add(editorButton);
                    movingX += list.tinyWidgetWidth;
                }
                if (singleTrig) {
                    triggerField = new TextField(movingX, 0, triggerFieldWidth, height);
                    if (trigger.type == Trigger.Type.REGEX) {
                        triggerField.regexValidator();
                    }
                    triggerField.withValidator(new TextField.Validator.UniqueTrigger(notif, trigger));
                    triggerField.m_94199_(240);
                    triggerField.m_94151_(str -> {
                        trigger.string = str.strip();
                    });
                    triggerField.m_94144_(trigger.string);
                    triggerField.m_257771_((Component)Localization.localized("option", "notif.trigger.field.hint", new Object[0]));
                } else {
                    triggerField = new FakeTextField(movingX, 0, triggerFieldWidth, height, () -> mc.m_91152_((Screen)new NotifScreen(mc.f_91080_, notif)));
                    triggerField.m_94199_(240);
                    triggerField.m_94144_(NotifOptions.createLabel(notif, triggerFieldWidth - 10).getString());
                }
                this.elements.add(triggerField);
                ImageButton editButton = new ImageButton(movingX += triggerFieldWidth + 2, 0, list.smallWidgetWidth, height, 0, 0, 20, OPTIONS_ICON, 32, 64, button -> mc.m_91152_((Screen)new NotifScreen(mc.f_91080_, notif)));
                editButton.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "notif.open.options.tooltip", new Object[0])));
                editButton.m_257427_(200);
                this.elements.add(editButton);
                RightClickableButton colorEditButton = new RightClickableButton(movingX += list.smallWidgetWidth + 2, 0, list.tinyWidgetWidth, height, (Component)Component.m_237113_((String)Unicode.PAINT.str).m_130948_(Style.f_131099_.m_178520_(notif.textStyle.doColor ? notif.textStyle.color : 0xFFFFFF)), button -> {
                    int cpHeight = 80;
                    int cpWidth = 200;
                    list.screen.setOverlayWidget(new HsvColorPicker(x + width / 2 - cpWidth / 2, list.screen.f_96544_ / 2 - cpHeight / 2, cpWidth, cpHeight, () -> notif.textStyle.color, color -> {
                        notif.textStyle.color = color;
                    }, widget -> list.init()));
                }, button -> {
                    notif.textStyle.doColor = !notif.textStyle.doColor;
                    list.init();
                });
                colorEditButton.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "notif.color.status.tooltip." + (notif.textStyle.doColor ? "enabled" : "disabled"), new Object[0]).m_130946_("\n").m_7220_((Component)Localization.localized("option", "notif.click_edit", new Object[0]))));
                colorEditButton.m_257427_(200);
                if (showColorField) {
                    TextField colorField = new TextField(movingX, 0, minFieldWidth, height);
                    colorField.hexColorValidator().strict();
                    colorField.m_94199_(7);
                    colorField.m_94151_(val -> {
                        TextColor textColor = TextColor.m_131268_((String)val);
                        if (textColor != null) {
                            int color;
                            notif.textStyle.color = color = textColor.m_131265_();
                            float[] hsv = new float[3];
                            Color.RGBtoHSB(FastColor.ARGB32.m_13665_((int)color), FastColor.ARGB32.m_13667_((int)color), FastColor.ARGB32.m_13669_((int)color), hsv);
                            if ((double)hsv[2] < 0.1) {
                                colorField.m_94202_(0xFFFFFF);
                            } else {
                                colorField.m_94202_(color);
                            }
                            colorEditButton.m_93666_((Component)colorEditButton.m_6035_().m_6881_().m_130948_(Style.f_131099_.m_178520_(color)));
                        }
                    });
                    colorField.m_94144_(((TextColorAccessor)TextColor.m_131266_((int)notif.textStyle.color)).chatnotify$formatValue());
                    colorField.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "notif.color.field.tooltip", new Object[0])));
                    colorField.m_257427_(500);
                    this.elements.add(colorField);
                    movingX += minFieldWidth;
                }
                colorEditButton.m_264152_(movingX, 0);
                this.elements.add(colorEditButton);
                movingX += list.tinyWidgetWidth + 2;
                if (showSoundField) {
                    TextField soundField = new TextField(movingX, 0, soundFieldWidth, height);
                    soundField.soundValidator();
                    soundField.m_94199_(240);
                    soundField.m_94151_(notif.sound::setId);
                    soundField.m_94144_(notif.sound.getId());
                    soundField.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "notif.sound.field.tooltip", new Object[0])));
                    soundField.m_257427_(500);
                    this.elements.add(soundField);
                    movingX += soundFieldWidth;
                }
                RightClickableButton soundEditButton = new RightClickableButton(movingX, 0, list.tinyWidgetWidth, height, (Component)Component.m_237113_((String)Unicode.SOUND.str).m_130940_(notif.sound.isEnabled() ? ChatFormatting.WHITE : ChatFormatting.RED), button -> mc.m_91152_((Screen)new NotifScreen(mc.f_91080_, notif, NotifScreen.TabKey.SOUND.key)), button -> {
                    notif.sound.setEnabled(!notif.sound.isEnabled());
                    list.init();
                });
                soundEditButton.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "notif.sound.status.tooltip." + (notif.sound.isEnabled() ? "enabled" : "disabled"), new Object[0]).m_130946_("\n").m_7220_((Component)Localization.localized("option", "notif.click_edit", new Object[0]))));
                soundEditButton.m_257427_(200);
                this.elements.add(soundEditButton);
                this.elements.add(CycleButton.m_168896_((Component)CommonComponents.f_130653_.m_6881_().m_130940_(ChatFormatting.GREEN), (Component)CommonComponents.f_130654_.m_6881_().m_130940_(ChatFormatting.RED)).m_168929_().m_168948_((Object)notif.enabled).m_168936_(x + width - statusButtonWidth, 0, statusButtonWidth, height, (Component)Component.m_237119_(), (button, status) -> {
                    notif.enabled = status;
                    list.refreshSubList();
                }));
                if (index != 0) {
                    this.elements.add(new ConfirmButton(x + width + 4, 0, list.smallWidgetWidth, height, (Component)Component.m_237113_((String)Unicode.CROSS.str), (Component)Component.m_237113_((String)Unicode.CROSS.str).m_130940_(ChatFormatting.RED), button -> {
                        if (Config.get().removeNotif(index)) {
                            list.init();
                        }
                    }));
                }
            }

            private static MutableComponent createLabel(Notification notif, int maxWidth) {
                MutableComponent label;
                Font font = Minecraft.m_91087_().f_91062_;
                String separator = ", ";
                String plusNumFormat = " [+%d]";
                Pattern plusNumPattern = Pattern.compile(" \\[\\+\\d+]");
                if (notif.triggers.isEmpty() || notif.triggers.get((int)0).string.isBlank()) {
                    label = Component.m_237113_((String)"> ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Localization.localized("option", "notif.label.configure", new Object[0]).m_130940_(ChatFormatting.WHITE)).m_130946_(" <");
                } else {
                    String str;
                    TreeSet<String> usedStrings = new TreeSet<String>();
                    ArrayList<String> strList = new ArrayList<String>();
                    int cap = 10;
                    int i = 0;
                    for (Trigger trig : notif.triggers) {
                        String str2 = StringUtil.m_14406_((String)trig.string);
                        if (!usedStrings.contains(str2)) {
                            strList.add((String)(i == 0 ? str2 : separator + str2));
                            usedStrings.add(str2);
                        }
                        if (++i < cap) continue;
                        break;
                    }
                    if (notif.triggers.size() > cap) {
                        strList.add(String.format(plusNumFormat, notif.triggers.size() - cap));
                    }
                    while (!(font.m_92895_(NotifOptions.compileLabel(strList)) <= maxWidth || strList.size() == 1 || strList.size() == 2 && plusNumPattern.matcher((CharSequence)strList.get(strList.size() - 1)).matches())) {
                        if (plusNumPattern.matcher((CharSequence)strList.remove(strList.size() - 1)).matches()) {
                            strList.remove(strList.size() - 1);
                        }
                        strList.add(String.format(plusNumFormat, usedStrings.size() - strList.size()));
                    }
                    while (font.m_92895_(NotifOptions.compileLabel(strList)) > maxWidth && (str = (String)strList.get(0)).length() >= 3) {
                        strList.set(0, str.substring(0, str.length() - 5) + " ...");
                    }
                    label = Component.m_237113_((String)NotifOptions.compileLabel(strList));
                    if (notif.textStyle.isEnabled()) {
                        label.m_130948_(Style.f_131099_.m_178520_(notif.textStyle.color));
                    }
                }
                return label;
            }

            private static String compileLabel(List<String> list) {
                StringBuilder builder = new StringBuilder();
                for (String s : list) {
                    builder.append(s);
                }
                return builder.toString();
            }

            public static class Locked
            extends NotifOptions {
                public Locked(int x, int width, int height, FilterList<?> list, Notification notif) {
                    super(x, width, height, list, notif, 0);
                }
            }
        }

        public static class ResponseOptions
        extends SpacedListEntry {
            public ResponseOptions(int x, int width, int height, FilterList<?> list, Response message, int index, Consumer<Integer> removeFunction) {
                int fieldSpacing = 1;
                int timeFieldWidth = Minecraft.m_91087_().f_91062_.m_92895_("00000");
                int msgFieldWidth = width - timeFieldWidth - list.tinyWidgetWidth - fieldSpacing * 2;
                int movingX = x;
                this.elements.add(Button.m_253074_((Component)Component.m_237113_((String)Unicode.UP_DOWN.str), button -> {
                    this.m_7897_(true);
                    list.startDragging(this, null, false);
                }).m_252794_(x - list.smallWidgetWidth - 4, 0).m_253046_(list.smallWidgetWidth, height).m_253136_());
                CycleButton typeButton = CycleButton.m_168894_(type -> Component.m_237113_((String)type.icon)).m_168961_((Object[])Response.Type.values()).m_168929_().m_168948_((Object)message.type).m_232498_(type -> Tooltip.m_257550_((Component)Localization.localized("option", "notif.response.type." + type.name() + ".tooltip", new Object[0]))).m_168936_(movingX, 0, list.tinyWidgetWidth, height, (Component)Component.m_237119_(), (button, type) -> {
                    message.type = type;
                    list.init();
                });
                typeButton.m_257427_(500);
                this.elements.add(typeButton);
                movingX += list.tinyWidgetWidth + fieldSpacing;
                if (message.type.equals((Object)Response.Type.COMMANDKEYS)) {
                    int keyFieldWidth = msgFieldWidth / 2;
                    List<String> keys = KeyAccessor.chatnotify$getNameMap().keySet().stream().sorted().toList();
                    FakeTextField keyField1 = new FakeTextField(movingX, 0, keyFieldWidth, height, () -> {
                        int wHeight = Math.max(40, ((FilterList)list).f_93389_);
                        int wWidth = Math.max(80, list.dynWideEntryWidth);
                        int wX = x + width / 2 - wWidth / 2;
                        int wY = ((FilterList)list).f_93390_;
                        list.screen.setOverlayWidget(new DropdownTextField(wX, wY, wWidth, wHeight, (Component)Component.m_237119_(), () -> message.string.matches(".+-.+") ? message.string.split("-")[0] : "", val -> {
                            message.string = val + "-" + (message.string.matches(".+-.+") ? message.string.split("-")[1] : "key.keyboard.unknown");
                        }, widget -> list.init(), keys));
                    });
                    MutableComponent label1 = Localization.localized("option", "notif.response.commandkeys.limit_key", new Object[0]);
                    keyField1.m_257771_((Component)label1.m_6881_());
                    keyField1.m_257544_(Tooltip.m_257550_((Component)label1.m_130946_("\n\n").m_7220_((Component)Localization.localized("option", "notif.response.commandkeys.limit_key.tooltip", new Object[0]))));
                    keyField1.m_94199_(240);
                    keyField1.withValidator(new TextField.Validator.InputKey(keys));
                    keyField1.m_94144_(message.string.matches(".+-.+") ? message.string.split("-")[0] : "");
                    this.elements.add(keyField1);
                    FakeTextField keyField2 = new FakeTextField(movingX += keyFieldWidth, 0, keyFieldWidth, height, () -> {
                        int wHeight = Math.max(40, ((FilterList)list).f_93389_);
                        int wWidth = Math.max(80, list.dynWideEntryWidth);
                        int wX = x + width / 2 - wWidth / 2;
                        int wY = ((FilterList)list).f_93390_;
                        list.screen.setOverlayWidget(new DropdownTextField(wX, wY, wWidth, wHeight, (Component)Component.m_237119_(), () -> message.string.matches(".+-.+") ? message.string.split("-")[1] : "", val -> {
                            message.string = message.string.matches(".+-.+") ? message.string.split("-")[0] + "-" + val : "key.keyboard.unknown";
                        }, widget -> list.init(), keys));
                    });
                    MutableComponent label2 = Localization.localized("option", "notif.response.commandkeys.key", new Object[0]);
                    keyField2.m_257771_((Component)label2.m_6881_());
                    keyField2.m_257544_(Tooltip.m_257550_((Component)label2.m_130946_("\n\n").m_7220_((Component)Localization.localized("option", "notif.response.commandkeys.key.tooltip", new Object[0]))));
                    keyField2.m_94199_(240);
                    keyField2.withValidator(new TextField.Validator.InputKey(keys));
                    keyField2.m_94144_(message.string.matches(".+-.+") ? message.string.split("-")[1] : "");
                    this.elements.add(keyField2);
                } else {
                    MultiLineTextField msgField = new MultiLineTextField(movingX, 0, msgFieldWidth, height * 2);
                    msgField.m_239313_(256);
                    msgField.m_240159_(message.string);
                    msgField.m_239273_(val -> {
                        message.string = val.strip();
                    });
                    this.elements.add(msgField);
                }
                TextField timeField = new TextField(x + width - timeFieldWidth, 0, timeFieldWidth, height);
                timeField.posIntValidator().strict();
                timeField.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "notif.response.time.tooltip", new Object[0])));
                timeField.m_257427_(500);
                timeField.m_94199_(5);
                timeField.m_94151_(s -> {
                    message.delayTicks = Integer.parseInt(s.strip());
                });
                timeField.m_94144_(String.valueOf(message.delayTicks));
                this.elements.add(timeField);
                this.elements.add(Button.m_253074_((Component)Component.m_237113_((String)Unicode.CROSS.str).m_130940_(ChatFormatting.RED), button -> {
                    removeFunction.accept(index);
                    list.init();
                }).m_252794_(x + width + 4, 0).m_253046_(list.smallWidgetWidth, height).m_253136_());
            }
        }

        public static class StyleTargetOptions
        extends ListEntryTrailer {
            public StyleTargetOptions(int x, int width, int height, FilterList<?> list, StyleTarget styleTarget) {
                int stringFieldWidth = width - list.tinyWidgetWidth * 4;
                int movingX = x + list.tinyWidgetWidth;
                StringWidget infoIcon = new StringWidget(movingX, 0, list.tinyWidgetWidth, height, (Component)Component.m_237113_((String)Unicode.INFO.str), Minecraft.m_91087_().f_91062_);
                infoIcon.m_267729_();
                infoIcon.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "notif.trigger.style_target.tooltip", new Object[0])));
                infoIcon.m_257427_(500);
                this.elements.add(infoIcon);
                CycleButton typeButton = CycleButton.m_168894_(type -> Component.m_237113_((String)type.icon)).m_168961_((Object[])StyleTarget.Type.values()).m_168929_().m_168948_((Object)styleTarget.type).m_232498_(type -> Tooltip.m_257550_((Component)Localization.localized("option", "notif.trigger.style_target.type." + String.valueOf(type) + ".tooltip", new Object[0]))).m_168936_(movingX += list.tinyWidgetWidth, 0, list.tinyWidgetWidth, height, (Component)Component.m_237119_(), (button, type) -> {
                    styleTarget.type = type;
                    list.init();
                });
                typeButton.m_257427_(500);
                this.elements.add(typeButton);
                TextField stringField = new TextField(movingX += list.tinyWidgetWidth, 0, stringFieldWidth, height);
                if (styleTarget.type == StyleTarget.Type.REGEX) {
                    stringField.regexValidator();
                }
                stringField.m_94199_(240);
                stringField.m_94144_(styleTarget.string);
                stringField.m_94151_(string -> {
                    styleTarget.string = string.strip();
                });
                stringField.m_257771_((Component)Localization.localized("option", "notif.trigger.style_target.field.hint", new Object[0]));
                this.elements.add(stringField);
                movingX = x + width - list.tinyWidgetWidth;
                this.elements.add(Button.m_253074_((Component)Component.m_237113_((String)Unicode.CROSS.str).m_130940_(ChatFormatting.RED), button -> {
                    styleTarget.enabled = false;
                    list.init();
                }).m_252794_(movingX, 0).m_253046_(list.tinyWidgetWidth, height).m_253136_());
            }
        }

        public static class LockedTriggerOptions
        extends ListEntry {
            public LockedTriggerOptions(int x, int width, int height, Trigger trigger, Component tooltip) {
                TextField displayField = new TextField(x, 0, width, height);
                displayField.m_94144_(trigger.string);
                displayField.m_257544_(Tooltip.m_257550_((Component)tooltip));
                displayField.m_257427_(500);
                displayField.m_94186_(false);
                displayField.f_93623_ = false;
                this.elements.add(displayField);
            }
        }

        public static class TriggerOptions
        extends ListEntry {
            public TriggerOptions(int x, int width, int height, FilterList<?> list, Trigger trigger, TextStyle textStyle, int index, Consumer<Integer> removeFunction, TextField.Validator validator, boolean canUseStyleTarget) {
                Minecraft mc = Minecraft.m_91087_();
                int triggerFieldWidth = width - list.tinyWidgetWidth * 2;
                if (canUseStyleTarget) {
                    triggerFieldWidth -= list.tinyWidgetWidth;
                }
                int movingX = x;
                Button indicatorButton = Button.m_253074_((Component)Component.m_237113_((String)String.valueOf(index + 1)), button -> {}).m_252794_(x - list.smallWidgetWidth - 4 - list.tinyWidgetWidth, 0).m_253046_(list.tinyWidgetWidth, height).m_253136_();
                indicatorButton.f_93623_ = false;
                this.elements.add(indicatorButton);
                Button dragButton = Button.m_253074_((Component)Component.m_237113_((String)Unicode.UP_DOWN.str), button -> {
                    this.m_7897_(true);
                    list.startDragging(this, StyleTargetOptions.class, trigger.styleTarget.enabled);
                }).m_252794_(x - list.smallWidgetWidth - 4, 0).m_253046_(list.smallWidgetWidth, height).m_253136_();
                dragButton.f_93623_ = list.filterPattern == null;
                this.elements.add(dragButton);
                CycleButton typeButton = CycleButton.m_168894_(type -> Component.m_237113_((String)type.icon)).m_168961_((Object[])Trigger.Type.values()).m_168929_().m_168948_((Object)trigger.type).m_232498_(type -> Tooltip.m_257550_((Component)Localization.localized("option", "notif.trigger.type." + String.valueOf(type) + ".tooltip", new Object[0]))).m_168936_(movingX, 0, list.tinyWidgetWidth, height, (Component)Component.m_237119_(), (button, type) -> {
                    trigger.type = type;
                    list.init();
                });
                typeButton.m_257427_(500);
                this.elements.add(typeButton);
                Button editorButton = Button.m_253074_((Component)Component.m_237113_((String)Unicode.EDIT.str), button -> mc.m_91152_((Screen)new TriggerScreen(mc.f_91080_, trigger, textStyle, () -> {}, TriggerScreen.TabKey.TRIGGER_EDITOR.key))).m_252794_(movingX += list.tinyWidgetWidth, 0).m_253046_(list.tinyWidgetWidth, height).m_253136_();
                editorButton.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "notif.trigger.open.trigger_editor.tooltip", new Object[0])));
                editorButton.m_257427_(500);
                this.elements.add(editorButton);
                TextField triggerField = new TextField(movingX += list.tinyWidgetWidth, 0, triggerFieldWidth, height);
                triggerField.withValidator(validator);
                if (trigger.type == Trigger.Type.REGEX) {
                    triggerField.regexValidator();
                }
                triggerField.m_94199_(240);
                triggerField.m_94151_(str -> {
                    trigger.string = str.strip();
                });
                triggerField.m_94144_(trigger.string);
                triggerField.m_257771_((Component)Localization.localized("option", "notif.trigger.field.hint", new Object[0]));
                this.elements.add(triggerField);
                movingX += triggerFieldWidth;
                if (canUseStyleTarget) {
                    Button styleButton = Button.m_253074_((Component)Component.m_237113_((String)"+"), button -> {
                        trigger.styleTarget.enabled = true;
                        list.init();
                    }).m_252794_(movingX, 0).m_253046_(list.tinyWidgetWidth, height).m_253136_();
                    if (!trigger.styleTarget.enabled) {
                        styleButton.m_257544_(Tooltip.m_257550_((Component)Localization.localized("option", "notif.trigger.style_target.add.tooltip", new Object[0])));
                        styleButton.m_257427_(500);
                    } else {
                        styleButton.f_93623_ = false;
                    }
                    this.elements.add(styleButton);
                }
                this.elements.add(Button.m_253074_((Component)Component.m_237113_((String)Unicode.CROSS.str).m_130940_(ChatFormatting.RED), button -> {
                    removeFunction.accept(index);
                    list.init();
                }).m_252794_(x + width + 4, 0).m_253046_(list.smallWidgetWidth, height).m_253136_());
            }
        }

        public static abstract class ListEntryTrailer
        extends Entry {
        }

        public static abstract class SpacedListEntry
        extends ListEntry {
        }

        public static abstract class ListEntry
        extends Entry {
        }

        private static class ListHeader
        extends Entry {
            ListHeader(int x, int width, int height, FilterList<?> list) {
                boolean hasStatus = list.statusSupplier != null && list.statusConsumer != null;
                int cappedWidth = Math.min(width, 320);
                if (cappedWidth < width) {
                    x += (width - cappedWidth) / 2;
                    width = cappedWidth;
                }
                int titleWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)list.title) + 8;
                int statusButtonWidth = 25;
                int searchFieldMinWidth = 50;
                int searchFieldWidth = width - titleWidth - 4;
                if (hasStatus) {
                    searchFieldWidth -= statusButtonWidth + 4;
                }
                if (searchFieldWidth < searchFieldMinWidth) {
                    int diff = searchFieldMinWidth - searchFieldWidth;
                    searchFieldWidth += diff;
                    titleWidth -= diff;
                }
                int movingX = x;
                StringWidget titleWidget = new StringWidget(movingX, 0, titleWidth, height, list.title, list.mc.f_91062_);
                titleWidget.m_257544_(Tooltip.m_257550_((Component)list.titleTooltip));
                this.elements.add(titleWidget);
                movingX += titleWidth + 4;
                if (hasStatus) {
                    this.elements.add(CycleButton.m_168896_((Component)CommonComponents.f_130653_.m_6881_().m_130940_(ChatFormatting.GREEN), (Component)CommonComponents.f_130654_.m_6881_().m_130940_(ChatFormatting.RED)).m_168929_().m_168948_((Object)list.statusSupplier.get()).m_168936_(movingX, 0, statusButtonWidth, height, (Component)Component.m_237119_(), (button, status) -> {
                        list.statusConsumer.accept((Boolean)status);
                        list.tabNameUpdate.run();
                    }));
                    movingX += statusButtonWidth + 4;
                }
                TextField searchField = new TextField(movingX, 0, searchFieldWidth, height);
                searchField.m_94199_(64);
                searchField.m_257771_((Component)Localization.localized("common", "search", new Object[0]));
                searchField.m_94144_(list.filterString);
                searchField.m_94151_(str -> {
                    list.filterString = str;
                    list.filterPattern = str.isBlank() ? null : Pattern.compile("(?iU)" + Pattern.quote(str));
                    list.refreshSubList();
                });
                this.elements.add(searchField);
            }
        }
    }
}

