/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget.list.root;

import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.gui.screen.OptionScreen;
import dev.terminalmc.chatnotify.gui.widget.HsvColorPicker;
import dev.terminalmc.chatnotify.gui.widget.field.DropdownTextField;
import dev.terminalmc.chatnotify.gui.widget.field.TextField;
import dev.terminalmc.chatnotify.gui.widget.list.OptionList;
import dev.terminalmc.chatnotify.mixin.accessor.TextColorAccessor;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.Unicode;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.SoundOptionsScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;

public class DefaultList
extends OptionList {
    public DefaultList(Minecraft mc, OptionScreen screen, int width, int height, int top, int bottom, int entryWidth, int entryHeight, int entrySpacing) {
        super(mc, screen, width, height, top, bottom, entryWidth, entryHeight, entrySpacing);
    }

    @Override
    protected void addEntries() {
        this.m_7085_((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (Component)Localization.localized("option", "default.list", Unicode.INFO.str), Tooltip.m_257550_((Component)Localization.localized("option", "default.list.tooltip", new Object[0])), -1));
        this.m_7085_((AbstractSelectionList.Entry)new Entry.DefaultColor(this.entryX, this.entryWidth, this.entryHeight, this));
        this.m_7085_((AbstractSelectionList.Entry)new Entry.DefaultSound(this.entryX, this.entryWidth, this.entryHeight, this));
        this.m_7085_((AbstractSelectionList.Entry)new OptionList.Entry.DoubleSlider(this.entryX, this.entryWidth, this.entryHeight, 0.0, 1.0, 2, Localization.localized("option", "notif.sound.volume", new Object[0]).getString(), null, CommonComponents.f_130654_.getString(), null, () -> Config.get().defaultSound.getVolume(), value -> Config.get().defaultSound.setVolume(value.floatValue())));
        this.m_7085_((AbstractSelectionList.Entry)new OptionList.Entry.DoubleSlider(this.entryX, this.entryWidth, this.entryHeight, 0.5, 2.0, 2, Localization.localized("option", "notif.sound.pitch", new Object[0]).getString(), null, null, null, () -> Config.get().defaultSound.getPitch(), value -> Config.get().defaultSound.setPitch(value.floatValue())));
        this.m_7085_((AbstractSelectionList.Entry)new Entry.SoundSource(this.entryX, this.entryWidth, this.entryHeight, this));
    }

    private static abstract class Entry
    extends OptionList.Entry {
        private Entry() {
        }

        private static class SoundSource
        extends Entry {
            SoundSource(int x, int width, int height, DefaultList list) {
                this.elements.add(CycleButton.m_168894_(source -> Component.m_237115_((String)("soundCategory." + source.m_12676_()))).m_168961_((Object[])net.minecraft.sounds.SoundSource.values()).m_168948_((Object)Config.get().soundSource).m_232498_(status -> Tooltip.m_257550_((Component)Localization.localized("option", "notif.sound.source.tooltip", new Object[0]))).m_168936_(x, 0, width - list.smallWidgetWidth - 4, height, (Component)Localization.localized("option", "notif.sound.source", new Object[0]), (button, status) -> {
                    Config.get().soundSource = status;
                }));
                this.elements.add(Button.m_253074_((Component)Component.m_237113_((String)Unicode.SOUND.str), button -> Minecraft.m_91087_().m_91152_((Screen)new SoundOptionsScreen((Screen)list.screen, Minecraft.m_91087_().f_91066_))).m_257505_(Tooltip.m_257550_((Component)Localization.localized("option", "notif.sound.open.minecraft_volume", new Object[0]))).m_252794_(x + width - list.smallWidgetWidth, 0).m_253046_(list.smallWidgetWidth, height).m_253136_());
            }
        }

        private static class DefaultSound
        extends Entry {
            DefaultSound(int x, int width, int height, DefaultList list) {
                this.elements.add(Button.m_253074_((Component)Localization.localized("option", "default.sound", Config.get().defaultSound.getId()), button -> {
                    int wHeight = Math.max(40, list.f_93389_);
                    int wWidth = Math.max(80, list.dynWideEntryWidth);
                    int wX = x + width / 2 - wWidth / 2;
                    int wY = list.f_93390_;
                    list.screen.setOverlayWidget(new DropdownTextField(wX, wY, wWidth, wHeight, (Component)Component.m_237119_(), Config.get().defaultSound::getId, Config.get().defaultSound::setId, widget -> list.init(), Minecraft.m_91087_().m_91106_().m_120354_().stream().map(ResourceLocation::toString).sorted().toList()).withSoundDropType());
                }).m_252794_(x, 0).m_253046_(width, height).m_253136_());
            }
        }

        private static class DefaultColor
        extends Entry {
            DefaultColor(int x, int width, int height, DefaultList list) {
                int colorFieldWidth = Minecraft.m_91087_().f_91062_.m_92895_("#FFAAFF+++");
                Button mainButton = Button.m_253074_((Component)Localization.localized("option", "default.color", new Object[0]).m_6270_(Style.f_131099_.m_178520_(Config.get().defaultColor)), button -> {
                    int cpHeight = 80;
                    int cpWidth = 200;
                    list.screen.setOverlayWidget(new HsvColorPicker(x + width / 2 - cpWidth / 2, ((DefaultList)list).screen.f_96544_ / 2 - cpHeight / 2, cpWidth, cpHeight, () -> Config.get().defaultColor, val -> {
                        Config.get().defaultColor = val;
                    }, widget -> list.init()));
                }).m_252794_(x, 0).m_253046_(width - colorFieldWidth - 4, height).m_253136_();
                this.elements.add(mainButton);
                TextField colorField = new TextField(x + width - colorFieldWidth, 0, colorFieldWidth, height);
                colorField.hexColorValidator().strict();
                colorField.m_94199_(7);
                colorField.m_94151_(val -> {
                    TextColor textColor = TextColor.m_131268_((String)val);
                    if (textColor != null) {
                        int color;
                        Config.get().defaultColor = color = textColor.m_131265_();
                        mainButton.m_93666_((Component)Localization.localized("option", "default.color", new Object[0]).m_6270_(Style.f_131099_.m_131148_(textColor)));
                        float[] hsv = new float[3];
                        Color.RGBtoHSB(FastColor.ARGB32.m_13665_((int)color), FastColor.ARGB32.m_13667_((int)color), FastColor.ARGB32.m_13669_((int)color), hsv);
                        if ((double)hsv[2] < 0.1) {
                            colorField.m_94202_(0xFFFFFF);
                        } else {
                            colorField.m_94202_(color);
                        }
                    }
                });
                colorField.m_94144_(((TextColorAccessor)TextColor.m_131266_((int)Config.get().defaultColor)).chatnotify$formatValue());
                this.elements.add(colorField);
            }
        }
    }
}

