/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget.list.root;

import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.gui.screen.OptionScreen;
import dev.terminalmc.chatnotify.gui.widget.field.TextField;
import dev.terminalmc.chatnotify.gui.widget.list.OptionList;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.Unicode;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class DetectionList
extends OptionList {
    public DetectionList(Minecraft mc, OptionScreen screen, int width, int height, int top, int bottom, int entryWidth, int entryHeight, int entrySpacing) {
        super(mc, screen, width, height, top, bottom, entryWidth, entryHeight, entrySpacing);
    }

    @Override
    protected void addEntries() {
        this.m_7085_((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (Component)Localization.localized("option", "detection.message", Unicode.INFO.str), Tooltip.m_257550_((Component)Localization.localized("option", "detection.message.tooltip", new Object[0])), -1));
        this.m_7085_((AbstractSelectionList.Entry)new Entry.ChatDetection(this.dynEntryX, this.dynEntryWidth, this.entryHeight));
        this.m_7085_((AbstractSelectionList.Entry)new Entry.ActionBarDetection(this.dynEntryX, this.dynEntryWidth, this.entryHeight));
        this.m_7085_((AbstractSelectionList.Entry)new Entry.TitleDetection(this.dynEntryX, this.dynEntryWidth, this.entryHeight));
        this.m_7085_((AbstractSelectionList.Entry)new Entry.SubtitleDetection(this.dynEntryX, this.dynEntryWidth, this.entryHeight));
        this.m_7085_((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (Component)Localization.localized("option", "detection.sender", Unicode.INFO.str), Tooltip.m_257550_((Component)Localization.localized("option", "detection.sender.tooltip", new Object[0])), -1));
        this.m_7085_((AbstractSelectionList.Entry)new Entry.SelfNotify(this.dynEntryX, this.dynEntryWidth, this.entryHeight));
        this.m_7085_((AbstractSelectionList.Entry)new Entry.SenderDetection(this.dynEntryX, this.dynEntryWidth, this.entryHeight));
        this.m_7085_((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (Component)Localization.localized("option", "detection.prefix.list", Unicode.INFO.str), Tooltip.m_257550_((Component)Localization.localized("option", "detection.prefix.list.tooltip", new Object[0])), -1));
        int max = Config.get().prefixes.size();
        for (int i = 0; i < max; ++i) {
            this.m_7085_((AbstractSelectionList.Entry)new Entry.PrefixFieldEntry(this.entryX, this.entryWidth, this.entryHeight, this, i));
        }
        this.m_7085_((AbstractSelectionList.Entry)new OptionList.Entry.ActionButton(this.entryX, this.entryWidth, this.entryHeight, (Component)Component.m_237113_((String)"+"), null, -1, button -> {
            Config.get().prefixes.add("");
            this.init();
        }));
    }

    private static abstract class Entry
    extends OptionList.Entry {
        private Entry() {
        }

        private static class PrefixFieldEntry
        extends Entry {
            PrefixFieldEntry(int x, int width, int height, DetectionList list, int index) {
                TextField prefixField = new TextField(x, 0, width, height);
                prefixField.m_94199_(30);
                prefixField.m_94151_(prefix -> Config.get().prefixes.set(index, prefix.strip()));
                prefixField.m_94144_(Config.get().prefixes.get(index));
                this.elements.add(prefixField);
                this.elements.add(Button.m_253074_((Component)Component.m_237113_((String)Unicode.CROSS.str).m_130940_(ChatFormatting.RED), button -> {
                    Config.get().prefixes.remove(index);
                    list.init();
                }).m_252794_(x + width + 4, 0).m_253046_(list.smallWidgetWidth, height).m_253136_());
            }
        }

        private static class SenderDetection
        extends Entry {
            SenderDetection(int x, int width, int height) {
                this.elements.add(CycleButton.m_168894_(status -> Localization.localized("option", "detection.sender.mode.status." + status.name(), new Object[0])).m_168961_((Object[])Config.SenderDetectionMode.values()).m_168948_((Object)Config.get().senderDetectionMode).m_232498_(mode -> Tooltip.m_257550_((Component)Localization.localized("option", "detection.sender.mode.status." + mode.name() + ".tooltip", new Object[0]))).m_168936_(x, 0, width, height, (Component)Localization.localized("option", "detection.sender.mode", new Object[0]), (button, status) -> {
                    Config.get().senderDetectionMode = status;
                }));
            }
        }

        private static class SelfNotify
        extends Entry {
            SelfNotify(int x, int width, int height) {
                this.elements.add(CycleButton.m_168896_((Component)CommonComponents.f_130653_.m_6881_().m_130940_(ChatFormatting.GREEN), (Component)CommonComponents.f_130654_.m_6881_().m_130940_(ChatFormatting.RED)).m_168948_((Object)Config.get().checkOwnMessages).m_232498_(status -> Tooltip.m_257550_((Component)Localization.localized("option", "detection.self_notify.tooltip", new Object[0]))).m_168936_(x, 0, width, height, (Component)Localization.localized("option", "detection.self_notify", new Object[0]), (button, status) -> {
                    Config.get().checkOwnMessages = status;
                }));
            }
        }

        private static class SubtitleDetection
        extends Entry {
            SubtitleDetection(int x, int width, int height) {
                this.elements.add(CycleButton.m_168894_(mode -> Localization.localized("option", "detection.message.common.mode.status." + mode.name(), new Object[0])).m_168961_((Object[])Config.CommonDetectionMode.values()).m_168948_((Object)Config.get().subtitleDetectionMode).m_232498_(status -> Tooltip.m_257550_((Component)Localization.localized("option", "detection.message.common.mode.status." + status.name() + ".tooltip", new Object[0]))).m_168936_(x, 0, width, height, (Component)Localization.localized("option", "detection.message.subtitle.mode", new Object[0]), (button, mode) -> {
                    Config.get().subtitleDetectionMode = mode;
                }));
            }
        }

        private static class TitleDetection
        extends Entry {
            TitleDetection(int x, int width, int height) {
                this.elements.add(CycleButton.m_168894_(mode -> Localization.localized("option", "detection.message.common.mode.status." + mode.name(), new Object[0])).m_168961_((Object[])Config.CommonDetectionMode.values()).m_168948_((Object)Config.get().titleDetectionMode).m_232498_(status -> Tooltip.m_257550_((Component)Localization.localized("option", "detection.message.common.mode.status." + status.name() + ".tooltip", new Object[0]))).m_168936_(x, 0, width, height, (Component)Localization.localized("option", "detection.message.title.mode", new Object[0]), (button, mode) -> {
                    Config.get().titleDetectionMode = mode;
                }));
            }
        }

        private static class ActionBarDetection
        extends Entry {
            ActionBarDetection(int x, int width, int height) {
                this.elements.add(CycleButton.m_168894_(mode -> Localization.localized("option", "detection.message.common.mode.status." + mode.name(), new Object[0])).m_168961_((Object[])Config.CommonDetectionMode.values()).m_168948_((Object)Config.get().actionBarDetectionMode).m_232498_(status -> Tooltip.m_257550_((Component)Localization.localized("option", "detection.message.common.mode.status." + status.name() + ".tooltip", new Object[0]))).m_168936_(x, 0, width, height, (Component)Localization.localized("option", "detection.message.action_bar.mode", new Object[0]), (button, mode) -> {
                    Config.get().actionBarDetectionMode = mode;
                }));
            }
        }

        private static class ChatDetection
        extends Entry {
            ChatDetection(int x, int width, int height) {
                this.elements.add(CycleButton.m_168894_(mode -> Localization.localized("option", "detection.message.chat.mode.status." + mode.name(), new Object[0])).m_168961_((Object[])Config.ChatDetectionMode.values()).m_168948_((Object)Config.get().detectionMode).m_232498_(status -> Tooltip.m_257550_((Component)Localization.localized("option", "detection.message.chat.mode.status." + status.name() + ".tooltip", new Object[0]))).m_168936_(x, 0, width, height, (Component)Localization.localized("option", "detection.message.chat.mode", new Object[0]), (button, mode) -> {
                    Config.get().detectionMode = mode;
                }));
            }
        }
    }
}

