/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget.list.root.notif;

import dev.terminalmc.chatnotify.config.Notification;
import dev.terminalmc.chatnotify.config.TextStyle;
import dev.terminalmc.chatnotify.gui.screen.OptionScreen;
import dev.terminalmc.chatnotify.gui.widget.HsvColorPicker;
import dev.terminalmc.chatnotify.gui.widget.field.TextField;
import dev.terminalmc.chatnotify.gui.widget.list.OptionList;
import dev.terminalmc.chatnotify.mixin.accessor.TextColorAccessor;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.Unicode;
import java.awt.Color;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FastColor;

public class FormatList
extends OptionList {
    private final Notification notif;

    public FormatList(Minecraft mc, OptionScreen screen, int width, int height, int top, int bottom, int entryWidth, int entryHeight, int entrySpacing, Notification notif) {
        super(mc, screen, width, height, top, bottom, entryWidth, entryHeight, entrySpacing);
        this.notif = notif;
    }

    @Override
    protected void addEntries() {
        this.m_7085_((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (Component)Localization.localized("option", "notif.format.list", Unicode.INFO.str), Tooltip.m_257550_((Component)Localization.localized("option", "notif.format.list.tooltip", new Object[0])), -1));
        this.m_7085_((AbstractSelectionList.Entry)new Entry.ColorOptions(this.entryX, this.entryWidth, this.entryHeight, this, () -> this.notif.textStyle.color, val -> {
            this.notif.textStyle.color = val;
        }, () -> this.notif.textStyle.doColor, val -> {
            this.notif.textStyle.doColor = val;
        }, Localization.localized("option", "notif.format.color", new Object[0])));
        this.m_7085_((AbstractSelectionList.Entry)new Entry.FormatOptions(this.entryX, this.entryWidth, this.entryHeight, this.notif, true));
        this.m_7085_((AbstractSelectionList.Entry)new Entry.FormatOptions(this.entryX, this.entryWidth, this.entryHeight, this.notif, false));
    }

    private void initList() {
        this.init();
    }

    static abstract class Entry
    extends OptionList.Entry {
        Entry() {
        }

        private static class FormatOptions
        extends Entry {
            private FormatOptions(int x, int width, int height, Notification notif, boolean first) {
                if (first) {
                    this.createFirst(x, width, height, notif);
                } else {
                    this.createSecond(x, width, height, notif);
                }
            }

            private void createFirst(int x, int width, int height, Notification notif) {
                int buttonWidth = (width - 8) / 3;
                CycleButton boldButton = CycleButton.m_168894_(state -> this.getMessage((TextStyle.FormatMode)((Object)state), ChatFormatting.BOLD)).m_168961_((Object[])TextStyle.FormatMode.values()).m_168948_((Object)notif.textStyle.bold).m_232498_(this::getTooltip).m_168936_(x, 0, buttonWidth, height, (Component)Localization.localized("option", "notif.format.bold", new Object[0]), (button, state) -> {
                    notif.textStyle.bold = state;
                });
                boldButton.m_257427_(500);
                this.elements.add(boldButton);
                CycleButton italicButton = CycleButton.m_168894_(state -> this.getMessage((TextStyle.FormatMode)((Object)state), ChatFormatting.ITALIC)).m_168961_((Object[])TextStyle.FormatMode.values()).m_168948_((Object)notif.textStyle.italic).m_232498_(this::getTooltip).m_168936_(x + width / 2 - buttonWidth / 2, 0, buttonWidth, height, (Component)Localization.localized("option", "notif.format.italic", new Object[0]), (button, state) -> {
                    notif.textStyle.italic = state;
                });
                italicButton.m_257427_(500);
                this.elements.add(italicButton);
                CycleButton underlineButton = CycleButton.m_168894_(state -> this.getMessage((TextStyle.FormatMode)((Object)state), ChatFormatting.UNDERLINE)).m_168961_((Object[])TextStyle.FormatMode.values()).m_168948_((Object)notif.textStyle.underlined).m_232498_(this::getTooltip).m_168936_(x + width - buttonWidth, 0, buttonWidth, height, (Component)Localization.localized("option", "notif.format.underline", new Object[0]), (button, state) -> {
                    notif.textStyle.underlined = state;
                });
                underlineButton.m_257427_(500);
                this.elements.add(underlineButton);
            }

            private void createSecond(int x, int width, int height, Notification notif) {
                int buttonWidth = (width - 4) / 2;
                CycleButton strikethroughButton = CycleButton.m_168894_(state -> this.getMessage((TextStyle.FormatMode)((Object)state), ChatFormatting.STRIKETHROUGH)).m_168961_((Object[])TextStyle.FormatMode.values()).m_168948_((Object)notif.textStyle.strikethrough).m_232498_(this::getTooltip).m_168936_(x, 0, buttonWidth, height, (Component)Localization.localized("option", "notif.format.strikethrough", new Object[0]), (button, state) -> {
                    notif.textStyle.strikethrough = state;
                });
                strikethroughButton.m_257427_(500);
                this.elements.add(strikethroughButton);
                CycleButton obfuscateButton = CycleButton.m_168894_(state -> this.getMessage((TextStyle.FormatMode)((Object)state), ChatFormatting.OBFUSCATED)).m_168961_((Object[])TextStyle.FormatMode.values()).m_168948_((Object)notif.textStyle.obfuscated).m_232498_(this::getTooltip).m_168936_(x + width - buttonWidth, 0, buttonWidth, height, (Component)Localization.localized("option", "notif.format.obfuscate", new Object[0]), (button, state) -> {
                    notif.textStyle.obfuscated = state;
                });
                obfuscateButton.m_257427_(500);
                this.elements.add(obfuscateButton);
            }

            private Component getMessage(TextStyle.FormatMode mode, ChatFormatting format) {
                return switch (mode) {
                    case TextStyle.FormatMode.ON -> CommonComponents.f_130653_.m_6881_().m_130940_(format).m_130940_(ChatFormatting.GREEN);
                    case TextStyle.FormatMode.OFF -> CommonComponents.f_130654_.m_6881_().m_130940_(ChatFormatting.RED);
                    default -> Component.m_237113_((String)"/").m_130940_(ChatFormatting.GRAY);
                };
            }

            private Tooltip getTooltip(TextStyle.FormatMode mode) {
                return mode.equals((Object)TextStyle.FormatMode.DISABLED) ? Tooltip.m_257550_((Component)Localization.localized("option", "notif.format.disabled.tooltip", new Object[0])) : null;
            }
        }

        private static class ColorOptions
        extends Entry {
            ColorOptions(int x, int width, int height, FormatList list, Supplier<Integer> supplier, Consumer<Integer> consumer, Supplier<Boolean> statusSupplier, Consumer<Boolean> statusConsumer, MutableComponent text) {
                int statusButtonWidth = Math.max(24, height);
                int colorFieldWidth = Minecraft.m_91087_().f_91062_.m_92895_("#FFAAFF+++");
                int mainButtonWidth = width - colorFieldWidth - statusButtonWidth - 8;
                Button mainButton = Button.m_253074_((Component)text.m_130948_(Style.f_131099_.m_178520_(supplier.get().intValue())), button -> {
                    int cpHeight = 80;
                    int cpWidth = 200;
                    list.getScreen().setOverlayWidget(new HsvColorPicker(x + width / 2 - cpWidth / 2, list.getScreen().f_96544_ / 2 - cpHeight / 2, cpWidth, cpHeight, supplier, consumer, widget -> list.initList()));
                }).m_252794_(x, 0).m_253046_(mainButtonWidth, height).m_253136_();
                this.elements.add(mainButton);
                TextField colorField = new TextField(x + mainButtonWidth + 4, 0, colorFieldWidth, height);
                colorField.hexColorValidator().strict();
                colorField.m_94199_(7);
                colorField.m_94151_(val -> {
                    TextColor textColor = TextColor.m_131268_((String)val);
                    if (textColor != null) {
                        int color = textColor.m_131265_();
                        consumer.accept(color);
                        mainButton.m_93666_((Component)mainButton.m_6035_().m_6881_().m_130948_(Style.f_131099_.m_178520_(color)));
                        float[] hsv = new float[3];
                        Color.RGBtoHSB(FastColor.ARGB32.m_13665_((int)color), FastColor.ARGB32.m_13667_((int)color), FastColor.ARGB32.m_13669_((int)color), hsv);
                        if ((double)hsv[2] < 0.1) {
                            colorField.m_94202_(0xFFFFFF);
                        } else {
                            colorField.m_94202_(color);
                        }
                    }
                });
                colorField.m_94144_(((TextColorAccessor)TextColor.m_131266_((int)supplier.get())).chatnotify$formatValue());
                this.elements.add(colorField);
                this.elements.add(CycleButton.m_168896_((Component)CommonComponents.f_130653_.m_6881_().m_130940_(ChatFormatting.GREEN), (Component)CommonComponents.f_130654_.m_6881_().m_130940_(ChatFormatting.RED)).m_168929_().m_168948_((Object)statusSupplier.get()).m_168936_(x + width - statusButtonWidth, 0, statusButtonWidth, height, (Component)Component.m_237119_(), (button, status) -> statusConsumer.accept((Boolean)status)));
            }
        }
    }
}

