/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_9017;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HorizontalList<E extends class_339>
extends class_9017 {
    private static final class_2960 LEFT_SEPARATOR = class_2960.method_60655((String)"chatnotify", (String)"textures/gui/left_separator.png");
    private static final class_2960 RIGHT_SEPARATOR = class_2960.method_60655((String)"chatnotify", (String)"textures/gui/right_separator.png");
    private static final class_2960 MENU_LIST_BACKGROUND = class_2960.method_60656((String)"textures/gui/menu_list_background.png");
    private static final class_2960 SCROLLER_SPRITE = class_2960.method_60655((String)"chatnotify", (String)"widget/scroller_horizontal");
    private static final class_2960 SCROLLER_BACKGROUND_SPRITE = class_2960.method_60655((String)"chatnotify", (String)"widget/scroller_background_horizontal");
    private static final int SCROLLBAR_WIDTH = 32;
    private static final int SCROLLBAR_HEIGHT = 6;
    private static final int MIN_WIDTH = 64;
    private static final int MIN_HEIGHT = 26;
    private final List<E> entries = new ArrayList();
    private final class_310 mc;
    private final int space;
    public Snap snap = Snap.BOTTOM;
    public boolean topScrollbar;
    private boolean scrolling;
    private double scrollAmount;
    @Nullable
    private E hovered;
    @Nullable
    private E selected;

    public HorizontalList(int x, int y, int width, int height, int spacing, boolean topScrollbar) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.space = spacing;
        this.mc = class_310.method_1551();
        this.topScrollbar = topScrollbar;
    }

    @Nullable
    public E getHovered() {
        return this.hovered;
    }

    private void updateHovered(double mouseX, double mouseY) {
        if (this.method_25405(mouseX, mouseY)) {
            for (class_339 e : this.entries) {
                if (!e.method_25405(mouseX, mouseY)) continue;
                this.hovered = e;
                return;
            }
        }
    }

    @Nullable
    public E getSelected() {
        return this.selected;
    }

    public void setSelected(@Nullable E selected) {
        if (!this.entries.contains(selected)) {
            throw new IllegalArgumentException("Specified entry is not present in the list.");
        }
        this.selected = selected;
    }

    public int numEntries() {
        return this.entries.size();
    }

    @NotNull
    public List<E> entries() {
        return Collections.unmodifiableList(this.entries);
    }

    public E getEntry(int index) {
        return (E)((class_339)this.entries.get(index));
    }

    public int addEntry(E entry) {
        this.entries.add(entry);
        return this.entries.size() - 1;
    }

    public boolean removeEntry(E entry) {
        boolean removed = this.entries.remove(entry);
        if (removed && entry == this.getSelected()) {
            this.setSelected(null);
        }
        return removed;
    }

    public void clearEntries() {
        this.entries.clear();
        this.setSelected(null);
    }

    public void method_25358(int width) {
        this.method_55445(width, this.method_25364());
    }

    public void method_53533(int height) {
        this.method_55445(this.method_25368(), height);
    }

    public void method_55445(int width, int height) {
        super.method_55445(Math.max(width, 64), Math.max(height, 26));
        this.clampScrollAmount();
    }

    public void setBounds(int width, int height, int x, int y) {
        this.method_55445(width, height);
        this.method_48229(x, y);
    }

    protected void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.renderListBackground(graphics);
        this.renderChildren(graphics, mouseX, mouseY, partialTick);
        this.renderScrollbar(graphics);
        this.renderSeparators(graphics);
        this.updateHovered(mouseX, mouseY);
    }

    protected void renderListBackground(class_332 graphics) {
        RenderSystem.enableBlend();
        graphics.method_25290(MENU_LIST_BACKGROUND, this.method_46426(), this.method_46427(), 0.0f, 0.0f, this.method_25368(), this.method_25364(), 32, 32);
        RenderSystem.disableBlend();
    }

    protected void renderChildren(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        graphics.method_44379(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443());
        int x = this.method_46426() - (int)this.scrollAmount;
        int topOffset = this.topScrollbar ? 6 : 0;
        int bottomOffset = this.topScrollbar ? 0 : 6;
        for (class_339 child : this.entries) {
            int y = switch (this.snap.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.method_46427() + topOffset;
                case 1 -> this.method_46427() + (this.method_25364() - child.method_25364()) / 2;
                case 2 -> this.method_46427() + this.method_25364() - child.method_25364() - bottomOffset;
            };
            child.method_48229(x, y);
            if (child.method_55442() > this.method_46426() && child.method_46426() < this.method_55442()) {
                child.method_25394(graphics, mouseX, mouseY, partialTick);
            }
            x += child.method_25368() + this.space;
        }
        graphics.method_44380();
    }

    protected void renderScrollbar(class_332 graphics) {
        if (this.scrollbarVisible()) {
            int y = this.getScrollbarPosition();
            int scrollerWidth = (int)((float)(this.method_25368() * this.method_25368()) / (float)this.getMaxPosition());
            scrollerWidth = class_3532.method_15340((int)scrollerWidth, (int)32, (int)this.method_25368());
            int scrollerPos = Math.max(this.method_46426(), (int)this.scrollAmount * (this.method_25368() - scrollerWidth) / this.getMaxScroll() + this.method_46426());
            RenderSystem.enableBlend();
            graphics.method_52706(SCROLLER_BACKGROUND_SPRITE, this.method_46426(), y, this.method_25368(), 6);
            graphics.method_52706(SCROLLER_SPRITE, scrollerPos, y, scrollerWidth, 6);
            RenderSystem.disableBlend();
        }
    }

    protected boolean scrollbarVisible() {
        return this.getMaxScroll() > 0;
    }

    protected void renderSeparators(class_332 guiGraphics) {
        RenderSystem.enableBlend();
        guiGraphics.method_25290(LEFT_SEPARATOR, this.method_46426() - 2, this.method_46427() - 1, 0.0f, 0.0f, 2, this.method_25364() + 2, 2, 32);
        guiGraphics.method_25290(RIGHT_SEPARATOR, this.method_55442(), this.method_46427() - 1, 0.0f, 0.0f, 2, this.method_25364() + 2, 2, 32);
        guiGraphics.method_25290(class_437.field_49895, this.method_46426() - 1, this.method_46427() - 2, 0.0f, 0.0f, this.method_25368() + 2, 2, 32, 2);
        guiGraphics.method_25290(class_437.field_49896, this.method_46426() - 1, this.method_55443(), 0.0f, 0.0f, this.method_25368() + 2, 2, 32, 2);
        RenderSystem.disableBlend();
    }

    public void method_25395(@Nullable class_364 focused) {
        super.method_25395(focused);
        int i = this.entries.indexOf((class_339)focused);
        if (i >= 0) {
            class_339 entry = (class_339)this.entries.get(i);
            this.setSelected(entry);
            if (this.mc.method_48186().method_48183()) {
                this.ensureVisible(entry);
            }
        }
    }

    protected void ensureVisible(E entry) {
        int leftHang = entry.method_46426() - this.method_46426();
        int rightHang = entry.method_55442() - this.method_55442();
        if (leftHang < 0) {
            this.scroll(leftHang);
        } else if (rightHang > 0) {
            this.scroll(rightHang);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.updateScrollingState(mouseX, mouseY, button);
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        return this.scrolling || super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0 && this.scrolling) {
            if (mouseX < (double)this.method_46426()) {
                this.setScrollAmount(0.0);
            } else if (mouseX > (double)this.method_55442()) {
                this.setScrollAmount(this.getMaxScroll());
            } else {
                double maxScroll = Math.max(1, this.getMaxScroll());
                int innerWidth = this.method_25368();
                int scrollerWidth = class_3532.method_15340((int)((int)((float)(innerWidth * innerWidth) / (float)this.getMaxPosition())), (int)32, (int)innerWidth);
                double multiplier = Math.max(1.0, maxScroll / (double)(innerWidth - scrollerWidth));
                this.setScrollAmount(this.scrollAmount + dragX * multiplier);
            }
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        int scrollMultiplier = 10;
        this.setScrollAmount(this.scrollAmount - scrollY * (double)scrollMultiplier);
        return true;
    }

    protected void updateScrollingState(double mouseX, double mouseY, int button) {
        this.scrolling = button == 0 && mouseY >= (double)this.getScrollbarPosition() && mouseY < (double)(this.getScrollbarPosition() + 6) && mouseX >= (double)this.method_46426() && mouseX < (double)this.method_55442();
    }

    protected int getScrollbarPosition() {
        return this.topScrollbar ? this.method_46427() : this.method_46427() + this.method_25364() - 6;
    }

    protected int getMaxPosition() {
        int pos = 0;
        for (class_339 e : this.entries) {
            pos += e.method_25368();
            pos += this.space;
        }
        return pos - this.space;
    }

    private void scroll(int scroll) {
        this.setScrollAmount(this.scrollAmount + (double)scroll);
    }

    public void setScrollAmount(double scroll) {
        this.setClampedScrollAmount(scroll);
    }

    public void clampScrollAmount() {
        this.setClampedScrollAmount(this.scrollAmount);
    }

    public void setClampedScrollAmount(double scroll) {
        this.scrollAmount = class_3532.method_15350((double)scroll, (double)0.0, (double)this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - this.method_25368());
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_6379.class_6380 method_37018() {
        if (this.method_25370()) {
            return class_6379.class_6380.field_33786;
        }
        return this.hovered != null ? class_6379.class_6380.field_33785 : class_6379.class_6380.field_33784;
    }

    public void method_47399(@NotNull class_6382 output) {
        E hovered = this.getHovered();
        if (hovered != null) {
            hovered.method_37020(output.method_37031());
            this.narrateListElementPosition(output, hovered);
        } else {
            class_339 focused = (class_339)this.method_25399();
            if (focused != null) {
                focused.method_37020(output.method_37031());
                this.narrateListElementPosition(output, focused);
            }
        }
        output.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.component_list.usage"));
    }

    protected void narrateListElementPosition(class_6382 output, E entry) {
        int index;
        if (this.entries.size() > 1 && (index = this.entries.indexOf(entry)) != -1) {
            output.method_37034(class_6381.field_33789, (class_2561)class_2561.method_43469((String)"narrator.position.list", (Object[])new Object[]{index + 1, this.entries.size()}));
        }
    }

    @NotNull
    public final List<E> method_25396() {
        return Collections.unmodifiableList(this.entries);
    }

    public static enum Snap {
        TOP,
        MIDDLE,
        BOTTOM;

    }
}

