/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget.list.root.notif;

import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.config.Sound;
import dev.terminalmc.chatnotify.gui.screen.OptionScreen;
import dev.terminalmc.chatnotify.gui.widget.SilentButton;
import dev.terminalmc.chatnotify.gui.widget.field.DropdownTextField;
import dev.terminalmc.chatnotify.gui.widget.field.FakeTextField;
import dev.terminalmc.chatnotify.gui.widget.field.TextField;
import dev.terminalmc.chatnotify.gui.widget.list.OptionList;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.Unicode;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_350;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_443;
import net.minecraft.class_5244;
import net.minecraft.class_5676;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public class SoundList
extends OptionList {
    public static final String[] NOTEBLOCK_SOUNDS = new String[]{"block.note_block.banjo", "block.note_block.bass", "block.note_block.basedrum", "block.note_block.bell", "block.note_block.bit", "block.note_block.chime", "block.note_block.cow_bell", "block.note_block.didgeridoo", "block.note_block.flute", "block.note_block.guitar", "block.note_block.harp", "block.note_block.hat", "block.note_block.iron_xylophone", "block.note_block.pling", "block.note_block.snare", "block.note_block.xylophone"};
    public static final String[] POWER_SOUNDS = new String[]{"block.beacon.activate", "block.beacon.deactivate", "block.beacon.power_select", "block.conduit.activate", "block.conduit.deactivate", "block.end_portal_frame.fill", "block.portal.travel", "block.portal.trigger", "entity.enderman.teleport", "item.trident.return", "entity.elder_guardian.curse", "entity.warden.sonic_boom", "entity.evoker.cast_spell", "entity.evoker.prepare_summon", "entity.evoker.prepare_attack", "entity.zombie_villager.converted"};
    public static final String[] EXPLOSION_SOUNDS = new String[]{"entity.tnt.primed", "entity.generic.explode", "entity.lightning_bolt.thunder", "item.firecharge.use", "block.fire.extinguish", "entity.firework_rocket.blast", "entity.firework_rocket.large_blast", "entity.firework_rocket.twinkle"};
    public static final String[] VILLAGER_SOUNDS = new String[]{"entity.villager.ambient", "entity.villager.yes", "entity.villager.no", "entity.villager.trade", "entity.pillager.ambient", "entity.vindicator.ambient", "entity.vindicator.celebrate", "entity.evoker.ambient"};
    public static final String[] MISC_SOUNDS = new String[]{"entity.arrow.hit_player", "block.bell.use", "block.amethyst_block.hit", "block.amethyst_cluster.place", "entity.allay.item_thrown", "entity.iron_golem.repair", "block.anvil.land", "item.shield.block", "item.shield.break", "entity.player.death", "entity.goat.screaming.prepare_ram", "ui.button.click"};
    private final Sound sound;
    @Nullable
    private class_1113 lastSound;

    public SoundList(class_310 mc, OptionScreen screen, int width, int height, int y, int entryWidth, int entryHeight, Sound sound) {
        super(mc, screen, width, height, y, entryWidth, entryHeight, 1);
        this.sound = sound;
    }

    @Override
    protected void addEntries() {
        this.method_25321((class_350.class_351)new Entry.SoundField(this.entryX, this.entryWidth, this.entryHeight, this.sound, this));
        this.method_25321((class_350.class_351)new OptionList.Entry.DoubleSlider(this.entryX, this.entryWidth, this.entryHeight, 0.0, 1.0, 2, Localization.localized("option", "notif.sound.volume", new Object[0]).getString(), null, class_5244.field_24333.getString(), null, () -> this.sound.getVolume(), value -> this.sound.setVolume(value.floatValue())));
        this.method_25321((class_350.class_351)new OptionList.Entry.DoubleSlider(this.entryX, this.entryWidth, this.entryHeight, 0.5, 2.0, 2, Localization.localized("option", "notif.sound.pitch", new Object[0]).getString(), null, null, null, () -> this.sound.getPitch(), value -> this.sound.setPitch(value.floatValue())));
        this.method_25321((class_350.class_351)new OptionList.Entry.SilentActionButton(this.entryX, this.entryWidth, this.entryHeight, (class_2561)class_2561.method_43470((String)"> ").method_27692(class_124.field_1054).method_10852((class_2561)Localization.localized("option", "notif.sound.test", new Object[0]).method_27692(class_124.field_1068)).method_27693(" <"), null, -1, button -> this.playNotifSound()));
        this.method_25321((class_350.class_351)new Entry.SoundSource(this.entryX, this.entryWidth, this.entryHeight, this));
        this.method_25321((class_350.class_351)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (class_2561)Localization.localized("sound", "group.noteblock", new Object[0]), null, -1));
        this.addSoundEntries(NOTEBLOCK_SOUNDS);
        this.method_25321((class_350.class_351)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (class_2561)Localization.localized("sound", "group.power", new Object[0]), null, -1));
        this.addSoundEntries(POWER_SOUNDS);
        this.method_25321((class_350.class_351)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (class_2561)Localization.localized("sound", "group.explosion", new Object[0]), null, -1));
        this.addSoundEntries(EXPLOSION_SOUNDS);
        this.method_25321((class_350.class_351)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (class_2561)Localization.localized("sound", "group.illager", new Object[0]), null, -1));
        this.addSoundEntries(VILLAGER_SOUNDS);
        this.method_25321((class_350.class_351)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (class_2561)Localization.localized("sound", "group.misc", new Object[0]), null, -1));
        this.addSoundEntries(MISC_SOUNDS);
    }

    private void addSoundEntries(String[] sounds) {
        for (int i = 0; i < sounds.length; ++i) {
            this.method_25321((class_350.class_351)new Entry.SoundOption(this.entryX, this.entryWidth, this.entryHeight, this, this.sound, sounds[i], i < sounds.length - 1 ? sounds[++i] : null));
        }
    }

    private void refreshSoundField() {
        OptionList.Entry entry = (OptionList.Entry)this.method_25326(0);
        if (entry instanceof Entry.SoundField) {
            Entry.SoundField soundField = (Entry.SoundField)entry;
            soundField.updateValue();
        }
    }

    private void playNotifSound() {
        class_2960 location = this.sound.getResourceLocation();
        if (location != null) {
            if (this.lastSound != null) {
                this.mc.method_1483().method_4870(this.lastSound);
            }
            this.lastSound = new class_1109(location, Config.get().soundSource, this.sound.getVolume(), this.sound.getPitch(), class_1113.method_43221(), false, 0, class_1113.class_1114.field_5478, 0.0, 0.0, 0.0, true);
            this.mc.method_1483().method_4873(this.lastSound);
        }
    }

    private static abstract class Entry
    extends OptionList.Entry {
        private Entry() {
        }

        private static class SoundOption
        extends Entry {
            SoundOption(int x, int width, int height, SoundList list, Sound sound, String soundId1, @Nullable String soundId2) {
                int buttonWidth = (width - 1) / 2;
                this.elements.add(new SilentButton(x, 0, buttonWidth, height, (class_2561)Localization.localized("sound", "id." + soundId1, new Object[0]), button -> {
                    sound.setId(soundId1);
                    list.refreshSoundField();
                    list.playNotifSound();
                }));
                if (soundId2 != null) {
                    this.elements.add(new SilentButton(x + width - buttonWidth, 0, buttonWidth, height, (class_2561)Localization.localized("sound", "id." + soundId2, new Object[0]), button -> {
                        sound.setId(soundId2);
                        list.refreshSoundField();
                        list.playNotifSound();
                    }));
                }
            }
        }

        private static class SoundSource
        extends Entry {
            SoundSource(int x, int width, int height, SoundList list) {
                int mainButtonWidth = width - list.smallWidgetWidth - 1;
                this.elements.add(class_5676.method_32606(source -> class_2561.method_43471((String)("soundCategory." + source.method_14840()))).method_32624((Object[])class_3419.values()).method_32619((Object)Config.get().soundSource).method_32618(status -> class_7919.method_47407((class_2561)Localization.localized("option", "notif.sound.source.tooltip", new Object[0]))).method_32617(x, 0, mainButtonWidth, height, (class_2561)Localization.localized("option", "notif.sound.source", new Object[0]), (button, status) -> {
                    Config.get().soundSource = status;
                }));
                this.elements.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)Unicode.SOUND.str), button -> class_310.method_1551().method_1507((class_437)new class_443((class_437)list.screen, class_310.method_1551().field_1690))).method_46436(class_7919.method_47407((class_2561)Localization.localized("option", "notif.sound.open.minecraft_volume.tooltip", new Object[0]))).method_46433(x + width - list.smallWidgetWidth, 0).method_46437(list.smallWidgetWidth, height).method_46431());
            }
        }

        private static class SoundField
        extends Entry {
            private final Sound sound;
            private final TextField soundField;

            SoundField(int x, int width, int height, Sound sound, SoundList list) {
                this.sound = sound;
                int statusButtonWidth = 25;
                int fieldWidth = width - statusButtonWidth - 2;
                this.soundField = new FakeTextField(x, 0, fieldWidth, height, () -> {
                    int wHeight = Math.max(40, list.field_22759);
                    int wWidth = Math.max(80, list.dynWideEntryWidth);
                    int wX = x + width / 2 - wWidth / 2;
                    int wY = list.method_46427();
                    list.screen.setOverlayWidget(new DropdownTextField(wX, wY, wWidth, wHeight, (class_2561)class_2561.method_43473(), sound::getId, sound::setId, widget -> list.init(), class_310.method_1551().method_1483().method_4864().stream().map(class_2960::toString).sorted().toList()).withSoundDropType());
                });
                this.soundField.soundValidator();
                this.soundField.method_1880(240);
                this.soundField.method_1852(sound.getId());
                this.elements.add(this.soundField);
                this.elements.add(class_5676.method_32607((class_2561)class_5244.field_24332.method_27661().method_27692(class_124.field_1060), (class_2561)class_5244.field_24333.method_27661().method_27692(class_124.field_1061)).method_32616().method_32619((Object)sound.isEnabled()).method_32617(x + width - statusButtonWidth, 0, statusButtonWidth, height, (class_2561)class_2561.method_43473(), (button, status) -> sound.setEnabled((boolean)status)));
            }

            public void updateValue() {
                this.soundField.method_1852(this.sound.getId());
            }
        }
    }
}

