/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget.list.root.notif.trigger;

import com.mojang.datafixers.util.Pair;
import dev.terminalmc.chatnotify.ChatNotify;
import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.config.StyleTarget;
import dev.terminalmc.chatnotify.config.TextStyle;
import dev.terminalmc.chatnotify.config.Trigger;
import dev.terminalmc.chatnotify.gui.screen.OptionScreen;
import dev.terminalmc.chatnotify.gui.widget.HsvColorPicker;
import dev.terminalmc.chatnotify.gui.widget.field.MultiLineTextField;
import dev.terminalmc.chatnotify.gui.widget.field.TextField;
import dev.terminalmc.chatnotify.gui.widget.list.OptionList;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.Unicode;
import dev.terminalmc.chatnotify.util.text.FormatUtil;
import dev.terminalmc.chatnotify.util.text.MessageUtil;
import dev.terminalmc.chatnotify.util.text.StyleUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5676;
import net.minecraft.class_7417;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import net.minecraft.class_7940;

public class TriggerEditorList
extends OptionList {
    private final Trigger trigger;
    private final TextStyle textStyle;
    private final List<class_2561> recentChat;
    private boolean filter;
    private boolean restyle;
    private MultiLineTextField textDisplayField;
    private String displayText = "";
    private TextField keyDisplayField;
    private String displayKey = "";

    public TriggerEditorList(class_310 mc, OptionScreen screen, int width, int height, int y, int entryWidth, int entryHeight, int entrySpacing, Trigger trigger, TextStyle textStyle) {
        super(mc, screen, width, height, y, entryWidth, entryHeight, entrySpacing);
        this.trigger = trigger;
        this.textStyle = textStyle;
        this.recentChat = ChatNotify.unmodifiedChat.stream().toList().reversed();
    }

    @Override
    protected void addEntries() {
        this.addSpacedEntry(new Entry.TriggerOptions(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight + this.field_22741, this, this.trigger));
        if (this.trigger.styleTarget.enabled) {
            this.method_25321((class_350.class_351)new Entry.StyleTargetOptions(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, this, this.trigger.styleTarget));
        }
        this.textDisplayField = new MultiLineTextField(this.dynWideEntryX, 0, this.dynWideEntryWidth, this.entryHeight, (class_2561)Localization.localized("option", "notif.trigger.editor.display.text.hint", new Object[0]));
        this.textDisplayField.method_44400(this.displayText);
        this.addSpacedEntry(new Entry.DisplayField(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight + this.field_22741, (class_339)this.textDisplayField, (class_2561)Localization.localized("option", "notif.trigger.editor.display.text", new Object[0])));
        this.keyDisplayField = new TextField(this.dynWideEntryX, 0, this.dynWideEntryWidth, this.entryHeight);
        this.keyDisplayField.method_1880(256);
        this.keyDisplayField.method_1852(this.displayKey);
        this.method_25321((class_350.class_351)new Entry.DisplayField(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, (class_339)this.keyDisplayField, (class_2561)Localization.localized("option", "notif.trigger.editor.display.key", new Object[0])));
        this.method_25321((class_350.class_351)new Entry.Controls(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, this));
        this.addChatMessages(this.recentChat);
    }

    private void setTextDisplayValue(String text) {
        this.displayText = text;
        this.textDisplayField.method_44400(this.displayText);
    }

    private void setKeyDisplayValue(String key) {
        this.displayKey = key;
        this.keyDisplayField.method_1852(this.displayKey);
    }

    private void addChatMessages(List<class_2561> recentChat) {
        boolean restyleAll = Config.get().restyleMode.equals((Object)Config.RestyleMode.ALL_INSTANCES);
        ArrayList<Pair> displayChat = new ArrayList<Pair>();
        for (class_2561 msg : recentChat) {
            boolean hit;
            class_5250 restyledMsg = msg.method_27661();
            Matcher matcher = null;
            String msgStr = FormatUtil.stripCodes(msg.getString());
            switch (this.trigger.type) {
                default: {
                    throw new MatchException(null, null);
                }
                case NORMAL: {
                    boolean bl;
                    matcher = MessageUtil.normalSearch(msgStr, this.trigger.string);
                    boolean bl2 = bl = matcher.find();
                    break;
                }
                case REGEX: {
                    boolean bl2;
                    boolean bl;
                    try {
                        matcher = Pattern.compile(this.trigger.string).matcher(msgStr);
                        bl2 = bl = matcher.find();
                    }
                    catch (PatternSyntaxException ignored) {
                        bl2 = bl = false;
                    }
                    break;
                }
                case KEY: {
                    boolean bl;
                    boolean bl2 = hit = (bl = MessageUtil.keySearch(msg, this.trigger.string));
                }
            }
            if (this.filter && !hit) continue;
            if (this.restyle && hit) {
                if (this.trigger.styleTarget.enabled) {
                    if (this.trigger.styleTarget.type == StyleTarget.Type.REGEX) {
                        this.trigger.styleTarget.tryCompilePattern();
                    } else if (this.trigger.styleTarget.type == StyleTarget.Type.CAPTURING) {
                        this.trigger.styleTarget.tryParseIndexes();
                    }
                }
                restyledMsg = StyleUtil.restyle(msg, msgStr, this.trigger, matcher, this.textStyle, restyleAll);
            }
            displayChat.add(new Pair((Object)msg, (Object)restyledMsg));
        }
        displayChat.forEach(pair -> {
            Entry.MessageEntry entry = new Entry.MessageEntry(this.dynWideEntryX, this.dynWideEntryWidth, this, (class_2561)pair.getFirst(), (class_2561)pair.getSecond());
            this.method_25321((class_350.class_351)entry);
            for (int requiredHeight = this.mc.field_1772.method_1713(((class_2561)pair.getFirst()).getString(), this.dynWideEntryWidth) - this.field_22741; requiredHeight > 0; requiredHeight -= this.field_22741) {
                OptionList.Entry.Space spaceEntry = new OptionList.Entry.Space(entry);
                this.method_25321((class_350.class_351)spaceEntry);
            }
        });
        if (!(this.method_25396().getLast() instanceof Entry.MessageEntry)) {
            this.method_25321((class_350.class_351)new OptionList.Entry.Text(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, (class_2561)Localization.localized("option", "notif.trigger.editor.recent_messages.none", new Object[0]), null, -1));
        }
    }

    static abstract class Entry
    extends OptionList.Entry {
        Entry() {
        }

        private static class MessageEntry
        extends Entry {
            private final TriggerEditorList list;
            private final class_2561 msg;

            MessageEntry(int x, int width, TriggerEditorList list, class_2561 msg, class_2561 restyledMsg) {
                this.list = list;
                this.msg = msg;
                class_7940 widget = new class_7940(x, 0, restyledMsg, class_310.method_1551().field_1772);
                widget.method_48984(width);
                this.elements.add(widget);
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                String string;
                this.list.setTextDisplayValue(FormatUtil.stripCodes(this.msg.getString()));
                class_7417 class_74172 = this.msg.method_10851();
                if (class_74172 instanceof class_2588) {
                    class_2588 tc = (class_2588)class_74172;
                    string = tc.method_11022();
                } else {
                    string = Localization.localized("option", "notif.trigger.editor.display.key.none", new Object[0]).getString();
                }
                this.list.setKeyDisplayValue(string);
                this.list.method_25307(0.0);
                return true;
            }
        }

        private static class DisplayField
        extends Entry {
            DisplayField(int x, int width, int height, class_339 widget, class_2561 label) {
                int labelWidth = 40;
                int fieldWidth = width - labelWidth - 4;
                class_4185 labelButton = class_4185.method_46430((class_2561)label, button -> {}).method_46433(x, 0).method_46437(labelWidth, height).method_46431();
                labelButton.field_22763 = false;
                this.elements.add(labelButton);
                widget.method_25358(fieldWidth);
                widget.method_53533(height);
                widget.method_46421(x + width - fieldWidth);
                this.elements.add(widget);
            }
        }

        private static class Controls
        extends Entry {
            Controls(int x, int width, int height, TriggerEditorList list) {
                int buttonWidth = (width - 8) / 3;
                int movingX = x;
                this.elements.add(class_5676.method_32607((class_2561)class_5244.field_24332.method_27661().method_27692(class_124.field_1060), (class_2561)class_5244.field_24333.method_27661().method_27692(class_124.field_1061)).method_32619((Object)list.filter).method_32617(movingX, 0, buttonWidth, height, (class_2561)Localization.localized("option", "notif.trigger.editor.filter", new Object[0]), (button, status) -> {
                    list.filter = status;
                    list.init();
                }));
                this.elements.add(class_5676.method_32607((class_2561)class_5244.field_24332.method_27661().method_27692(class_124.field_1060), (class_2561)class_5244.field_24333.method_27661().method_27692(class_124.field_1061)).method_32619((Object)list.restyle).method_32617(movingX += buttonWidth + 4, 0, buttonWidth, height, (class_2561)Localization.localized("option", "notif.trigger.editor.restyle", new Object[0]), (button, status) -> {
                    list.restyle = status;
                    list.init();
                }));
                movingX = x + width - buttonWidth;
                this.elements.add(class_4185.method_46430((class_2561)Localization.localized("option", "notif.format.color", new Object[0]).method_10862(class_2583.field_24360.method_36139(list.textStyle.color)), button -> {
                    int cpHeight = 80;
                    int cpWidth = 200;
                    list.screen.setOverlayWidget(new HsvColorPicker(x + width / 2 - cpWidth / 2, ((TriggerEditorList)list).screen.field_22790 / 2 - cpHeight / 2, cpWidth, cpHeight, () -> list.textStyle.color, val -> {
                        list.textStyle.color = val;
                    }, widget -> list.init()));
                }).method_46433(movingX, 0).method_46437(buttonWidth, height).method_46431());
            }
        }

        private static class StyleTargetOptions
        extends Entry {
            StyleTargetOptions(int x, int width, int height, TriggerEditorList list, StyleTarget styleTarget) {
                int stringFieldWidth = width - list.tinyWidgetWidth * 4;
                int movingX = x + list.tinyWidgetWidth;
                class_7842 infoIcon = new class_7842(movingX, 0, list.tinyWidgetWidth, height, (class_2561)class_2561.method_43470((String)Unicode.INFO.str), class_310.method_1551().field_1772);
                infoIcon.method_48597();
                infoIcon.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "notif.trigger.style_target.tooltip", new Object[0])));
                infoIcon.method_47402(Duration.ofMillis(500L));
                this.elements.add(infoIcon);
                class_5676 typeButton = class_5676.method_32606(type -> class_2561.method_43470((String)type.icon)).method_32624((Object[])StyleTarget.Type.values()).method_32616().method_32619((Object)styleTarget.type).method_32618(type -> class_7919.method_47407((class_2561)Localization.localized("option", "notif.trigger.style_target.type." + String.valueOf(type) + ".tooltip", new Object[0]))).method_32617(movingX += list.tinyWidgetWidth, 0, list.tinyWidgetWidth, height, (class_2561)class_2561.method_43473(), (button, type) -> {
                    styleTarget.type = type;
                    list.init();
                });
                typeButton.method_47402(Duration.ofMillis(500L));
                this.elements.add(typeButton);
                TextField stringField = new TextField(movingX += list.tinyWidgetWidth, 0, stringFieldWidth, height);
                if (styleTarget.type == StyleTarget.Type.REGEX) {
                    stringField.regexValidator();
                }
                stringField.method_1880(240);
                stringField.method_1852(styleTarget.string);
                stringField.method_1863(string -> {
                    styleTarget.string = string.strip();
                    list.method_25396().removeIf(entry -> entry instanceof MessageEntry || entry instanceof OptionList.Entry.Text || entry instanceof OptionList.Entry.Space && list.method_25396().indexOf(entry) > 4);
                    list.addChatMessages(list.recentChat);
                });
                stringField.method_47404((class_2561)Localization.localized("option", "notif.trigger.style_target.field.hint", new Object[0]));
                this.elements.add(stringField);
                movingX = x + width - list.tinyWidgetWidth;
                this.elements.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)Unicode.CROSS.str).method_27692(class_124.field_1061), button -> {
                    styleTarget.enabled = false;
                    list.init();
                }).method_46433(movingX, 0).method_46437(list.tinyWidgetWidth, height).method_46431());
            }
        }

        private static class TriggerOptions
        extends Entry {
            TriggerOptions(int x, int width, int height, TriggerEditorList list, Trigger trigger) {
                int triggerFieldWidth = width - list.tinyWidgetWidth * 2;
                int movingX = x;
                class_5676 typeButton = class_5676.method_32606(type -> class_2561.method_43470((String)type.icon)).method_32624((Object[])Trigger.Type.values()).method_32616().method_32619((Object)trigger.type).method_32618(type -> class_7919.method_47407((class_2561)Localization.localized("option", "notif.trigger.type." + String.valueOf(type) + ".tooltip", new Object[0]))).method_32617(movingX, 0, list.tinyWidgetWidth, height, (class_2561)class_2561.method_43473(), (button, type) -> {
                    trigger.type = type;
                    list.init();
                });
                typeButton.method_47402(Duration.ofMillis(500L));
                this.elements.add(typeButton);
                MultiLineTextField triggerField = new MultiLineTextField(movingX += list.tinyWidgetWidth, 0, triggerFieldWidth, height, (class_2561)Localization.localized("option", "notif.trigger.field.hint", new Object[0]));
                if (trigger.type == Trigger.Type.REGEX) {
                    triggerField.regexValidator();
                }
                triggerField.method_44401(str -> {
                    trigger.string = str.strip();
                    if (list.method_25396().size() > 4) {
                        list.method_25396().removeIf(entry -> entry instanceof MessageEntry || entry instanceof OptionList.Entry.Text || entry instanceof OptionList.Entry.Space && list.method_25396().indexOf(entry) > 4);
                        list.addChatMessages(list.recentChat);
                    }
                });
                triggerField.method_44400(trigger.string);
                this.elements.add(triggerField);
                class_4185 styleButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"+"), button -> {
                    trigger.styleTarget.enabled = true;
                    list.init();
                }).method_46433(movingX += triggerFieldWidth, 0).method_46437(list.tinyWidgetWidth, height).method_46431();
                if (!trigger.styleTarget.enabled) {
                    styleButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "notif.trigger.style_target.add.tooltip", new Object[0])));
                    styleButton.method_47402(Duration.ofMillis(500L));
                } else {
                    styleButton.field_22763 = false;
                }
                this.elements.add(styleButton);
            }
        }
    }
}

