/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.util.text;

import dev.terminalmc.chatnotify.ChatNotify;
import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.config.TextStyle;
import dev.terminalmc.chatnotify.config.Trigger;
import dev.terminalmc.chatnotify.util.text.FormatUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_8828;

public class StyleUtil {
    private static boolean debug = false;

    private StyleUtil() {
    }

    public static class_2561 restyle(class_2561 msg, String cleanStr, Trigger trig, Matcher matcher, TextStyle textStyle, boolean restyleAllInstances) {
        block22: {
            boolean bl = debug = Config.get().debugMode == Config.DebugMode.ALL;
            if (!textStyle.isEnabled()) {
                return msg;
            }
            try {
                msg = FormatUtil.convertToStyledLiteral(msg.method_27661());
                if (debug) {
                    ChatNotify.LOG.warn("Converting message prior to initiating restyle", new Object[0]);
                    ChatNotify.LOG.warn("Converted text:", new Object[0]);
                    ChatNotify.LOG.warn(msg.getString(), new Object[0]);
                    ChatNotify.LOG.warn("Converted tree:", new Object[0]);
                    ChatNotify.LOG.warn(msg.toString(), new Object[0]);
                }
                boolean restyled = false;
                if (trig.styleTarget.enabled && !trig.styleTarget.string.isBlank()) {
                    switch (trig.styleTarget.type) {
                        case NORMAL: {
                            Matcher m = StyleUtil.styleSearch(cleanStr, trig.styleTarget.string);
                            if (!m.find()) break;
                            restyled = true;
                            do {
                                msg = StyleUtil.restyleLeaves(msg, textStyle, m.start(), m.end());
                            } while (restyleAllInstances && m.find());
                            break;
                        }
                        case REGEX: {
                            Matcher m;
                            if (trig.styleTarget.pattern == null || !(m = trig.styleTarget.pattern.matcher(cleanStr)).find()) break;
                            restyled = true;
                            do {
                                msg = StyleUtil.restyleLeaves(msg, textStyle, m.start(), m.end());
                            } while (restyleAllInstances && m.find());
                            break;
                        }
                        case CAPTURING: {
                            if (trig.type != Trigger.Type.REGEX || matcher.groupCount() < 1) break;
                            for (int i = 1; i <= matcher.groupCount(); ++i) {
                                if (!trig.styleTarget.groupIndexes.contains(i)) continue;
                                restyled = true;
                                msg = StyleUtil.restyleLeaves(msg, textStyle, matcher.start(i), matcher.end(i));
                            }
                            break;
                        }
                    }
                }
                if (!restyled) {
                    if (debug) {
                        ChatNotify.LOG.warn("Style target '{}' (type {})", new Object[]{trig.styleTarget.string, trig.styleTarget.type});
                        ChatNotify.LOG.warn("Defaulting to trigger restyle", new Object[0]);
                    }
                    switch (trig.type) {
                        case NORMAL: {
                            do {
                                msg = StyleUtil.restyleLeaves(msg, textStyle, matcher.start() + matcher.group(1).length(), matcher.end() - matcher.group(2).length());
                            } while (restyleAllInstances && matcher.find());
                            break;
                        }
                        case REGEX: {
                            do {
                                msg = StyleUtil.restyleLeaves(msg, textStyle, matcher.start(), matcher.end());
                            } while (restyleAllInstances && matcher.find());
                            break;
                        }
                        case KEY: {
                            msg = StyleUtil.restyleRoot(msg, textStyle);
                        }
                    }
                }
            }
            catch (IllegalArgumentException e) {
                if (!debug) break block22;
                ChatNotify.LOG.warn("Restyle error", e);
            }
        }
        return msg;
    }

    public static Matcher styleSearch(String msg, String str) {
        return Pattern.compile("(?iU)" + Pattern.quote(str)).matcher(msg);
    }

    private static class_2561 restyleRoot(class_2561 msg, TextStyle style) {
        return msg.method_27661().method_10862(StyleUtil.applyStyle(msg.method_10866(), style));
    }

    private static class_2561 restyleLeaves(class_2561 msg, TextStyle style, int start, int end) {
        return StyleUtil.recursiveRestyle(msg.method_27661(), style, start, end, 0);
    }

    private static class_5250 recursiveRestyle(class_5250 msg, TextStyle style, int start, int end, int index) {
        if (debug) {
            ChatNotify.LOG.warn("recursiveRestyle('{}', {}, {}, {})", msg.getString(), start, end, index);
        }
        ArrayList oldSiblings = new ArrayList(msg.method_10855());
        msg.method_10855().clear();
        class_7417 class_74172 = msg.method_10851();
        if (class_74172 instanceof class_8828) {
            String str;
            class_8828 contents = (class_8828)class_74172;
            if (debug) {
                ChatNotify.LOG.warn("PlainTextContents", new Object[0]);
            }
            if (index + (str = contents.comp_737()).length() > start && index < end) {
                String part3;
                String part2;
                class_2583 oldStyle = msg.method_10866();
                msg = class_2561.method_43473().method_27696(oldStyle);
                int localStart = Math.max(0, start - index);
                int localEnd = Math.min(str.length(), end - index);
                String part1 = str.substring(0, localStart);
                if (!part1.isEmpty()) {
                    msg.method_10852((class_2561)class_2561.method_43470((String)part1));
                }
                if (!(part2 = str.substring(localStart, localEnd)).isEmpty()) {
                    msg.method_10852((class_2561)class_2561.method_43470((String)part2).method_27696(style.getStyle()));
                }
                if (!(part3 = str.substring(localEnd)).isEmpty()) {
                    msg.method_10852((class_2561)class_2561.method_43470((String)part3));
                }
            }
            index += str.length();
        } else {
            index += msg.getString().length();
        }
        List siblings = msg.method_10855();
        for (class_2561 sibling : oldSiblings) {
            String str = sibling.getString();
            if (index + str.length() >= start && index < end) {
                siblings.add(StyleUtil.recursiveRestyle(sibling.method_27661(), style, start, end, index));
            } else {
                siblings.add(sibling);
            }
            index += str.length();
        }
        return msg;
    }

    public static class_2561 styledSubstring(class_2561 msg, int start, int end) {
        return StyleUtil.recursiveStyledSubstring(msg.method_27661(), start, end, 0);
    }

    private static class_5250 recursiveStyledSubstring(class_5250 msg, int start, int end, int index) {
        if (debug) {
            ChatNotify.LOG.warn("recursiveStyledSubstring('{}', {}, {}, {})", msg.getString(), start, end, index);
        }
        ArrayList oldSiblings = new ArrayList(msg.method_10855());
        msg.method_10855().clear();
        class_7417 class_74172 = msg.method_10851();
        if (class_74172 instanceof class_8828) {
            class_8828 contents = (class_8828)class_74172;
            if (debug) {
                ChatNotify.LOG.warn("PlainTextContents", new Object[0]);
            }
            class_2583 oldStyle = msg.method_10866();
            msg = class_2561.method_43473().method_27696(oldStyle);
            String str = contents.comp_737();
            if (index + str.length() > start && index < end) {
                int localStart = Math.max(0, start - index);
                int localEnd = Math.min(str.length(), end - index);
                msg.method_10852((class_2561)class_2561.method_43470((String)str.substring(localStart, localEnd)));
            }
            index += str.length();
        } else {
            index += msg.getString().length();
        }
        List siblings = msg.method_10855();
        for (class_2561 sibling : oldSiblings) {
            String str = sibling.getString();
            if (index + str.length() >= start && index < end) {
                siblings.add(StyleUtil.recursiveStyledSubstring(sibling.method_27661(), start, end, index));
            }
            index += str.length();
        }
        return msg;
    }

    private static class_2583 applyStyle(class_2583 style, TextStyle textStyle) {
        if (!textStyle.bold.equals((Object)TextStyle.FormatMode.DISABLED)) {
            style = style.method_10982(Boolean.valueOf(textStyle.bold.equals((Object)TextStyle.FormatMode.ON)));
        }
        if (!textStyle.italic.equals((Object)TextStyle.FormatMode.DISABLED)) {
            style = style.method_10978(Boolean.valueOf(textStyle.italic.equals((Object)TextStyle.FormatMode.ON)));
        }
        if (!textStyle.underlined.equals((Object)TextStyle.FormatMode.DISABLED)) {
            style = style.method_30938(Boolean.valueOf(textStyle.underlined.equals((Object)TextStyle.FormatMode.ON)));
        }
        if (!textStyle.strikethrough.equals((Object)TextStyle.FormatMode.DISABLED)) {
            style = style.method_36140(Boolean.valueOf(textStyle.strikethrough.equals((Object)TextStyle.FormatMode.ON)));
        }
        if (!textStyle.obfuscated.equals((Object)TextStyle.FormatMode.DISABLED)) {
            style = style.method_36141(Boolean.valueOf(textStyle.obfuscated.equals((Object)TextStyle.FormatMode.ON)));
        }
        if (textStyle.doColor) {
            style = style.method_27703(textStyle.getTextColor());
        }
        return style;
    }
}

