/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.terminalmc.chatnotify.ChatNotify;
import dev.terminalmc.chatnotify.config.StyleTarget;
import dev.terminalmc.chatnotify.config.util.JsonUtil;
import dev.terminalmc.chatnotify.util.Unicode;
import dev.terminalmc.chatnotify.util.functional.StringSupplier;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Trigger
implements StringSupplier {
    public static final int VERSION = 4;
    public final int version = 4;
    @Nullable
    public transient Pattern pattern;
    public boolean enabled;
    public static final boolean enabledDefault = true;
    @NotNull
    public String string;
    @NotNull
    public static final String stringDefault = "";
    public final StyleTarget styleTarget;
    public static final Supplier<StyleTarget> styleTargetDefault = StyleTarget::new;
    public Type type;

    public Trigger() {
        this(stringDefault);
    }

    public Trigger(@NotNull String string) {
        this(true, string, styleTargetDefault.get(), Type.values()[0]);
    }

    Trigger(boolean enabled, @NotNull String string, StyleTarget styleTarget, Type type) {
        this.enabled = enabled;
        this.string = string;
        this.styleTarget = styleTarget;
        this.type = type;
    }

    @Override
    @NotNull
    public String getString() {
        return this.string;
    }

    public void tryCompilePattern() {
        try {
            this.pattern = Pattern.compile(this.string);
        }
        catch (PatternSyntaxException e) {
            ChatNotify.LOG.warn("ChatNotify: Error processing regex: " + String.valueOf(e), new Object[0]);
            this.pattern = null;
        }
    }

    Trigger validate() {
        if (this.type == Type.KEY) {
            this.string = this.string.toLowerCase(Locale.ROOT);
        }
        this.styleTarget.validate();
        if (this.styleTarget.string.isBlank()) {
            this.styleTarget.enabled = false;
        }
        return this;
    }

    public static enum Type {
        NORMAL("~"),
        REGEX(".*"),
        KEY(Unicode.KEY.str);

        public final String icon;

        private Type(String icon) {
            this.icon = icon;
        }
    }

    public static class Deserializer
    implements JsonDeserializer<Trigger> {
        public Trigger deserialize(JsonElement json, java.lang.reflect.Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
            StyleTarget styleTarget;
            JsonObject obj = json.getAsJsonObject();
            int version = obj.get("version").getAsInt();
            boolean silent = version != 4;
            boolean enabled = JsonUtil.getOrDefault(obj, "enabled", true, silent);
            String string = JsonUtil.getOrDefault(obj, "string", Trigger.stringDefault, silent);
            if (version < 4) {
                String styleString = JsonUtil.getOrDefault(obj, "styleString", Trigger.stringDefault, true);
                styleTarget = new StyleTarget(styleString);
            } else {
                styleTarget = JsonUtil.getOrDefault(ctx, obj, "styleTarget", StyleTarget.class, styleTargetDefault.get(), silent);
            }
            Type type = JsonUtil.getOrDefault(obj, "type", Type.class, Type.values()[0], silent);
            if (version < 3) {
                boolean isKey = JsonUtil.getOrDefault(obj, "isKey", false, true);
                boolean isRegex = JsonUtil.getOrDefault(obj, "isRegex", false, true);
                type = isKey ? Type.KEY : (isRegex ? Type.REGEX : Type.NORMAL);
            }
            return new Trigger(enabled, string, styleTarget, type).validate();
        }
    }
}

