/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HorizontalList<E extends class_339>
extends class_362
implements class_4068,
class_6379 {
    private static final int SCROLLBAR_WIDTH = 32;
    private static final int SCROLLBAR_HEIGHT = 6;
    private static final int MIN_WIDTH = 64;
    private static final int MIN_HEIGHT = 26;
    private final List<E> entries = new ArrayList();
    private final class_310 mc;
    private final int space;
    public Snap snap = Snap.BOTTOM;
    public boolean topScrollbar;
    private boolean scrolling;
    private double scrollAmount;
    @Nullable
    private E hovered;
    @Nullable
    private E selected;
    protected int x0;
    protected int x1;
    protected int y0;
    protected int y1;
    protected int width;
    protected int height;

    public HorizontalList(int x, int y, int width, int height, int spacing, boolean topScrollbar) {
        this.space = spacing;
        this.mc = class_310.method_1551();
        this.topScrollbar = topScrollbar;
        this.x0 = x;
        this.x1 = x + width;
        this.y0 = y;
        this.y1 = y + height;
        this.width = width;
        this.height = height;
    }

    @Nullable
    public E getHovered() {
        return this.hovered;
    }

    private void updateHovered(double mouseX, double mouseY) {
        if (this.method_25405(mouseX, mouseY)) {
            for (class_339 e : this.entries) {
                if (!e.method_25405(mouseX, mouseY)) continue;
                this.hovered = e;
                return;
            }
        }
    }

    @Nullable
    public E getSelected() {
        return this.selected;
    }

    public void setSelected(@Nullable E selected) {
        if (!this.entries.contains(selected)) {
            throw new IllegalArgumentException("Specified entry is not present in the list.");
        }
        this.selected = selected;
    }

    public int numEntries() {
        return this.entries.size();
    }

    @NotNull
    public List<E> entries() {
        return Collections.unmodifiableList(this.entries);
    }

    public E getEntry(int index) {
        return (E)((class_339)this.entries.get(index));
    }

    public int addEntry(E entry) {
        this.entries.add(entry);
        return this.entries.size() - 1;
    }

    public boolean removeEntry(E entry) {
        boolean removed = this.entries.remove(entry);
        if (removed && entry == this.getSelected()) {
            this.setSelected(null);
        }
        return removed;
    }

    public void clearEntries() {
        this.entries.clear();
        this.setSelected(null);
    }

    public int getX() {
        return this.x0;
    }

    public int getY() {
        return this.y0;
    }

    public int getRight() {
        return this.x1;
    }

    public int getBottom() {
        return this.y1;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    public void setHeight(int height) {
        this.setSize(this.getWidth(), height);
    }

    public void setSize(int width, int height) {
        this.width = Math.max(width, 64);
        this.height = Math.max(height, 26);
        this.x1 = this.x0 + width;
        this.y1 = this.y0 + height;
        this.clampScrollAmount();
    }

    public void setBounds(int width, int height, int x, int y) {
        this.setSize(width, height);
        this.setPosition(x, y);
    }

    public void setPosition(int x, int y) {
        this.x0 = x;
        this.x1 = x + this.width;
        this.y0 = y;
        this.y1 = y + this.height;
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.renderListBackground(graphics);
        this.renderChildren(graphics, mouseX, mouseY, partialTick);
        this.renderScrollbar(graphics);
        this.renderSeparators(graphics);
        this.updateHovered(mouseX, mouseY);
    }

    protected void renderListBackground(class_332 graphics) {
        graphics.method_51422(0.125f, 0.125f, 0.125f, 1.0f);
        graphics.method_25290(class_437.field_44669, this.x0, this.y0, (float)this.x1, (float)(this.y1 + (int)this.scrollAmount), this.x1 - this.x0, this.y1 - this.y0, 32, 32);
        graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void renderChildren(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        graphics.method_44379(this.getX(), this.getY(), this.getRight(), this.getBottom());
        int x = this.getX() - (int)this.scrollAmount;
        int topOffset = this.topScrollbar ? 6 : 0;
        int bottomOffset = this.topScrollbar ? 0 : 6;
        for (class_339 child : this.entries) {
            int y = switch (this.snap) {
                default -> throw new IncompatibleClassChangeError();
                case Snap.TOP -> this.getY() + topOffset;
                case Snap.MIDDLE -> this.getY() + (this.getHeight() - child.method_25364()) / 2;
                case Snap.BOTTOM -> this.getY() + this.getHeight() - child.method_25364() - bottomOffset;
            };
            child.method_48229(x, y);
            if (child.method_46426() + child.method_25368() > this.getX() && child.method_46426() < this.getRight()) {
                child.method_25394(graphics, mouseX, mouseY, partialTick);
            }
            x += child.method_25368() + this.space;
        }
        graphics.method_44380();
    }

    protected void renderScrollbar(class_332 graphics) {
        if (this.scrollbarVisible()) {
            int y = this.getScrollbarPosition();
            int scrollerWidth = (int)((float)(this.getWidth() * this.getWidth()) / (float)this.getMaxPosition());
            scrollerWidth = class_3532.method_15340((int)scrollerWidth, (int)32, (int)this.getWidth());
            int scrollerPos = Math.max(this.getX(), (int)this.scrollAmount * (this.getWidth() - scrollerWidth) / this.getMaxScroll() + this.getX());
            graphics.method_25294(this.getX(), y, this.getRight(), y + 6, -16777216);
            graphics.method_25294(scrollerPos, y, scrollerPos + scrollerWidth, y + 6, -8355712);
            graphics.method_25294(scrollerPos, y, scrollerPos + scrollerWidth - 1, y + 6 - 1, -4144960);
        }
    }

    protected boolean scrollbarVisible() {
        return this.getMaxScroll() > 0;
    }

    protected void renderSeparators(class_332 guiGraphics) {
        guiGraphics.method_51422(0.25f, 0.25f, 0.25f, 1.0f);
        guiGraphics.method_25290(class_437.field_44669, this.x0 - 2, 0, 0.0f, 0.0f, this.width, this.y0 - 2, 32, 32);
        guiGraphics.method_25290(class_437.field_44669, this.x0 - 2, this.y1 + 2, 0.0f, (float)this.y1, this.width, this.height - this.y1, 32, 32);
        guiGraphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.method_51740(class_1921.method_51785(), this.x0 - 2, this.y0 - 2, this.x1 + 2, this.y0 + 2, -16777216, 0, 0);
        guiGraphics.method_51740(class_1921.method_51785(), this.x0 - 2, this.y1 - 2, this.x1 + 2, this.y1 + 2, 0, -16777216, 0);
    }

    public void method_25395(@Nullable class_364 focused) {
        super.method_25395(focused);
        int i = this.entries.indexOf((class_339)focused);
        if (i >= 0) {
            class_339 entry = (class_339)this.entries.get(i);
            this.setSelected(entry);
            if (this.mc.method_48186().method_48183()) {
                this.ensureVisible(entry);
            }
        }
    }

    protected void ensureVisible(E entry) {
        int leftHang = entry.method_46426() - this.getX();
        int rightHang = entry.method_46426() + entry.method_25368() - this.getRight();
        if (leftHang < 0) {
            this.scroll(leftHang);
        } else if (rightHang > 0) {
            this.scroll(rightHang);
        }
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= (double)this.getX() && mouseY >= (double)this.getY() && mouseX < (double)this.getRight() && mouseY < (double)this.getBottom();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.updateScrollingState(mouseX, mouseY, button);
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        return this.scrolling || super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0 && this.scrolling) {
            if (mouseX < (double)this.getX()) {
                this.setScrollAmount(0.0);
            } else if (mouseX > (double)this.getRight()) {
                this.setScrollAmount(this.getMaxScroll());
            } else {
                double maxScroll = Math.max(1, this.getMaxScroll());
                int innerWidth = this.getWidth();
                int scrollerWidth = class_3532.method_15340((int)((int)((float)(innerWidth * innerWidth) / (float)this.getMaxPosition())), (int)32, (int)innerWidth);
                double multiplier = Math.max(1.0, maxScroll / (double)(innerWidth - scrollerWidth));
                this.setScrollAmount(this.scrollAmount + dragX * multiplier);
            }
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        int scrollMultiplier = 10;
        this.setScrollAmount(this.scrollAmount - delta * (double)scrollMultiplier);
        return true;
    }

    protected void updateScrollingState(double mouseX, double mouseY, int button) {
        this.scrolling = button == 0 && mouseY >= (double)this.getScrollbarPosition() && mouseY < (double)(this.getScrollbarPosition() + 6) && mouseX >= (double)this.getX() && mouseX < (double)this.getRight();
    }

    protected int getScrollbarPosition() {
        return this.topScrollbar ? this.getY() : this.getY() + this.getHeight() - 6;
    }

    protected int getMaxPosition() {
        int pos = 0;
        for (class_339 e : this.entries) {
            pos += e.method_25368();
            pos += this.space;
        }
        return pos - this.space;
    }

    private void scroll(int scroll) {
        this.setScrollAmount(this.scrollAmount + (double)scroll);
    }

    public void setScrollAmount(double scroll) {
        this.setClampedScrollAmount(scroll);
    }

    public void clampScrollAmount() {
        this.setClampedScrollAmount(this.scrollAmount);
    }

    public void setClampedScrollAmount(double scroll) {
        this.scrollAmount = class_3532.method_15350((double)scroll, (double)0.0, (double)this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - this.getWidth());
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_6379.class_6380 method_37018() {
        if (this.method_25370()) {
            return class_6379.class_6380.field_33786;
        }
        return this.hovered != null ? class_6379.class_6380.field_33785 : class_6379.class_6380.field_33784;
    }

    public void method_37020(@NotNull class_6382 output) {
        E hovered = this.getHovered();
        if (hovered != null) {
            hovered.method_37020(output.method_37031());
            this.narrateListElementPosition(output, hovered);
        } else {
            class_339 focused = (class_339)this.method_25399();
            if (focused != null) {
                focused.method_37020(output.method_37031());
                this.narrateListElementPosition(output, focused);
            }
        }
        output.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.component_list.usage"));
    }

    protected void narrateListElementPosition(class_6382 output, E entry) {
        int index;
        if (this.entries.size() > 1 && (index = this.entries.indexOf(entry)) != -1) {
            output.method_37034(class_6381.field_33789, (class_2561)class_2561.method_43469((String)"narrator.position.list", (Object[])new Object[]{index + 1, this.entries.size()}));
        }
    }

    @NotNull
    public final List<E> method_25396() {
        return Collections.unmodifiableList(this.entries);
    }

    public static enum Snap {
        TOP,
        MIDDLE,
        BOTTOM;

    }
}

