/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import org.jetbrains.annotations.NotNull;

public class ExpandingList
extends ContainerObjectSelectionList<Entry> {
    public static final int HIGHLIGHT_COLOR = -1770489736;
    public static final int SCROLLBAR_WIDTH = 6;
    public static final int VERTICAL_BUFFER = 6;
    protected final int maxHeight;
    protected final int entryWidth;
    protected final int entryHeight;
    protected final int entryX;
    public int highlightIndex = -1;

    public ExpandingList(int x, int y, int width, int maxHeight, int defaultEntryHeight, int entryHeight, int xMargin) {
        super(Minecraft.getInstance(), width, 0, y, defaultEntryHeight);
        super.setX(x);
        this.maxHeight = maxHeight;
        this.entryWidth = width - 6 - xMargin * 2;
        this.entryHeight = entryHeight;
        this.entryX = x + xMargin;
    }

    protected Entry getEntry(int index) {
        return (Entry)((Object)this.children().get(index));
    }

    public void ensureVisible(int index) {
        this.scrollToEntry((AbstractSelectionList.Entry)this.getEntry(index));
    }

    public boolean isEmpty() {
        return this.children().isEmpty();
    }

    public int size() {
        return this.children().size();
    }

    public AbstractWidget get(int index) {
        return this.getEntry(index).getWidget();
    }

    public void replaceWidgets(Iterable<AbstractWidget> widgets) {
        this.clearWidgets();
        widgets.forEach(this::addWidget);
        this.setHeight(Math.min(this.defaultEntryHeight * this.children().size() + 6, this.maxHeight));
    }

    public void clearWidgets() {
        this.children().clear();
        this.setHeight(0);
    }

    public void addWidget(AbstractWidget widget) {
        this.addEntry((AbstractSelectionList.Entry)new Entry(this.entryX, this.entryWidth, this.entryHeight, widget));
        this.setHeight(Math.min(this.defaultEntryHeight * this.children().size() + 6, this.maxHeight));
    }

    protected void renderItem(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta, Entry widget) {
        if (this.highlightIndex != -1 && widget == this.getEntry(this.highlightIndex)) {
            graphics.fill(widget.getX(), widget.getY(), widget.getX() + widget.getWidth(), widget.getY() + widget.getHeight(), -1770489736);
        }
        super.renderItem(graphics, mouseX, mouseY, delta, (AbstractSelectionList.Entry)widget);
    }

    public int getRowWidth() {
        return this.width;
    }

    protected int scrollBarX() {
        return this.getX() + this.width - 6;
    }

    public static class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        private final AbstractWidget widget;

        public Entry(int x, int width, int height, AbstractWidget widget) {
            widget.setX(x);
            widget.setY(0);
            widget.setWidth(width);
            widget.setHeight(height);
            this.widget = widget;
        }

        public AbstractWidget getWidget() {
            return this.widget;
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return List.of(this.widget);
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return List.of(this.widget);
        }

        public void renderContent(@NotNull GuiGraphics graphics, int mouseX, int mouseY, boolean hovered, float delta) {
            this.widget.setY(this.getContentY());
            this.widget.render(graphics, mouseX, mouseY, delta);
        }
    }
}

