/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget.list.root.notif;

import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.config.Notification;
import dev.terminalmc.chatnotify.gui.screen.OptionScreen;
import dev.terminalmc.chatnotify.gui.widget.field.TextField;
import dev.terminalmc.chatnotify.gui.widget.list.OptionList;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.Unicode;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class MiscOptionList
extends OptionList {
    private final Notification notif;

    public MiscOptionList(Minecraft mc, OptionScreen screen, int width, int height, int y, int entryWidth, int entryHeight, int entrySpacing, Notification notif) {
        super(mc, screen, width, height, y, entryWidth, entryHeight, entrySpacing);
        this.notif = notif;
    }

    @Override
    protected void addEntries() {
        Minecraft mc = Minecraft.getInstance();
        this.addEntry((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (Component)Localization.localized("option", "notif.misc.control", new Object[0]), null, -1));
        this.addEntry((AbstractSelectionList.Entry)new Entry.Controls(this.entryX, this.entryWidth, this.entryHeight, this.notif));
        this.addEntry((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (Component)Localization.localized("option", "notif.misc.msg", Unicode.INFO.str), Tooltip.create((Component)Localization.localized("option", "notif.misc.msg.tooltip.format_codes", new Object[0]).append("\n\n").append((Component)Localization.localized("option", "notif.misc.msg.tooltip.regex_groups", new Object[0]))), -1));
        this.addEntry((AbstractSelectionList.Entry)new Entry.CustomMessage(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, () -> this.notif.replacementMsg, str -> {
            this.notif.replacementMsg = str;
        }, () -> this.notif.replacementMsgEnabled, val -> {
            this.notif.replacementMsgEnabled = val;
        }, (Component)Localization.localized("option", "notif.misc.msg.replacement", new Object[0]), (Component)Localization.localized("option", "notif.misc.msg.replacement", new Object[0]).append(".\n").append((Component)Localization.localized("option", "notif.misc.msg.replacement.tooltip", new Object[0])).append("\n\n").append((Component)Localization.localized("option", "notif.misc.msg.tooltip.blank_hide", new Object[0]))));
        this.addEntry((AbstractSelectionList.Entry)new Entry.CustomMessage(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, () -> this.notif.statusBarMsg, str -> {
            this.notif.statusBarMsg = str;
        }, () -> this.notif.statusBarMsgEnabled, val -> {
            this.notif.statusBarMsgEnabled = val;
        }, (Component)Localization.localized("option", "notif.misc.msg.status_bar", new Object[0]), (Component)Localization.localized("option", "notif.misc.msg.status_bar", new Object[0]).append(".\n").append((Component)Localization.localized("option", "notif.misc.msg.status_bar.tooltip", new Object[0])).append("\n\n").append((Component)Localization.localized("option", "notif.misc.msg.tooltip.blank_original", new Object[0]))));
        this.addEntry((AbstractSelectionList.Entry)new Entry.CustomMessage(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, () -> this.notif.titleMsg, str -> {
            this.notif.titleMsg = str;
        }, () -> this.notif.titleMsgEnabled, val -> {
            this.notif.titleMsgEnabled = val;
        }, (Component)Localization.localized("option", "notif.misc.msg.title", new Object[0]), (Component)Localization.localized("option", "notif.misc.msg.title", new Object[0]).append(".\n").append((Component)Localization.localized("option", "notif.misc.msg.title.tooltip", new Object[0])).append("\n\n").append((Component)Localization.localized("option", "notif.misc.msg.tooltip.blank_original", new Object[0]))));
        this.addEntry((AbstractSelectionList.Entry)new Entry.CustomMessage(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, () -> this.notif.subtitleMsg, str -> {
            this.notif.subtitleMsg = str;
        }, () -> this.notif.subtitleMsgEnabled, val -> {
            this.notif.subtitleMsgEnabled = val;
        }, (Component)Localization.localized("option", "notif.misc.msg.subtitle", new Object[0]), (Component)Localization.localized("option", "notif.misc.msg.subtitle", new Object[0]).append(".\n").append((Component)Localization.localized("option", "notif.misc.msg.subtitle.tooltip", new Object[0])).append("\n\n").append((Component)Localization.localized("option", "notif.misc.msg.tooltip.blank_original", new Object[0]))));
        this.addEntry((AbstractSelectionList.Entry)new Entry.CustomMessage(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, () -> this.notif.toastMsg, str -> {
            this.notif.toastMsg = str;
        }, () -> this.notif.toastMsgEnabled, val -> {
            this.notif.toastMsgEnabled = val;
        }, (Component)Localization.localized("option", "notif.misc.msg.toast", new Object[0]), (Component)Localization.localized("option", "notif.misc.msg.toast", new Object[0]).append(".\n").append((Component)Localization.localized("option", "notif.misc.msg.toast.tooltip", new Object[0])).append("\n\n").append((Component)Localization.localized("option", "notif.misc.msg.tooltip.blank_original", new Object[0]))));
        this.addEntry((AbstractSelectionList.Entry)new Entry.CustomMessage(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, () -> this.notif.typedMsg, str -> {
            this.notif.typedMsg = str;
        }, () -> this.notif.typedMsgEnabled, val -> {
            this.notif.typedMsgEnabled = val;
        }, (Component)Localization.localized("option", "notif.misc.msg.typed", new Object[0]), (Component)Localization.localized("option", "notif.misc.msg.typed", new Object[0]).append(".\n").append((Component)Localization.localized("option", "notif.misc.msg.typed.tooltip", new Object[0])).append("\n\n").append((Component)Localization.localized("option", "notif.misc.msg.tooltip.blank_original", new Object[0]))));
        this.addEntry((AbstractSelectionList.Entry)new Entry.CustomMessage(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, () -> this.notif.clipboardMsg, str -> {
            this.notif.clipboardMsg = str;
        }, () -> this.notif.clipboardMsgEnabled, val -> {
            this.notif.clipboardMsgEnabled = val;
        }, (Component)Localization.localized("option", "notif.misc.msg.clipboard", new Object[0]), (Component)Localization.localized("option", "notif.misc.msg.clipboard", new Object[0]).append(".\n").append((Component)Localization.localized("option", "notif.misc.msg.clipboard.tooltip", new Object[0])).append("\n\n").append((Component)Localization.localized("option", "notif.misc.msg.tooltip.blank_original", new Object[0]))));
        Entry.CustomLabeledMessageReset.resetLabelWidth();
        Entry.CustomLabeledMessageReset.registerLabel((Component)Localization.localized("options", "notif.misc.timing.delay", new Object[0]));
        Entry.CustomLabeledMessageReset.registerLabel((Component)Localization.localized("option", "notif.misc.timing.title_fade_in", new Object[0]));
        Entry.CustomLabeledMessageReset.registerLabel((Component)Localization.localized("option", "notif.misc.timing.title_stay", new Object[0]));
        Entry.CustomLabeledMessageReset.registerLabel((Component)Localization.localized("option", "notif.misc.timing.title_fade_out", new Object[0]));
        Entry.CustomLabeledMessageReset.registerLabel((Component)Localization.localized("option", "notif.misc.timing.status_bar_stay", new Object[0]));
        Entry.CustomLabeledMessageReset.registerLabel((Component)Localization.localized("option", "notif.misc.timing.toast_stay", new Object[0]));
        this.addEntry((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (Component)Localization.localized("option", "notif.misc.timing", Unicode.INFO.str), Tooltip.create((Component)Localization.localized("option", "notif.misc.timing.tooltip", new Object[0])), -1));
        this.addEntry((AbstractSelectionList.Entry)new Entry.CustomCycler(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, () -> this.notif.soundSync, b -> {
            this.notif.soundSync = b;
        }, (Component)Localization.localized("option", "notif.misc.timing.sound_delay", new Object[0]), (Component)Localization.localized("option", "notif.misc.timing.sound_delay.tooltip.on", new Object[0]), (Component)Localization.localized("option", "notif.misc.timing.sound_delay.tooltip.off", new Object[0])));
        this.addEntry((AbstractSelectionList.Entry)new Entry.CustomLabeledMessageReset(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, () -> this.notif.delay, s -> {
            this.notif.delay = Integer.parseInt(s.strip());
        }, 0, (Component)Localization.localized("option", "notif.misc.timing.delay", new Object[0]), (Component)Localization.localized("option", "notif.misc.timing.delay", new Object[0]).append(".\n").append((Component)Localization.localized("option", "notif.misc.timing.delay.tooltip", new Object[0]))));
        this.addEntry((AbstractSelectionList.Entry)new Entry.CustomLabeledMessageReset(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, () -> this.notif.titleFadeIn, s -> {
            this.notif.titleFadeIn = Integer.parseInt(s.strip());
        }, 10, (Component)Localization.localized("option", "notif.misc.timing.title_fade_in", new Object[0]), (Component)Localization.localized("option", "notif.misc.timing.title_fade_in", new Object[0]).append(".\n").append((Component)Localization.localized("option", "notif.misc.timing.title_fade_in.tooltip", new Object[0]))));
        this.addEntry((AbstractSelectionList.Entry)new Entry.CustomLabeledMessageReset(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, () -> this.notif.titleStay, s -> {
            this.notif.titleStay = Integer.parseInt(s.strip());
        }, 70, (Component)Localization.localized("option", "notif.misc.timing.title_stay", new Object[0]), (Component)Localization.localized("option", "notif.misc.timing.title_stay", new Object[0]).append(".\n").append((Component)Localization.localized("option", "notif.misc.timing.title_stay.tooltip", new Object[0]))));
        this.addEntry((AbstractSelectionList.Entry)new Entry.CustomLabeledMessageReset(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, () -> this.notif.titleFadeOut, s -> {
            this.notif.titleFadeOut = Integer.parseInt(s.strip());
        }, 20, (Component)Localization.localized("option", "notif.misc.timing.title_fade_out", new Object[0]), (Component)Localization.localized("option", "notif.misc.timing.title_fade_out", new Object[0]).append(".\n").append((Component)Localization.localized("option", "notif.misc.timing.title_fade_out.tooltip", new Object[0]))));
        this.addEntry((AbstractSelectionList.Entry)new Entry.CustomLabeledMessageReset(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, () -> this.notif.statusBarStay, s -> {
            this.notif.statusBarStay = Integer.parseInt(s.strip());
        }, 60, (Component)Localization.localized("option", "notif.misc.timing.status_bar_stay", new Object[0]), (Component)Localization.localized("option", "notif.misc.timing.status_bar_stay", new Object[0]).append(".\n").append((Component)Localization.localized("option", "notif.misc.timing.status_bar_stay.tooltip", new Object[0]))));
        this.addEntry((AbstractSelectionList.Entry)new Entry.CustomLabeledMessageReset(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, () -> this.notif.toastStay, s -> {
            this.notif.toastStay = Integer.parseInt(s.strip());
        }, 100, (Component)Localization.localized("option", "notif.misc.timing.toast_stay", new Object[0]), (Component)Localization.localized("option", "notif.misc.timing.toast_stay", new Object[0]).append(".\n").append((Component)Localization.localized("option", "notif.misc.timing.toast_stay.tooltip", new Object[0]))));
        this.addEntry((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (Component)Localization.localized("option", "notif.misc.reset", new Object[0]), null, -1));
        this.addEntry((AbstractSelectionList.Entry)new OptionList.Entry.ActionButton(this.entryX, this.entryWidth, this.entryHeight, (Component)Localization.localized("option", "notif.misc.reset.button", new Object[0]), Tooltip.create((Component)Localization.localized("option", "notif.misc.reset.tooltip", new Object[0])), -1, button -> mc.setScreen((Screen)new ConfirmScreen(value -> {
            if (value) {
                Config.resetAndSave();
                mc.setScreen(null);
            } else {
                mc.setScreen((Screen)this.screen);
                this.init();
            }
        }, (Component)Localization.localized("option", "notif.misc.reset", new Object[0]), (Component)Localization.localized("option", "notif.misc.reset.confirm", new Object[0])))));
    }

    protected static abstract class Entry
    extends OptionList.Entry {
        protected Entry() {
        }

        private static class CustomCycler
        extends Entry {
            CustomCycler(int x, int width, int height, Supplier<Boolean> statusSupplier, Consumer<Boolean> statusConsumer, Component hint, Component tooltipOn, Component tooltipOff) {
                this.elements.add(CycleButton.booleanBuilder((Component)CommonComponents.OPTION_ON.copy().withStyle(ChatFormatting.GREEN), (Component)CommonComponents.OPTION_OFF.copy().withStyle(ChatFormatting.RED)).withInitialValue((Object)statusSupplier.get()).withTooltip(b -> b != false ? Tooltip.create((Component)tooltipOn) : Tooltip.create((Component)tooltipOff)).create(x, 0, width, height, (Component)hint.copy(), (btn, val) -> statusConsumer.accept((Boolean)val)));
            }
        }

        protected static class CustomLabeledMessageReset
        extends Entry {
            private static final double MAX_SIZE_RELATIVE = 0.7;
            private static int longestLabelWidth = 0;

            CustomLabeledMessageReset(int x, int width, int height, Supplier<Integer> textSupplier, Consumer<String> textConsumer, int defaultVal, Component hint, Component tooltip) {
                int statusButtonWidth = Math.max(24, height);
                int labelWidth = 0.7 < (double)longestLabelWidth / (double)width ? (int)Math.floor(0.7 * (double)width) : longestLabelWidth;
                int fieldWidth = width - statusButtonWidth - labelWidth - 8;
                MutableComponent labelText = hint.copy().append(": ");
                StringWidget label = new StringWidget(x, 0, labelWidth, height, (Component)labelText, Minecraft.getInstance().font);
                if ((double)Minecraft.getInstance().font.width(labelText.getString()) / (double)width > 0.7) {
                    label.setTooltip(Tooltip.create((Component)hint));
                }
                this.elements.add(label);
                TextField titleField = new TextField(x + labelWidth + 4, 0, fieldWidth, height);
                titleField.posIntValidator().strict();
                titleField.setMaxLength(256);
                titleField.setValue(textSupplier.get().toString());
                titleField.setResponder(textConsumer);
                titleField.setHint(hint);
                titleField.setTooltip(Tooltip.create((Component)tooltip));
                this.elements.add(titleField);
                this.elements.add(Button.builder((Component)Component.literal((String)Unicode.RESET.str), btn -> {
                    titleField.setValue(Integer.toString(defaultVal));
                    textConsumer.accept(Integer.toString(defaultVal));
                }).bounds(x + width - statusButtonWidth, 0, statusButtonWidth, height).build());
            }

            public static void registerLabel(Component text) {
                int width = Minecraft.getInstance().font.width(text.copy().append(": ").getString());
                if (width > longestLabelWidth) {
                    longestLabelWidth = width;
                }
            }

            public static void resetLabelWidth() {
                longestLabelWidth = 0;
            }
        }

        private static class CustomMessage
        extends Entry {
            CustomMessage(int x, int width, int height, Supplier<String> textSupplier, Consumer<String> textConsumer, Supplier<Boolean> statusSupplier, Consumer<Boolean> statusConsumer, Component hint, Component tooltip) {
                int statusButtonWidth = Math.max(24, height);
                int fieldWidth = width - statusButtonWidth - 4;
                TextField titleField = new TextField(x, 0, fieldWidth, height);
                titleField.setMaxLength(256);
                titleField.setValue(textSupplier.get());
                titleField.setResponder(textConsumer);
                titleField.setHint(hint);
                titleField.setTooltip(Tooltip.create((Component)tooltip));
                this.elements.add(titleField);
                this.elements.add(CycleButton.booleanBuilder((Component)CommonComponents.OPTION_ON.copy().withStyle(ChatFormatting.GREEN), (Component)CommonComponents.OPTION_OFF.copy().withStyle(ChatFormatting.RED)).displayOnlyValue().withInitialValue((Object)statusSupplier.get()).create(x + width - statusButtonWidth, 0, statusButtonWidth, height, (Component)Component.empty(), (button, status) -> statusConsumer.accept((Boolean)status)));
            }
        }

        private static class Controls
        extends Entry {
            Controls(int x, int width, int height, Notification notif) {
                this.elements.add(CycleButton.builder(status -> Localization.localized("option", "notif.misc.control.self_notify.status." + status.name(), new Object[0])).withValues((Object[])Notification.CheckOwnMode.values()).withInitialValue((Object)notif.checkOwnMode).withTooltip(status -> Tooltip.create((Component)Localization.localized("option", "notif.misc.control.self_notify.status." + status.name() + ".tooltip", new Object[0]))).create(x, 0, width, height, (Component)Localization.localized("option", "detection.self_notify", new Object[0]), (button, status) -> {
                    notif.checkOwnMode = status;
                }));
            }
        }
    }
}

