/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.util;

import dev.terminalmc.chatnotify.compat.commandkeys.CommandKeysWrapper;
import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.config.Response;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;

public class ResponseUtil {
    private static final List<ScheduledResponse> RESPONSES = new ArrayList<ScheduledResponse>();

    private ResponseUtil() {
    }

    public static void send(Response response, int totalDelay) {
        RESPONSES.add(new ScheduledResponse(response, totalDelay));
    }

    public static void clear() {
        RESPONSES.clear();
    }

    public static void tickResponses(Minecraft mc) {
        if (mc.getConnection() == null || !mc.getConnection().isAcceptingMessages()) {
            RESPONSES.clear();
            return;
        }
        ArrayList<String> sending = new ArrayList<String>();
        RESPONSES.removeIf(sr -> {
            if (sr.tick()) {
                Response res = sr.response;
                if (res.cooldown <= 0) {
                    res.cooldown = res.cooldownTicks;
                    if (res.sendingString != null && !res.sendingString.isBlank()) {
                        if (res.type.equals((Object)Response.Type.COMMANDKEYS)) {
                            CommandKeysWrapper.trySend(res.sendingString);
                        } else {
                            sending.add(res.sendingString);
                        }
                    }
                }
                return false;
            }
            return sr.canRemove();
        });
        ResponseUtil.sendMessages(sending, mc.getConnection());
    }

    private static void sendMessages(List<String> messages, ClientPacketListener connection) {
        if (messages.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        switch (Config.get().sendMode) {
            case SCREEN: {
                Object object;
                Screen oldScreen = mc.screen;
                if (!(mc.screen instanceof ChatScreen)) {
                    mc.setScreen((Screen)new ChatScreen("", false));
                }
                if ((object = mc.screen) instanceof ChatScreen) {
                    ChatScreen cs = (ChatScreen)object;
                    for (String msg : messages) {
                        cs.handleChatInput(msg, false);
                    }
                }
                mc.setScreen(oldScreen);
                break;
            }
            case PACKET: {
                for (String msg : messages) {
                    if (msg.startsWith("/")) {
                        connection.sendCommand(msg.substring(1));
                        continue;
                    }
                    connection.sendChat(msg);
                }
                break;
            }
        }
    }

    private static class ScheduledResponse {
        Response response;
        int ticks;
        boolean completed;

        ScheduledResponse(Response response, int delay) {
            this.response = response;
            this.ticks = delay;
            this.completed = false;
        }

        boolean tick() {
            --this.response.cooldown;
            if (--this.ticks <= 0 && !this.completed) {
                this.completed = true;
                return true;
            }
            return false;
        }

        boolean canRemove() {
            return this.completed && this.response.cooldown <= 0;
        }
    }
}

