/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget;

import com.mojang.blaze3d.platform.Window;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public abstract class OverlayWidget
extends AbstractWidget {
    private Consumer<OverlayWidget> close;
    public final boolean fixedSize;
    public final double nominalWidthRatio;
    public final double nominalHeightRatio;

    public OverlayWidget(int x, int y, int width, int height, boolean fixedSize, Component msg, Consumer<OverlayWidget> close) {
        super(x, y, width, height, msg);
        this.checkWidth(width);
        this.checkHeight(height);
        this.close = close;
        Window window = Minecraft.getInstance().getWindow();
        this.fixedSize = fixedSize;
        this.nominalWidthRatio = (double)width / (double)window.getGuiScaledWidth();
        this.nominalHeightRatio = (double)height / (double)window.getGuiScaledHeight();
    }

    public void addOnClose(Consumer<OverlayWidget> close) {
        Consumer<OverlayWidget> close2 = this.close;
        this.close = widget -> {
            close.accept((OverlayWidget)((Object)widget));
            close2.accept((OverlayWidget)((Object)widget));
        };
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return true;
    }

    protected abstract void init();

    public void onClose() {
        this.close.accept(this);
    }

    public abstract int getMinWidth();

    public abstract int getMaxWidth();

    public abstract int getMinHeight();

    public abstract int getMaxHeight();

    public int getNominalWidth(int screenWidth) {
        if (this.fixedSize) {
            return this.width;
        }
        return Math.min(Math.max(this.getMinWidth(), (int)((double)screenWidth * this.nominalWidthRatio)), this.getMaxWidth());
    }

    public int getNominalHeight(int screenHeight) {
        if (this.fixedSize) {
            return this.height;
        }
        return Math.min(Math.max(this.getMinHeight(), (int)((double)screenHeight * this.nominalHeightRatio)), this.getMaxHeight());
    }

    public void updateBounds(int screenWidth, int screenHeight) {
        super.setWidth(this.getNominalWidth(screenWidth));
        super.setHeight(this.getNominalHeight(screenHeight));
        super.setX(screenWidth / 2 - this.getWidth() / 2);
        super.setY(screenHeight / 2 - this.getHeight() / 2);
        this.init();
    }

    public void setPosition(int x, int y) {
        super.setPosition(x, y);
        this.init();
    }

    public void setX(int x) {
        super.setX(x);
        this.init();
    }

    public void setY(int y) {
        super.setY(y);
        this.init();
    }

    public void setSize(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
        this.init();
    }

    public void setWidth(int width) {
        super.setWidth(this.checkWidth(width));
        this.init();
    }

    public void setHeight(int height) {
        super.setHeight(this.checkHeight(height));
        this.init();
    }

    protected int checkWidth(int width) {
        if (width < this.getMinWidth()) {
            throw new IllegalArgumentException("Width cannot be less than " + this.getMinWidth() + ", got " + width);
        }
        return width;
    }

    protected int checkHeight(int height) {
        if (height < this.getMinHeight()) {
            throw new IllegalArgumentException("Height cannot be less than " + this.getMinHeight() + ", got " + height);
        }
        return height;
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narration) {
    }
}

