/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget.list.root;

import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.gui.screen.OptionScreen;
import dev.terminalmc.chatnotify.gui.widget.field.TextField;
import dev.terminalmc.chatnotify.gui.widget.list.OptionList;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.Unicode;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;

public class PrefixList
extends OptionList {
    public PrefixList(Minecraft mc, OptionScreen screen, int width, int height, int y, int entryWidth, int entryHeight, int entrySpacing) {
        super(mc, screen, width, height, y, entryWidth, entryHeight, entrySpacing);
    }

    @Override
    protected void addEntries() {
        this.addEntry((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (Component)Localization.localized("option", "prefix.list", Unicode.INFO.str), Tooltip.create((Component)Localization.localized("option", "prefix.list.tooltip", new Object[0])), -1));
        int max = Config.get().prefixes.size();
        for (int i = 0; i < max; ++i) {
            this.addEntry((AbstractSelectionList.Entry)new Entry.PrefixFieldEntry(this.entryX, this.entryWidth, this.entryHeight, this, i));
        }
        this.addEntry((AbstractSelectionList.Entry)new OptionList.Entry.ActionButton(this.entryX, this.entryWidth, this.entryHeight, (Component)Component.literal((String)"+"), null, -1, button -> {
            Config.get().prefixes.add("");
            this.init();
        }));
    }

    private static abstract class Entry
    extends OptionList.Entry {
        private Entry() {
        }

        private static class PrefixFieldEntry
        extends Entry {
            PrefixFieldEntry(int x, int width, int height, PrefixList list, int index) {
                TextField prefixField = new TextField(x, 0, width, height);
                prefixField.setMaxLength(30);
                prefixField.setResponder(prefix -> Config.get().prefixes.set(index, prefix.strip()));
                prefixField.setValue(Config.get().prefixes.get(index));
                this.elements.add(prefixField);
                this.elements.add(Button.builder((Component)Component.literal((String)Unicode.CROSS.str).withStyle(ChatFormatting.RED), button -> {
                    Config.get().prefixes.remove(index);
                    list.init();
                }).pos(x + width + 4, 0).size(list.smallWidgetWidth, height).build());
            }
        }
    }
}

