/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.mojang.authlib.GameProfile;
import dev.terminalmc.chatnotify.compat.chatheads.ChatHeadsWrapper;
import dev.terminalmc.chatnotify.compat.chatheads.Ownable;
import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.util.text.MessageUtil;
import java.time.Instant;
import net.minecraft.client.multiplayer.chat.ChatListener;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.PlayerChatMessage;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={ChatListener.class}, priority=792)
public class ChatListenerMixin {
    @WrapMethod(method={"handleDisguisedChatMessage"})
    private void wrapHandleDisguisedChatMessage(Component message, ChatType.Bound boundChatType, Operation<Void> original) {
        if (Config.get().detectionMode.equals((Object)Config.DetectionMode.PACKET)) {
            ChatHeadsWrapper.handleAddedMessage(message, boundChatType, null);
            message = MessageUtil.processMessage(message);
            if (message != null) {
                original.call(new Object[]{message, boundChatType});
            }
        } else {
            original.call(new Object[]{message, boundChatType});
        }
    }

    @WrapMethod(method={"handleSystemMessage"})
    private void wrapHandleSystemMessage(Component message, boolean isOverlay, Operation<Void> original) {
        if (Config.get().detectionMode.equals((Object)Config.DetectionMode.PACKET)) {
            ChatHeadsWrapper.handleAddedMessage(message, null, null);
            message = MessageUtil.processMessage(message);
            if (message != null) {
                original.call(new Object[]{message, isOverlay});
            }
        } else {
            original.call(new Object[]{message, isOverlay});
        }
    }

    @WrapMethod(method={"showMessageToPlayer"})
    private boolean wrapShowMessageToPlayer(ChatType.Bound bound, PlayerChatMessage playerChatMessage, Component message, GameProfile gameProfile, boolean onlyShowSecureChat, Instant timestamp, Operation<Boolean> original) {
        if (Config.get().detectionMode.equals((Object)Config.DetectionMode.PACKET)) {
            ChatHeadsWrapper.handleAddedMessage(message, bound, ((Ownable)message).chatheads$getOwner());
            message = MessageUtil.processMessage(message);
            if (message != null) {
                return (Boolean)original.call(new Object[]{bound, playerChatMessage, message, gameProfile, onlyShowSecureChat, timestamp});
            }
            return false;
        }
        return (Boolean)original.call(new Object[]{bound, playerChatMessage, message, gameProfile, onlyShowSecureChat, timestamp});
    }
}

