/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.util.text;

import dev.terminalmc.chatnotify.ChatNotify;
import dev.terminalmc.chatnotify.compat.chatheads.ChatHeadsWrapper;
import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.config.Notification;
import dev.terminalmc.chatnotify.config.Response;
import dev.terminalmc.chatnotify.config.Trigger;
import dev.terminalmc.chatnotify.gui.toast.NotificationToast;
import dev.terminalmc.chatnotify.util.Unicode;
import dev.terminalmc.chatnotify.util.text.FormatUtil;
import dev.terminalmc.chatnotify.util.text.StyleUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class MessageUtil {
    private static boolean debug = false;
    private static boolean ownMsg = false;

    private MessageUtil() {
    }

    @Nullable
    public static Component processMessage(Component msg) {
        String cleanStr;
        String cleanOwnedStr;
        debug = Config.get().debugMode.equals((Object)Config.DebugMode.ALL);
        ownMsg = false;
        String str = msg.getString();
        if (str.isBlank()) {
            return msg;
        }
        if (ChatNotify.unmodifiedChat.size() > 30) {
            ChatNotify.unmodifiedChat.poll();
        }
        ChatNotify.unmodifiedChat.add(msg);
        if (debug) {
            ChatNotify.LOG.warn("Processing new message", new Object[0]);
            ChatNotify.LOG.warn("Original text:", new Object[0]);
            ChatNotify.LOG.warn(msg.getString(), new Object[0]);
            ChatNotify.LOG.warn("Original tree:", new Object[0]);
            ChatNotify.LOG.warn(msg.toString(), new Object[0]);
        }
        ownMsg = !(cleanOwnedStr = MessageUtil.checkOwner(cleanStr = FormatUtil.stripCodes(str))).equals(cleanStr);
        msg = MessageUtil.tryNotify((Component)msg.copy(), cleanStr, cleanOwnedStr);
        if (debug) {
            ChatNotify.LOG.warn("Finished processing message", new Object[0]);
            if (msg == null) {
                ChatNotify.LOG.warn("null", new Object[0]);
            } else {
                ChatNotify.LOG.warn("Final text:", new Object[0]);
                ChatNotify.LOG.warn(msg.getString(), new Object[0]);
                ChatNotify.LOG.warn("Final tree:", new Object[0]);
                ChatNotify.LOG.warn(msg.toString(), new Object[0]);
            }
        }
        return msg;
    }

    private static String checkOwner(String cleanStr) {
        PlayerInfo ownerInfo = null;
        Object cleanOwnedStr = cleanStr;
        if (Config.get().senderDetectionMode == Config.SenderDetectionMode.COMBINED) {
            ownerInfo = ChatHeadsWrapper.getPlayerInfo();
        }
        if (ownerInfo != null) {
            UUID id;
            if (debug) {
                ChatNotify.LOG.warn("Owner check using ChatHeads", new Object[0]);
            }
            if (Minecraft.getInstance().player != null && (id = ownerInfo.getProfile().getId()).equals(Minecraft.getInstance().player.getUUID())) {
                if (debug) {
                    ChatNotify.LOG.warn("Matched user's UUID", new Object[0]);
                }
                for (Trigger t : Config.get().getUserNotif().triggers) {
                    Matcher matcher = MessageUtil.normalSearch(cleanStr, t.string);
                    if (!matcher.find()) continue;
                    if (debug) {
                        ChatNotify.LOG.warn("Matched trigger '{}'", t.string);
                    }
                    cleanOwnedStr = cleanStr.substring(0, matcher.start()) + cleanStr.substring(matcher.end());
                    break;
                }
            }
        } else {
            if (debug) {
                ChatNotify.LOG.warn("Owner check using heuristic", new Object[0]);
            }
            block1: for (int i = 0; i < ChatNotify.recentMessages.size(); ++i) {
                Matcher recentMatcher = Pattern.compile("(?iU)" + Pattern.quote((String)ChatNotify.recentMessages.get(i).getSecond())).matcher(cleanStr);
                int recentStart = -1;
                while (recentMatcher.find()) {
                    recentStart = recentMatcher.start();
                }
                if (recentStart == -1) continue;
                if (debug) {
                    ChatNotify.LOG.warn("Matched recent message '{}' at index {}", ChatNotify.recentMessages.get(i).getSecond(), recentStart);
                }
                String prefix = cleanStr.substring(0, recentStart);
                for (Trigger t : Config.get().getUserNotif().triggers) {
                    Matcher triggerMatcher = MessageUtil.normalSearch(prefix, t.string);
                    if (!triggerMatcher.find()) continue;
                    if (debug) {
                        ChatNotify.LOG.warn("Matched trigger '{}' at index {}", t.string, triggerMatcher.start());
                    }
                    ChatNotify.recentMessages.remove(i);
                    cleanOwnedStr = cleanStr.substring(0, triggerMatcher.start() + triggerMatcher.group(1).length()) + cleanStr.substring(triggerMatcher.end() - triggerMatcher.group(2).length());
                    continue block1;
                }
            }
        }
        if (debug) {
            ChatNotify.LOG.warn("Owner-checked string: '{}'", cleanOwnedStr);
        }
        return cleanOwnedStr;
    }

    @Nullable
    private static Component tryNotify(Component msg, String cleanStr, String cleanOwnedStr) {
        boolean restyleAll = Config.get().restyleMode.equals((Object)Config.RestyleMode.ALL_INSTANCES);
        boolean anyTriggered = false;
        boolean anySoundPlayed = false;
        for (Notification notif : Config.get().getNotifs()) {
            if (!notif.canBeTriggered(ownMsg)) continue;
            for (Trigger trig : notif.triggers) {
                boolean inMiss;
                Matcher matcher;
                block24: {
                    boolean hit;
                    if (trig.string.isBlank()) continue;
                    matcher = null;
                    switch (trig.type) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case NORMAL: {
                            boolean bl;
                            if (MessageUtil.normalSearch(cleanOwnedStr, trig.string).find()) {
                                matcher = MessageUtil.normalSearch(cleanStr, trig.string);
                                bl = matcher.find();
                                break;
                            }
                            bl = false;
                            break;
                        }
                        case REGEX: {
                            boolean bl;
                            if (trig.pattern == null) {
                                bl = false;
                                break;
                            }
                            matcher = trig.pattern.matcher(cleanStr);
                            bl = matcher.find();
                            break;
                        }
                        case KEY: {
                            boolean bl = hit = MessageUtil.keySearch(msg, trig.string);
                        }
                    }
                    if (!hit) continue;
                    inMiss = false;
                    if (!notif.inclusionEnabled) break block24;
                    for (Trigger trigger : notif.inclusionTriggers) {
                        boolean bl;
                        block26: {
                            block25: {
                                if (trig.string.isBlank()) continue;
                                switch (trigger.type) {
                                    default: {
                                        throw new MatchException(null, null);
                                    }
                                    case NORMAL: {
                                        if (!MessageUtil.normalSearch(cleanOwnedStr, trigger.string).find()) break;
                                        break block25;
                                    }
                                    case REGEX: {
                                        if (trigger.pattern != null && !trigger.pattern.matcher(cleanStr).find()) break;
                                        break block25;
                                    }
                                    case KEY: {
                                        if (MessageUtil.keySearch(msg, trigger.string)) break block25;
                                    }
                                }
                                bl = true;
                                break block26;
                            }
                            bl = false;
                        }
                        if (!(inMiss = bl)) continue;
                        break;
                    }
                }
                if (inMiss) continue;
                boolean exHit = false;
                if (notif.exclusionEnabled) {
                    for (Trigger exTrig : notif.exclusionTriggers) {
                        if (trig.string.isBlank()) continue;
                        if (!(exHit = (switch (exTrig.type) {
                            default -> throw new MatchException(null, null);
                            case Trigger.Type.NORMAL -> MessageUtil.normalSearch(cleanOwnedStr, exTrig.string).find();
                            case Trigger.Type.REGEX -> {
                                if (exTrig.pattern != null && exTrig.pattern.matcher(cleanStr).find()) {
                                    yield true;
                                }
                                yield false;
                            }
                            case Trigger.Type.KEY -> MessageUtil.keySearch(msg, exTrig.string);
                        }))) continue;
                        break;
                    }
                }
                if (exHit) continue;
                anyTriggered = true;
                if (!anySoundPlayed || Config.get().notifMode.equals((Object)Config.NotifMode.ALL)) {
                    anySoundPlayed = MessageUtil.playSound(notif);
                }
                Matcher matcher2 = trig.type == Trigger.Type.REGEX ? matcher : null;
                MessageUtil.sendResponses(notif, matcher2);
                msg = StyleUtil.restyle(msg, cleanStr, trig, matcher, notif.textStyle, restyleAll);
                MessageUtil.showStatusBarMsg(notif, msg, matcher2);
                MessageUtil.showTitleMsg(notif, msg, matcher2);
                MessageUtil.showToastMsg(notif, msg, matcher2);
                MessageUtil.typeTypedMsg(notif, msg, matcher2);
                MessageUtil.copyClipboardMsg(notif, msg, matcher2);
                if (!notif.replacementMsgEnabled) break;
                msg = MessageUtil.convertMsg(notif.replacementMsg, matcher2, msg);
                String str = msg.getString();
                cleanOwnedStr = cleanStr = FormatUtil.stripCodes(str);
                if (!str.isBlank()) break;
                return null;
            }
            if (!anyTriggered || !Config.get().notifMode.equals((Object)Config.NotifMode.SINGLE)) continue;
            return msg;
        }
        return msg;
    }

    public static boolean keySearch(Component msg, String key) {
        if (key.equals(".")) {
            return true;
        }
        ComponentContents componentContents = msg.getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents tc = (TranslatableContents)componentContents;
            return tc.getKey().contains(key);
        }
        return false;
    }

    public static Matcher normalSearch(String msg, String str) {
        return Pattern.compile("(?iU)(?<!\\w)(\\W?)" + Pattern.quote(str) + "(\\W?)(?!\\w)").matcher(msg);
    }

    private static boolean playSound(Notification notif) {
        ResourceLocation location;
        if (notif.sound.isEnabled() && notif.sound.getVolume() > 0.0f && (location = notif.sound.getResourceLocation()) != null) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)new SimpleSoundInstance(notif.sound.getResourceLocation(), Config.get().soundSource, notif.sound.getVolume(), notif.sound.getPitch(), SoundInstance.createUnseededRandom(), false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true));
            return true;
        }
        return false;
    }

    private static Component convertMsg(String msgString, @Nullable Matcher matcher, Component msg) {
        msgString = msgString.replaceAll(Matcher.quoteReplacement("$"), Unicode.SECTION.str);
        if (matcher != null && matcher.find(0)) {
            Object replacement;
            for (int i = 0; i <= matcher.groupCount(); ++i) {
                String replacement2 = matcher.group(i) == null ? "" : matcher.group(i);
                msgString = msgString.replaceAll(Matcher.quoteReplacement(Unicode.SECTION.str + "(" + i + ")"), replacement2);
            }
            msg = FormatUtil.convertToStyledLiteral(msg.copy());
            ArrayList<int[]> groupReplacementIndices = new ArrayList<int[]>();
            HashMap<Integer, MutableComponent> groupReplacementMap = new HashMap<Integer, MutableComponent>();
            for (int groupNum = 0; groupNum <= matcher.groupCount(); ++groupNum) {
                String targetString = "(" + groupNum + ")";
                if (!msgString.contains(targetString)) continue;
                int index = msgString.indexOf(targetString);
                while (index >= 0) {
                    groupReplacementIndices.add(new int[]{index, groupNum});
                    index = msgString.indexOf(targetString, index + targetString.length());
                }
                if (matcher.group(groupNum) == null) {
                    replacement = Component.empty();
                } else {
                    int start = matcher.start(groupNum);
                    int end = matcher.end(groupNum);
                    replacement = StyleUtil.styledSubstring(msg, start, end);
                }
                groupReplacementMap.put(groupNum, (MutableComponent)replacement);
            }
            groupReplacementIndices.sort(Comparator.comparingInt(obj -> obj[0]));
            if (!groupReplacementIndices.isEmpty()) {
                MutableComponent newMsg = Component.empty();
                Object startIndex = 0;
                Iterator iterator = groupReplacementIndices.iterator();
                while (iterator.hasNext()) {
                    replacement = (int[])iterator.next();
                    newMsg.append((Component)Component.literal((String)msgString.substring((int)startIndex, (int)replacement[0])));
                    newMsg.append((Component)groupReplacementMap.get((int)replacement[1]));
                    startIndex = replacement[0] + ("(" + (int)replacement[1] + ")").length();
                }
                newMsg.append((Component)Component.literal((String)msgString.substring((int)startIndex)));
                return newMsg;
            }
        }
        return Component.literal((String)msgString);
    }

    private static void showStatusBarMsg(Notification notif, Component msg, Matcher matcher) {
        if (notif.statusBarMsgEnabled) {
            Component displayMsg = notif.statusBarMsg.isBlank() ? msg : MessageUtil.convertMsg(notif.statusBarMsg, matcher, msg);
            Minecraft.getInstance().gui.setOverlayMessage(displayMsg, false);
        }
    }

    private static void showTitleMsg(Notification notif, Component msg, Matcher matcher) {
        if (notif.titleMsgEnabled) {
            Component displayMsg = notif.titleMsg.isBlank() ? msg : MessageUtil.convertMsg(notif.titleMsg, matcher, msg);
            Minecraft.getInstance().gui.setTitle(displayMsg);
        }
    }

    private static void showToastMsg(Notification notif, Component msg, Matcher matcher) {
        if (notif.toastMsgEnabled) {
            Component displayMsg = notif.toastMsg.isBlank() ? msg : MessageUtil.convertMsg(notif.toastMsg, matcher, msg);
            Minecraft.getInstance().getToastManager().addToast((Toast)new NotificationToast(displayMsg));
        }
    }

    private static void typeTypedMsg(Notification notif, Component msg, Matcher matcher) {
        if (notif.typedMsgEnabled && Minecraft.getInstance().screen == null) {
            Component displayMsg = notif.typedMsg.isBlank() ? msg : MessageUtil.convertMsg(notif.typedMsg, matcher, msg);
            Minecraft.getInstance().setScreen((Screen)new ChatScreen(displayMsg.getString()));
        }
    }

    private static void copyClipboardMsg(Notification notif, Component msg, Matcher matcher) {
        if (notif.clipboardMsgEnabled) {
            Component displayMsg = notif.clipboardMsg.isBlank() ? msg : MessageUtil.convertMsg(notif.clipboardMsg, matcher, msg);
            Minecraft.getInstance().keyboardHandler.setClipboard(displayMsg.getString());
        }
    }

    private static void sendResponses(Notification notif, @Nullable Matcher matcher) {
        if (notif.responseEnabled) {
            int totalDelay = 0;
            for (Response msg : notif.responses) {
                msg.sendingString = msg.string;
                if (msg.type.equals((Object)Response.Type.REGEX) && matcher != null && matcher.find(0)) {
                    for (int i = 0; i <= matcher.groupCount(); ++i) {
                        String replacement = matcher.group(i) == null ? "" : matcher.group(i);
                        msg.sendingString = msg.sendingString.replaceAll("\\(" + i + "\\)", replacement);
                    }
                }
                msg.countdown = totalDelay += msg.delayTicks;
                ChatNotify.RESPONSES.add(msg);
            }
        }
    }
}

