/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.retraining.network.handler;

import com.mrbysco.retraining.CommonRetraining;
import com.mrbysco.retraining.messages.ResetTradesPayload;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerPayloadHandler {
    public static final ServerPayloadHandler INSTANCE = new ServerPayloadHandler();

    public static ServerPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleData(ResetTradesPayload data, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CommonRetraining.resetTrades(serverPlayer);
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"retraining.networking.reset_trades.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

