/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.command.CommandUtil;
import lovexyn0827.mess.rendering.RenderedBitmap;
import lovexyn0827.mess.rendering.RenderedBox;
import lovexyn0827.mess.rendering.RenderedLine;
import lovexyn0827.mess.rendering.RenderedText;
import lovexyn0827.mess.rendering.ShapeSpace;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2177;
import net.minecraft.class_2277;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_5321;

public class DrawShapeCommand {
    private static final ShapeSpace SPACE = new ShapeSpace("manual");
    private static final Set<ShapeSpace> CREATED_SPACES = new TreeSet<ShapeSpace>(Comparator.comparing(s -> s.name));
    private static final int DEFAULT_LIFE = 100;
    private static final int DEFAULT_COLOR = 838044671;

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        SuggestionProvider spaceSuggestion = (ct, b) -> {
            b.suggest(DrawShapeCommand.SPACE.name);
            CREATED_SPACES.forEach(s -> b.suggest(s.name));
            return b.buildFuture();
        };
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"drawshape").requires(CommandUtil.COMMAND_REQUMENT)).then(class_2170.method_9247((String)"box").then(class_2170.method_9244((String)"corner1", (ArgumentType)class_2277.method_9735((boolean)false)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"corner2", (ArgumentType)class_2277.method_9735((boolean)false)).executes(ct -> DrawShapeCommand.drawBox((CommandContext<class_2168>)ct, 838044671, 100, 0, SPACE))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"color", (ArgumentType)class_2177.method_9276()).executes(ct -> {
            class_124 color = class_2177.method_9277((CommandContext)ct, (String)"color");
            int colorRgba = color.method_532() << 8 | 0xFF;
            return DrawShapeCommand.drawBox((CommandContext<class_2168>)ct, colorRgba, 100, 0, SPACE);
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"life", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ct -> {
            class_124 color = class_2177.method_9277((CommandContext)ct, (String)"color");
            int colorRgba = color.method_532() << 8 | 0xFF;
            int life = IntegerArgumentType.getInteger((CommandContext)ct, (String)"life");
            return DrawShapeCommand.drawBox((CommandContext<class_2168>)ct, colorRgba, life, 0, SPACE);
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"fill", (ArgumentType)class_2177.method_9276()).executes(ct -> {
            class_124 color = class_2177.method_9277((CommandContext)ct, (String)"color");
            int colorRgba = color.method_532() << 8 | 0xFF;
            int life = IntegerArgumentType.getInteger((CommandContext)ct, (String)"life");
            class_124 fill = class_2177.method_9277((CommandContext)ct, (String)"fill");
            int fillRgba = fill.method_532() == null ? 0 : fill.method_532() << 8 | 0x5F;
            return DrawShapeCommand.drawBox((CommandContext<class_2168>)ct, colorRgba, life, fillRgba, SPACE);
        })).then(class_2170.method_9244((String)"space", (ArgumentType)StringArgumentType.word()).suggests(spaceSuggestion).executes(ct -> {
            class_124 color = class_2177.method_9277((CommandContext)ct, (String)"color");
            int colorRgba = color.method_532() << 8 | 0xFF;
            int life = IntegerArgumentType.getInteger((CommandContext)ct, (String)"life");
            class_124 fill = class_2177.method_9277((CommandContext)ct, (String)"fill");
            int fillRgba = fill.method_532() == null ? 0 : fill.method_532() << 8 | 0x5F;
            ShapeSpace space = new ShapeSpace(StringArgumentType.getString((CommandContext)ct, (String)"space"));
            CREATED_SPACES.add(space);
            return DrawShapeCommand.drawBox((CommandContext<class_2168>)ct, colorRgba, life, fillRgba, space);
        }))))))))).then(class_2170.method_9247((String)"line").then(class_2170.method_9244((String)"corner1", (ArgumentType)class_2277.method_9735((boolean)false)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"corner2", (ArgumentType)class_2277.method_9735((boolean)false)).executes(ct -> DrawShapeCommand.drawLine((CommandContext<class_2168>)ct, 838044671, 100, SPACE))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"color", (ArgumentType)class_2177.method_9276()).executes(ct -> {
            class_124 color = class_2177.method_9277((CommandContext)ct, (String)"color");
            int colorRgba = color.method_532() << 8 | 0xFF;
            return DrawShapeCommand.drawLine((CommandContext<class_2168>)ct, colorRgba, 100, SPACE);
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"life", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ct -> {
            class_124 color = class_2177.method_9277((CommandContext)ct, (String)"color");
            int colorRgba = color.method_532() << 8 | 0xFF;
            int life = IntegerArgumentType.getInteger((CommandContext)ct, (String)"life");
            return DrawShapeCommand.drawLine((CommandContext<class_2168>)ct, colorRgba, life, SPACE);
        })).then(class_2170.method_9244((String)"space", (ArgumentType)StringArgumentType.word()).suggests(spaceSuggestion).executes(ct -> {
            class_124 color = class_2177.method_9277((CommandContext)ct, (String)"color");
            int colorRgba = color.method_532() << 8 | 0xFF;
            int life = IntegerArgumentType.getInteger((CommandContext)ct, (String)"life");
            ShapeSpace space = new ShapeSpace(StringArgumentType.getString((CommandContext)ct, (String)"space"));
            CREATED_SPACES.add(space);
            return DrawShapeCommand.drawLine((CommandContext<class_2168>)ct, colorRgba, life, space);
        })))))))).then(class_2170.method_9247((String)"text").then(class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9735((boolean)false)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"text", (ArgumentType)StringArgumentType.string()).executes(ct -> DrawShapeCommand.drawText((CommandContext<class_2168>)ct, 838044671, 100, 1.0f, SPACE))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"color", (ArgumentType)class_2177.method_9276()).executes(ct -> {
            class_124 color = class_2177.method_9277((CommandContext)ct, (String)"color");
            int colorRgba = color.method_532() << 8 | 0xFF;
            return DrawShapeCommand.drawText((CommandContext<class_2168>)ct, colorRgba, 100, 1.0f, SPACE);
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"life", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ct -> {
            class_124 color = class_2177.method_9277((CommandContext)ct, (String)"color");
            int colorRgba = color.method_532() << 8 | 0xFF;
            int life = IntegerArgumentType.getInteger((CommandContext)ct, (String)"life");
            return DrawShapeCommand.drawText((CommandContext<class_2168>)ct, colorRgba, life, 1.0f, SPACE);
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"scale", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(ct -> {
            class_124 color = class_2177.method_9277((CommandContext)ct, (String)"color");
            int colorRgba = color.method_532() << 8 | 0xFF;
            int life = IntegerArgumentType.getInteger((CommandContext)ct, (String)"life");
            float scale = FloatArgumentType.getFloat((CommandContext)ct, (String)"scale");
            return DrawShapeCommand.drawText((CommandContext<class_2168>)ct, colorRgba, life, scale, SPACE);
        })).then(class_2170.method_9244((String)"space", (ArgumentType)StringArgumentType.word()).suggests(spaceSuggestion).executes(ct -> {
            class_124 color = class_2177.method_9277((CommandContext)ct, (String)"color");
            int colorRgba = color.method_532() << 8 | 0xFF;
            int life = IntegerArgumentType.getInteger((CommandContext)ct, (String)"life");
            float scale = FloatArgumentType.getFloat((CommandContext)ct, (String)"scale");
            ShapeSpace space = new ShapeSpace(StringArgumentType.getString((CommandContext)ct, (String)"space"));
            CREATED_SPACES.add(space);
            return DrawShapeCommand.drawText((CommandContext<class_2168>)ct, colorRgba, life, scale, space);
        }))))))))).then(class_2170.method_9247((String)"image").then(class_2170.method_9244((String)"oriention", (ArgumentType)StringArgumentType.word()).suggests(CommandUtil.immutableSuggestions("X", "Y", "Z")).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9735((boolean)false)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"url", (ArgumentType)StringArgumentType.string()).executes(ct -> DrawShapeCommand.drawImage((CommandContext<class_2168>)ct, 100, 1.0f, SPACE))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"life", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ct -> {
            int life = IntegerArgumentType.getInteger((CommandContext)ct, (String)"life");
            return DrawShapeCommand.drawImage((CommandContext<class_2168>)ct, life, 1.0f, SPACE);
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"scale", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(ct -> {
            int life = IntegerArgumentType.getInteger((CommandContext)ct, (String)"life");
            float scale = FloatArgumentType.getFloat((CommandContext)ct, (String)"scale");
            return DrawShapeCommand.drawImage((CommandContext<class_2168>)ct, life, scale, SPACE);
        })).then(class_2170.method_9244((String)"space", (ArgumentType)StringArgumentType.word()).suggests(spaceSuggestion).executes(ct -> {
            int life = IntegerArgumentType.getInteger((CommandContext)ct, (String)"life");
            float scale = FloatArgumentType.getFloat((CommandContext)ct, (String)"scale");
            ShapeSpace space = new ShapeSpace(StringArgumentType.getString((CommandContext)ct, (String)"space"));
            CREATED_SPACES.add(space);
            return DrawShapeCommand.drawImage((CommandContext<class_2168>)ct, life, scale, space);
        }))))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").executes(ct -> {
            MessMod.INSTANCE.shapeSender.clearSpaceFromServer(SPACE, null);
            CREATED_SPACES.forEach(s -> MessMod.INSTANCE.shapeSender.clearSpaceFromServer((ShapeSpace)s, null));
            return 1;
        })).then(class_2170.method_9244((String)"space", (ArgumentType)StringArgumentType.word()).suggests(spaceSuggestion).executes(ct -> {
            ShapeSpace space = new ShapeSpace(StringArgumentType.getString((CommandContext)ct, (String)"space"));
            MessMod.INSTANCE.shapeSender.clearSpaceFromServer(space, null);
            return 1;
        })));
        dispatcher.register(command);
    }

    private static int drawBox(CommandContext<class_2168> ct, int color, int life, int fill, ShapeSpace space) throws CommandSyntaxException {
        class_243 c1 = class_2277.method_9736(ct, (String)"corner1");
        class_243 c2 = class_2277.method_9736(ct, (String)"corner2");
        RenderedBox box = new RenderedBox(new class_238(c1, c2), color, fill, life, MessMod.INSTANCE.getGameTime());
        MessMod.INSTANCE.shapeSender.addShape(box, (class_5321<class_1937>)((class_2168)ct.getSource()).method_9225().method_27983(), space, null);
        CommandUtil.feedback(ct, "cmd.general.success");
        return 1;
    }

    private static int drawLine(CommandContext<class_2168> ct, int color, int life, ShapeSpace space) throws CommandSyntaxException {
        class_243 c1 = class_2277.method_9736(ct, (String)"corner1");
        class_243 c2 = class_2277.method_9736(ct, (String)"corner2");
        RenderedLine line = new RenderedLine(c1, c2, color, life, MessMod.INSTANCE.getGameTime());
        MessMod.INSTANCE.shapeSender.addShape(line, (class_5321<class_1937>)((class_2168)ct.getSource()).method_9225().method_27983(), space, null);
        CommandUtil.feedback(ct, "cmd.general.success");
        return 1;
    }

    private static int drawText(CommandContext<class_2168> ct, int color, int life, float scale, ShapeSpace space) throws CommandSyntaxException {
        String content = StringArgumentType.getString(ct, (String)"text");
        class_243 pos = class_2277.method_9736(ct, (String)"pos");
        RenderedText text = new RenderedText(content, pos, color, scale, life, MessMod.INSTANCE.getGameTime());
        MessMod.INSTANCE.shapeSender.addShape(text, (class_5321<class_1937>)((class_2168)ct.getSource()).method_9225().method_27983(), space, null);
        CommandUtil.feedback(ct, "cmd.general.success");
        return 1;
    }

    private static int drawImage(CommandContext<class_2168> ct, int life, float size, ShapeSpace space) throws CommandSyntaxException {
        URL url;
        class_243 pos = class_2277.method_9736(ct, (String)"pos");
        String axisStr = StringArgumentType.getString(ct, (String)"oriention");
        class_2350.class_2351 axis = class_2350.class_2351.method_10177((String)axisStr.toLowerCase());
        if (axis == null) {
            CommandUtil.errorWithArgs(ct, "cmd.general.nodef", axisStr);
            return 0;
        }
        String urlStr = StringArgumentType.getString(ct, (String)"url");
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            CommandUtil.errorWithArgs(ct, "cmd.drawshape.malurl", urlStr);
            return 0;
        }
        try {
            BufferedImage img = ImageIO.read(url);
            int width = img.getWidth();
            int height = img.getHeight();
            int[] pixels = new int[width * height];
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    pixels[x + y * width] = DrawShapeCommand.rgb2Abgr(img.getRGB(x, y));
                }
            }
            RenderedBitmap imgToSend = new RenderedBitmap(pixels, size / (float)Math.max(height, width), height, width, axis, pos, life, MessMod.INSTANCE.getGameTime());
            MessMod.INSTANCE.shapeSender.addShape(imgToSend, (class_5321<class_1937>)((class_2168)ct.getSource()).method_9225().method_27983(), space, null);
            CommandUtil.feedback(ct, "cmd.general.success");
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            CommandUtil.error(ct, "cmd.drawshape.imgfail", e);
            return 0;
        }
    }

    private static int rgb2Abgr(int rgb) {
        return 0xFF000000 | (rgb & 0xFF) << 16 | rgb & 0xFF00 | (rgb & 0xFF0000) >> 16;
    }
}

