/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.command;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import lovexyn0827.mess.command.ElementSetArgumentType;
import lovexyn0827.mess.util.NameFilter;
import net.minecraft.class_2314;
import net.minecraft.class_2316;
import net.minecraft.class_2540;

public class FilteredSetArgumentType<T>
extends ElementSetArgumentType<T, ParseResult<T>> {
    private final Map<String, T> elementsByName;

    private FilteredSetArgumentType(Map<String, T> elementsByName) {
        this.elementsByName = elementsByName;
    }

    public static <T> FilteredSetArgumentType<T> of(Set<T> set, Function<? super T, String> toString) {
        return new FilteredSetArgumentType<T>(set.stream().collect(() -> new HashMap(), (map, v) -> map.put((String)toString.apply(v), v), Map::putAll));
    }

    public static <T> FilteredSetArgumentType<T> of(Map<String, T> elementsByName) {
        return new FilteredSetArgumentType<T>(elementsByName);
    }

    public static <T> Set<T> getFiltered(CommandContext<?> context, String name) {
        return ((ParseResult)context.getArgument((String)name, ParseResult.class)).set;
    }

    @Override
    protected ParseResult<T> filter(NameFilter filter) {
        return new ParseResult(Sets.newHashSet(filter.filterByKey(this.elementsByName, a -> a).values()));
    }

    @Override
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        for (String e : this.elementsByName.keySet()) {
            if (!e.startsWith(builder.getRemaining())) continue;
            builder.suggest(e);
        }
        return builder.buildFuture();
    }

    public static void registerArgumentType() {
        Class<FilteredSetArgumentType> cl = FilteredSetArgumentType.class;
        class_2316.method_10017((String)"mess_filter", cl, new Serializer());
    }

    static final class ParseResult<T>
    extends ElementSetArgumentType.ParseResult<T> {
        public ParseResult(Set<T> set) {
            super(set);
        }
    }

    private static class Serializer<T>
    implements class_2314<FilteredSetArgumentType<T>> {
        private Serializer() {
        }

        public void toPacket(FilteredSetArgumentType<T> type, class_2540 buf) {
            buf.writeInt(type.elementsByName.size());
            type.elementsByName.keySet().forEach(arg_0 -> ((class_2540)buf).method_10814(arg_0));
        }

        public FilteredSetArgumentType<T> fromPacket(class_2540 buf) {
            int count = buf.readInt();
            HashMap<String, Object> elements = new HashMap<String, Object>();
            for (int i = 0; i < count; ++i) {
                elements.put(buf.method_19772(), new Object());
            }
            return FilteredSetArgumentType.of(elements);
        }

        public void toJson(FilteredSetArgumentType<T> type, JsonObject jsonObject) {
            JsonArray list = new JsonArray();
            type.elementsByName.keySet().forEach(arg_0 -> ((JsonArray)list).add(arg_0));
            jsonObject.add("elements", (JsonElement)list);
        }
    }
}

