/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.command;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lovexyn0827.mess.command.CommandUtil;
import lovexyn0827.mess.util.FloatPredicate;
import lovexyn0827.mess.util.FormattedText;
import lovexyn0827.mess.util.NameFilter;
import lovexyn0827.mess.util.Reflection;
import lovexyn0827.mess.util.TranslatableException;
import lovexyn0827.mess.util.WrappedPath;
import lovexyn0827.mess.util.access.AccessingPath;
import lovexyn0827.mess.util.access.AccessingPathArgumentType;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class LogDeathCommand {
    public static final Map<String, DeathInfoLoggingItem> SUBSCRIPTED_DEATH_PREDICATES = Maps.newHashMap();
    public static final Object2IntMap<AutoDeathStatKey> DEATH_AUTO_STATS = new Object2IntOpenHashMap();

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        SuggestionProvider predNameSuggestion = (ct, b) -> {
            SUBSCRIPTED_DEATH_PREDICATES.keySet().forEach(n -> b.suggest("\"" + n + "\""));
            b.suggest("\"*\"");
            return b.buildFuture();
        };
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"logdeath").requires(CommandUtil.COMMAND_REQUMENT)).then(class_2170.method_9247((String)"sub").then(class_2170.method_9244((String)"target", (ArgumentType)StringArgumentType.greedyString()).suggests((ct, b) -> {
            DeathInfoLoggingItem.buildSuggestions(b.getRemaining(), b);
            return b.buildFuture();
        }).executes(ct -> {
            String in = StringArgumentType.getString((CommandContext)ct, (String)"target").replace(" ", "");
            try {
                SUBSCRIPTED_DEATH_PREDICATES.put(in, DeathInfoLoggingItem.parse(in));
            }
            catch (TranslatableException e) {
                CommandUtil.error((CommandContext<? extends class_2168>)ct, e.getLocalizedMessage());
                return 0;
            }
            CommandUtil.feedback((CommandContext<? extends class_2168>)ct, "cmd.general.success");
            return 1;
        })))).then(class_2170.method_9247((String)"unsub").then(class_2170.method_9244((String)"target", (ArgumentType)StringArgumentType.greedyString()).suggests(predNameSuggestion).suggests((ct, b) -> {
            SUBSCRIPTED_DEATH_PREDICATES.keySet().forEach(arg_0 -> ((SuggestionsBuilder)b).suggest(arg_0));
            return b.buildFuture();
        }).executes(ct -> {
            String in = StringArgumentType.getString((CommandContext)ct, (String)"target").replace(" ", "");
            NameFilter filter = NameFilter.compile(in);
            int count = 0;
            Iterator<String> keys = SUBSCRIPTED_DEATH_PREDICATES.keySet().iterator();
            while (keys.hasNext()) {
                String cur = keys.next();
                if (!filter.test(cur)) continue;
                keys.remove();
                ++count;
            }
            CommandUtil.feedbackWithArgs((CommandContext<? extends class_2168>)ct, "cmd.general.unsubmulticnt", count);
            return 1;
        })))).then(class_2170.method_9247((String)"subVictimField").then(class_2170.method_9244((String)"target", (ArgumentType)StringArgumentType.string()).suggests(predNameSuggestion).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"path", (ArgumentType)AccessingPathArgumentType.accessingPathArg(ct -> class_1297.class)).executes(ct -> LogDeathCommand.subField((CommandContext<class_2168>)ct, item -> item.victimDetails))))))).then(class_2170.method_9247((String)"subDamageField").then(class_2170.method_9244((String)"target", (ArgumentType)StringArgumentType.string()).suggests(predNameSuggestion).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"path", (ArgumentType)AccessingPathArgumentType.accessingPathArg(ct -> class_1282.class)).executes(ct -> LogDeathCommand.subField((CommandContext<class_2168>)ct, item -> item.damageDetails))))))).then(class_2170.method_9247((String)"unsubVictimField").then(class_2170.method_9244((String)"target", (ArgumentType)StringArgumentType.string()).suggests(predNameSuggestion).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(ct -> LogDeathCommand.unsubField((CommandContext<class_2168>)ct, item -> item.victimDetails)))))).then(class_2170.method_9247((String)"unsubDamageField").then(class_2170.method_9244((String)"target", (ArgumentType)StringArgumentType.string()).suggests(predNameSuggestion).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(ct -> LogDeathCommand.unsubField((CommandContext<class_2168>)ct, item -> item.damageDetails)))))).then(class_2170.method_9247((String)"setVisible").then(class_2170.method_9244((String)"target", (ArgumentType)StringArgumentType.string()).suggests(predNameSuggestion).then(class_2170.method_9244((String)"visible", (ArgumentType)BoolArgumentType.bool()).executes(ct -> {
            String in = StringArgumentType.getString((CommandContext)ct, (String)"target").replace(" ", "");
            NameFilter filter = NameFilter.compile(in);
            boolean visible = BoolArgumentType.getBool((CommandContext)ct, (String)"visible");
            SUBSCRIPTED_DEATH_PREDICATES.forEach((k, v) -> {
                if (filter.test((String)k)) {
                    v.setVisible(visible);
                }
            });
            CommandUtil.feedback((CommandContext<? extends class_2168>)ct, "cmd.general.success");
            return 1;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"stats").executes(ct -> {
            SUBSCRIPTED_DEATH_PREDICATES.forEach((k, v) -> CommandUtil.feedbackRawWithArgs((CommandContext<? extends class_2168>)ct, "%s: %d", k, v.getTriggerCount()));
            return 1;
        })).then(class_2170.method_9244((String)"target", (ArgumentType)StringArgumentType.string()).suggests(predNameSuggestion).executes(ct -> {
            String in = StringArgumentType.getString((CommandContext)ct, (String)"target").replace(" ", "");
            NameFilter filter = NameFilter.compile(in);
            SUBSCRIPTED_DEATH_PREDICATES.forEach((k, v) -> {
                if (filter.test((String)k)) {
                    CommandUtil.feedbackRawWithArgs((CommandContext<? extends class_2168>)ct, "%s: %d", k, v.getTriggerCount());
                }
            });
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"autoStats").executes(ct -> {
            DEATH_AUTO_STATS.forEach((k, v) -> CommandUtil.feedbackRawWithArgs((CommandContext<? extends class_2168>)ct, "%s + %s(%s) -> %s: %d", LogDeathCommand.entityTypeToString(k.killerType), LogDeathCommand.entityTypeToString(k.directKillerType), k.cause, LogDeathCommand.entityTypeToString(k.victimType), v));
            return 1;
        })).then(class_2170.method_9247((String)"reset").executes(ct -> {
            DEATH_AUTO_STATS.clear();
            CommandUtil.feedback((CommandContext<? extends class_2168>)ct, "cmd.general.success");
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").executes(ct -> {
            SUBSCRIPTED_DEATH_PREDICATES.forEach((k, v) -> v.resetTriggerCount());
            DEATH_AUTO_STATS.clear();
            CommandUtil.feedback((CommandContext<? extends class_2168>)ct, "cmd.general.success");
            return 1;
        })).then(class_2170.method_9244((String)"target", (ArgumentType)StringArgumentType.string()).suggests(predNameSuggestion).executes(ct -> {
            String in = StringArgumentType.getString((CommandContext)ct, (String)"target").replace(" ", "");
            NameFilter filter = NameFilter.compile(in);
            SUBSCRIPTED_DEATH_PREDICATES.forEach((k, v) -> {
                if (filter.test((String)k)) {
                    v.resetTriggerCount();
                }
            });
            CommandUtil.feedback((CommandContext<? extends class_2168>)ct, "cmd.general.success");
            return 1;
        })));
        dispatcher.register(command);
    }

    static String entityTypeToString(class_1299<?> type) {
        return type == null ? "null" : new class_2588(type.method_5882()).getString();
    }

    static void reset() {
        SUBSCRIPTED_DEATH_PREDICATES.clear();
        DEATH_AUTO_STATS.clear();
    }

    private static int subField(CommandContext<class_2168> ct, Function<DeathInfoLoggingItem, Map<String, WrappedPath>> mapGetter) {
        String in = StringArgumentType.getString(ct, (String)"target").replace(" ", "");
        String name = StringArgumentType.getString(ct, (String)"name");
        AccessingPath path = AccessingPathArgumentType.getAccessingPath(ct, "path");
        NameFilter filter = NameFilter.compile(in);
        SUBSCRIPTED_DEATH_PREDICATES.forEach((k, v) -> {
            if (filter.test((String)k)) {
                ((Map)mapGetter.apply((DeathInfoLoggingItem)v)).put(name, new WrappedPath(path, name));
            }
        });
        CommandUtil.feedback(ct, "cmd.general.success");
        return 1;
    }

    private static int unsubField(CommandContext<class_2168> ct, Function<DeathInfoLoggingItem, Map<String, WrappedPath>> mapGetter) {
        String in = StringArgumentType.getString(ct, (String)"target").replace(" ", "");
        String name = StringArgumentType.getString(ct, (String)"name");
        NameFilter filter = NameFilter.compile(in);
        SUBSCRIPTED_DEATH_PREDICATES.forEach((k, v) -> {
            if (filter.test((String)k)) {
                ((Map)mapGetter.apply((DeathInfoLoggingItem)v)).remove(name);
            }
        });
        CommandUtil.feedback(ct, "cmd.general.success");
        return 1;
    }

    public static void onEntityDies(class_1282 damage, @NotNull class_1297 victim, float amount) {
        List triggered = SUBSCRIPTED_DEATH_PREDICATES.values().stream().filter(p -> p.test(damage, victim, amount)).collect(Collectors.toList());
        if (triggered.isEmpty()) {
            return;
        }
        class_1297 killer = damage.method_5529();
        class_1297 directKiller = damage.method_5526();
        AutoDeathStatKey key = new AutoDeathStatKey(killer == null ? null : killer.method_5864(), directKiller == null ? null : directKiller.method_5864(), damage.field_5841, victim == null ? null : victim.method_5864());
        DEATH_AUTO_STATS.computeInt((Object)key, (k, v) -> v == null ? 1 : v + 1);
        TreeMap damageDetails = Maps.newTreeMap();
        TreeMap victimDetails = Maps.newTreeMap();
        boolean[] isVisible = new boolean[]{false};
        for (DeathInfoLoggingItem item : triggered) {
            item.increaseTriggerCount();
            if (!item.isVisible()) continue;
            isVisible[0] = true;
            damageDetails.putAll(item.damageDetails);
            victimDetails.putAll(item.victimDetails);
        }
        if (!isVisible[0]) {
            return;
        }
        class_2561 deathReport = LogDeathCommand.getDeathReport(damage, victim, amount, damageDetails, victimDetails);
        victim.method_5682().method_3760().method_14616(deathReport, class_2556.field_11737, class_156.field_25140);
    }

    private static class_2561 getDeathReport(class_1282 damage, @NotNull class_1297 victim, float amount, Map<String, WrappedPath> damageDetails, Map<String, WrappedPath> victimDetails) {
        class_5250 t = new FormattedText("%s", "c", false, LogDeathCommand.entityToString(damage.method_5529())).asMutableText();
        t.method_10852((class_2561)new FormattedText(" + ", "rl", false, new Object[0]).asMutableText());
        t.method_10852((class_2561)new FormattedText("%s", "r5", false, LogDeathCommand.entityToString(damage.method_5526())).asMutableText());
        t.method_10852((class_2561)new FormattedText("(", "rl", false, new Object[0]).asMutableText());
        t.method_10852((class_2561)new FormattedText("%s", "ra", false, damage.field_5841).asMutableText());
        t.method_10852((class_2561)new FormattedText(") -> ", "rl", false, new Object[0]).asMutableText());
        t.method_10852((class_2561)new FormattedText("%s", "r7", false, LogDeathCommand.entityToString(victim)).asMutableText());
        t.method_10852((class_2561)new FormattedText(" @ ", "rl", false, new Object[0]).asMutableText());
        t.method_10852((class_2561)new FormattedText("%.2f", "r4", false, Float.valueOf(amount)).asMutableText());
        if (!damageDetails.isEmpty()) {
            t.method_10852((class_2561)new FormattedText("cmd.logdeath.dmginf", "r6l").asMutableText());
        }
        for (WrappedPath l : damageDetails.values()) {
            t.method_10852((class_2561)new FormattedText("\n%s: ", "rcl", false, l.getName()).asMutableText());
            t.method_10852((class_2561)new FormattedText("%s", "rfo", false, l.getFrom(damage)).asMutableText());
        }
        if (!victimDetails.isEmpty()) {
            t.method_10852((class_2561)new FormattedText("cmd.logdeath.vctinf", "r6l").asMutableText());
        }
        for (WrappedPath l : victimDetails.values()) {
            t.method_10852((class_2561)new FormattedText("\n%s: ", "rcl", false, l.getName()).asMutableText());
            t.method_10852((class_2561)new FormattedText("%s", "rfo", false, l.getFrom(victim)).asMutableText());
        }
        return t;
    }

    private static String entityToString(class_1297 e) {
        if (e != null) {
            return e.method_5477().getString();
        }
        return "null";
    }

    static {
        DEATH_AUTO_STATS.defaultReturnValue(0);
    }

    private static class AutoDeathStatKey {
        final class_1299<?> killerType;
        final class_1299<?> directKillerType;
        final String cause;
        final class_1299<?> victimType;

        AutoDeathStatKey(class_1299<?> killerType, class_1299<?> directKillerType, String cause, class_1299<?> victimType) {
            this.killerType = killerType;
            this.directKillerType = directKillerType;
            this.cause = cause;
            this.victimType = victimType;
        }

        public int hashCode() {
            return Objects.hash(this.cause, this.directKillerType, this.killerType, this.victimType);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AutoDeathStatKey other = (AutoDeathStatKey)obj;
            return Objects.equals(this.cause, other.cause) && Objects.equals(this.directKillerType, other.directKillerType) && Objects.equals(this.killerType, other.killerType) && Objects.equals(this.victimType, other.victimType);
        }
    }

    private static final class DeathInfoLoggingItem {
        private static final Pattern PATTERN = Pattern.compile("^(?<killer>[!a-zA-Z_]*|\\*)??(\\+(?<directKiller>[!a-zA-Z_]*|\\*))??(\\((?<cause>[!a-zA-Z_\\.]*|\\*)\\))??\\-\\>(?<victim>[!a-zA-Z_]*|\\*)??(@(?<min>[0-9\\.]+)??\\.\\.(?<max>[0-9\\.]+)??)?$");
        private static final ImmutableSet<String> DAMAGE_NAMES;
        private static final Supplier<Stream<String>> ENTITY_TYPES_PROVIDER;
        private final Predicate<class_1282> damageValid;
        private final Predicate<class_1297> victimValid;
        private final FloatPredicate amountValid;
        private final String strRep;
        final Map<String, WrappedPath> damageDetails = Maps.newTreeMap();
        final Map<String, WrappedPath> victimDetails = Maps.newTreeMap();
        private int triggerCount = 0;
        private boolean visible = true;

        private DeathInfoLoggingItem(Predicate<class_1282> damageValid, Predicate<class_1297> victimValid, FloatPredicate amountPred, String strRep) {
            this.damageValid = damageValid;
            this.victimValid = victimValid;
            this.amountValid = amountPred;
            this.strRep = strRep;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        void increaseTriggerCount() {
            ++this.triggerCount;
        }

        int getTriggerCount() {
            return this.triggerCount;
        }

        void resetTriggerCount() {
            this.triggerCount = 0;
        }

        static DeathInfoLoggingItem parse(String in) {
            Matcher matcher = PATTERN.matcher(in);
            if (!matcher.matches()) {
                throw new TranslatableException("cmd.logdeath.fmterr");
            }
            Predicate<class_1297> killerPred = DeathInfoLoggingItem.parseEntityPredicate(matcher.group("killer"), true);
            Predicate<class_1297> directKillerPred = DeathInfoLoggingItem.parseEntityPredicate(matcher.group("directKiller"), true);
            Predicate<String> causePred = DeathInfoLoggingItem.parseSourceNamePredicate(matcher.group("cause"));
            Predicate<class_1297> victimPred = DeathInfoLoggingItem.parseEntityPredicate(matcher.group("victim"), false);
            FloatPredicate amountPred = DeathInfoLoggingItem.parseAmountPred(matcher.group("min"), matcher.group("max"));
            Predicate<class_1282> damagePred = ds -> killerPred.test(ds.method_5529()) && directKillerPred.test(ds.method_5526()) && causePred.test(ds.field_5841);
            return new DeathInfoLoggingItem(damagePred, victimPred, amountPred, in);
        }

        private static FloatPredicate parseAmountPred(String minStr, String maxStr) {
            if (minStr != null && maxStr == null) {
                float min = Float.parseFloat(minStr);
                return v -> v >= min;
            }
            if (minStr == null && maxStr != null) {
                float max = Float.parseFloat(maxStr);
                return v -> v <= max;
            }
            if (minStr != null && maxStr != null) {
                float min = Float.parseFloat(minStr);
                float max = Float.parseFloat(maxStr);
                return v -> v <= max && v >= min;
            }
            return v -> true;
        }

        private static Predicate<class_1297> parseEntityPredicate(String in, boolean nullable) {
            if ("null".equals(in)) {
                if (nullable) {
                    return e -> e == null;
                }
                throw new TranslatableException("cmd.logdeath.nonnull");
            }
            if (in == null || in.isEmpty() || "*".equals(in)) {
                return e -> true;
            }
            Optional type = class_1299.method_5898((String)in.replace("!", ""));
            if (!type.isPresent()) {
                throw new TranslatableException("cmd.logdeath.noentype", in.replace("!", ""));
            }
            class_1299 t0 = (class_1299)type.get();
            return in.charAt(0) == '!' ? e -> e == null || e.method_5864() != t0 : e -> e != null && e.method_5864() == t0;
        }

        private static Predicate<String> parseSourceNamePredicate(String in) {
            if (in == null || in.isEmpty() || "*".equals(in)) {
                return e -> true;
            }
            if (in.charAt(0) != '!') {
                return s -> !s.equals(in.substring(1));
            }
            return s -> s.equals(in);
        }

        static void buildSuggestions(String in, SuggestionsBuilder sb) {
            int i;
            SuggestionPhase currentPhase = SuggestionPhase.KILLER;
            block5: for (i = in.length() - 1; i >= 0; --i) {
                switch (in.charAt(i)) {
                    case ')': 
                    case '-': 
                    case '>': {
                        currentPhase = SuggestionPhase.VICTIM;
                        break block5;
                    }
                    case '(': {
                        currentPhase = SuggestionPhase.CAUSE_NAME;
                        break block5;
                    }
                    case '+': {
                        currentPhase = SuggestionPhase.DIRECT_KILLER;
                        break block5;
                    }
                    default: {
                        continue block5;
                    }
                }
            }
            currentPhase.buildSuggestions(sb, i);
        }

        public boolean test(class_1282 damage, class_1297 victim, float amount) {
            return this.damageValid.test(damage) && this.victimValid.test(victim) && this.amountValid.test(amount);
        }

        public int hashCode() {
            return Objects.hash(this.strRep);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DeathInfoLoggingItem other = (DeathInfoLoggingItem)obj;
            return Objects.equals(this.strRep, other.strRep);
        }

        static {
            ENTITY_TYPES_PROVIDER = () -> Reflection.ENTITY_TYPE_TO_CLASS.keySet().stream().map(class_1299::method_5890).map(class_2960::method_12832);
            ImmutableSet.Builder b = ImmutableSet.builder();
            for (Field f : class_1282.class.getFields()) {
                if (f.getType() != class_1282.class || (f.getModifiers() & 1) == 0 || (f.getModifiers() & 8) == 0) continue;
                try {
                    b.add((Object)((class_1282)f.get(null)).field_5841);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            b.add((Object)"sting");
            b.add((Object)"mob");
            b.add((Object)"player");
            b.add((Object)"arrow");
            b.add((Object)"trident");
            b.add((Object)"fireworks");
            b.add((Object)"fireball");
            b.add((Object)"witherSkull");
            b.add((Object)"thrown");
            b.add((Object)"indirectMagic");
            b.add((Object)"thorns");
            b.add((Object)"explosion.player");
            b.add((Object)"explosion");
            DAMAGE_NAMES = b.build();
        }

        private static enum SuggestionPhase {
            KILLER(ENTITY_TYPES_PROVIDER, true, "+", "->", "("),
            DIRECT_KILLER(ENTITY_TYPES_PROVIDER, true, "->", "("),
            CAUSE_NAME(() -> DAMAGE_NAMES.stream(), false, ")->"),
            VICTIM(ENTITY_TYPES_PROVIDER, false, "@"),
            DAMAGE_RANGE(() -> Stream.of("1.."), false, new String[0]);

            private final Supplier<Stream<String>> mainSuggestionProvider;
            private boolean suggestsNull;
            private String[] others;

            private SuggestionPhase(Supplier<Stream<String>> mainSuggestionProvider, boolean suggestsNull, String ... others) {
                this.mainSuggestionProvider = mainSuggestionProvider;
                this.suggestsNull = suggestsNull;
                this.others = others;
            }

            void buildSuggestions(SuggestionsBuilder sb, int suggestionStart) {
                String done = sb.getRemaining().substring(0, suggestionStart + 1);
                this.mainSuggestionProvider.get().forEach(item -> sb.suggest(done + item));
                if (this.suggestsNull) {
                    sb.suggest(done + "null");
                }
                for (String item2 : this.others) {
                    sb.suggest(done + item2);
                }
            }
        }
    }
}

