/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.command;

import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.netty.util.internal.StringUtil;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.File;
import java.io.FileWriter;
import java.io.Flushable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.command.CommandUtil;
import lovexyn0827.mess.command.FilteredSetArgumentType;
import lovexyn0827.mess.log.CsvWriter;
import lovexyn0827.mess.mixins.NetworkStateAccessor;
import lovexyn0827.mess.util.deobfuscating.Mapping;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2539;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogPacketCommand {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, Class<?>> SUBSCRIBED_TYPES = Maps.newConcurrentMap();
    private static final Map<String, Class<?>> PACKET_TYPES = Maps.newHashMap();
    private static volatile PacketRecorder packetRecorder = null;
    private static final Object2LongMap<Class<?>> STATS = Object2LongMaps.synchronize((Object2LongMap)new Object2LongOpenHashMap());

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"logpacket").requires(CommandUtil.COMMAND_REQUMENT)).then(class_2170.method_9247((String)"sub").then(class_2170.method_9244((String)"type", FilteredSetArgumentType.of(PACKET_TYPES.keySet(), o -> o)).executes(ct -> {
            Set<String> classes = FilteredSetArgumentType.getFiltered(ct, "type");
            if (classes.isEmpty()) {
                CommandUtil.error((CommandContext<? extends class_2168>)ct, "cmd.general.nomatching");
                return 0;
            }
            classes.forEach(cn -> SUBSCRIBED_TYPES.put((String)cn, PACKET_TYPES.get(cn)));
            CommandUtil.feedbackWithArgs((CommandContext<? extends class_2168>)ct, "cmd.general.submulti", classes.size(), classes);
            return 1;
        })))).then(class_2170.method_9247((String)"unsub").then(class_2170.method_9244((String)"type", FilteredSetArgumentType.of(PACKET_TYPES.keySet(), o -> o)).executes(ct -> {
            Set<String> classes = FilteredSetArgumentType.getFiltered(ct, "type");
            if (classes.isEmpty()) {
                CommandUtil.error((CommandContext<? extends class_2168>)ct, "cmd.general.nomatching");
                return 0;
            }
            classes.forEach(SUBSCRIBED_TYPES::remove);
            CommandUtil.feedbackWithArgs((CommandContext<? extends class_2168>)ct, "cmd.general.unsubmulti", classes.size(), classes);
            return 1;
        })))).then(class_2170.method_9247((String)"startRecording").then(class_2170.method_9244((String)"format", (ArgumentType)StringArgumentType.word()).suggests(CommandUtil.immutableSuggestions("csv")).then(class_2170.method_9244((String)"saveTo", (ArgumentType)StringArgumentType.greedyString()).executes(ct -> {
            CsvRecorder rec;
            String fmt;
            if (packetRecorder != null) {
                CommandUtil.errorWithArgs((CommandContext<? extends class_2168>)ct, "cmd.general.alstartlog", new Object[0]);
                return 0;
            }
            File out = new File(StringArgumentType.getString((CommandContext)ct, (String)"saveTo"));
            if (out.exists()) {
                CommandUtil.errorWithArgs((CommandContext<? extends class_2168>)ct, "cmd.general.alexist", out);
                return 0;
            }
            switch (fmt = StringArgumentType.getString((CommandContext)ct, (String)"format")) {
                case "csv": {
                    rec = new CsvRecorder();
                    break;
                }
                default: {
                    CommandUtil.errorWithArgs((CommandContext<? extends class_2168>)ct, "cmd.general.nodef", fmt);
                    return 0;
                }
            }
            try {
                rec.start(out);
            }
            catch (IOException e) {
                LOGGER.error("Failed to start recording!", (Throwable)e);
                LOGGER.info("Recording file: {}", (Object)out.getAbsolutePath());
                CommandUtil.error((CommandContext<class_2168>)ct, "cmd.general.unexpected", e);
                return 0;
            }
            packetRecorder = rec;
            CommandUtil.feedback((CommandContext<? extends class_2168>)ct, "cmd.general.success");
            return 1;
        }))))).then(class_2170.method_9247((String)"stopRecording").executes(ct -> {
            PacketRecorder rec = packetRecorder;
            try {
                rec.close();
            }
            catch (Exception e) {
                LOGGER.error("Failed to stop recording!", (Throwable)e);
                CommandUtil.error((CommandContext<class_2168>)ct, "cmd.general.unexpected", e);
                return 0;
            }
            packetRecorder = null;
            CommandUtil.feedbackWithArgs((CommandContext<? extends class_2168>)ct, "cmd.general.success", new Object[0]);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"stats").then(class_2170.method_9247((String)"reset").executes(ct -> {
            STATS.clear();
            CommandUtil.feedbackWithArgs((CommandContext<? extends class_2168>)ct, "cmd.general.success", new Object[0]);
            return 1;
        }))).executes(ct -> {
            STATS.forEach((clz, count) -> {
                if (count != 0L) {
                    String className = MessMod.INSTANCE.getMapping().simpleNamedClass((Class<?>)clz);
                    CommandUtil.feedbackRawWithArgs((CommandContext<? extends class_2168>)ct, "%s: %d", className, count);
                }
            });
            return 1;
        })).then(class_2170.method_9244((String)"types", FilteredSetArgumentType.of(PACKET_TYPES.keySet(), o -> o)).executes(ct -> {
            FilteredSetArgumentType.getFiltered(ct, "types").forEach(className -> {
                Class<?> pktClz = PACKET_TYPES.get(className);
                long count = STATS.getOrDefault(pktClz, 0L);
                if (count != 0L) {
                    String shortClzName = MessMod.INSTANCE.getMapping().simpleNamedClass(pktClz);
                    CommandUtil.feedbackRawWithArgs((CommandContext<? extends class_2168>)ct, "%s: %d", shortClzName, count);
                }
            });
            return 1;
        })));
        dispatcher.register(command);
    }

    public static boolean isSubscribed(class_2596<?> packet) {
        return SUBSCRIBED_TYPES.values().contains(packet.getClass());
    }

    public static void onPacket(class_2598 side, class_2596<?> packet, boolean sending) {
        STATS.computeLong(packet.getClass(), (clz, original) -> (original == null ? 0L : original) + 1L);
        String strRep = LogPacketCommand.toString(packet);
        LOGGER.info(sending ? "{}: Sended Packet: {}" : "", (Object)(side == class_2598.field_11942 ? "CLIENT" : "SERVER"), (Object)LogPacketCommand.toString(packet));
        if (packetRecorder != null) {
            try {
                packetRecorder.onPacket(side, packet, strRep, sending);
            }
            catch (IOException e) {
                LOGGER.error("Failed to record a packet!", (Throwable)e);
            }
        }
    }

    private static String toString(class_2596<?> packet) {
        Mapping mapping = MessMod.INSTANCE.getMapping();
        StringBuilder sb = new StringBuilder(mapping.simpleNamedClass(packet.getClass().getName()));
        sb.append('[');
        for (Field f : packet.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            try {
                sb.append(mapping.namedField(f.getName())).append('=').append(f.get(packet)).append(',');
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public static void reset() {
        SUBSCRIBED_TYPES.clear();
        STATS.clear();
        if (packetRecorder != null) {
            try {
                packetRecorder.close();
            }
            catch (Exception e) {
                LOGGER.error("Failed to stop recording!", (Throwable)e);
            }
            packetRecorder = null;
        }
    }

    static {
        try {
            Mapping mapping = MessMod.INSTANCE.getMapping();
            for (class_2539 state : class_2539.values()) {
                Map<class_2598, class_2539.class_4532<?>> handlerMap = ((NetworkStateAccessor)state).getHandlerMap();
                handlerMap.values().forEach(handler -> {
                    try {
                        Iterable classes = handler.method_22309();
                        for (Class clazz : classes) {
                            PACKET_TYPES.put(mapping.simpleNamedClass(clazz.getName()), clazz);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static interface PacketRecorder
    extends AutoCloseable,
    Flushable {
        public void start(File var1) throws IOException;

        public void onPacket(class_2598 var1, class_2596<?> var2, String var3, boolean var4) throws IOException;
    }

    private static class CsvRecorder
    implements PacketRecorder {
        private CsvWriter csv;

        private CsvRecorder() {
        }

        @Override
        public void close() throws Exception {
            this.csv.close();
        }

        @Override
        public void flush() throws IOException {
            this.csv.flush();
        }

        @Override
        public void start(File file) throws IOException {
            CsvWriter csv;
            FileWriter recOut = new FileWriter(file);
            this.csv = csv = new CsvWriter.Builder().addColumn("Time").addColumn("Nano").addColumn("Side").addColumn("Direction").addColumn("Class").addColumn("Detail").build(recOut);
        }

        @Override
        public void onPacket(class_2598 side, class_2596<?> packet, String strRep, boolean sending) throws IOException {
            this.csv.println(System.currentTimeMillis(), System.nanoTime(), side == class_2598.field_11942 ? "Client" : "Server", sending ? "Sending" : "Receiving", MessMod.INSTANCE.getMapping().namedClass(packet.getClass().getCanonicalName()), StringUtil.escapeCsv((CharSequence)strRep));
        }
    }
}

