/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.BiConsumer;
import lovexyn0827.mess.command.CommandUtil;
import net.minecraft.class_1936;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2257;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class TouchCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"touch").requires(CommandUtil.COMMAND_REQUMENT)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"from", (ArgumentType)class_2262.method_9698()).executes(ct -> {
            class_2338 pos = class_2262.method_9697((CommandContext)ct, (String)"from");
            class_3218 world = ((class_2168)ct.getSource()).method_9225();
            TouchCommand.performFullUpdates(pos, world);
            CommandUtil.feedback((CommandContext<? extends class_2168>)ct, "cmd.general.success");
            return 1;
        })).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"to", (ArgumentType)class_2262.method_9698()).executes(ct -> {
            TouchCommand.forEachPos((CommandContext<class_2168>)ct, TouchCommand::performFullUpdates);
            CommandUtil.feedback((CommandContext<? extends class_2168>)ct, "cmd.general.success");
            return 1;
        })).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"nc").executes(ct -> {
            TouchCommand.forEachPos((CommandContext<class_2168>)ct, TouchCommand::ncUpdateInAllDirections);
            CommandUtil.feedback((CommandContext<? extends class_2168>)ct, "cmd.general.success");
            return 1;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"srcPos", (ArgumentType)class_2262.method_9698()).executes(ct -> {
            class_2338 srcPos = class_2262.method_9697((CommandContext)ct, (String)"srcPos");
            TouchCommand.forEachPos((CommandContext<class_2168>)ct, (pos, world) -> {
                class_2680 srcBlock = world.method_8320(srcPos);
                world.method_8492(srcPos, srcBlock.method_26204(), pos);
            });
            CommandUtil.feedback((CommandContext<? extends class_2168>)ct, "cmd.general.success");
            return 1;
        })).then(class_2170.method_9244((String)"srcBlock", (ArgumentType)class_2257.method_9653()).executes(ct -> {
            class_2338 srcPos = class_2262.method_9697((CommandContext)ct, (String)"srcPos");
            class_2248 srcBlock = class_2257.method_9655((CommandContext)ct, (String)"srcBlock").method_9494().method_26204();
            TouchCommand.forEachPos((CommandContext<class_2168>)ct, (pos, world) -> world.method_8492(srcPos, srcBlock, pos));
            CommandUtil.feedback((CommandContext<? extends class_2168>)ct, "cmd.general.success");
            return 1;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"pp").executes(ct -> {
            TouchCommand.forEachPos((CommandContext<class_2168>)ct, (pos, world) -> {
                class_2680 state = world.method_8320(pos);
                TouchCommand.ppUpdate(world, pos, state, state, 3, 512);
            });
            CommandUtil.feedback((CommandContext<? extends class_2168>)ct, "cmd.general.success");
            return 1;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"maxUpdateDepth", (ArgumentType)IntegerArgumentType.integer()).executes(ct -> {
            int maxUpdateDepth = IntegerArgumentType.getInteger((CommandContext)ct, (String)"maxUpdateDepth");
            TouchCommand.forEachPos((CommandContext<class_2168>)ct, (pos, world) -> {
                class_2680 state = world.method_8320(pos);
                TouchCommand.ppUpdate(world, pos, state, state, 3, maxUpdateDepth);
            });
            CommandUtil.feedback((CommandContext<? extends class_2168>)ct, "cmd.general.success");
            return 1;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"flags", (ArgumentType)IntegerArgumentType.integer()).executes(ct -> {
            int maxUpdateDepth = IntegerArgumentType.getInteger((CommandContext)ct, (String)"maxUpdateDepth");
            int flags = IntegerArgumentType.getInteger((CommandContext)ct, (String)"flags");
            TouchCommand.forEachPos((CommandContext<class_2168>)ct, (pos, world) -> {
                class_2680 state = world.method_8320(pos);
                TouchCommand.ppUpdate(world, pos, state, state, flags, maxUpdateDepth);
            });
            CommandUtil.feedback((CommandContext<? extends class_2168>)ct, "cmd.general.success");
            return 1;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"oldState", (ArgumentType)class_2257.method_9653()).executes(ct -> {
            int maxUpdateDepth = IntegerArgumentType.getInteger((CommandContext)ct, (String)"maxUpdateDepth");
            int flags = IntegerArgumentType.getInteger((CommandContext)ct, (String)"flags");
            class_2680 oldState = class_2257.method_9655((CommandContext)ct, (String)"oldState").method_9494();
            TouchCommand.forEachPos((CommandContext<class_2168>)ct, (pos, world) -> {
                class_2680 state = world.method_8320(pos);
                TouchCommand.ppUpdate(world, pos, oldState, state, flags, maxUpdateDepth);
            });
            CommandUtil.feedback((CommandContext<? extends class_2168>)ct, "cmd.general.success");
            return 1;
        })).then(class_2170.method_9244((String)"newState", (ArgumentType)class_2257.method_9653()).executes(ct -> {
            int maxUpdateDepth = IntegerArgumentType.getInteger((CommandContext)ct, (String)"maxUpdateDepth");
            int flags = IntegerArgumentType.getInteger((CommandContext)ct, (String)"flags");
            class_2680 oldState = class_2257.method_9655((CommandContext)ct, (String)"oldState").method_9494();
            class_2680 newState = class_2257.method_9655((CommandContext)ct, (String)"oldState").method_9494();
            TouchCommand.forEachPos((CommandContext<class_2168>)ct, (pos, world) -> TouchCommand.ppUpdate(world, pos, oldState, newState, flags, maxUpdateDepth));
            CommandUtil.feedback((CommandContext<? extends class_2168>)ct, "cmd.general.success");
            return 1;
        }))))))));
        dispatcher.register(command);
    }

    private static void performFullUpdates(class_2338 pos, class_3218 world) {
        TouchCommand.ncUpdateInAllDirections(pos, world);
        for (class_2350 dir : class_2350.values()) {
            class_2338 srcPos = pos.method_10093(dir);
            class_2680 srcBlock = world.method_8320(srcPos);
            TouchCommand.ppUpdate(world, srcPos, srcBlock, srcBlock, 3, 512);
        }
    }

    private static void ncUpdateInAllDirections(class_2338 pos, class_3218 world) {
        for (class_2350 dir : class_2350.values()) {
            class_2338 srcPos = pos.method_10093(dir);
            class_2680 srcBlock = world.method_8320(srcPos);
            world.method_8492(srcPos, srcBlock.method_26204(), pos);
        }
        class_2680 srcBlock = world.method_8320(pos);
        world.method_8492(pos, srcBlock.method_26204(), pos);
    }

    private static void ppUpdate(class_3218 world, class_2338 pos, class_2680 oldState, class_2680 newState, int flags, int maxUpdateDepth) {
        int i = flags & 0xFFFFFFDE;
        oldState.method_26198((class_1936)world, pos, i, maxUpdateDepth - 1);
        newState.method_26183((class_1936)world, pos, i, maxUpdateDepth - 1);
        newState.method_26198((class_1936)world, pos, i, maxUpdateDepth - 1);
    }

    private static void forEachPos(CommandContext<class_2168> ct, BiConsumer<class_2338, class_3218> action) throws CommandSyntaxException {
        class_2338 from = class_2262.method_9697(ct, (String)"from");
        class_2338 to = class_2262.method_9697(ct, (String)"to");
        class_3218 world = ((class_2168)ct.getSource()).method_9225();
        for (class_2338 pos : class_2338.method_10097((class_2338)from, (class_2338)to)) {
            action.accept(pos, world);
        }
    }
}

