/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.electronic;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.electronic.Oscilscope;
import lovexyn0827.mess.electronic.OscilscopeDataStorage;
import lovexyn0827.mess.util.FormattedText;
import lovexyn0827.mess.util.ServerMicroTime;
import lovexyn0827.mess.util.i18n.I18N;
import lovexyn0827.mess.util.phase.ServerTickingPhase;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1159;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public final class OscilscopeScreen
extends class_437 {
    private static final int VALID_TICKING_STAGE_COUNT = (int)Arrays.stream(ServerTickingPhase.values()).filter(phase -> !phase.notInAnyWorld).count();
    private static final Object2IntMap<ServerTickingPhase> VALID_TICKING_STAGE_INDICES = (Object2IntMap)class_156.method_656(() -> {
        int idx = 0;
        Object2IntOpenHashMap result = new Object2IntOpenHashMap();
        for (ServerTickingPhase phase : ServerTickingPhase.values()) {
            if (phase.notInAnyWorld) continue;
            result.put((Object)phase, idx++);
        }
        return result;
    });
    private WaveArea waveArea;
    private TrigHistory trigHistory;
    private ChannelList channelList;
    private final OscilscopeDataStorage waveData = OscilscopeDataStorage.get();
    private class_4185 modeBtn;
    private boolean digitalMode = false;
    private class_4286 tickAlignedBtn;
    private class_342 stroageDepth;
    private class_4185 resetBtn;
    private class_357 waveTransparancySlider;
    private int waveTransparancy;

    public OscilscopeScreen() {
        super(I18N.translateAsText("oscilscope.gui.title"));
    }

    public void method_25426() {
        this.field_22789 = this.field_22787.method_22683().method_4486();
        this.field_22790 = this.field_22787.method_22683().method_4502();
        this.updateWaveArea();
        this.trigHistory = new TrigHistory();
        this.channelList = new ChannelList();
        this.method_37063((class_364)this.trigHistory);
        this.method_37063((class_364)this.channelList);
        this.waveData.takeNewChannels(ch -> {});
        this.waveData.takeUnprocessedTriggers(trig -> {});
        this.waveData.getAllChannels().forEach(this::onNewChannel);
        this.waveData.getTriggerHistory().forEach(this.trigHistory::onTrig);
        this.modeBtn = new class_4185((int)((double)this.field_22789 * 0.5) - 90, (int)((double)this.field_22790 * 0.6) + 16, 80, 20, I18N.translateAsText(this.digitalMode ? "oscil.gui.mode.digital" : "oscil.gui.mode.analog"), btn -> {
            this.digitalMode ^= true;
            btn.method_25355(I18N.translateAsText(this.digitalMode ? "oscil.gui.mode.digital" : "oscil.gui.mode.analog"));
            this.updateWaveArea();
            MessMod.INSTANCE.getOscilscope().setDigitalMode(this.digitalMode);
        });
        this.method_25429((class_364)this.modeBtn);
        this.tickAlignedBtn = new class_4286((int)((double)this.field_22789 * 0.5) + 10, (int)((double)this.field_22790 * 0.6) + 16, 80, 20, I18N.translateAsText("oscil.gui.tickaligned"), false);
        this.method_25429((class_364)this.tickAlignedBtn);
        this.stroageDepth = new class_342(this.field_22793, (int)((double)this.field_22789 * 0.5) - 90, (int)((double)this.field_22790 * 0.6) + 38, 80, 20, I18N.translateAsText("oscil.gui.storage"));
        this.stroageDepth.method_1890(in -> in.matches("^[0-9]*$"));
        this.stroageDepth.method_1863(in -> {
            if (!in.isEmpty()) {
                this.waveData.setStorageDepth(Integer.parseInt(in));
            }
        });
        this.stroageDepth.method_1852(Integer.toString(this.waveData.getStorageDepth()));
        this.method_37063((class_364)this.stroageDepth);
        this.resetBtn = new class_4185((int)((double)this.field_22789 * 0.5) + 10, (int)((double)this.field_22790 * 0.6) + 38, 80, 20, I18N.translateAsText("oscil.gui.reset"), btn -> {
            this.waveData.reset();
            this.trigHistory.reset();
            this.waveArea.leftTick = MessMod.INSTANCE.getGameTime();
        });
        this.method_25429((class_364)this.resetBtn);
        this.waveTransparancySlider = new class_357((int)((double)this.field_22789 * 0.5) - 90, (int)((double)this.field_22790 * 0.6) + 60, 180, 20, class_2561.method_30163((String)String.format("%d / %d", this.waveTransparancy, 255)), this.waveTransparancy){

            protected void method_25346() {
                this.method_25355(class_2561.method_30163((String)String.format("%d / %d", (int)(this.field_22753 * 255.0), 255)));
            }

            protected void method_25344() {
                OscilscopeScreen.this.waveTransparancy = (int)(this.field_22753 * 255.0);
            }
        };
        this.method_37063((class_364)this.waveTransparancySlider);
    }

    private void updateWaveArea() {
        this.method_25396().remove(this.waveArea);
        this.waveArea = this.digitalMode ? new DigitalWaveArea() : new AnalogWaveArea();
        this.method_37060(this.waveArea);
        this.waveArea.recalculateWaveAreaParameters();
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.waveData.takeNewChannels(this::onNewChannel);
        this.waveData.takeUnprocessedTriggers(this::onTrig);
        this.method_25420(matrices);
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.trigHistory.method_25394(matrices, mouseX, mouseY, delta);
        this.channelList.method_25394(matrices, mouseX, mouseY, delta);
        this.modeBtn.method_25394(matrices, mouseX, mouseY, delta);
        this.tickAlignedBtn.method_25394(matrices, mouseX, mouseY, delta);
        this.stroageDepth.method_25394(matrices, mouseX, mouseY, delta);
        this.resetBtn.method_25394(matrices, mouseX, mouseY, delta);
        this.waveTransparancySlider.method_25394(matrices, mouseX, mouseY, delta);
        this.waveArea.method_25394(matrices, mouseX, mouseY, delta);
    }

    private void onTrig(Oscilscope.Trigger trig) {
        this.waveArea.scrollToTrig(trig.time.gameTime);
        this.trigHistory.onTrig(trig);
    }

    private void onNewChannel(Oscilscope.Channel channel) {
        this.channelList.newChannel(channel);
    }

    @NotNull
    private class_364 getHoveringElement(double mouseX, double mouseY) {
        for (class_364 e : this.method_25396()) {
            if (!e.method_25405(mouseX, mouseY)) continue;
            return e;
        }
        if (mouseY > (double)this.field_22790 * 0.6 + 16.0) {
            return mouseY > (double)(this.field_22789 / 2) ? this.channelList : this.trigHistory;
        }
        return this.waveArea;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return super.method_25402(mouseX, mouseY, button) || this.getHoveringElement(mouseX, mouseY).method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return super.method_25406(mouseX, mouseY, button) || this.getHoveringElement(mouseX, mouseY).method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY) || this.getHoveringElement(mouseX, mouseY).method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        return super.method_25401(mouseX, mouseY, amount) || this.getHoveringElement(mouseX, mouseY).method_25401(mouseX, mouseY, amount);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25421() {
        return false;
    }

    private final class TrigHistory
    extends CustomPositionEntryListWidget<Entry> {
        public TrigHistory() {
            super(8, (int)((double)OscilscopeScreen.this.field_22790 * 0.6) + 12, (int)((double)OscilscopeScreen.this.field_22790 * 0.4) - 24, (int)((double)OscilscopeScreen.this.field_22789 * 0.5) - 108, 12);
        }

        public void reset() {
            this.method_25339();
        }

        void onTrig(Oscilscope.Trigger trig) {
            this.method_25321((class_350.class_351)new Entry(trig));
        }

        private final class Entry
        extends class_4280.class_4281<Entry> {
            private final Oscilscope.Trigger trig;

            public Entry(Oscilscope.Trigger trig) {
                this.trig = trig;
            }

            public void method_25343(class_4587 ms, int j, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovering, float var10) {
                class_5250 text = this.trig.rising ? new FormattedText("\u2b06 ", "rcl", false, new Object[0]).asMutableText() : new FormattedText("\u2b07 ", "ral", false, new Object[0]).asMutableText();
                text.method_10852((class_2561)new FormattedText("oscil.gui.triginf", "rf", true, this.trig.channel.getId(), this.trig.time.gameTime).asMutableText());
                class_332.method_27535((class_4587)ms, (class_327)OscilscopeScreen.this.field_22793, (class_2561)text, (int)x, (int)y, (int)mouseY);
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                OscilscopeScreen.this.waveArea.scrollToTrig(this.trig.time.gameTime);
                return true;
            }

            public class_2561 method_37006() {
                return class_2561.method_30163((String)"");
            }
        }
    }

    private final class ChannelList
    extends CustomPositionEntryListWidget<Entry> {
        private List<class_2561> tooltip;

        public ChannelList() {
            super((int)((double)OscilscopeScreen.this.field_22789 * 0.5) + 100, (int)((double)OscilscopeScreen.this.field_22790 * 0.6) + 12, (int)((double)OscilscopeScreen.this.field_22790 * 0.4) - 24, (int)((double)OscilscopeScreen.this.field_22789 * 0.5) - 108, 22);
        }

        void newChannel(Oscilscope.Channel channel) {
            this.method_25321((class_350.class_351)new Entry(channel));
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            this.tooltip = null;
            super.method_25394(matrices, mouseX, mouseY, delta);
            if (this.tooltip != null) {
                OscilscopeScreen.this.method_30901(matrices, this.tooltip, mouseX, mouseY);
            }
        }

        private final class Entry
        extends class_4280.class_4281<Entry> {
            private final Oscilscope.Channel backend;
            private final class_4185 trigMode;
            private final class_342 trigLevel;
            private final class_4286 show;
            private final class_4286 active;

            public Entry(Oscilscope.Channel backend) {
                this.backend = backend;
                this.trigMode = new class_4185(ChannelList.this.field_19088 + 23, 1, 20, 20, this.getTrigModeIndicator(), btn -> {
                    int prevTrigModeOrd = backend.getTrigMode().ordinal();
                    int newTrigModeOrd = (prevTrigModeOrd + 1) % Oscilscope.TrigMode.values().length;
                    Oscilscope.TrigMode newTrigMode = Oscilscope.TrigMode.values()[newTrigModeOrd];
                    this.backend.setTrigMode(newTrigMode);
                    btn.method_25355(this.getTrigModeIndicator());
                });
                this.trigLevel = new class_342(OscilscopeScreen.this.field_22793, ChannelList.this.field_19088 + 47, 4, 20, 14, class_2561.method_30163((String)Integer.toString(this.backend.getTrigLevel())));
                this.trigLevel.method_1890(in -> in.matches("^[+-]?[0-9]*$"));
                this.trigLevel.method_1863(in -> {
                    if (!in.isEmpty()) {
                        this.backend.setTrigLevel(Integer.parseInt(in));
                    }
                });
                this.trigLevel.method_1852(Integer.toString(this.backend.getTrigLevel()));
                this.show = new class_4286(ChannelList.this.field_19088 + 71, 1, 20, 20, class_2561.method_30163((String)I18N.translateAsText("oscil.gui.show").method_10858(2)), this.backend.isVisible()){

                    public void method_25306() {
                        super.method_25306();
                        Entry.this.backend.setVisible(this.method_20372());
                    }
                };
                int lengthOfShow = ((ChannelList)ChannelList.this).field_22740.field_1772.method_1727(I18N.translateAsText("oscil.gui.show").method_10858(2));
                this.active = new class_4286(ChannelList.this.field_19088 + 100 + lengthOfShow, 1, 20, 20, class_2561.method_30163((String)I18N.translateAsText("oscil.gui.active").method_10858(2)), this.backend.isUpdatingActively()){

                    public void method_25306() {
                        super.method_25306();
                        Entry.this.backend.setActiveUpdate(this.method_20372());
                    }
                };
                this.backend.setChangeListener(ch -> this.trigLevel.method_1852(Integer.toString(ch.getTrigLevel())));
            }

            private class_2561 getTrigModeIndicator() {
                switch (this.backend.getTrigMode()) {
                    case BOTH: {
                        return new FormattedText("\u2b06", "rcl").asMutableText().method_10852((class_2561)new FormattedText("\u2b07", "ral").asMutableText());
                    }
                    case FALLING: {
                        return new FormattedText("\u2b07", "ral").asMutableText();
                    }
                    case NONE: {
                        return new FormattedText("\u2715", "rcl").asMutableText();
                    }
                    case RISING: {
                        return new FormattedText("\u2b06", "rcl").asMutableText();
                    }
                }
                throw new IllegalStateException();
            }

            public int hashCode() {
                return Objects.hash(this.backend);
            }

            public boolean equals(Object other) {
                return other instanceof Entry && this.backend.equals(((Entry)((Object)other)).backend);
            }

            public void method_25343(class_4587 ms, int j, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovering, float var10) {
                class_332.method_25294((class_4587)ms, (int)(x + 2), (int)(y + 2), (int)(x + 19), (int)(y + 19), (int)-1);
                class_332.method_25294((class_4587)ms, (int)(x + 3), (int)(y + 3), (int)(x + 18), (int)(y + 18), (int)this.backend.getColor());
                this.trigMode.field_22761 = y + 1;
                this.trigLevel.field_22761 = y + 4;
                this.show.field_22761 = y + 1;
                this.active.field_22761 = y + 1;
                this.trigMode.method_25394(ms, mouseX, mouseY, var10);
                this.trigLevel.method_25394(ms, mouseX, mouseY, var10);
                this.show.method_25394(ms, mouseX, mouseY, var10);
                this.active.method_25394(ms, mouseX, mouseY, var10);
                int deltaX = mouseX - x;
                int deltaY = mouseY - y;
                if (deltaX >= 2 && deltaX <= 19 && deltaY >= 2 && deltaY <= 19) {
                    Oscilscope.Channel ch = this.backend;
                    ChannelList.this.tooltip = Lists.newArrayList((Object[])new class_2561[]{I18N.translateAsText("oscil.gui.chinf.1", ch.getId()), I18N.translateAsText("oscil.gui.chinf.2", ch.getDimensionId()), I18N.translateAsText("oscil.gui.chinf.x", ch.getPos().method_10263()), I18N.translateAsText("oscil.gui.chinf.y", ch.getPos().method_10264()), I18N.translateAsText("oscil.gui.chinf.z", ch.getPos().method_10260())});
                }
                if (deltaX >= 23 && deltaX <= 43 && deltaY >= 2 && deltaY <= 19) {
                    ChannelList.this.tooltip = Lists.newArrayList((Object[])new class_2561[]{I18N.translateAsText("oscil.gui.trigmode." + this.backend.getTrigMode().name())});
                }
                if (deltaX >= 71 && mouseX <= this.active.field_22760 && deltaY >= 2 && deltaY <= 19) {
                    ChannelList.this.tooltip = Lists.newArrayList((Object[])new class_2561[]{I18N.translateAsText("oscil.gui.show")});
                }
                if (mouseX >= this.active.field_22760 && deltaY >= 2 && deltaY <= 19) {
                    ChannelList.this.tooltip = Lists.newArrayList((Object[])new class_2561[]{I18N.translateAsText("oscil.gui.active")});
                }
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                return this.trigMode.method_25402(mouseX, mouseY, button) || this.trigLevel.method_25402(mouseX, mouseY, button) || this.show.method_25402(mouseX, mouseY, button) || this.active.method_25402(mouseX, mouseY, button);
            }

            public boolean method_25400(char chr, int keyCode) {
                return this.trigLevel.method_25400(chr, keyCode);
            }

            public boolean method_25404(int keyCode, int scanCode, int modifiers) {
                return this.trigLevel.method_25404(keyCode, scanCode, modifiers);
            }

            public class_2561 method_37006() {
                return I18N.translateAsText("oscil.gui.chinf.1", this.backend.getId());
            }
        }
    }

    private abstract class WaveArea
    implements class_364,
    class_4068 {
        protected int tickPerDiv = 1;
        protected long leftTick = MessMod.INSTANCE.getGameTime();
        protected int trigHDiv = 0;
        protected int left;
        protected int right;
        protected int top;
        protected int bottom;
        protected int pixelsPerHDiv;
        protected int hDivs;
        private boolean draggingTrigHDivMarker = false;

        private WaveArea() {
        }

        void recalculateWaveAreaParameters() {
            this.pixelsPerHDiv = VALID_TICKING_STAGE_COUNT * 3;
            this.hDivs = (OscilscopeScreen.this.field_22789 - 48) / this.pixelsPerHDiv;
            int waveAreaWidth = this.pixelsPerHDiv * this.hDivs;
            this.left = (OscilscopeScreen.this.field_22789 - waveAreaWidth) / 2;
            this.right = this.left + waveAreaWidth;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            int trigHorizontalPos = this.trigHDiv * this.pixelsPerHDiv + this.left;
            if (class_3532.method_15391((double)(mouseX - (double)trigHorizontalPos), (double)(mouseY - (double)(this.top - 5))) < 5.0) {
                this.draggingTrigHDivMarker = true;
                return true;
            }
            return false;
        }

        public boolean method_25406(double mouseX, double mouseY, int button) {
            this.draggingTrigHDivMarker = false;
            return true;
        }

        public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (this.draggingTrigHDivMarker) {
                int nearestDiv = (int)Math.round((mouseX - (double)this.left) / (double)this.pixelsPerHDiv);
                this.trigHDiv = class_3532.method_15340((int)nearestDiv, (int)0, (int)this.hDivs);
                return true;
            }
            return false;
        }

        protected int calculateNextDivLength(int prev, boolean inc, int max) {
            if (prev >= max && inc || prev == 1 && !inc) {
                return prev;
            }
            double logFrac = Math.log10(prev) - Math.floor(Math.log10(prev));
            if (logFrac > 0.4) {
                return inc ? prev * 2 : prev * 2 / 5;
            }
            if (logFrac < 0.3) {
                return inc ? prev * 2 : prev / 2;
            }
            return inc ? prev * 5 / 2 : prev / 2;
        }

        public boolean method_25401(double mouseX, double mouseY, double amount) {
            if (class_437.method_25441()) {
                int prevTickPreDiv = this.tickPerDiv;
                this.tickPerDiv = this.calculateNextDivLength(this.tickPerDiv, amount < 0.0, 1000000);
                long tickAtCursor = ((long)mouseX - (long)this.left) * (long)prevTickPreDiv / (long)this.pixelsPerHDiv + this.leftTick;
                this.leftTick = tickAtCursor - ((long)mouseX - (long)this.left) * (long)this.tickPerDiv / (long)this.pixelsPerHDiv;
            } else {
                this.leftTick = (long)((double)this.leftTick + -(class_437.method_25442() ? amount * (double)this.hDivs : amount) * (double)this.tickPerDiv);
            }
            return true;
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            switch (keyCode) {
                case 263: {
                    if (class_437.method_25441()) {
                        this.tickPerDiv = this.calculateNextDivLength(this.tickPerDiv, false, 1000000);
                    } else {
                        this.leftTick += (long)((class_437.method_25442() ? -this.hDivs : -1) * this.tickPerDiv);
                    }
                    return true;
                }
                case 262: {
                    if (class_437.method_25441()) {
                        this.tickPerDiv = this.calculateNextDivLength(this.tickPerDiv, true, 1000000);
                    } else {
                        this.leftTick += (long)((class_437.method_25442() ? this.hDivs : 1) * this.tickPerDiv);
                    }
                    return true;
                }
            }
            return false;
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            this.drawBackground(matrices);
            this.drawGrids(matrices);
            this.drawAxises(matrices);
            this.drawTrigMarkers(matrices);
            this.drawWaves(matrices, mouseX, mouseY);
            this.drawStatus(matrices);
            this.drawToolTip(matrices, mouseX, mouseY);
        }

        protected void drawToolTip(class_4587 matrices, int mouseX, int mouseY) {
        }

        protected void appendToolTipIfNeeded(List<class_2561> toolTip, int mouseX, int mouseY, int prevX, int prevY, int curX, int curY, Oscilscope.Channel channel, Oscilscope.Edge prevEdge, Oscilscope.Edge edge) {
            int minY;
            long window = OscilscopeScreen.this.field_22787.method_22683().method_4490();
            if (GLFW.glfwGetMouseButton((long)window, (int)0) != 1) {
                return;
            }
            int maxY = prevY > curY ? prevY : curY;
            int n = minY = prevY < curY ? prevY : curY;
            if (edge != null && class_3532.method_15382((int)(mouseX - curX)) <= 1 && mouseY > minY && mouseY < maxY) {
                toolTip.add(class_2561.method_30163((String)String.format("%d : %s", edge.time.gameTime, edge.time.phase)));
                toolTip.add(class_2561.method_30163((String)String.format("  CH%d: %d => %d", channel.getId(), prevEdge.newLevel, edge.newLevel)));
            } else if (class_3532.method_15382((int)(mouseY - prevY)) <= 1 && mouseX >= prevX && mouseX <= curX) {
                boolean prevInvalid;
                List<Oscilscope.Edge> wave = OscilscopeScreen.this.waveData.getWaveData().get(channel);
                int lastEdgeIdx = Collections.binarySearch(wave, prevEdge, Comparator.comparing(e -> e.time));
                if (edge == null && lastEdgeIdx < wave.size() - 1) {
                    edge = wave.get(lastEdgeIdx + 1);
                }
                boolean digitalMode = OscilscopeScreen.this.digitalMode;
                boolean bl = prevEdge.time.gameTime < 0L || digitalMode && edge != null && !(prevEdge.newLevel > 0 ^ edge.newLevel > 0) ? true : (prevInvalid = false);
                if (prevInvalid || edge == null) {
                    toolTip.add(class_2561.method_30163((String)String.format("CH%d: %d, ? gt", channel.getId(), prevEdge.newLevel)));
                } else {
                    toolTip.add(class_2561.method_30163((String)String.format("CH%d: %d, %d gt", channel.getId(), prevEdge.newLevel, edge.time.gameTime - prevEdge.time.gameTime)));
                }
                if (prevInvalid) {
                    toolTip.add(class_2561.method_30163((String)"From: ?"));
                } else {
                    toolTip.add(class_2561.method_30163((String)String.format("  From: %d @ %s", prevEdge.time.gameTime, prevEdge.time.phase)));
                }
                if (edge != null) {
                    toolTip.add(class_2561.method_30163((String)String.format("  To: %d @ %s", edge.time.gameTime, edge.time.phase)));
                } else {
                    toolTip.add(class_2561.method_30163((String)"  To: ?"));
                }
            }
        }

        protected abstract void drawStatus(class_4587 var1);

        protected void drawBackground(class_4587 matrices) {
            class_332.method_25294((class_4587)matrices, (int)this.left, (int)this.top, (int)this.right, (int)this.bottom, (int)-16777216);
        }

        protected abstract void drawWaves(class_4587 var1, int var2, int var3);

        protected int getTransformedColor(Oscilscope.Channel ch) {
            return ch.getColor() & (255 - OscilscopeScreen.this.waveTransparancy << 24 | 0xFFFFFF);
        }

        protected int calculatePosOfTime(ServerMicroTime t) {
            long relativeTime = t.gameTime - this.leftTick;
            boolean alignToTick = OscilscopeScreen.this.tickAlignedBtn.method_20372();
            long flatTime = relativeTime * (long)VALID_TICKING_STAGE_COUNT + (long)(alignToTick ? 0 : VALID_TICKING_STAGE_INDICES.getInt((Object)t.phase));
            int raw = (int)(flatTime * (long)this.pixelsPerHDiv / (long)VALID_TICKING_STAGE_COUNT / (long)this.tickPerDiv + (long)this.left);
            return class_3532.method_15340((int)raw, (int)this.left, (int)this.right);
        }

        private void drawTrigMarkers(class_4587 matrices) {
            class_1159 matrix = matrices.method_23760().method_23761();
            class_287 bufferBuilder = class_289.method_1348().method_1349();
            RenderSystem.enableBlend();
            RenderSystem.disableTexture();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableCull();
            bufferBuilder.method_1328(class_293.class_5596.field_27379, class_290.field_1576);
            this.drawTrigMarkers(matrix, bufferBuilder);
            bufferBuilder.method_1326();
            class_286.method_1309((class_287)bufferBuilder);
            RenderSystem.enableCull();
            RenderSystem.enableTexture();
            RenderSystem.disableBlend();
        }

        protected void drawTrigMarkers(class_1159 matrix, class_287 bufferBuilder) {
            int trigHorizontalPos = this.trigHDiv * this.pixelsPerHDiv + this.left;
            bufferBuilder.method_22918(matrix, (float)trigHorizontalPos, (float)this.top, 0.0f).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
            bufferBuilder.method_22918(matrix, (float)(trigHorizontalPos - 5), (float)(this.top - 5), 0.0f).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
            bufferBuilder.method_22918(matrix, (float)(trigHorizontalPos + 5), (float)(this.top - 5), 0.0f).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
        }

        protected void drawAxises(class_4587 matrices) {
            int i;
            int hStep = this.pixelsPerHDiv / VALID_TICKING_STAGE_COUNT;
            for (i = 0; i <= this.hDivs * VALID_TICKING_STAGE_COUNT; ++i) {
                OscilscopeScreen.this.method_25301(matrices, this.left + i * hStep, this.bottom, this.bottom - 2, -1);
            }
            for (i = 0; i <= this.hDivs; ++i) {
                if (i % 5 != 0) continue;
                class_332.method_25300((class_4587)matrices, (class_327)OscilscopeScreen.this.field_22793, (String)Long.toString(this.getTickAtDiv(i)), (int)(this.left + i * this.pixelsPerHDiv), (int)(this.bottom + 3), (int)-1);
                OscilscopeScreen.this.method_25301(matrices, this.left + i * this.pixelsPerHDiv, this.bottom, this.bottom - 3, -1);
            }
        }

        private long getTickAtDiv(int i) {
            return this.leftTick + (long)(i * this.tickPerDiv);
        }

        protected void drawGrids(class_4587 matrices) {
            for (int i = 0; i <= this.hDivs; ++i) {
                OscilscopeScreen.this.method_25301(matrices, this.left + i * this.pixelsPerHDiv, this.top, this.bottom, 0x3FFFFFFF);
            }
        }

        public void scrollToTrig(long gameTime) {
            this.leftTick = gameTime - (long)(this.tickPerDiv * this.trigHDiv);
        }
    }

    private final class DigitalWaveArea
    extends WaveArea {
        private int topChannelId = 0;
        private int displayedChannelCount = 0;
        private int waveHeight = 8;

        private DigitalWaveArea() {
        }

        @Override
        void recalculateWaveAreaParameters() {
            super.recalculateWaveAreaParameters();
            int maxHeight = (int)((double)OscilscopeScreen.this.field_22790 * 0.6 - 8.0);
            this.displayedChannelCount = (maxHeight - 3 * this.waveHeight) / (this.waveHeight * 2);
            int height = (this.displayedChannelCount * 2 + 3) * this.waveHeight;
            this.top = 8;
            this.bottom = this.top + height;
        }

        @Override
        protected void drawStatus(class_4587 matrices) {
            class_332.method_25300((class_4587)matrices, (class_327)OscilscopeScreen.this.field_22793, (String)String.format("%d gt / div", this.tickPerDiv), (int)(OscilscopeScreen.this.field_22789 / 2), (int)(OscilscopeScreen.this.field_22790 - 12), (int)-1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void drawWaves(class_4587 matrices, int mouseX, int mouseY) {
            long from = this.leftTick;
            long to = this.leftTick + (long)(this.hDivs * this.tickPerDiv);
            int vOffset = 0;
            ArrayList<class_2561> toolTip = new ArrayList<class_2561>();
            Map<Oscilscope.Channel, List<Oscilscope.Edge>> data = OscilscopeScreen.this.waveData.getWaveData(from, to, true);
            for (Map.Entry<Oscilscope.Channel, List<Oscilscope.Edge>> channelPair : data.entrySet()) {
                Oscilscope.Channel channel = channelPair.getKey();
                List<Oscilscope.Edge> wave = channelPair.getValue();
                int color = this.getTransformedColor(channel);
                if (wave.isEmpty() || channel.getId() < this.topChannelId) continue;
                Oscilscope.Edge prevEdge = null;
                List<Oscilscope.Edge> list = wave;
                synchronized (list) {
                    for (Oscilscope.Edge edge : wave) {
                        if (prevEdge != null) {
                            int prevX = this.calculatePosOfTime(prevEdge.time);
                            int curX = this.calculatePosOfTime(edge.time);
                            int prevY = this.getWaveY(prevEdge.newLevel > 0, vOffset);
                            int curY = this.getWaveY(edge.newLevel > 0, vOffset);
                            OscilscopeScreen.this.method_25292(matrices, prevX, curX, prevY, color);
                            OscilscopeScreen.this.method_25301(matrices, curX, prevY, curY, color);
                            this.appendToolTipIfNeeded(toolTip, mouseX, mouseY, prevX, prevY, curX, curY, channel, prevEdge, edge);
                        }
                        prevEdge = edge;
                    }
                }
                OscilscopeScreen.this.method_25292(matrices, this.calculatePosOfTime(prevEdge.time), this.calculatePosOfTime(ServerMicroTime.current()), this.getWaveY(prevEdge.newLevel > 0, vOffset), color);
                this.appendToolTipIfNeeded(toolTip, mouseX, mouseY, this.calculatePosOfTime(prevEdge.time), this.getWaveY(prevEdge.newLevel > 0, vOffset), this.right, -1, channel, prevEdge, null);
                class_332.method_25300((class_4587)matrices, (class_327)OscilscopeScreen.this.field_22793, (String)String.format("CH%d", channel.getId()), (int)(this.left / 2), (int)this.getWaveY(true, vOffset), (int)-1);
                if (++vOffset <= this.displayedChannelCount) continue;
                break;
            }
            if (!toolTip.isEmpty()) {
                OscilscopeScreen.this.method_30901(matrices, toolTip, mouseX, Math.max(mouseY, 24));
            }
        }

        private int getWaveY(boolean high, int vOffset) {
            return this.top + (vOffset * 2 - (high ? 1 : 0) + 2) * this.waveHeight;
        }

        @Override
        public boolean method_25401(double mouseX, double mouseY, double amount) {
            if (class_437.method_25443()) {
                if (class_437.method_25441()) {
                    this.waveHeight = class_3532.method_15340((int)(amount > 0.0 ? this.waveHeight * 2 : this.waveHeight / 2), (int)4, (int)16);
                    this.recalculateWaveAreaParameters();
                } else if (amount < 0.0) {
                    OscilscopeScreen.this.waveData.getAllChannels().stream().filter(Oscilscope.Channel::isVisible).filter(ch -> ch.getId() > this.topChannelId).findFirst().ifPresent(ch -> {
                        this.topChannelId = ch.getId();
                    });
                } else {
                    OscilscopeScreen.this.waveData.getAllChannels().stream().filter(Oscilscope.Channel::isVisible).filter(ch -> ch.getId() < this.topChannelId).reduce((ch0, ch1) -> ch1).ifPresent(ch -> {
                        this.topChannelId = ch.getId();
                    });
                }
            } else {
                super.method_25401(mouseX, mouseY, amount);
            }
            return true;
        }

        @Override
        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            switch (keyCode) {
                case 263: {
                    if (class_437.method_25441()) {
                        this.tickPerDiv = this.calculateNextDivLength(this.tickPerDiv, false, 1000000);
                    } else {
                        this.leftTick += (long)((class_437.method_25442() ? -this.hDivs : -1) * this.tickPerDiv);
                    }
                    return true;
                }
                case 262: {
                    if (class_437.method_25441()) {
                        this.tickPerDiv = this.calculateNextDivLength(this.tickPerDiv, true, 1000000);
                    } else {
                        this.leftTick += (long)((class_437.method_25442() ? this.hDivs : 1) * this.tickPerDiv);
                    }
                    return true;
                }
            }
            return false;
        }
    }

    private final class AnalogWaveArea
    extends WaveArea {
        private int levelPerDiv = 1;
        private int bottomLevel = 0;
        private int vDivs;
        private int pixelsPerVDiv;
        private Oscilscope.Channel draggingTrigLevelMarker = null;

        private AnalogWaveArea() {
        }

        @Override
        void recalculateWaveAreaParameters() {
            super.recalculateWaveAreaParameters();
            this.vDivs = 15;
            this.pixelsPerVDiv = (int)((double)OscilscopeScreen.this.field_22790 * 0.6 - 8.0) / this.vDivs;
            int waveAreaHeight = this.pixelsPerVDiv * this.vDivs;
            this.top = 8;
            this.bottom = this.top + waveAreaHeight;
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (super.method_25402(mouseX, mouseY, button)) {
                return true;
            }
            Optional<Oscilscope.Channel> dragging = OscilscopeScreen.this.waveData.getAllChannels().stream().filter(Oscilscope.Channel::isVisible).sorted(Comparator.comparing(Oscilscope.Channel::getId)).filter(ch -> {
                int yPos = this.bottom - (ch.getTrigLevel() - this.bottomLevel) * this.pixelsPerVDiv;
                return class_3532.method_15391((double)(mouseX - (double)(this.right + 5)), (double)(mouseY - (double)this.top - (double)yPos)) < 10.0;
            }).findFirst();
            if (dragging.isPresent()) {
                this.draggingTrigLevelMarker = dragging.get();
                return true;
            }
            return false;
        }

        @Override
        public boolean method_25406(double mouseX, double mouseY, int button) {
            super.method_25406(mouseX, mouseY, button);
            this.draggingTrigLevelMarker = null;
            return true;
        }

        @Override
        public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (super.method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
                return true;
            }
            if (this.draggingTrigLevelMarker != null) {
                int nearestDiv = (int)Math.round(((double)this.bottom - mouseY) / (double)this.pixelsPerVDiv);
                int clampedDiv = class_3532.method_15340((int)nearestDiv, (int)0, (int)this.vDivs);
                this.draggingTrigLevelMarker.setTrigLevel(clampedDiv * this.levelPerDiv + this.bottomLevel);
            }
            return true;
        }

        @Override
        public boolean method_25401(double mouseX, double mouseY, double amount) {
            if (class_437.method_25443()) {
                if (class_437.method_25441()) {
                    this.levelPerDiv = this.calculateNextDivLength(this.levelPerDiv, amount < 0.0, 100);
                } else {
                    this.bottomLevel = (int)((double)this.bottomLevel + (class_437.method_25442() ? amount * (double)this.vDivs : amount) * (double)this.levelPerDiv);
                }
            } else {
                super.method_25401(mouseX, mouseY, amount);
            }
            return true;
        }

        @Override
        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            switch (keyCode) {
                case 265: {
                    if (class_437.method_25441()) {
                        this.levelPerDiv = this.calculateNextDivLength(this.levelPerDiv, true, 500);
                    } else {
                        this.bottomLevel += (class_437.method_25442() ? this.vDivs : 1) * this.levelPerDiv;
                    }
                    return true;
                }
                case 264: {
                    if (class_437.method_25441()) {
                        this.levelPerDiv = this.calculateNextDivLength(this.levelPerDiv, false, 500);
                    } else {
                        this.bottomLevel += (class_437.method_25442() ? -this.vDivs : -1) * this.levelPerDiv;
                    }
                    return true;
                }
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        @Override
        protected void drawToolTip(class_4587 matrices, int mouseX, int mouseY) {
            if (this.draggingTrigLevelMarker != null) {
                ArrayList tooltip = Lists.newArrayList((Object[])new class_2561[]{class_2561.method_30163((String)String.format("CH%d: %d", this.draggingTrigLevelMarker.getId(), this.draggingTrigLevelMarker.getTrigLevel()))});
                OscilscopeScreen.this.method_30901(matrices, tooltip, mouseX, mouseY);
            }
        }

        @Override
        protected void drawStatus(class_4587 matrices) {
            class_332.method_25300((class_4587)matrices, (class_327)OscilscopeScreen.this.field_22793, (String)String.format("Hori: %d gt / div   Vert: %d level / div", this.tickPerDiv, this.levelPerDiv), (int)(OscilscopeScreen.this.field_22789 / 2), (int)(OscilscopeScreen.this.field_22790 - 12), (int)-1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void drawWaves(class_4587 matrices, int mouseX, int mouseY) {
            Map<Oscilscope.Channel, List<Oscilscope.Edge>> data;
            long from = this.leftTick;
            long to = this.leftTick + (long)(this.hDivs * this.tickPerDiv);
            ArrayList<class_2561> toolTip = new ArrayList<class_2561>();
            Map<Oscilscope.Channel, List<Oscilscope.Edge>> map = data = OscilscopeScreen.this.waveData.getWaveData(from, to, false);
            synchronized (map) {
                this.drawSingleWave(matrices, mouseX, mouseY, toolTip, data);
            }
            if (!toolTip.isEmpty()) {
                OscilscopeScreen.this.method_30901(matrices, toolTip, mouseX, Math.max(mouseY, 24));
            }
        }

        private void drawSingleWave(class_4587 matrices, int mouseX, int mouseY, List<class_2561> toolTip, Map<Oscilscope.Channel, List<Oscilscope.Edge>> data) {
            data.forEach((channel, wave) -> {
                int color = this.getTransformedColor((Oscilscope.Channel)channel);
                if (wave.isEmpty()) {
                    return;
                }
                Oscilscope.Edge prevEdge = null;
                for (Oscilscope.Edge edge : wave) {
                    if (prevEdge != null) {
                        int prevX = this.calculatePosOfTime(prevEdge.time);
                        int curX = this.calculatePosOfTime(edge.time);
                        int prevY = this.calculatePosOfLevel(prevEdge.newLevel);
                        int curY = this.calculatePosOfLevel(edge.newLevel);
                        OscilscopeScreen.this.method_25292(matrices, prevX, curX, prevY, color);
                        OscilscopeScreen.this.method_25301(matrices, curX, prevY, curY, color);
                        this.appendToolTipIfNeeded(toolTip, mouseX, mouseY, prevX, prevY, curX, curY, (Oscilscope.Channel)channel, prevEdge, edge);
                    }
                    prevEdge = edge;
                }
                OscilscopeScreen.this.method_25292(matrices, this.calculatePosOfTime(prevEdge.time), this.calculatePosOfTime(ServerMicroTime.current()), this.calculatePosOfLevel(prevEdge.newLevel), color);
                this.appendToolTipIfNeeded(toolTip, mouseX, mouseY, this.calculatePosOfTime(prevEdge.time), this.calculatePosOfLevel(prevEdge.newLevel), this.right, -1, (Oscilscope.Channel)channel, prevEdge, null);
            });
        }

        private int calculatePosOfLevel(int level) {
            int raw = this.bottom - (level - this.bottomLevel) * this.pixelsPerVDiv / this.levelPerDiv;
            return class_3532.method_15340((int)raw, (int)this.top, (int)this.bottom);
        }

        @Override
        protected void drawTrigMarkers(class_1159 matrix, class_287 bufferBuilder) {
            super.drawTrigMarkers(matrix, bufferBuilder);
            OscilscopeScreen.this.waveData.getAllChannels().stream().filter(Oscilscope.Channel::isVisible).mapToInt(ch -> this.bottom - (ch.getTrigLevel() - this.bottomLevel) * this.pixelsPerVDiv).forEach(yPos -> {
                bufferBuilder.method_22918(matrix, (float)this.right, (float)yPos, 0.0f).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
                bufferBuilder.method_22918(matrix, (float)(this.right + 5), (float)(yPos - 5), 0.0f).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
                bufferBuilder.method_22918(matrix, (float)(this.right + 5), (float)(yPos + 5), 0.0f).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
            });
        }

        @Override
        protected void drawAxises(class_4587 matrices) {
            super.drawAxises(matrices);
            for (int i = 0; i <= this.vDivs; ++i) {
                class_332.method_25300((class_4587)matrices, (class_327)OscilscopeScreen.this.field_22793, (String)Integer.toString(this.getLevelAtDiv(i)), (int)(this.left - 12), (int)(this.top + i * this.pixelsPerVDiv - 4), (int)-1);
            }
        }

        private int getLevelAtDiv(int i) {
            return this.bottomLevel + (this.vDivs - i) * this.levelPerDiv;
        }

        @Override
        protected void drawGrids(class_4587 matrices) {
            super.drawGrids(matrices);
            for (int i = 0; i <= this.vDivs; ++i) {
                OscilscopeScreen.this.method_25292(matrices, this.left, this.right, this.top + i * this.pixelsPerVDiv, 0x3FFFFFFF);
            }
        }
    }

    private class CustomPositionEntryListWidget<E extends class_4280.class_4281<E>>
    extends class_4280<E> {
        public CustomPositionEntryListWidget(int x, int y, int height, int width, int itemHeight) {
            super(class_310.method_1551(), width, height, y, y + height, itemHeight);
            this.field_19088 = x;
            this.field_19087 = x + width;
            this.method_31322(false);
            this.method_31323(false);
        }

        public int method_25342() {
            return this.field_19088;
        }

        public int method_25322() {
            return this.field_22742;
        }

        public int method_25329() {
            return this.field_19087;
        }

        protected void method_25325(class_4587 matrices) {
            class_332.method_25294((class_4587)matrices, (int)this.field_19088, (int)this.field_19085, (int)this.field_19087, (int)this.field_19086, (int)0x7F000000);
        }
    }
}

