/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.export;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.export.Region;
import lovexyn0827.mess.export.SaveComponent;
import lovexyn0827.mess.export.WorldGenType;
import lovexyn0827.mess.mixins.DataCommandStorageAccessor;
import lovexyn0827.mess.mixins.IdCountsStateAccessor;
import lovexyn0827.mess.mixins.MinecraftServerAccessor;
import lovexyn0827.mess.mixins.RaidManagerAccessor;
import lovexyn0827.mess.mixins.WorldSavePathMixin;
import lovexyn0827.mess.options.OptionManager;
import lovexyn0827.mess.rendering.RenderedBox;
import net.minecraft.class_155;
import net.minecraft.class_18;
import net.minecraft.class_1806;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1932;
import net.minecraft.class_1937;
import net.minecraft.class_2165;
import net.minecraft.class_22;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_269;
import net.minecraft.class_273;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3765;
import net.minecraft.class_3767;
import net.minecraft.class_3978;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.mutable.MutableBoolean;

public final class ExportTask {
    private static final class_5218 EXPORT_PATH = WorldSavePathMixin.create("exported_saves");
    private static final Map<class_2165, ExportTask> TASKS = new HashMap<class_2165, ExportTask>();
    private final Map<String, Region> regions = new HashMap<String, Region>();
    private final MinecraftServer server;
    private final EnumSet<SaveComponent> components = EnumSet.noneOf(SaveComponent.class);
    private final class_3222 owner;

    private ExportTask(class_2165 k, MinecraftServer server) {
        this.owner = k instanceof class_3222 ? (class_3222)k : null;
        this.server = server;
        this.components.addAll(OptionManager.defaultSaveComponents);
    }

    public static ExportTask of(class_2165 output, MinecraftServer server) {
        return TASKS.computeIfAbsent(output, k -> new ExportTask((class_2165)k, server));
    }

    public void addRegion(String name, class_1923 corner1, class_1923 corner2, class_3218 dimension) {
        this.regions.put(name, new Region(name, corner1, corner2, dimension));
    }

    public boolean deleteRegion(String name) {
        return this.regions.remove(name) != null;
    }

    public void drawPreview(String name, int ticks) {
        Region region = this.regions.get(name);
        if (region != null) {
            RenderedBox box = new RenderedBox(class_238.method_19316((class_3341)region.getBlockBox()), -16776961, -65473, ticks, region.getWorld().method_8510());
            MessMod.INSTANCE.shapeSender.addShape(box, (class_5321<class_1937>)region.getWorld().method_27983(), this.owner);
        }
    }

    public void addComponents(Set<SaveComponent> comps) {
        this.components.addAll(comps);
    }

    public void omitComponents(Set<SaveComponent> comps) {
        this.components.removeAll(comps);
    }

    public EnumSet<SaveComponent> getComponents() {
        return this.components;
    }

    public Path export(String name, WorldGenType wgType) throws IOException {
        Path archivePath = this.server.method_27050(EXPORT_PATH);
        if (!Files.exists(archivePath, new LinkOption[0])) {
            Files.createDirectories(archivePath, new FileAttribute[0]);
        }
        Path temp = Files.createTempDirectory(this.server.method_27050(EXPORT_PATH), "export_", new FileAttribute[0]);
        this.regions.forEach((n, region) -> {
            try {
                region.exportMcas(temp, this.components);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        });
        for (class_3218 world : this.server.method_3738()) {
            Path dir = temp.resolve(this.server.method_27050(WorldSavePathMixin.create("")).relativize(((MinecraftServerAccessor)this.server).getSession().method_27424(world.method_27983())));
            if (!dir.resolve("data").toFile().exists()) {
                Files.createDirectories(dir.resolve("data"), new FileAttribute[0]);
            }
            class_26 psm = new class_26(dir.resolve("data").toFile(), this.server.method_3855());
            if (this.components.contains((Object)SaveComponent.RAID)) {
                this.exportRaids(world, psm);
            }
            this.tryExportMaps(world, psm);
            this.tryExportForceChunks(world, psm);
            if (world.method_27983() == class_1937.field_25179) {
                if (this.components.contains((Object)SaveComponent.SCOREBOARD)) {
                    class_273 ss = new class_273((class_269)world.method_14170());
                    psm.method_123("scoreboard", (class_18)ss);
                }
                if (this.components.contains((Object)SaveComponent.DATA_COMMAND_STORAGE)) {
                    ((DataCommandStorageAccessor)this.server.method_22827()).getStorages().forEach((id, cds) -> {
                        cds.method_80();
                        psm.method_123(id, cds);
                    });
                }
            }
            psm.method_125();
        }
        this.tryExportPlayerRelatedData(temp, "advancements", ".json", SaveComponent.ADVANCEMENTS_SELF, SaveComponent.ADVANCEMENT_OTHER);
        this.tryExportPlayerRelatedData(temp, "stats", ".json", SaveComponent.STAT_SELF, SaveComponent.STAT_OTHER);
        this.tryExportPlayerRelatedData(temp, "playerdata", ".dat", SaveComponent.PLAYER_SELF, SaveComponent.PLAYER_OTHER);
        this.tryCopySingle(temp, "icon.png", SaveComponent.ICON);
        this.tryCopySingle(temp, "carpet.conf", SaveComponent.CARPET);
        this.tryCopySingle(temp, "mcwmem.prop", SaveComponent.MESSMOD);
        this.tryCopySingle(temp, "saved_accessing_paths.prop", SaveComponent.MESSMOD);
        this.createLevelDat(name, wgType, temp);
        return this.createArchive(name, archivePath, temp);
    }

    private void tryCopySingle(Path temp, String name, SaveComponent comp) throws IOException {
        Path origin = this.server.method_27050(WorldSavePathMixin.create(name));
        if (this.components.contains((Object)comp) && Files.exists(origin, new LinkOption[0])) {
            Path dst = temp.resolve(name);
            Files.copy(origin, dst, new CopyOption[0]);
        }
    }

    private void tryExportPlayerRelatedData(Path temp, String dirName, String ext, SaveComponent selfFlag, SaveComponent otherFlag) throws IOException {
        boolean copySelf = this.components.contains((Object)selfFlag);
        boolean copyOther = this.components.contains((Object)otherFlag);
        if (!copySelf && !copyOther) {
            return;
        }
        Path origin = this.server.method_27050(WorldSavePathMixin.create(dirName));
        if (!Files.exists(origin, new LinkOption[0])) {
            return;
        }
        Path dst = temp.resolve(dirName);
        Files.createDirectories(dst, new FileAttribute[0]);
        for (Path p : (Path[])Files.list(origin).toArray(Path[]::new)) {
            UUID uuid;
            if (Files.isDirectory(p, new LinkOption[0]) || !p.getFileName().toString().toLowerCase().endsWith(ext)) continue;
            try {
                uuid = UUID.fromString(p.getFileName().toString().replace(ext, ""));
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            boolean self = this.isOwner(uuid);
            if ((!copySelf || !self) && (!copyOther || self)) continue;
            Path dstFile = dst.resolve(origin.relativize(p));
            Files.copy(p, dstFile, new CopyOption[0]);
        }
    }

    private boolean isOwner(UUID uuid) {
        return this.owner == null || this.owner.method_5667().equals(uuid);
    }

    private void tryExportForceChunks(class_3218 world, class_26 psm) {
        boolean copyLocal = this.components.contains((Object)SaveComponent.FORCE_CHUNKS_LOCAL);
        boolean copyOther = this.components.contains((Object)SaveComponent.FORCE_CHUNKS_OTHER);
        class_1932 fcs = class_1932.method_32350((class_2487)((class_1932)world.method_17983().method_17924(class_1932::method_32350, class_1932::new, "chunks")).method_75(new class_2487()));
        fcs.method_80();
        fcs.method_8375().removeIf(pos -> {
            boolean local = this.regions.values().stream().anyMatch(r -> r.contains(world, pos));
            return !(local && copyLocal || !local && copyOther);
        });
    }

    private void tryExportMaps(class_3218 world, class_26 psm) {
        boolean copyLocal = this.components.contains((Object)SaveComponent.MAP_LOCAL);
        boolean copyOther = this.components.contains((Object)SaveComponent.MAP_OTHER);
        class_3978 idCounts = (class_3978)world.method_17983().method_17924(class_3978::method_32360, class_3978::new, "idcounts");
        if (idCounts == null) {
            return;
        }
        int nextId = ((IdCountsStateAccessor)idCounts).getIdCountsForMessMod().getOrDefault((Object)"map", 0) + 1;
        for (int i = 0; i < nextId; ++i) {
            boolean local;
            String name = class_1806.method_17440((int)i);
            class_22 origin = world.method_17891(name);
            if (origin == null) continue;
            class_22 ms = class_22.method_32371((class_2487)origin.method_75(new class_2487()));
            ms.method_80();
            if (ms == null || (!(local = this.regions.values().stream().anyMatch(r -> r.contains(ms))) || !copyLocal) && (local || !copyOther)) continue;
            psm.method_123(name, (class_18)ms);
        }
        if ((copyLocal || copyOther) && world.method_27983() == class_1937.field_25179) {
            idCounts.method_80();
            psm.method_123("idcounts", (class_18)idCounts);
        }
    }

    private Path createArchive(String name, Path archiveDir, final Path temp) throws IOException, FileNotFoundException {
        final MutableBoolean success = new MutableBoolean(true);
        for (char c : class_155.field_1126) {
            name = name.replace(c, '_');
        }
        final String escapedName = name;
        String fn = escapedName + "-" + new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date()) + ".zip";
        Path archive = archiveDir.resolve(fn);
        try (final ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(archive.toFile()));){
            Files.walkFileTree(temp, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attr) throws IOException {
                    String entryPath = escapedName + "/" + temp.relativize(path).toString().replace('\\', '/');
                    try {
                        zos.putNextEntry(new ZipEntry(entryPath));
                        zos.write(Files.readAllBytes(path));
                    }
                    catch (IOException e) {
                        MessMod.LOGGER.warn("Failed to export: " + path.toString());
                        e.printStackTrace();
                        success.setFalse();
                    }
                    Files.delete(path);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
            zos.finish();
        }
        if (success.booleanValue()) {
            return archive;
        }
        return null;
    }

    private void createLevelDat(String name, WorldGenType wgType, Path temp) throws IOException {
        class_2487 level = class_2507.method_30613((File)this.server.method_27050(WorldSavePathMixin.create("level.dat")).toFile());
        level.method_10562("Data").method_10582("LevelName", name);
        if (!this.components.contains((Object)SaveComponent.GAMERULES)) {
            level.method_10562("Data").method_10566("GameRules", (class_2520)new class_1928().method_8358());
        }
        class_2487 wgConfig = level.method_10562("Data").method_10562("WorldGenSettings").method_10562("dimensions").method_10562("minecraft:overworld");
        switch (wgType) {
            case BEDROCK: {
                wgConfig.method_10566("generator", (class_2520)ExportTask.createFlatWorld(class_2246.field_9987));
                break;
            }
            case COPY: {
                break;
            }
            case GLASS: {
                wgConfig.method_10566("generator", (class_2520)ExportTask.createFlatWorld(class_2246.field_10087));
                break;
            }
            case PLAIN: {
                wgConfig.method_10566("generator", (class_2520)ExportTask.createFlatWorld(class_2246.field_10219));
                break;
            }
            case VOID: {
                wgConfig.method_10566("generator", (class_2520)ExportTask.createFlatWorld(class_2246.field_10124));
            }
        }
        class_2507.method_30614((class_2487)level, (File)temp.resolve("level.dat").toFile());
    }

    private void exportRaids(class_3218 world, class_26 psm) throws IOException {
        String id = class_3767.method_16533((class_6880)world.method_40134());
        class_3767 ps = (class_3767)world.method_17983().method_20786(nbt -> class_3767.method_77((class_3218)world, (class_2487)nbt), id);
        class_3767 tempRm = class_3767.method_77((class_3218)world, (class_2487)ps.method_75(new class_2487()));
        Iterator<Map.Entry<Integer, class_3765>> itr = ((RaidManagerAccessor)tempRm).getRaids().entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Integer, class_3765> entry = itr.next();
            if (this.regions.values().stream().anyMatch(reg -> reg.contains(world, ((class_3765)entry.getValue()).method_16495()))) continue;
            itr.remove();
        }
        psm.method_123(id, (class_18)tempRm);
    }

    private static class_2487 createFlatWorld(class_2248 block) {
        class_2487 newConf = new class_2487();
        newConf.method_10582("type", "minecraft:flat");
        class_2487 settings = new class_2487();
        class_2487 structures = new class_2487();
        structures.method_10566("structures", (class_2520)new class_2487());
        settings.method_10566("structures", (class_2520)structures);
        class_2499 layers = new class_2499();
        class_2487 layer = new class_2487();
        layer.method_10582("block", class_2378.field_11146.method_10221((Object)block).toString());
        layer.method_10569("height", 1);
        layers.add((Object)layer);
        settings.method_10566("layers", (class_2520)layers);
        settings.method_10582("biome", "minecraft:the_void");
        settings.method_10567("features", (byte)0);
        settings.method_10567("lakes", (byte)0);
        newConf.method_10566("settings", (class_2520)settings);
        return newConf;
    }

    public Collection<Region> listRegions() {
        return this.regions.values();
    }

    public Set<String> listRegionNames() {
        return this.regions.keySet();
    }

    public static void reset(class_2165 output) {
        TASKS.remove(output);
    }
}

