/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.log.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.log.CsvWriter;
import lovexyn0827.mess.log.entity.EntityLogColumn;
import lovexyn0827.mess.log.entity.EntityLogger;
import lovexyn0827.mess.log.entity.SideLogStoragePolicy;
import lovexyn0827.mess.util.TranslatableException;
import lovexyn0827.mess.util.deobfuscating.Mapping;
import lovexyn0827.mess.util.phase.ClientTickingPhase;
import lovexyn0827.mess.util.phase.ServerTickingPhase;
import lovexyn0827.mess.util.phase.TickingPhase;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_155;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3545;

public class EntityHolder {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    final class_1297 entity;
    private final int entityId;
    private final CsvWriter writer;
    private int age;
    private final Map<EntityLogColumn, Object> listenedFields;
    private volatile boolean closed;
    final boolean shouldTickClient;
    final boolean shouldTickServer;
    final SideLogStoragePolicy policy;
    private boolean fresh = true;
    private final TickingPhase.Event dataUpdater;

    EntityHolder(class_1297 e, EntityLogger logger, boolean isClient, SideLogStoragePolicy policy) {
        this.entity = e;
        this.entityId = this.entity.method_5628();
        this.shouldTickServer = !isClient;
        this.shouldTickClient = isClient;
        this.policy = policy;
        this.listenedFields = Maps.newHashMap();
        try {
            FileWriter w = new FileWriter(EntityHolder.getLogFile(e, isClient ? (char)'C' : 'S', logger));
            CsvWriter.Builder builder = new CsvWriter.Builder().addColumn("tick").addColumn("x").addColumn("y").addColumn("z").addColumn("vx").addColumn("vy").addColumn("vz");
            if (e instanceof class_1309) {
                builder.addColumn("health");
            }
            Mapping map = MessMod.INSTANCE.getMapping();
            logger.getListenedFields().values().forEach(field -> {
                boolean sideMatched;
                boolean bl = sideMatched = field.getPhase() instanceof ClientTickingPhase && this.shouldTickClient || field.getPhase() instanceof ServerTickingPhase && this.shouldTickServer;
                if (sideMatched && field.canGetFrom(e)) {
                    builder.addColumn(map.namedField(field.getName()));
                    this.listenedFields.put((EntityLogColumn)field, (Object)ToBeReplaced.INSTANCE);
                }
            });
            this.writer = builder.build(w);
        }
        catch (IOException e1) {
            throw new TranslatableException("exp.log.holder", new Object[]{e1});
        }
        this.dataUpdater = this::updateData;
        if (!MessMod.isDedicatedServerEnv() && this.shouldTickClient) {
            ClientTickingPhase.addEventToAll(this.dataUpdater);
        } else if (this.shouldTickServer) {
            ServerTickingPhase.addEventToAll(this.dataUpdater);
        }
    }

    private EntityHolder(class_1297 e, EntityLogger logger, boolean isClient, CsvWriter writer, List<EntityLogColumn> columns) {
        this.entity = e;
        this.entityId = this.entity.method_5628();
        this.shouldTickServer = !isClient;
        this.shouldTickClient = isClient;
        this.policy = SideLogStoragePolicy.MIXED;
        this.listenedFields = Maps.newHashMap();
        columns.forEach(c -> this.listenedFields.put((EntityLogColumn)c, (Object)ToBeReplaced.INSTANCE));
        this.writer = writer;
        this.dataUpdater = this::updateData;
        if (!MessMod.isDedicatedServerEnv() && this.shouldTickClient) {
            ClientTickingPhase.addEventToAll(this.dataUpdater);
        } else if (this.shouldTickServer) {
            ServerTickingPhase.addEventToAll(this.dataUpdater);
        }
    }

    private static File getLogFile(class_1297 e, char type, EntityLogger logger) {
        String entityName = e.method_5477().getString();
        for (char c : class_155.field_1126) {
            entityName = entityName.replace(c, '_');
        }
        String name = String.format("%s@%d-%c-%s.csv", DATE_FORMAT.format(new Date()), e.method_5628(), Character.valueOf(type), entityName.length() == 0 ? e.method_5864().method_5882().replaceFirst("^.+\\u002e", "") : entityName);
        return logger.getLogPath().resolve(name).toFile();
    }

    static class_3545<EntityHolder, EntityHolder> createMixedHolderPair(class_1297 e, EntityLogger logger) {
        try {
            FileWriter w = new FileWriter(EntityHolder.getLogFile(e, 'M', logger));
            CsvWriter.Builder builder = new CsvWriter.Builder().addColumn("tick").addColumn("x").addColumn("y").addColumn("z").addColumn("vx").addColumn("vy").addColumn("vz");
            if (e instanceof class_1309) {
                builder.addColumn("health");
            }
            Mapping map = MessMod.INSTANCE.getMapping();
            ArrayList<EntityLogColumn> columns = new ArrayList<EntityLogColumn>();
            logger.getListenedFields().values().forEach(field -> {
                if (field.canGetFrom(e)) {
                    builder.addColumn(map.namedField(field.getName()));
                    columns.add((EntityLogColumn)field);
                }
            });
            CsvWriter writer = builder.build(w);
            return new class_3545((Object)new EntityHolder(e, logger, true, writer, columns), (Object)new EntityHolder(e, logger, false, writer, columns));
        }
        catch (IOException e1) {
            throw new TranslatableException("exp.log.holder", new Object[]{e1});
        }
    }

    public void serverTick() {
        if (!this.shouldTickServer) {
            throw new IllegalStateException("Shouldn't be called!");
        }
        class_1297 e = this.entity;
        class_243 v = e.method_18798();
        ArrayList obs = Lists.newArrayList((Object[])new Object[]{this.age++, e.method_23317(), e.method_23318(), e.method_23321(), v.field_1352, v.field_1351, v.field_1350});
        if (e instanceof class_1309) {
            obs.add(Float.valueOf(((class_1309)e).method_6032()));
        }
        this.listenedFields.forEach((field, value) -> {
            if (field.getPhase() instanceof ClientTickingPhase) {
                if (this.policy == SideLogStoragePolicy.MIXED) {
                    obs.add("");
                }
                return;
            }
            if (value == ToBeReplaced.INSTANCE && !this.fresh) {
                throw new IllegalStateException("The value of " + field + " hasn't been set!");
            }
            obs.add(value);
        });
        this.listenedFields.entrySet().forEach(entry -> entry.setValue(ToBeReplaced.INSTANCE));
        this.writer.println(obs.toArray());
        this.fresh = false;
    }

    public void clientTick() {
        if (!this.shouldTickClient) {
            throw new IllegalStateException("Shouldn't be called!");
        }
        class_1297 e = this.entity;
        class_243 v = e.method_18798();
        ArrayList obs = Lists.newArrayList((Object[])new Object[]{this.age++, e.method_23317(), e.method_23318(), e.method_23321(), v.field_1352, v.field_1351, v.field_1350});
        if (e instanceof class_1309) {
            obs.add(Float.valueOf(((class_1309)e).method_6032()));
        }
        this.listenedFields.forEach((field, value) -> {
            if (field.getPhase() instanceof ServerTickingPhase) {
                if (this.policy == SideLogStoragePolicy.MIXED) {
                    obs.add("");
                }
                return;
            }
            if (value == ToBeReplaced.INSTANCE && !this.fresh) {
                throw new IllegalStateException("The value of " + field + " hasn't been set!");
            }
            obs.add(value);
        });
        this.listenedFields.entrySet().forEach(entry -> entry.setValue(ToBeReplaced.INSTANCE));
        this.writer.println(obs.toArray());
        this.fresh = false;
    }

    public void updateData(TickingPhase phase, class_1937 world) {
        if (this.closed) {
            return;
        }
        this.listenedFields.entrySet().forEach(e -> {
            boolean isEntityWorld;
            boolean bl = isEntityWorld = ((EntityLogColumn)e.getKey()).getPhase().isNotInAnyWorld() || world == this.entity.field_6002;
            if (((EntityLogColumn)e.getKey()).getPhase() == phase && isEntityWorld) {
                if (e.getValue() != ToBeReplaced.INSTANCE) {
                    throw new IllegalStateException("The value of " + e.getKey() + " has already been set!");
                }
                e.setValue(((EntityLogColumn)e.getKey()).getFrom(this.entity));
            }
        });
    }

    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            MessMod.LOGGER.warn("Failed to flush: " + this.entityId);
            e.printStackTrace();
        }
    }

    public boolean isInvaild() {
        return this.entity.method_31481();
    }

    public void close() {
        try {
            this.writer.close();
            this.closed = true;
            if (this.shouldTickClient) {
                ClientTickingPhase.removeEventFromAll(this.dataUpdater);
            }
            if (this.shouldTickServer) {
                ServerTickingPhase.removeEventFromAll(this.dataUpdater);
            }
        }
        catch (IOException e) {
            MessMod.LOGGER.warn("Failed to close: " + this.entityId);
            e.printStackTrace();
        }
    }

    public int getId() {
        return this.entityId;
    }

    private static enum ToBeReplaced {
        INSTANCE;

    }
}

