/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.log.entity;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lovexyn0827.mess.log.AbstractAchivingLogger;
import lovexyn0827.mess.log.entity.EntityHolder;
import lovexyn0827.mess.log.entity.EntityLogColumn;
import lovexyn0827.mess.log.entity.SideLogStoragePolicy;
import lovexyn0827.mess.rendering.hud.data.HudLine;
import lovexyn0827.mess.util.CarpetUtil;
import lovexyn0827.mess.util.ListenedField;
import lovexyn0827.mess.util.Reflection;
import lovexyn0827.mess.util.TranslatableException;
import lovexyn0827.mess.util.WrappedPath;
import lovexyn0827.mess.util.access.AccessingPath;
import lovexyn0827.mess.util.phase.TickingPhase;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_3545;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class EntityLogger
extends AbstractAchivingLogger {
    public static final Logger LOGGER = LogManager.getLogger();
    Map<EntityIndex, EntityHolder> serverLoggingEntries = new HashMap<EntityIndex, EntityHolder>();
    Map<EntityIndex, EntityHolder> clientLoggingEntries = new HashMap<EntityIndex, EntityHolder>();
    private Map<String, EntityLogColumn> customFields = new HashMap<String, EntityLogColumn>();
    private final Set<class_1299<?>> autoSubTypes = Sets.newHashSet();
    private final Set<String> autoSubNames = Sets.newHashSet();
    private SideLogStoragePolicy defaultStoragePolicy = SideLogStoragePolicy.SERVER_ONLY;

    public EntityLogger(MinecraftServer server) {
        super(server);
    }

    public synchronized void serverTick() {
        if (!this.autoSubTypes.isEmpty()) {
            this.server.method_3738().forEach(world -> this.subscribe(world.method_18198(null, e -> this.autoSubTypes.contains(e.method_5864()) || this.autoSubNames.contains(e.method_5477().method_10851())), this.defaultStoragePolicy));
        }
        if (CarpetUtil.isTickFrozen()) {
            return;
        }
        this.serverLoggingEntries.values().forEach(EntityHolder::serverTick);
        Iterator<Map.Entry<EntityIndex, EntityHolder>> itr = this.serverLoggingEntries.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<EntityIndex, EntityHolder> entry = itr.next();
            if (!entry.getValue().isInvaild()) continue;
            try {
                entry.getValue().close();
                itr.remove();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public synchronized void clientTick() {
        this.clientLoggingEntries.values().forEach(EntityHolder::clientTick);
        Iterator<Map.Entry<EntityIndex, EntityHolder>> itr = this.clientLoggingEntries.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<EntityIndex, EntityHolder> entry = itr.next();
            if (!entry.getValue().isInvaild()) continue;
            try {
                entry.getValue().close();
                itr.remove();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    protected String getLogFolderName() {
        return "entitylog";
    }

    public void flushAll() {
        this.serverLoggingEntries.values().forEach(EntityHolder::flush);
        this.clientLoggingEntries.values().forEach(EntityHolder::flush);
    }

    public synchronized void closeAll() {
        this.serverLoggingEntries.values().forEach(EntityHolder::close);
        this.serverLoggingEntries.clear();
        this.clientLoggingEntries.values().forEach(EntityHolder::close);
        this.clientLoggingEntries.clear();
    }

    public void listenToField(String field, class_1299<?> type, String name, @Nullable AccessingPath path, TickingPhase phase) {
        HudLine column;
        if (path == null) {
            path = AccessingPath.DUMMY;
        }
        if (!this.isIdle()) {
            throw new TranslatableException("cmd.entitylog.reqidle");
        }
        if (this.customFields.containsKey(name)) {
            throw new TranslatableException("exp.dupname");
        }
        if ("-THIS-".equals(field)) {
            column = new WrappedPath.Phased(path, name, phase);
        } else {
            Field f = Reflection.getFieldFromNamed(Reflection.ENTITY_TYPE_TO_CLASS.get(type), field);
            if (f != null) {
                column = new ListenedField.Phased(f, path, name, phase);
            } else {
                throw new TranslatableException("exp.nofield", field, type.method_5897().getString());
            }
        }
        if (this.customFields.containsValue(column)) {
            throw new TranslatableException("exp.dupfield");
        }
        this.customFields.put(column.getName(), (EntityLogColumn)((Object)column));
    }

    public void unlistenToField(String name) {
        if (!this.isIdle()) {
            throw new TranslatableException("cmd.entitilog.reqidle");
        }
        if (this.customFields.remove(name) == null) {
            throw new TranslatableException("exp.nofieldunlistend", name);
        }
    }

    public synchronized int subscribe(Collection<? extends class_1297> entities, SideLogStoragePolicy policy) {
        this.hasCreatedAnyLog = true;
        MutableInt i = new MutableInt();
        MutableInt j = new MutableInt();
        entities.forEach(e -> {
            EntityIndex idx = new EntityIndex((class_1297)e);
            if (policy == SideLogStoragePolicy.MIXED) {
                class_3545<EntityHolder, EntityHolder> holder = EntityHolder.createMixedHolderPair(e, this);
                if (!this.clientLoggingEntries.containsKey(idx)) {
                    this.clientLoggingEntries.put(idx, (EntityHolder)holder.method_15442());
                }
                if (!this.serverLoggingEntries.containsKey(idx)) {
                    this.serverLoggingEntries.put(idx, (EntityHolder)holder.method_15441());
                    i.increment();
                }
            } else {
                this.serverLoggingEntries.computeIfAbsent(idx, id -> {
                    i.increment();
                    return new EntityHolder((class_1297)e, this, false, policy);
                });
                this.clientLoggingEntries.computeIfAbsent(idx, id -> new EntityHolder((class_1297)e, this, true, policy));
            }
        });
        return Math.max(i.intValue(), j.intValue());
    }

    public int subscribe(Collection<? extends class_1297> entities) {
        return this.subscribe(entities, this.defaultStoragePolicy);
    }

    public synchronized int unsubscribe(Collection<? extends class_1297> entities) {
        MutableInt i = new MutableInt();
        MutableInt j = new MutableInt();
        entities.stream().map(EntityIndex::new).map(this.serverLoggingEntries::remove).forEach(eh -> {
            if (eh != null) {
                eh.close();
                i.increment();
            }
        });
        entities.stream().map(EntityIndex::new).map(this.clientLoggingEntries::remove).forEach(eh -> {
            if (eh != null) {
                eh.close();
                j.increment();
            }
        });
        return Math.max(i.intValue(), j.intValue());
    }

    public void addAutoSubEntityType(class_1299<?> type) {
        this.autoSubTypes.add(type);
    }

    public boolean removeAutoSubEntityType(class_1299<?> type) {
        return this.autoSubTypes.remove(type);
    }

    public boolean shouldAutoSub(class_1299<?> type) {
        return this.autoSubTypes.contains(type);
    }

    public ImmutableSet<class_1299<?>> listAutoSubEntityTypes() {
        return ImmutableSet.copyOf(this.autoSubTypes);
    }

    public Map<String, EntityLogColumn> getListenedFields() {
        return this.customFields;
    }

    public void addAutoSubName(String name) {
        this.autoSubNames.add(name);
    }

    public void removeAutoSubName(String name) {
        this.autoSubNames.remove(name);
    }

    public int countLoggedEntities() {
        return this.serverLoggingEntries.size();
    }

    public SideLogStoragePolicy getDefaultStoragePolicy() {
        return this.defaultStoragePolicy;
    }

    public void setDefaultStoragePolicy(SideLogStoragePolicy storagePolicy) {
        this.defaultStoragePolicy = storagePolicy;
    }

    public boolean isIdle() {
        return this.clientLoggingEntries.isEmpty() && this.serverLoggingEntries.isEmpty();
    }

    private static class EntityIndex {
        private final int entityId;
        private final boolean isClientSideEntity;

        private EntityIndex(class_1297 e) {
            this.entityId = e.method_5628();
            this.isClientSideEntity = e.field_6002.field_9236;
        }

        public int hashCode() {
            return Objects.hash(this.entityId, this.isClientSideEntity);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EntityIndex other = (EntityIndex)obj;
            return this.entityId == other.entityId && this.isClientSideEntity == other.isClientSideEntity;
        }
    }
}

