/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.mixins;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.fakes.ChunkTaskPrioritySystemInterface;
import lovexyn0827.mess.log.chunk.ChunkBehaviorLogger;
import lovexyn0827.mess.log.chunk.ChunkEvent;
import lovexyn0827.mess.log.chunk.ChunkTaskPrintUtil;
import lovexyn0827.mess.util.blame.StackTrace;
import net.minecraft.class_1923;
import net.minecraft.class_3218;
import net.minecraft.class_3900;
import net.minecraft.class_3906;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3900.class})
public class ChunkTaskPrioritySystemMixin
implements ChunkTaskPrioritySystemInterface {
    @Unique
    private static final AtomicLong NEXT_ID = new AtomicLong(0L);
    @Unique
    private static final Map<Object, Long> IDS_BY_TASK = Collections.synchronizedMap(new WeakHashMap());
    @Unique
    private class_3218 world;

    @Override
    public void initWorld(class_3218 world) {
        IDS_BY_TASK.clear();
        NEXT_ID.set(0L);
        this.world = world;
    }

    @Inject(method={"updateLevel"}, at={@At(value="HEAD")})
    private void onLevelUpdate(class_1923 pos, IntSupplier levelGetter, int targetLevel, IntConsumer levelSetter, CallbackInfo ci) {
        if (ChunkBehaviorLogger.shouldSkip()) {
            return;
        }
        MessMod.INSTANCE.getChunkLogger().onEvent(ChunkEvent.CTPS_LEVEL, pos.method_8324(), this.world.method_27983().method_29177(), Thread.currentThread(), StackTrace.blameCurrent(), targetLevel);
    }

    @Inject(method={"removeChunk"}, at={@At(value="HEAD")})
    private void onRemoveChunk(class_3906<?> actor, long chunkPos, Runnable callback, boolean clearTask, CallbackInfo ci) {
        if (ChunkBehaviorLogger.shouldSkip()) {
            return;
        }
        long taskId = IDS_BY_TASK.computeIfAbsent(callback, k -> NEXT_ID.getAndIncrement());
        MessMod.INSTANCE.getChunkLogger().onEvent(ChunkEvent.CTPS_REMOVE, chunkPos, this.world.method_27983().method_29177(), Thread.currentThread(), StackTrace.blameCurrent(), ChunkTaskPrintUtil.printTask(taskId, callback) + ":" + clearTask + "@" + actor.method_16898());
    }

    @Inject(method={"enqueueChunk"}, at={@At(value="HEAD")})
    private void onEnqueueChunk(class_3906<?> actor, Function<?, ?> task, long chunkPos, IntSupplier lastLevelUpdatedToProvider, boolean addBlocker, CallbackInfo ci) {
        if (ChunkBehaviorLogger.shouldSkip()) {
            return;
        }
        long taskId = IDS_BY_TASK.computeIfAbsent(task, k -> NEXT_ID.getAndIncrement());
        MessMod.INSTANCE.getChunkLogger().onEvent(ChunkEvent.CTPS_CHUNK, chunkPos, this.world.method_27983().method_29177(), Thread.currentThread(), StackTrace.blameCurrent(), ChunkTaskPrintUtil.printTask(taskId, task) + ":" + addBlocker + "@" + actor.method_16898());
    }
}

