/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.mixins;

import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.command.LazyLoadCommand;
import lovexyn0827.mess.fakes.ChunkTaskPrioritySystemInterface;
import lovexyn0827.mess.fakes.ChunkTicketManagerInterface;
import lovexyn0827.mess.log.chunk.ChunkBehaviorLogger;
import lovexyn0827.mess.log.chunk.ChunkEvent;
import lovexyn0827.mess.options.OptionManager;
import lovexyn0827.mess.util.blame.BlamingMode;
import lovexyn0827.mess.util.blame.StackTrace;
import net.minecraft.class_1923;
import net.minecraft.class_2960;
import net.minecraft.class_3204;
import net.minecraft.class_3218;
import net.minecraft.class_3228;
import net.minecraft.class_3900;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3204.class})
public class ChunkTicketManagerMixin
implements ChunkTicketManagerInterface {
    @Unique
    private class_3218 world;
    @Shadow
    @Final
    private class_3900 field_17456;

    @Inject(method={"addTicket(JLnet/minecraft/server/world/ChunkTicket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void returnIfNeeded(long pos, class_3228<?> ticket, CallbackInfo ci) {
        if (OptionManager.rejectChunkTicket.contains(ticket.method_14281())) {
            ci.cancel();
        }
    }

    @Inject(method={"addTicket(JLnet/minecraft/server/world/ChunkTicket;)V"}, at={@At(value="RETURN")})
    private void onTicketAdded(long pos, class_3228<?> ticket, CallbackInfo ci) {
        if (!ChunkBehaviorLogger.shouldSkip()) {
            MessMod.INSTANCE.getChunkLogger().onEvent(ChunkEvent.TICKET_ADDITION, pos, this.getDimesionId(), Thread.currentThread(), OptionManager.blamingMode == BlamingMode.DISABLED ? null : StackTrace.current().blame(), ticket);
        }
    }

    @Inject(method={"removeTicket(JLnet/minecraft/server/world/ChunkTicket;)V"}, at={@At(value="RETURN")})
    private void onTicketRemoved(long pos, class_3228<?> ticket, CallbackInfo ci) {
        if (!ChunkBehaviorLogger.shouldSkip()) {
            MessMod.INSTANCE.getChunkLogger().onEvent(ChunkEvent.TICKET_REMOVAL, pos, this.getDimesionId(), Thread.currentThread(), StackTrace.blameCurrent(), ticket);
        }
    }

    @Inject(method={"shouldTickEntities"}, at={@At(value="HEAD")}, cancellable=true)
    private void tickEntityIfNeeded(long pos, CallbackInfoReturnable<Boolean> cir) {
        if (!LazyLoadCommand.LAZY_CHUNKS.isEmpty() && (LazyLoadCommand.LAZY_CHUNKS.containsKey(this.world.method_27983()) || LazyLoadCommand.LAZY_CHUNKS.get(this.world.method_27983()).contains(pos))) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    protected void onTickNoArg(CallbackInfoReturnable<Boolean> cir) {
        if (ChunkBehaviorLogger.shouldSkip()) {
            return;
        }
        MessMod.INSTANCE.getChunkLogger().onEvent(ChunkEvent.CTM_TICK, class_1923.field_17348, this.getDimesionId(), Thread.currentThread(), StackTrace.blameCurrent(), null);
    }

    @Override
    public class_2960 getDimesionId() {
        return this.world.method_27983().method_29177();
    }

    @Override
    public void initWorld(class_3218 world) {
        this.world = world;
        if (this.field_17456 instanceof ChunkTaskPrioritySystemInterface) {
            ((ChunkTaskPrioritySystemInterface)this.field_17456).initWorld(world);
        }
    }
}

